/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.xml;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.xml.XmlPropertiesFile;
import com.intellij.lang.properties.xml.XmlPropertiesIndex;
import com.intellij.lang.properties.xml.XmlProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.reference.SoftLazyValue;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlPropertiesFileImpl
extends XmlPropertiesFile {
    private static final Key<CachedValue<PropertiesFile>> KEY = Key.create((String)"xml properties file");
    private final XmlFile myFile;
    private final SoftLazyValue<MultiMap<String, IProperty>> myPropertiesMap = new SoftLazyValue<MultiMap<String, IProperty>>(){

        @NotNull
        protected MultiMap<String, IProperty> compute() {
            XmlTag rootTag = XmlPropertiesFileImpl.this.myFile.getRootTag();
            if (rootTag == null) {
                MultiMap multiMap = MultiMap.emptyInstance();
                if (multiMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlPropertiesFileImpl$1", "compute"));
                }
                return multiMap;
            }
            XmlTag[] entries = rootTag.findSubTags("entry");
            MultiMap map = new MultiMap();
            for (XmlTag entry : entries) {
                XmlProperty property = new XmlProperty(entry, XmlPropertiesFileImpl.this);
                map.putValue((Object)property.getKey(), (Object)property);
            }
            MultiMap multiMap = map;
            if (multiMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlPropertiesFileImpl$1", "compute"));
            }
            return multiMap;
        }
    };

    private XmlPropertiesFileImpl(XmlFile file) {
        this.myFile = file;
    }

    @Override
    @NotNull
    public PsiFile getContainingFile() {
        XmlFile xmlFile = this.myFile;
        if (xmlFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlPropertiesFileImpl", "getContainingFile"));
        }
        return xmlFile;
    }

    @Override
    @NotNull
    public List<IProperty> getProperties() {
        ArrayList<IProperty> arrayList = new ArrayList<IProperty>(((MultiMap)this.myPropertiesMap.getValue()).values());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlPropertiesFileImpl", "getProperties"));
        }
        return arrayList;
    }

    @Override
    public IProperty findPropertyByKey(@NotNull @NonNls String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/lang/properties/xml/XmlPropertiesFileImpl", "findPropertyByKey"));
        }
        Collection properties = ((MultiMap)this.myPropertiesMap.getValue()).get((Object)key);
        return properties.isEmpty() ? null : (IProperty)properties.iterator().next();
    }

    @Override
    @NotNull
    public List<IProperty> findPropertiesByKey(@NotNull @NonNls String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/lang/properties/xml/XmlPropertiesFileImpl", "findPropertiesByKey"));
        }
        ArrayList<IProperty> arrayList = new ArrayList<IProperty>(((MultiMap)this.myPropertiesMap.getValue()).get((Object)key));
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlPropertiesFileImpl", "findPropertiesByKey"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public ResourceBundle getResourceBundle() {
        ResourceBundle resourceBundle = PropertiesImplUtil.getResourceBundle(this);
        if (resourceBundle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlPropertiesFileImpl", "getResourceBundle"));
        }
        return resourceBundle;
    }

    @Override
    @NotNull
    public Locale getLocale() {
        Locale locale = ResourceBundleManager.getInstance(this.getProject()).getLocale(this.getVirtualFile());
        if (locale == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlPropertiesFileImpl", "getLocale"));
        }
        return locale;
    }

    @Override
    public PsiElement addProperty(@NotNull IProperty property) throws IncorrectOperationException {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/properties/xml/XmlPropertiesFileImpl", "addProperty"));
        }
        return null;
    }

    @Override
    public PsiElement addPropertyAfter(@NotNull Property property, @Nullable Property anchor) throws IncorrectOperationException {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/properties/xml/XmlPropertiesFileImpl", "addPropertyAfter"));
        }
        return null;
    }

    @Override
    public IProperty addPropertyFirst(String key, String value) {
        return null;
    }

    @Override
    public IProperty addPropertyLast(String key, String value) {
        return null;
    }

    @Override
    public IProperty addPropertyAfter(String key, String value, Property anchor) {
        return null;
    }

    @Override
    @NotNull
    public IProperty addProperty(String key, String value) {
        XmlTag rootTag = this.myFile.getRootTag();
        XmlTag entry = rootTag.createChildTag("entry", "", value, false);
        entry.setAttribute("key", key);
        rootTag.addSubTag(entry, false);
        XmlProperty property = new XmlProperty(entry, this);
        ((MultiMap)this.myPropertiesMap.getValue()).putValue((Object)key, (Object)property);
        XmlProperty xmlProperty = property;
        if (xmlProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlPropertiesFileImpl", "addProperty"));
        }
        return xmlProperty;
    }

    public static PropertiesFile getPropertiesFile(final PsiFile file) {
        CachedValuesManager manager = CachedValuesManager.getManager((Project)file.getProject());
        if (file instanceof XmlFile) {
            return (PropertiesFile)manager.getCachedValue((UserDataHolder)file, KEY, (CachedValueProvider)new CachedValueProvider<PropertiesFile>(){

                public CachedValueProvider.Result<PropertiesFile> compute() {
                    XmlPropertiesFileImpl value = XmlPropertiesIndex.isPropertiesFile((XmlFile)file) ? new XmlPropertiesFileImpl((XmlFile)file) : null;
                    return CachedValueProvider.Result.create((Object)value, (Object[])new Object[]{file});
                }
            }, false);
        }
        return null;
    }

    @Override
    @NotNull
    public Map<String, String> getNamesMap() {
        THashMap result = new THashMap();
        for (IProperty property : this.getProperties()) {
            result.put(property.getUnescapedKey(), property.getValue());
        }
        THashMap tHashMap = result;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlPropertiesFileImpl", "getNamesMap"));
        }
        return tHashMap;
    }

    @Override
    public String getName() {
        return this.getContainingFile().getName();
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.getContainingFile().getVirtualFile();
    }

    @Override
    public PsiDirectory getParent() {
        return this.getContainingFile().getParent();
    }

    @Override
    public Project getProject() {
        return this.getContainingFile().getProject();
    }

    @Override
    public String getText() {
        return this.getContainingFile().getText();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XmlPropertiesFileImpl that = (XmlPropertiesFileImpl)o;
        return this.myFile.equals(that.myFile);
    }

    public int hashCode() {
        return this.myFile.hashCode();
    }
}

