/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.commander;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.actions.DocumentFragmentContent;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.ElementPresentation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiDiffContentFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.ex.PsiDiffContentFactory");

    private PsiDiffContentFactory() {
    }

    @Nullable
    private static DiffContent fromPsiElement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/ide/commander/PsiDiffContentFactory", "fromPsiElement"));
        }
        if (psiElement instanceof PsiFile) {
            return DiffContentFactory.getInstance().create(psiElement.getProject(), ((PsiFile)psiElement).getVirtualFile());
        }
        if (psiElement instanceof PsiDirectory) {
            return DiffContentFactory.getInstance().create(psiElement.getProject(), ((PsiDirectory)psiElement).getVirtualFile());
        }
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null) {
            String text = psiElement.getText();
            if (text == null) {
                return null;
            }
            return DiffContentFactory.getInstance().create(text, (FileType)psiElement.getLanguage().getAssociatedFileType());
        }
        DocumentContent wholeFileContent = DiffContentFactory.getInstance().createDocument(psiElement.getProject(), containingFile.getVirtualFile());
        if (wholeFileContent == null) {
            return null;
        }
        return new DocumentFragmentContent(psiElement.getProject(), wholeFileContent, psiElement.getTextRange());
    }

    @Nullable
    public static DiffRequest comparePsiElements(@NotNull PsiElement psiElement1, @NotNull PsiElement psiElement2) {
        if (psiElement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement1", "com/intellij/ide/commander/PsiDiffContentFactory", "comparePsiElements"));
        }
        if (psiElement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement2", "com/intellij/ide/commander/PsiDiffContentFactory", "comparePsiElements"));
        }
        if (!psiElement1.isValid() || !psiElement2.isValid()) {
            return null;
        }
        Project project = psiElement1.getProject();
        LOG.assertTrue(project == psiElement2.getProject());
        DiffContent content1 = PsiDiffContentFactory.fromPsiElement(psiElement1);
        DiffContent content2 = PsiDiffContentFactory.fromPsiElement(psiElement2);
        if (content1 == null || content2 == null) {
            return null;
        }
        ElementPresentation presentation1 = ElementPresentation.forElement((PsiElement)psiElement1);
        ElementPresentation presentation2 = ElementPresentation.forElement((PsiElement)psiElement2);
        String title = DiffBundle.message((String)"diff.element.qualified.name.vs.element.qualified.name.dialog.title", (Object[])new Object[]{presentation1.getQualifiedName(), presentation2.getQualifiedName()});
        return new SimpleDiffRequest(title, content1, content2, presentation1.getQualifiedName(), presentation2.getQualifiedName());
    }
}

