/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import java.util.Collection;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.UnsupportedNotationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeNotationParser<N, T>
implements NotationParser<N, T> {
    private final Collection<? extends NotationParser<? super N, ? extends T>> delegates;

    public CompositeNotationParser(Collection<? extends NotationParser<? super N, ? extends T>> delegates) {
        assert (delegates != null) : "delegates cannot be null!";
        this.delegates = delegates;
    }

    @Override
    public void describe(Collection<String> candidateFormats) {
        for (NotationParser<N, T> delegate : this.delegates) {
            delegate.describe(candidateFormats);
        }
    }

    @Override
    public T parseNotation(N notation) {
        for (NotationParser<N, T> delegate : this.delegates) {
            try {
                return delegate.parseNotation(notation);
            }
            catch (UnsupportedNotationException e) {
            }
        }
        throw new UnsupportedNotationException(notation);
    }
}

