/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemProperties {
    private static String ourTestUserName;

    private SystemProperties() {
    }

    public static String getUserHome() {
        return System.getProperty("user.home");
    }

    public static String getUserName() {
        return ourTestUserName != null ? ourTestUserName : System.getProperty("user.name");
    }

    public static void setTestUserName(@Nullable String name) {
        ourTestUserName = name;
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public static String getJavaVmVendor() {
        return System.getProperty("java.vm.vendor");
    }

    public static String getJavaHome() {
        return System.getProperty("java.home");
    }

    public static int getIntProperty(@NonNls @NotNull String key, int defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/SystemProperties", "getIntProperty"));
        }
        String value = System.getProperty(key);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static boolean getBooleanProperty(@NotNull String key, boolean defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/SystemProperties", "getBooleanProperty"));
        }
        String value = System.getProperty(key);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public static String getJavaVendor() {
        return System.getProperty("java.vendor");
    }
}

