/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.BasePrimitiveBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jdom.Content;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeBinding
extends BasePrimitiveBinding {
    public AttributeBinding(@NotNull Accessor accessor, @NotNull Attribute attribute) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/util/xmlb/AttributeBinding", "<init>"));
        }
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/util/xmlb/AttributeBinding", "<init>"));
        }
        super(accessor, attribute.value(), attribute.converter());
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Object o, @Nullable Object context, SerializationFilter filter) {
        String stringValue;
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/util/xmlb/AttributeBinding", "serialize"));
        }
        Object value = this.myAccessor.read(o);
        if (value == null) {
            return null;
        }
        if (this.myConverter != null) {
            stringValue = this.myConverter.toString(value);
        } else {
            assert (this.myBinding != null);
            Content content = (Content)this.myBinding.serialize(value, context, filter);
            if (content == null) {
                return null;
            }
            stringValue = content.getValue();
        }
        return new org.jdom.Attribute(this.myName, stringValue);
    }

    @Override
    @Nullable
    public Object deserialize(Object context, @NotNull Object node) {
        Object value;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/util/xmlb/AttributeBinding", "deserialize"));
        }
        org.jdom.Attribute attribute = (org.jdom.Attribute)node;
        assert (this.isBoundTo(attribute));
        if (this.myConverter != null) {
            value = this.myConverter.fromString(attribute.getValue());
        } else {
            assert (this.myBinding != null);
            value = this.myBinding.deserialize(context, new Text(attribute.getValue()));
        }
        this.myAccessor.write(context, value);
        return context;
    }

    @Override
    public boolean isBoundTo(Object node) {
        return node instanceof org.jdom.Attribute && ((org.jdom.Attribute)node).getName().equals(this.myName);
    }

    @Override
    public Class getBoundNodeType() {
        return org.jdom.Attribute.class;
    }

    @Override
    public void init() {
        super.init();
        if (this.myBinding != null && !Text.class.isAssignableFrom(this.myBinding.getBoundNodeType())) {
            throw new XmlSerializationException("Can't use attribute binding for non-text content: " + this.myAccessor);
        }
    }

    public String toString() {
        return "AttributeBinding[" + this.myName + ", binding=" + this.myBinding + "]";
    }
}

