/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.SerializationFilter;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JDOMExternalizableStringListBinding
extends Binding {
    private final String myName;

    protected JDOMExternalizableStringListBinding(@NotNull Accessor accessor) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/util/xmlb/JDOMExternalizableStringListBinding", "<init>"));
        }
        super(accessor);
        this.myName = this.myAccessor.getName();
    }

    @Override
    @Nullable
    public Object serialize(Object o, @Nullable Object context, SerializationFilter filter) {
        Element result = new Element(this.myName);
        JDOMExternalizableStringList list = (JDOMExternalizableStringList)o;
        if (list == null || list.isEmpty()) {
            return result;
        }
        for (String item : list) {
            result.addContent(new Element("item").setAttribute("value", item));
        }
        return result;
    }

    @Override
    @Nullable
    public Object deserialize(Object context, @NotNull Object node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/util/xmlb/JDOMExternalizableStringListBinding", "deserialize"));
        }
        JDOMExternalizableStringList list = (JDOMExternalizableStringList)context;
        list.clear();
        for (Element item : ((Element)node).getChildren("item")) {
            ContainerUtil.addIfNotNull(list, item.getAttributeValue("value"));
        }
        return list;
    }

    @Override
    public boolean isBoundTo(Object node) {
        return node instanceof Element && ((Element)node).getName().equals(this.myName);
    }

    @Override
    public Class getBoundNodeType() {
        return Element.class;
    }
}

