/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.BasePrimitiveBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OptionTagBinding
extends BasePrimitiveBinding {
    private final String myTagName;
    private final String myNameAttribute;
    private final String myValueAttribute;

    public OptionTagBinding(@NotNull Accessor accessor, @Nullable OptionTag optionTag) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/util/xmlb/OptionTagBinding", "<init>"));
        }
        super(accessor, optionTag == null ? null : optionTag.value(), optionTag == null ? null : optionTag.converter());
        if (optionTag == null) {
            this.myTagName = "option";
            this.myNameAttribute = "name";
            this.myValueAttribute = "value";
        } else {
            this.myNameAttribute = optionTag.nameAttribute();
            this.myValueAttribute = optionTag.valueAttribute();
            String tagName = optionTag.tag();
            if (StringUtil.isEmpty(this.myNameAttribute) && "option".equals(tagName)) {
                tagName = this.myAccessor.getName();
            }
            this.myTagName = tagName;
        }
    }

    @Override
    @Nullable
    public Object serialize(Object o, @Nullable Object context, SerializationFilter filter) {
        Object value = this.myAccessor.read(o);
        Element targetElement = new Element(this.myTagName);
        if (!StringUtil.isEmpty(this.myNameAttribute)) {
            targetElement.setAttribute(this.myNameAttribute, this.myName);
        }
        if (value == null) {
            return targetElement;
        }
        if (this.myConverter != null) {
            targetElement.setAttribute(this.myValueAttribute, this.myConverter.toString(value));
        } else {
            assert (this.myBinding != null);
            Object node = this.myBinding.serialize(value, targetElement, filter);
            if (node != null) {
                if (node instanceof Text) {
                    Text text = (Text)node;
                    targetElement.setAttribute(this.myValueAttribute, text.getText());
                } else if (targetElement != node) {
                    JDOMUtil.addContent(targetElement, node);
                }
            }
        }
        return targetElement;
    }

    @Override
    public Object deserialize(Object context, @NotNull Object node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/util/xmlb/OptionTagBinding", "deserialize"));
        }
        return this.deserialize(context, (Element)node);
    }

    private Object deserialize(Object context, Element element) {
        Attribute valueAttribute = element.getAttribute(this.myValueAttribute);
        if (valueAttribute == null) {
            List<Content> children = XmlSerializerImpl.getFilteredContent(element);
            if (children.isEmpty()) {
                this.myAccessor.write(context, null);
            } else {
                assert (this.myBinding != null);
                this.myAccessor.write(context, Binding.deserializeList(this.myBinding, this.myAccessor.read(context), children));
            }
        } else {
            Object value;
            if (this.myConverter != null) {
                value = this.myConverter.fromString(valueAttribute.getValue());
            } else {
                assert (this.myBinding != null);
                value = this.myBinding.deserialize(context, valueAttribute);
            }
            this.myAccessor.write(context, value);
        }
        return context;
    }

    @Override
    public boolean isBoundTo(Object node) {
        if (!(node instanceof Element)) {
            return false;
        }
        Element e = (Element)node;
        if (!e.getName().equals(this.myTagName)) {
            return false;
        }
        String name = e.getAttributeValue(this.myNameAttribute);
        if (StringUtil.isEmpty(this.myNameAttribute)) {
            return name == null || name.equals(this.myName);
        }
        return name != null && name.equals(this.myName);
    }

    @NonNls
    public String toString() {
        return "OptionTagBinding[" + this.myName + ", binding=" + this.myBinding + "]";
    }
}

