/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.ArrayBinding;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.CollectionBinding;
import com.intellij.util.xmlb.DateBinding;
import com.intellij.util.xmlb.JDOMElementBinding;
import com.intellij.util.xmlb.JDOMExternalizableStringListBinding;
import com.intellij.util.xmlb.MapBinding;
import com.intellij.util.xmlb.PrimitiveValueBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.filter.Filter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class XmlSerializerImpl {
    private static final Filter<Content> CONTENT_FILTER = new Filter<Content>(){

        public boolean matches(Object obj) {
            return !XmlSerializerImpl.isIgnoredNode(obj);
        }
    };
    private static java.lang.ref.SoftReference<Map<Pair<Type, Accessor>, Binding>> ourBindings;

    XmlSerializerImpl() {
    }

    @NotNull
    static List<Content> getFilteredContent(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/XmlSerializerImpl", "getFilteredContent"));
        }
        List content = element.getContent();
        if (content.isEmpty()) {
            List list = content;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "getFilteredContent"));
            }
            return list;
        }
        if (content.size() == 1) {
            List list = XmlSerializerImpl.isIgnoredNode(content.get(0)) ? Collections.emptyList() : content;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "getFilteredContent"));
            }
            return list;
        }
        List list = element.getContent(CONTENT_FILTER);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "getFilteredContent"));
        }
        return list;
    }

    @NotNull
    static Element serialize(@NotNull Object object, @NotNull SerializationFilter filter) throws XmlSerializationException {
        Element element;
        Binding binding;
        block8: {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/util/xmlb/XmlSerializerImpl", "serialize"));
            }
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/xmlb/XmlSerializerImpl", "serialize"));
            }
            Class<?> aClass = object.getClass();
            binding = XmlSerializerImpl._getClassBinding(aClass, aClass, null);
            if (!(binding instanceof BeanBinding)) break block8;
            Element element2 = ((BeanBinding)binding).serialize(object, true, filter);
            if (element2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "serialize"));
            }
            return element2;
        }
        try {
            element = (Element)binding.serialize(object, null, filter);
        }
        catch (XmlSerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException("Can't serialize instance of " + object.getClass(), e);
        }
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "serialize"));
        }
        return element;
    }

    @Nullable
    static Element serializeIfNotDefault(@NotNull Object object, @NotNull SerializationFilter filter) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/util/xmlb/XmlSerializerImpl", "serializeIfNotDefault"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/xmlb/XmlSerializerImpl", "serializeIfNotDefault"));
        }
        Class<?> aClass = object.getClass();
        return (Element)XmlSerializerImpl._getClassBinding(aClass, aClass, null).serialize(object, null, filter);
    }

    static Binding getBinding(@NotNull Type type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/util/xmlb/XmlSerializerImpl", "getBinding"));
        }
        return XmlSerializerImpl.getTypeBinding(type, null);
    }

    static Binding getBinding(@NotNull Accessor accessor) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/util/xmlb/XmlSerializerImpl", "getBinding"));
        }
        return XmlSerializerImpl.getTypeBinding(accessor.getGenericType(), accessor);
    }

    static Binding getTypeBinding(@NotNull Type type, @Nullable Accessor accessor) {
        Type bound;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/util/xmlb/XmlSerializerImpl", "getTypeBinding"));
        }
        Class aClass = type instanceof Class ? (Class)type : (type instanceof TypeVariable ? ((bound = ((TypeVariable)type).getBounds()[0]) instanceof Class ? (Class)bound : (Class)((ParameterizedType)bound).getRawType()) : (Class)((ParameterizedType)type).getRawType());
        return XmlSerializerImpl._getClassBinding(aClass, type, accessor);
    }

    @NotNull
    private static synchronized Binding _getClassBinding(@NotNull Class<?> aClass, @NotNull Type originalType, @Nullable Accessor accessor) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/xmlb/XmlSerializerImpl", "_getClassBinding"));
        }
        if (originalType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalType", "com/intellij/util/xmlb/XmlSerializerImpl", "_getClassBinding"));
        }
        Pair<Type, Accessor> key = Pair.create(originalType, accessor);
        Map<Pair<Type, Accessor>, Binding> map = XmlSerializerImpl.getBindingCacheMap();
        Binding binding = map.get(key);
        if (binding == null) {
            binding = XmlSerializerImpl._getNonCachedClassBinding(aClass, accessor, originalType);
            map.put(key, binding);
            try {
                binding.init();
            }
            catch (XmlSerializationException e) {
                map.remove(key);
                throw e;
            }
        }
        Binding binding2 = binding;
        if (binding2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "_getClassBinding"));
        }
        return binding2;
    }

    @NotNull
    private static Map<Pair<Type, Accessor>, Binding> getBindingCacheMap() {
        Map<Pair<Type, Accessor>, Binding> map = SoftReference.dereference(ourBindings);
        if (map == null) {
            map = new ConcurrentHashMap<Pair<Type, Accessor>, Binding>();
            ourBindings = new java.lang.ref.SoftReference<Map<Pair<Type, Accessor>, Binding>>(map);
        }
        Map<Pair<Type, Accessor>, Binding> map2 = map;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "getBindingCacheMap"));
        }
        return map2;
    }

    @NotNull
    private static Binding _getNonCachedClassBinding(@NotNull Class<?> aClass, @Nullable Accessor accessor, @NotNull Type originalType) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/xmlb/XmlSerializerImpl", "_getNonCachedClassBinding"));
        }
        if (originalType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalType", "com/intellij/util/xmlb/XmlSerializerImpl", "_getNonCachedClassBinding"));
        }
        if (aClass.isPrimitive()) {
            PrimitiveValueBinding primitiveValueBinding = new PrimitiveValueBinding(aClass, accessor);
            if (primitiveValueBinding == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "_getNonCachedClassBinding"));
            }
            return primitiveValueBinding;
        }
        if (aClass.isArray()) {
            Binding binding = Element.class.isAssignableFrom(aClass.getComponentType()) ? new JDOMElementBinding(accessor) : new ArrayBinding(aClass, accessor);
            if (binding == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "_getNonCachedClassBinding"));
            }
            return binding;
        }
        if (Number.class.isAssignableFrom(aClass)) {
            PrimitiveValueBinding primitiveValueBinding = new PrimitiveValueBinding(aClass, accessor);
            if (primitiveValueBinding == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "_getNonCachedClassBinding"));
            }
            return primitiveValueBinding;
        }
        if (Boolean.class.isAssignableFrom(aClass)) {
            PrimitiveValueBinding primitiveValueBinding = new PrimitiveValueBinding(aClass, accessor);
            if (primitiveValueBinding == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "_getNonCachedClassBinding"));
            }
            return primitiveValueBinding;
        }
        if (String.class.isAssignableFrom(aClass)) {
            PrimitiveValueBinding primitiveValueBinding = new PrimitiveValueBinding(aClass, accessor);
            if (primitiveValueBinding == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "_getNonCachedClassBinding"));
            }
            return primitiveValueBinding;
        }
        if (Collection.class.isAssignableFrom(aClass) && originalType instanceof ParameterizedType) {
            CollectionBinding collectionBinding = new CollectionBinding((ParameterizedType)originalType, accessor);
            if (collectionBinding == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "_getNonCachedClassBinding"));
            }
            return collectionBinding;
        }
        if (accessor != null) {
            if (Map.class.isAssignableFrom(aClass) && originalType instanceof ParameterizedType) {
                MapBinding mapBinding = new MapBinding((ParameterizedType)originalType, accessor);
                if (mapBinding == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "_getNonCachedClassBinding"));
                }
                return mapBinding;
            }
            if (Element.class.isAssignableFrom(aClass)) {
                JDOMElementBinding jDOMElementBinding = new JDOMElementBinding(accessor);
                if (jDOMElementBinding == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "_getNonCachedClassBinding"));
                }
                return jDOMElementBinding;
            }
            if (JDOMExternalizableStringList.class == aClass) {
                JDOMExternalizableStringListBinding jDOMExternalizableStringListBinding = new JDOMExternalizableStringListBinding(accessor);
                if (jDOMExternalizableStringListBinding == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "_getNonCachedClassBinding"));
                }
                return jDOMExternalizableStringListBinding;
            }
        }
        if (Date.class.isAssignableFrom(aClass)) {
            DateBinding dateBinding = new DateBinding(accessor);
            if (dateBinding == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "_getNonCachedClassBinding"));
            }
            return dateBinding;
        }
        if (aClass.isEnum()) {
            PrimitiveValueBinding primitiveValueBinding = new PrimitiveValueBinding(aClass, accessor);
            if (primitiveValueBinding == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "_getNonCachedClassBinding"));
            }
            return primitiveValueBinding;
        }
        BeanBinding beanBinding = new BeanBinding(aClass, accessor);
        if (beanBinding == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "_getNonCachedClassBinding"));
        }
        return beanBinding;
    }

    @Deprecated
    @Nullable
    static <T> T findAnnotation(Annotation[] annotations, Class<T> aClass) {
        if (annotations == null) {
            return null;
        }
        for (Annotation annotation : annotations) {
            if (!aClass.isAssignableFrom(annotation.getClass())) continue;
            return (T)annotation;
        }
        return null;
    }

    @Nullable
    static <T> T convert(Object value, Class<T> type) {
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        if (String.class.isAssignableFrom(type)) {
            return (T)String.valueOf(value);
        }
        if (Integer.TYPE.isAssignableFrom(type) || Integer.class.isAssignableFrom(type)) {
            return (T)Integer.valueOf(String.valueOf(value));
        }
        if (Double.TYPE.isAssignableFrom(type) || Double.class.isAssignableFrom(type)) {
            return (T)Double.valueOf(String.valueOf(value));
        }
        if (Float.TYPE.isAssignableFrom(type) || Float.class.isAssignableFrom(type)) {
            return (T)Float.valueOf(String.valueOf(value));
        }
        if (Long.TYPE.isAssignableFrom(type) || Long.class.isAssignableFrom(type)) {
            return (T)Long.valueOf(String.valueOf(value));
        }
        if (Boolean.TYPE.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type)) {
            return (T)Boolean.valueOf(String.valueOf(value));
        }
        if (Character.TYPE.isAssignableFrom(type) || Character.class.isAssignableFrom(type)) {
            return (T)value;
        }
        if (type.isEnum()) {
            T[] enumConstants;
            for (T enumConstant : enumConstants = type.getEnumConstants()) {
                if (!enumConstant.toString().equals(value.toString())) continue;
                return enumConstant;
            }
            return null;
        }
        throw new XmlSerializationException("Can't covert " + value.getClass() + " into " + type);
    }

    public static boolean isIgnoredNode(Object child) {
        if (child instanceof Text && StringUtil.isEmptyOrSpaces(((Text)child).getValue())) {
            return true;
        }
        if (child instanceof Comment) {
            return true;
        }
        return child instanceof Attribute && !StringUtil.isEmpty(((Attribute)child).getNamespaceURI());
    }
}

