/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service;

import com.android.tools.idea.gradle.AndroidProjectKeys;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.gradle.compiler.PostProjectBuildTasksExecutor;
import com.android.tools.idea.gradle.customizer.ModuleCustomizer;
import com.android.tools.idea.gradle.customizer.android.AndroidFacetModuleCustomizer;
import com.android.tools.idea.gradle.customizer.android.AndroidSdkModuleCustomizer;
import com.android.tools.idea.gradle.customizer.android.CompilerOutputModuleCustomizer;
import com.android.tools.idea.gradle.customizer.android.ContentRootModuleCustomizer;
import com.android.tools.idea.gradle.customizer.android.DependenciesModuleCustomizer;
import com.android.tools.idea.gradle.customizer.android.RunConfigModuleCustomizer;
import com.android.tools.idea.gradle.messages.Message;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.android.tools.idea.gradle.project.PostProjectSetupTasksExecutor;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.DefaultSdks;
import com.android.tools.idea.sdk.Jdks;
import com.android.tools.idea.startup.AndroidStudioSpecificInitializer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class AndroidProjectDataService
implements ProjectDataService<IdeaAndroidProject, Void> {
    private static final Logger LOG = Logger.getInstance(AndroidProjectDataService.class);
    private final List<ModuleCustomizer<IdeaAndroidProject>> myCustomizers;

    public AndroidProjectDataService() {
        this((List<ModuleCustomizer<IdeaAndroidProject>>)ImmutableList.of((Object)new AndroidSdkModuleCustomizer(), (Object)new AndroidFacetModuleCustomizer(), (Object)new ContentRootModuleCustomizer(), (Object)new RunConfigModuleCustomizer(), (Object)new DependenciesModuleCustomizer(), (Object)new CompilerOutputModuleCustomizer()));
    }

    @VisibleForTesting
    AndroidProjectDataService(@NotNull List<ModuleCustomizer<IdeaAndroidProject>> customizers) {
        if (customizers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customizers", "com/android/tools/idea/gradle/service/AndroidProjectDataService", "<init>"));
        }
        this.myCustomizers = customizers;
    }

    @NotNull
    public Key<IdeaAndroidProject> getTargetDataKey() {
        Key<IdeaAndroidProject> key = AndroidProjectKeys.IDE_ANDROID_PROJECT;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/AndroidProjectDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<IdeaAndroidProject>> toImport, @NotNull Project project, boolean synchronous) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/android/tools/idea/gradle/service/AndroidProjectDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/AndroidProjectDataService", "importData"));
        }
        if (!toImport.isEmpty()) {
            try {
                this.doImport(toImport, project);
            }
            catch (Throwable e) {
                LOG.error(String.format("Failed to set up Android modules in project '%1$s'", project.getName()), e);
                String msg = e.getMessage();
                if (msg == null) {
                    msg = e.getClass().getCanonicalName();
                }
                GradleSyncState.getInstance(project).syncFailed(msg);
                return;
            }
        }
        PostProjectSetupTasksExecutor.getInstance(project).onProjectSyncCompletion();
    }

    private void doImport(final Collection<DataNode<IdeaAndroidProject>> toImport, final Project project) throws Throwable {
        RunResult result = new WriteCommandAction.Simple(project, new PsiFile[0]){

            protected void run() throws Throwable {
                Sdk jdk;
                LanguageLevel javaLangVersion = null;
                ProjectSyncMessages messages = ProjectSyncMessages.getInstance(project);
                boolean hasExtraGeneratedFolders = false;
                Map androidProjectsByModuleName = AndroidProjectDataService.indexByModuleName(toImport);
                ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
                for (Module module : moduleManager.getModules()) {
                    File[] sourceFolders;
                    IdeaAndroidProject androidProject = (IdeaAndroidProject)androidProjectsByModuleName.get(module.getName());
                    AndroidProjectDataService.this.customizeModule(module, project, androidProject);
                    if (androidProject == null) continue;
                    if (javaLangVersion == null) {
                        javaLangVersion = androidProject.getJavaLanguageLevel();
                    }
                    if ((sourceFolders = androidProject.getExtraGeneratedSourceFolders()).length > 0) {
                        hasExtraGeneratedFolders = true;
                    }
                    for (File folder : sourceFolders) {
                        String[] text = new String[]{"Folder " + folder.getPath()};
                        messages.add(new Message("Source folders generated at incorrect location", Message.Type.WARNING, text), new NotificationHyperlink[0]);
                    }
                }
                if (hasExtraGeneratedFolders) {
                    messages.add(new Message("Source folders generated at incorrect location", Message.Type.INFO, "3rd-party Gradle plug-ins may be the cause"), new NotificationHyperlink[0]);
                }
                if ((jdk = ProjectRootManager.getInstance((Project)project).getProjectSdk()) == null || !AndroidStudioSpecificInitializer.isAndroidStudio() && !Jdks.isApplicableJdk(jdk, javaLangVersion)) {
                    jdk = Jdks.chooseOrCreateJavaSdk(javaLangVersion);
                }
                if (jdk == null) {
                    String title = String.format("Problems importing/refreshing Gradle project '%1$s':\n", project.getName());
                    LanguageLevel level = javaLangVersion != null ? javaLangVersion : LanguageLevel.JDK_1_6;
                    String msg = String.format("Unable to find a JDK %1$s installed.\n", level.getPresentableText());
                    msg = msg + "After configuring a suitable JDK in the \"Project Structure\" dialog, sync the Gradle project again.";
                    NotificationData notification = new NotificationData(title, msg, NotificationCategory.ERROR, NotificationSource.PROJECT_SYNC);
                    ExternalSystemNotificationManager.getInstance((Project)project).showNotification(GradleConstants.SYSTEM_ID, notification);
                } else {
                    String homePath = jdk.getHomePath();
                    if (homePath != null) {
                        NewProjectUtil.applyJdkToProject((Project)project, (Sdk)jdk);
                        homePath = FileUtil.toSystemDependentName((String)homePath);
                        DefaultSdks.setDefaultJavaHome(new File(homePath));
                        PostProjectBuildTasksExecutor.getInstance(project).updateJavaLangLevelAfterBuild();
                    }
                }
            }
        }.execute();
        Throwable error = result.getThrowable();
        if (error != null) {
            throw error;
        }
    }

    @NotNull
    private static Map<String, IdeaAndroidProject> indexByModuleName(@NotNull Collection<DataNode<IdeaAndroidProject>> dataNodes) {
        if (dataNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataNodes", "com/android/tools/idea/gradle/service/AndroidProjectDataService", "indexByModuleName"));
        }
        HashMap index = Maps.newHashMap();
        for (DataNode<IdeaAndroidProject> d : dataNodes) {
            IdeaAndroidProject androidProject = (IdeaAndroidProject)d.getData();
            index.put(androidProject.getModuleName(), androidProject);
        }
        HashMap hashMap = index;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/AndroidProjectDataService", "indexByModuleName"));
        }
        return hashMap;
    }

    private void customizeModule(@NotNull Module module, @NotNull Project project, @Nullable IdeaAndroidProject ideaAndroidProject) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/service/AndroidProjectDataService", "customizeModule"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/AndroidProjectDataService", "customizeModule"));
        }
        for (ModuleCustomizer<IdeaAndroidProject> customizer : this.myCustomizers) {
            customizer.customizeModule(module, project, ideaAndroidProject);
        }
    }

    public void removeData(@NotNull Collection<? extends Void> toRemove, @NotNull Project project, boolean synchronous) {
        if (toRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemove", "com/android/tools/idea/gradle/service/AndroidProjectDataService", "removeData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/AndroidProjectDataService", "removeData"));
        }
    }
}

