/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.view;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.gradle.customizer.ModuleCustomizer;
import com.android.tools.idea.gradle.customizer.android.CompilerOutputModuleCustomizer;
import com.android.tools.idea.gradle.customizer.android.ContentRootModuleCustomizer;
import com.android.tools.idea.gradle.customizer.android.DependenciesModuleCustomizer;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.ProjectBuilder;
import com.android.tools.idea.gradle.variant.conflict.ConflictSet;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BuildVariantUpdater {
    private static final Logger LOG = Logger.getInstance(BuildVariantUpdater.class);
    private final List<ModuleCustomizer<IdeaAndroidProject>> myAndroidModuleCustomizers = ImmutableList.of((Object)new ContentRootModuleCustomizer(), (Object)new DependenciesModuleCustomizer(), (Object)new CompilerOutputModuleCustomizer());

    BuildVariantUpdater() {
    }

    @NotNull
    List<AndroidFacet> updateModule(final @NotNull Project project, final @NotNull String moduleName, final @NotNull String buildVariantName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "updateModule"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "updateModule"));
        }
        if (buildVariantName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildVariantName", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "updateModule"));
        }
        final ArrayList facets = Lists.newArrayList();
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                Module updatedModule = BuildVariantUpdater.this.doUpdate(project, moduleName, buildVariantName, facets);
                if (updatedModule != null) {
                    ConflictSet conflicts = ConflictSet.findConflicts(project);
                    conflicts.showSelectionConflicts();
                }
                if (!facets.isEmpty() && !ApplicationManager.getApplication().isUnitTestMode()) {
                    ProjectBuilder.getInstance(project).generateSourcesOnly();
                }
            }
        });
        ArrayList arrayList = facets;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "updateModule"));
        }
        return arrayList;
    }

    @Nullable
    private Module doUpdate(@NotNull Project project, @NotNull String moduleName, @NotNull String variant, @NotNull List<AndroidFacet> affectedFacets) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "doUpdate"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "doUpdate"));
        }
        if (variant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variant", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "doUpdate"));
        }
        if (affectedFacets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affectedFacets", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "doUpdate"));
        }
        Module moduleToUpdate = BuildVariantUpdater.findModule(project, moduleName);
        if (moduleToUpdate == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variant, String.format("Cannot find module '%1$s'.", moduleName));
            return null;
        }
        AndroidFacet facet = BuildVariantUpdater.getAndroidFacet(moduleToUpdate, variant);
        if (facet == null) {
            return null;
        }
        IdeaAndroidProject androidProject = BuildVariantUpdater.getAndroidProject(facet, variant);
        if (androidProject == null) {
            return null;
        }
        if (!this.updateSelectedVariant(facet, androidProject, variant, affectedFacets)) {
            return null;
        }
        affectedFacets.add(facet);
        return moduleToUpdate;
    }

    @Nullable
    private static Module findModule(@NotNull Project project, @NotNull String moduleName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "findModule"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "findModule"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        return moduleManager.findModuleByName(moduleName);
    }

    private boolean updateSelectedVariant(@NotNull AndroidFacet androidFacet, @NotNull IdeaAndroidProject androidProject, @NotNull String variantToSelect, @NotNull List<AndroidFacet> affectedFacets) {
        if (androidFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidFacet", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "updateSelectedVariant"));
        }
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "updateSelectedVariant"));
        }
        if (variantToSelect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variantToSelect", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "updateSelectedVariant"));
        }
        if (affectedFacets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affectedFacets", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "updateSelectedVariant"));
        }
        Variant selectedVariant = androidProject.getSelectedVariant();
        if (variantToSelect.equals(selectedVariant.getName())) {
            return false;
        }
        androidProject.setSelectedVariantName(variantToSelect);
        androidFacet.syncSelectedVariant();
        Module module = androidFacet.getModule();
        Project project = module.getProject();
        for (ModuleCustomizer<IdeaAndroidProject> customizer : this.myAndroidModuleCustomizers) {
            customizer.customizeModule(module, project, androidProject);
        }
        selectedVariant = androidProject.getSelectedVariant();
        for (AndroidLibrary library : selectedVariant.getMainArtifact().getDependencies().getLibraries()) {
            String projectVariant;
            String gradlePath = library.getProject();
            if (StringUtil.isEmpty((String)gradlePath) || !StringUtil.isNotEmpty((String)(projectVariant = library.getProjectVariant()))) continue;
            this.ensureVariantIsSelected(project, gradlePath, projectVariant, affectedFacets);
        }
        return true;
    }

    private void ensureVariantIsSelected(@NotNull Project project, @NotNull String moduleGradlePath, @NotNull String variant, @NotNull List<AndroidFacet> affectedFacets) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "ensureVariantIsSelected"));
        }
        if (moduleGradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleGradlePath", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "ensureVariantIsSelected"));
        }
        if (variant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variant", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "ensureVariantIsSelected"));
        }
        if (affectedFacets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affectedFacets", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "ensureVariantIsSelected"));
        }
        Module module = GradleUtil.findModuleByGradlePath(project, moduleGradlePath);
        if (module == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variant, String.format("Cannot find module with Gradle path '%1$s'.", moduleGradlePath));
            return;
        }
        AndroidFacet facet = BuildVariantUpdater.getAndroidFacet(module, variant);
        if (facet == null) {
            return;
        }
        IdeaAndroidProject androidProject = BuildVariantUpdater.getAndroidProject(facet, variant);
        if (androidProject == null) {
            return;
        }
        if (!this.updateSelectedVariant(facet, androidProject, variant, affectedFacets)) {
            return;
        }
        affectedFacets.add(facet);
    }

    @Nullable
    private static AndroidFacet getAndroidFacet(@NotNull Module module, @NotNull String variantToSelect) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "getAndroidFacet"));
        }
        if (variantToSelect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variantToSelect", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "getAndroidFacet"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variantToSelect, String.format("Cannot find 'Android' facet in module '%1$s'.", module.getName()));
        }
        return facet;
    }

    @Nullable
    private static IdeaAndroidProject getAndroidProject(@NotNull AndroidFacet facet, @NotNull String variantToSelect) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "getAndroidProject"));
        }
        if (variantToSelect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variantToSelect", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "getAndroidProject"));
        }
        IdeaAndroidProject androidProject = facet.getIdeaAndroidProject();
        if (androidProject == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variantToSelect, String.format("Cannot find AndroidProject for module '%1$s'.", facet.getModule().getName()));
        }
        return androidProject;
    }

    private static void logAndShowUpdateFailure(@NotNull String buildVariantName, @NotNull String reason) {
        if (buildVariantName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildVariantName", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "logAndShowUpdateFailure"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "logAndShowUpdateFailure"));
        }
        String prefix = String.format("Unable to select build variant '%1$s':\n", buildVariantName);
        String msg = prefix + reason;
        LOG.error(msg);
        msg = msg + ".\n\nConsult IDE log for more details (Help | Show Log)";
        Messages.showErrorDialog((String)msg, (String)"Error");
    }
}

