/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.difftool.properties;

import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.EventObject;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.difftool.properties.SvnPropertiesDiffViewer;

public class PropertiesTableModel
extends ListTableModel<SvnPropertiesDiffViewer.PropertyDiffRecord> {
    @NotNull
    private final MyNameTableCellRenderer myNameRenderer;
    @NotNull
    private final MyValueTableCellRenderer myValueRenderer;
    @NotNull
    private final MyValueTableCellEditor myValueEditor;

    public PropertiesTableModel(@Nullable String title1, @Nullable String title2, @NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "org/jetbrains/idea/svn/difftool/properties/PropertiesTableModel", "<init>"));
        }
        super(new ColumnInfo[0]);
        this.myNameRenderer = new MyNameTableCellRenderer();
        this.myValueRenderer = new MyValueTableCellRenderer(disposable);
        this.myValueEditor = new MyValueTableCellEditor();
        ValueColumnInfo left = new ValueColumnInfo(Side.LEFT, title1, this.myValueRenderer, this.myValueEditor);
        ValueColumnInfo right = new ValueColumnInfo(Side.RIGHT, title2, this.myValueRenderer, this.myValueEditor);
        NameColumnInfo middle = new NameColumnInfo(this.myNameRenderer);
        this.setColumnInfos(new ColumnInfo[]{left, middle, right});
    }

    private static String getValueTitle(@NotNull Side side, @Nullable String title) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "org/jetbrains/idea/svn/difftool/properties/PropertiesTableModel", "getValueTitle"));
        }
        if (title != null) {
            return "Value in " + title;
        }
        return side.isLeft() ? "Value Before" : "Value After";
    }

    public void updateRowHeights(@NotNull JTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "org/jetbrains/idea/svn/difftool/properties/PropertiesTableModel", "updateRowHeights"));
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            int height = this.getPreferredHeight((SvnPropertiesDiffViewer.PropertyDiffRecord)this.getRowValue(i));
            table.setRowHeight(i, height);
        }
    }

    @Nullable
    private static Color getRecordColor(@NotNull SvnPropertiesDiffViewer.PropertyDiffRecord record) {
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "org/jetbrains/idea/svn/difftool/properties/PropertiesTableModel", "getRecordColor"));
        }
        TextDiffType type = PropertiesTableModel.getRecordDiffType(record);
        if (type == null) {
            return JBColor.black;
        }
        if (type == TextDiffType.DELETED) {
            return FileStatus.COLOR_MISSING;
        }
        if (type == TextDiffType.INSERTED) {
            return FileStatus.COLOR_ADDED;
        }
        if (type == TextDiffType.MODIFIED) {
            return FileStatus.COLOR_MODIFIED;
        }
        throw new IllegalArgumentException();
    }

    @Nullable
    private static TextDiffType getRecordDiffType(@NotNull SvnPropertiesDiffViewer.PropertyDiffRecord record) {
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "org/jetbrains/idea/svn/difftool/properties/PropertiesTableModel", "getRecordDiffType"));
        }
        if (record.getBefore() == null) {
            return TextDiffType.INSERTED;
        }
        if (record.getAfter() == null) {
            return TextDiffType.DELETED;
        }
        if (!record.getFragments().isEmpty()) {
            return TextDiffType.MODIFIED;
        }
        return null;
    }

    @NotNull
    private static String getRecordText(@NotNull SvnPropertiesDiffViewer.PropertyDiffRecord record, @NotNull Side side) {
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "org/jetbrains/idea/svn/difftool/properties/PropertiesTableModel", "getRecordText"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "org/jetbrains/idea/svn/difftool/properties/PropertiesTableModel", "getRecordText"));
        }
        String string = StringUtil.notNullize((String)((String)side.select((Object)record.getBefore(), (Object)record.getAfter())));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/difftool/properties/PropertiesTableModel", "getRecordText"));
        }
        return string;
    }

    private static void setEditorContent(@NotNull EditorEx editor, @NotNull SvnPropertiesDiffViewer.PropertyDiffRecord record, @NotNull Side side) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/idea/svn/difftool/properties/PropertiesTableModel", "setEditorContent"));
        }
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "org/jetbrains/idea/svn/difftool/properties/PropertiesTableModel", "setEditorContent"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "org/jetbrains/idea/svn/difftool/properties/PropertiesTableModel", "setEditorContent"));
        }
        String text = PropertiesTableModel.getRecordText(record, side);
        editor.getDocument().setText((CharSequence)text);
        for (LineFragment lineFragment : record.getFragments()) {
            List innerFragments = lineFragment.getInnerFragments();
            int start = side.getStartOffset((DiffFragment)lineFragment);
            int end = side.getEndOffset((DiffFragment)lineFragment);
            TextDiffType type = DiffUtil.getLineDiffType((LineFragment)lineFragment);
            DiffDrawUtil.createHighlighter((Editor)editor, (int)start, (int)end, (TextDiffType)type, (innerFragments != null ? 1 : 0) != 0);
            if (innerFragments == null) continue;
            for (DiffFragment innerFragment : innerFragments) {
                int innerStart = side.getStartOffset(innerFragment);
                int innerEnd = side.getEndOffset(innerFragment);
                TextDiffType innerType = DiffUtil.getDiffType((DiffFragment)innerFragment);
                DiffDrawUtil.createInlineHighlighter((Editor)editor, (int)(innerStart += start), (int)(innerEnd += start), (TextDiffType)innerType);
            }
        }
    }

    private int getPreferredHeight(@NotNull SvnPropertiesDiffViewer.PropertyDiffRecord record) {
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "org/jetbrains/idea/svn/difftool/properties/PropertiesTableModel", "getPreferredHeight"));
        }
        String before = StringUtil.notNullize((String)record.getBefore());
        String after = StringUtil.notNullize((String)record.getAfter());
        int lines = Math.max(StringUtil.countNewLines((CharSequence)before) + 1, StringUtil.countNewLines((CharSequence)after) + 1);
        int valueHeight = lines * this.myValueRenderer.myEditor.getLineHeight();
        int nameHeight = ((MyNameTableCellRenderer)this.myNameRenderer).myPanel.getMinimumSize().height;
        return Math.max(valueHeight, nameHeight);
    }

    private class MyValueTableCellEditor
    extends AbstractTableCellEditor {
        private SvnPropertiesDiffViewer.PropertyDiffRecord myRecord;
        private Side mySide;

        public void setRecord(SvnPropertiesDiffViewer.PropertyDiffRecord record) {
            this.myRecord = record;
        }

        public void setSide(Side side) {
            this.mySide = side;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            EditorTextField field = new EditorTextField((Document)new DocumentImpl((CharSequence)"", true), null, (FileType)FileTypes.PLAIN_TEXT, false, false){

                protected boolean shouldHaveBorder() {
                    return false;
                }
            };
            field.addSettingsProvider(new EditorSettingsProvider(){

                public void customizeSettings(EditorEx editor) {
                    PropertiesTableModel.setEditorContent(editor, MyValueTableCellEditor.this.myRecord, MyValueTableCellEditor.this.mySide);
                }
            });
            return field;
        }

        public boolean isCellEditable(EventObject e) {
            return false;
        }

        public Object getCellEditorValue() {
            return this.myRecord;
        }

        public boolean stopCellEditing() {
            return super.stopCellEditing();
        }
    }

    private class MyValueTableCellRenderer
    implements TableCellRenderer {
        @NotNull
        private final EditorEx myEditor;
        private SvnPropertiesDiffViewer.PropertyDiffRecord myRecord;
        private Side mySide;

        public MyValueTableCellRenderer(Disposable disposable) {
            if (disposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "org/jetbrains/idea/svn/difftool/properties/PropertiesTableModel$MyValueTableCellRenderer", "<init>"));
            }
            EditorTextField field = new EditorTextField((Document)new DocumentImpl((CharSequence)"", true), null, (FileType)FileTypes.PLAIN_TEXT, true, false);
            field.setSupplementary(true);
            field.addNotify();
            this.myEditor = (EditorEx)ObjectUtils.assertNotNull((Object)field.getEditor());
            this.myEditor.setRendererMode(true);
            this.myEditor.getColorsScheme().setColor(EditorColors.CARET_ROW_COLOR, null);
            this.myEditor.getScrollPane().setBorder(null);
            Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

                public void dispose() {
                    EditorFactory.getInstance().releaseEditor((Editor)MyValueTableCellRenderer.this.myEditor);
                }
            });
        }

        public void setRecord(SvnPropertiesDiffViewer.PropertyDiffRecord record) {
            this.myRecord = record;
        }

        public void setSide(Side side) {
            this.mySide = side;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.myEditor.getMarkupModel().removeAllHighlighters();
            PropertiesTableModel.setEditorContent(this.myEditor, this.myRecord, this.mySide);
            return this.myEditor.getComponent();
        }

        public int getEditorLineHeight() {
            return this.myEditor.getLineHeight();
        }

        public int getTopOffset() {
            return 0;
        }
    }

    private class MyNameTableCellRenderer
    implements TableCellRenderer {
        private SvnPropertiesDiffViewer.PropertyDiffRecord myRecord;
        @NotNull
        private final JPanel myPanel;
        @NotNull
        private final JBLabel myLabel = new JBLabel();

        public MyNameTableCellRenderer() {
            this.myLabel.setFont(UIUtil.getLabelFont());
            this.myLabel.setHorizontalAlignment(0);
            this.myLabel.setVerticalAlignment(1);
            this.myPanel = new JPanel(new BorderLayout()){

                @Override
                protected void paintComponent(Graphics g) {
                    MyNameTableCellRenderer.this.drawBackground(g);
                }
            };
            this.myPanel.add((Component)this.myLabel, "Center");
            this.myPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        }

        public void setRecord(SvnPropertiesDiffViewer.PropertyDiffRecord record) {
            this.myRecord = record;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.myLabel.setText(this.myRecord.getName());
            this.myLabel.setForeground(PropertiesTableModel.getRecordColor(this.myRecord));
            return this.myPanel;
        }

        private void drawBackground(@NotNull Graphics g) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "org/jetbrains/idea/svn/difftool/properties/PropertiesTableModel$MyNameTableCellRenderer", "drawBackground"));
            }
            g.setColor(UIUtil.getSeparatorBackground());
            g.fillRect(0, 0, this.myPanel.getWidth(), this.myPanel.getHeight());
            GraphicsUtil.setupAAPainting((Graphics)g);
            int lineHeight = PropertiesTableModel.this.myValueRenderer.getEditorLineHeight();
            int topOffset = PropertiesTableModel.this.myValueRenderer.getTopOffset();
            for (LineFragment lineFragment : this.myRecord.getFragments()) {
                TextDiffType type = DiffUtil.getLineDiffType((LineFragment)lineFragment);
                Color color = type.getColor((Editor)PropertiesTableModel.this.myValueRenderer.myEditor);
                int start1 = lineFragment.getStartLine1() * lineHeight + topOffset;
                int end1 = lineFragment.getEndLine1() * lineHeight + topOffset;
                int start2 = lineFragment.getStartLine2() * lineHeight + topOffset;
                int end2 = lineFragment.getEndLine2() * lineHeight + topOffset;
                DiffDrawUtil.drawCurveTrapezium((Graphics2D)((Graphics2D)g), (int)0, (int)this.myPanel.getWidth(), (int)start1, (int)end1, (int)start2, (int)end2, (Color)color, null);
            }
        }
    }

    private static class ValueColumnInfo
    extends ColumnInfo<SvnPropertiesDiffViewer.PropertyDiffRecord, String> {
        @NotNull
        private final Side mySide;
        @NotNull
        private final MyValueTableCellRenderer myRenderer;
        @NotNull
        private final MyValueTableCellEditor myEditor;

        public ValueColumnInfo(@NotNull Side side, @Nullable String title, @NotNull MyValueTableCellRenderer renderer, @NotNull MyValueTableCellEditor editor) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "org/jetbrains/idea/svn/difftool/properties/PropertiesTableModel$ValueColumnInfo", "<init>"));
            }
            if (renderer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "org/jetbrains/idea/svn/difftool/properties/PropertiesTableModel$ValueColumnInfo", "<init>"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/idea/svn/difftool/properties/PropertiesTableModel$ValueColumnInfo", "<init>"));
            }
            super(PropertiesTableModel.getValueTitle(side, title));
            this.mySide = side;
            this.myRenderer = renderer;
            this.myEditor = editor;
        }

        @Nullable
        public TableCellRenderer getRenderer(SvnPropertiesDiffViewer.PropertyDiffRecord record) {
            this.myRenderer.setRecord(record);
            this.myRenderer.setSide(this.mySide);
            return this.myRenderer;
        }

        @Nullable
        public String valueOf(@NotNull SvnPropertiesDiffViewer.PropertyDiffRecord record) {
            if (record == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "org/jetbrains/idea/svn/difftool/properties/PropertiesTableModel$ValueColumnInfo", "valueOf"));
            }
            return StringUtil.notNullize((String)((String)this.mySide.select((Object)record.getBefore(), (Object)record.getAfter())));
        }

        public boolean isCellEditable(SvnPropertiesDiffViewer.PropertyDiffRecord record) {
            return true;
        }

        @Nullable
        public TableCellEditor getEditor(SvnPropertiesDiffViewer.PropertyDiffRecord record) {
            this.myEditor.setRecord(record);
            this.myEditor.setSide(this.mySide);
            return this.myEditor;
        }
    }

    private static class NameColumnInfo
    extends ColumnInfo<SvnPropertiesDiffViewer.PropertyDiffRecord, String> {
        @NotNull
        private final MyNameTableCellRenderer myRenderer;

        public NameColumnInfo(@NotNull MyNameTableCellRenderer renderer) {
            if (renderer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "org/jetbrains/idea/svn/difftool/properties/PropertiesTableModel$NameColumnInfo", "<init>"));
            }
            super("SVN Property Name");
            this.myRenderer = renderer;
        }

        @Nullable
        public String valueOf(SvnPropertiesDiffViewer.PropertyDiffRecord data) {
            return data.getName();
        }

        @Nullable
        public String getPreferredStringValue() {
            return "svn:some_property";
        }

        @Nullable
        public String getMaxStringValue() {
            return "svn:some_long_property";
        }

        @Nullable
        public TableCellRenderer getRenderer(SvnPropertiesDiffViewer.PropertyDiffRecord record) {
            this.myRenderer.setRecord(record);
            return this.myRenderer;
        }
    }
}

