/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.difftool.properties;

import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.properties.PropertyData;

public class SvnPropertiesDiffRequest
extends ContentDiffRequest {
    @NotNull
    private final DiffContent[] myContents;
    @NotNull
    private final String[] myContentTitles;
    @NotNull
    private final String myWindowTitle;

    public SvnPropertiesDiffRequest(@NotNull String windowTitle, @NotNull DiffContent content1, @NotNull DiffContent content2, @NotNull String title1, @NotNull String title2) {
        if (windowTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "windowTitle", "org/jetbrains/idea/svn/difftool/properties/SvnPropertiesDiffRequest", "<init>"));
        }
        if (content1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content1", "org/jetbrains/idea/svn/difftool/properties/SvnPropertiesDiffRequest", "<init>"));
        }
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content2", "org/jetbrains/idea/svn/difftool/properties/SvnPropertiesDiffRequest", "<init>"));
        }
        if (title1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title1", "org/jetbrains/idea/svn/difftool/properties/SvnPropertiesDiffRequest", "<init>"));
        }
        if (title2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title2", "org/jetbrains/idea/svn/difftool/properties/SvnPropertiesDiffRequest", "<init>"));
        }
        this.myWindowTitle = windowTitle;
        this.myContents = new DiffContent[]{content1, content2};
        this.myContentTitles = new String[]{title1, title2};
        assert (content1 instanceof PropertyContent || content1 instanceof EmptyContent);
        assert (content2 instanceof PropertyContent || content2 instanceof EmptyContent);
        assert (content1 instanceof PropertyContent || content2 instanceof PropertyContent);
    }

    public SvnPropertiesDiffRequest(@Nullable List<PropertyData> before, @Nullable List<PropertyData> after, @Nullable String title1, @Nullable String title2) {
        assert (before != null || after != null);
        this.myContents = new DiffContent[]{this.createContent(before), this.createContent(after)};
        this.myWindowTitle = "Svn Properties Diff";
        this.myContentTitles = new String[]{title1, title2};
    }

    @NotNull
    public DiffContent createContent(@Nullable List<PropertyData> content) {
        if (content == null) {
            EmptyContent emptyContent = new EmptyContent();
            if (emptyContent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/difftool/properties/SvnPropertiesDiffRequest", "createContent"));
            }
            return emptyContent;
        }
        PropertyContent propertyContent = new PropertyContent(content);
        if (propertyContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/difftool/properties/SvnPropertiesDiffRequest", "createContent"));
        }
        return propertyContent;
    }

    @NotNull
    public String getTitle() {
        String string = this.myWindowTitle;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/difftool/properties/SvnPropertiesDiffRequest", "getTitle"));
        }
        return string;
    }

    @NotNull
    public String[] getContentTitles() {
        if (this.myContentTitles == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/difftool/properties/SvnPropertiesDiffRequest", "getContentTitles"));
        }
        return this.myContentTitles;
    }

    @NotNull
    public DiffContent[] getContents() {
        if (this.myContents == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/difftool/properties/SvnPropertiesDiffRequest", "getContents"));
        }
        return this.myContents;
    }

    public static class PropertyContent
    implements DiffContent {
        @NotNull
        private final List<PropertyData> myProperties;

        public PropertyContent(@NotNull List<PropertyData> properties) {
            if (properties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/idea/svn/difftool/properties/SvnPropertiesDiffRequest$PropertyContent", "<init>"));
            }
            this.myProperties = properties;
        }

        @NotNull
        public List<PropertyData> getProperties() {
            List<PropertyData> list = this.myProperties;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/difftool/properties/SvnPropertiesDiffRequest$PropertyContent", "getProperties"));
            }
            return list;
        }

        @Nullable
        public FileType getContentType() {
            return null;
        }

        @Nullable
        public OpenFileDescriptor getOpenFileDescriptor() {
            return null;
        }

        public void onAssigned(boolean isAssigned) {
        }
    }
}

