/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.LineMarkersPass;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineMarkersPassFactory
extends AbstractProjectComponent
implements TextEditorHighlightingPassFactory {
    public LineMarkersPassFactory(Project project, TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        super(project);
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, new int[]{10}, new int[]{4}, false, 11);
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("LineMarkersPassFactory" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/LineMarkersPassFactory", "getComponentName"));
        }
        return "LineMarkersPassFactory";
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/LineMarkersPassFactory", "createHighlightingPass"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/LineMarkersPassFactory", "createHighlightingPass"));
        }
        TextRange textRange = LineMarkersPassFactory.calculateRangeToProcessForSyntaxPass(editor);
        if (textRange == null) {
            return new ProgressableTextEditorHighlightingPass.EmptyPass(this.myProject, editor.getDocument());
        }
        return new LineMarkersPass(this.myProject, file, editor, editor.getDocument(), textRange);
    }

    @Nullable
    private static TextRange calculateRangeToProcessForSyntaxPass(Editor editor) {
        return FileStatusMap.getDirtyTextRange(editor, 4);
    }
}

