/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nullable;

public class EditorFragmentComponent
extends JPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.hint.EditorFragmentComponent");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EditorFragmentComponent(EditorEx editor, int startLine, int endLine, boolean showFolding, boolean showGutter) {
        editor.setPurePaintingMode(true);
        try {
            this.doInit(editor, startLine, endLine, showFolding, showGutter);
        }
        finally {
            editor.setPurePaintingMode(false);
        }
    }

    private void doInit(final EditorEx editor, int startLine, int endLine, final boolean showFolding, final boolean showGutter) {
        DocumentEx doc = editor.getDocument();
        int endOffset = endLine < doc.getLineCount() ? doc.getLineEndOffset(endLine) : doc.getTextLength();
        final int textImageWidth = Math.min(editor.getMaxWidthInRange(doc.getLineStartOffset(startLine), endOffset), ScreenUtil.getScreenRectangle((int)1, (int)1).width);
        LOG.assertTrue(textImageWidth > 0, (Object)("TextWidth: " + textImageWidth + "; startLine:" + startLine + "; endLine:" + endLine + ";"));
        final FoldingModelEx foldingModel = editor.getFoldingModel();
        final boolean isFoldingEnabled = foldingModel.isFoldingEnabled();
        if (!showFolding) {
            foldingModel.setFoldingEnabled(false);
        }
        Point p1 = editor.logicalPositionToXY(new LogicalPosition(startLine, 0));
        Point p2 = editor.logicalPositionToXY(new LogicalPosition(Math.max(endLine, startLine + 1), 0));
        int y2 = p2.y;
        final int y1 = p1.y;
        final int textImageHeight = y2 - y1 == 0 ? editor.getLineHeight() : y2 - y1;
        LOG.assertTrue(textImageHeight > 0, (Object)("Height: " + textImageHeight + "; startLine:" + startLine + "; endLine:" + endLine + "; p1:" + p1 + "; p2:" + p2));
        final int savedScrollOffset = editor.getScrollingModel().getHorizontalScrollOffset();
        if (savedScrollOffset > 0) {
            editor.getScrollingModel().scrollHorizontally(0);
        }
        JComponent component = new JComponent(){
            private Graphics2D componentGraphics;
            private JComponent rowHeader;
            private BufferedImage markersImage;
            private int markersImageWidth;
            private BufferedImage textImage;

            private void updateImages() {
                if (this.getGraphics().equals(this.componentGraphics)) {
                    return;
                }
                this.componentGraphics = (Graphics2D)this.getGraphics();
                this.textImage = UIUtil.createImageForGraphics((Graphics2D)this.componentGraphics, (int)textImageWidth, (int)textImageHeight, (int)1);
                Graphics textGraphics = this.textImage.getGraphics();
                UISettings.setupAntialiasing((Graphics)textGraphics);
                if (showGutter) {
                    this.rowHeader = editor.getGutterComponentEx();
                    this.markersImageWidth = Math.max(1, this.rowHeader.getWidth());
                    this.markersImage = UIUtil.createImageForGraphics((Graphics2D)this.componentGraphics, (int)this.markersImageWidth, (int)textImageHeight, (int)1);
                    Graphics markerGraphics = this.markersImage.getGraphics();
                    UISettings.setupAntialiasing((Graphics)markerGraphics);
                    markerGraphics.translate(0, -y1);
                    markerGraphics.setClip(0, y1, this.rowHeader.getWidth(), textImageHeight);
                    markerGraphics.setColor(EditorFragmentComponent.getBackgroundColor(editor));
                    markerGraphics.fillRect(0, y1, this.rowHeader.getWidth(), textImageHeight);
                    this.rowHeader.paint(markerGraphics);
                } else {
                    this.markersImageWidth = 0;
                    this.rowHeader = null;
                    this.markersImage = null;
                }
                textGraphics.translate(0, -y1);
                textGraphics.setClip(0, y1, textImageWidth, textImageHeight);
                boolean wasVisible = editor.setCaretVisible(false);
                editor.getContentComponent().paint(textGraphics);
                if (wasVisible) {
                    editor.setCaretVisible(true);
                }
                if (!showFolding) {
                    foldingModel.setFoldingEnabled(isFoldingEnabled);
                }
                if (savedScrollOffset > 0) {
                    editor.getScrollingModel().scrollHorizontally(savedScrollOffset);
                }
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(textImageWidth + this.markersImageWidth, textImageHeight);
            }

            @Override
            public void addNotify() {
                super.addNotify();
                this.updateImages();
            }

            @Override
            protected void paintComponent(Graphics graphics) {
                if (this.markersImage != null) {
                    UIUtil.drawImage((Graphics)graphics, (Image)this.markersImage, (int)0, (int)0, null);
                    UIUtil.drawImage((Graphics)graphics, (Image)this.textImage, (int)this.rowHeader.getWidth(), (int)0, null);
                } else {
                    UIUtil.drawImage((Graphics)graphics, (Image)this.textImage, (int)0, (int)0, null);
                }
            }
        };
        this.setLayout(new BorderLayout());
        this.add(component);
        Color borderColor = editor.getColorsScheme().getColor(EditorColors.SELECTED_TEARLINE_COLOR);
        Border outsideBorder = BorderFactory.createLineBorder(borderColor, 1);
        Border insideBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        this.setBorder(BorderFactory.createCompoundBorder(outsideBorder, insideBorder));
    }

    @Nullable
    public static LightweightHint showEditorFragmentHintAt(Editor editor, TextRange range, int y, boolean showUpward, boolean showFolding, boolean hideByAnyKey) {
        int endLine;
        char c;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        Document document = editor.getDocument();
        int startOffset = range.getStartOffset();
        int startLine = document.getLineNumber(startOffset);
        CharSequence text = document.getCharsSequence();
        boolean incrementLine = false;
        int max = Math.min(range.getEndOffset(), text.length());
        for (int offset = startOffset; offset < max && (incrementLine = StringUtil.isWhiteSpace((char)(c = text.charAt(offset)))) && c != '\n'; ++offset) {
        }
        if (incrementLine) {
            ++startLine;
        }
        if (startLine >= (endLine = Math.min(document.getLineNumber(range.getEndOffset()) + 1, document.getLineCount() - 1))) {
            return null;
        }
        EditorFragmentComponent fragmentComponent = EditorFragmentComponent.createEditorFragmentComponent(editor, startLine, endLine, showFolding, true);
        if (showUpward) {
            y -= fragmentComponent.getPreferredSize().height + 10;
            y = Math.max(0, y);
        }
        JComponent c2 = editor.getComponent();
        int x = SwingUtilities.convertPoint((Component)c2, (Point)new Point((int)-3, (int)0), (Component)UIUtil.getRootPane((Component)c2)).x;
        Point p = new Point(x, y);
        MyComponentHint hint = new MyComponentHint(fragmentComponent);
        HintManagerImpl.getInstanceImpl().showEditorHint((LightweightHint)hint, editor, p, (hideByAnyKey ? 2 : 0) | 8 | 0x100, 0, false, new HintHint(editor, p));
        return hint;
    }

    public static EditorFragmentComponent createEditorFragmentComponent(Editor editor, int startLine, int endLine, boolean showFolding, boolean showGutter) {
        EditorEx editorEx = (EditorEx)editor;
        Color old = editorEx.getBackgroundColor();
        Color backColor = EditorFragmentComponent.getBackgroundColor(editor);
        editorEx.setBackgroundColor(backColor);
        EditorFragmentComponent fragmentComponent = new EditorFragmentComponent(editorEx, startLine, endLine, showFolding, showGutter);
        fragmentComponent.setBackground(backColor);
        editorEx.setBackgroundColor(old);
        return fragmentComponent;
    }

    @Nullable
    public static LightweightHint showEditorFragmentHint(Editor editor, TextRange range, boolean showFolding, boolean hideByAnyKey) {
        JComponent editorComponent = editor.getComponent();
        JRootPane rootPane = editorComponent.getRootPane();
        if (rootPane == null) {
            return null;
        }
        JLayeredPane layeredPane = rootPane.getLayeredPane();
        Point point = SwingUtilities.convertPoint(editorComponent, -2, 0, layeredPane);
        return EditorFragmentComponent.showEditorFragmentHintAt(editor, range, point.y, true, showFolding, hideByAnyKey);
    }

    public static Color getBackgroundColor(Editor editor) {
        EditorColorsScheme colorsScheme = editor.getColorsScheme();
        Color color = colorsScheme.getColor(EditorColors.CARET_ROW_COLOR);
        if (color == null) {
            color = colorsScheme.getDefaultBackground();
        }
        return color;
    }

    private static class MyComponentHint
    extends LightweightHint {
        public MyComponentHint(JComponent component) {
            super(component);
            this.setForceLightweightPopup(true);
        }

        @Override
        public void hide() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MyComponentHint.super.hide();
                }
            });
        }
    }
}

