/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.EditorTextProvider;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDebuggerEvaluator
extends XDebuggerEvaluator {
    private final DebugProcessImpl myDebugProcess;
    private final JavaStackFrame myStackFrame;

    public JavaDebuggerEvaluator(DebugProcessImpl debugProcess, JavaStackFrame stackFrame) {
        this.myDebugProcess = debugProcess;
        this.myStackFrame = stackFrame;
    }

    public void evaluate(@NotNull String expression, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/debugger/engine/JavaDebuggerEvaluator", "evaluate"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/debugger/engine/JavaDebuggerEvaluator", "evaluate"));
        }
        this.evaluate(XExpressionImpl.fromText(expression), callback, expressionPosition);
    }

    public void evaluate(final @NotNull XExpression expression, final @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/debugger/engine/JavaDebuggerEvaluator", "evaluate"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/debugger/engine/JavaDebuggerEvaluator", "evaluate"));
        }
        this.myDebugProcess.getManagerThread().schedule(new DebuggerContextCommandImpl(this.myDebugProcess.getDebuggerContext()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            @Override
            public void threadAction() {
                JavaDebugProcess process = JavaDebuggerEvaluator.this.myDebugProcess.getXdebugProcess();
                if (process == null) {
                    callback.errorOccurred("No debug process");
                    return;
                }
                TextWithImports text = TextWithImportsImpl.fromXExpression(expression);
                NodeManagerImpl nodeManager = process.getNodeManager();
                WatchItemDescriptor descriptor = nodeManager.getWatchItemDescriptor(null, text, null);
                EvaluationContextImpl evalContext = JavaDebuggerEvaluator.this.myStackFrame.getFrameDebuggerContext().createEvaluationContext();
                if (evalContext == null) {
                    callback.errorOccurred("Context is not available");
                    return;
                }
                descriptor.setContext(evalContext);
                EvaluateException exception = descriptor.getEvaluateException();
                if (exception != null && descriptor.getValue() == null) {
                    callback.errorOccurred(exception.getMessage());
                    return;
                }
                callback.evaluated((XValue)JavaValue.create(null, descriptor, evalContext, nodeManager, true));
            }
        });
    }

    @Nullable
    public TextRange getExpressionRangeAtOffset(final Project project, final Document document, final int offset, final boolean sideEffectsAllowed) {
        final Ref currentRange = Ref.create(null);
        PsiDocumentManager.getInstance((Project)project).commitAndRunReadAction(new Runnable(){

            @Override
            public void run() {
                PsiElement elementAtCursor = DebuggerUtilsEx.findElementAt(PsiDocumentManager.getInstance((Project)project).getPsiFile(document), offset);
                if (elementAtCursor == null) {
                    return;
                }
                Pair pair = JavaDebuggerEvaluator.findExpression(elementAtCursor, sideEffectsAllowed);
                if (pair != null) {
                    currentRange.set(pair.getSecond());
                }
            }
        });
        return (TextRange)currentRange.get();
    }

    @Nullable
    private static Pair<PsiElement, TextRange> findExpression(PsiElement element, boolean allowMethodCalls) {
        EditorTextProvider textProvider = (EditorTextProvider)EditorTextProvider.EP.forLanguage(element.getLanguage());
        if (textProvider != null) {
            return textProvider.findExpression(element, allowMethodCalls);
        }
        return null;
    }

    public EvaluationMode getEvaluationMode(@NotNull String text, int startOffset, int endOffset, @Nullable PsiFile psiFile) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/debugger/engine/JavaDebuggerEvaluator", "getEvaluationMode"));
        }
        if (psiFile != null) {
            PsiElement[] range = CodeInsightUtil.findStatementsInRange(psiFile, startOffset, endOffset);
            return range.length > 1 ? EvaluationMode.CODE_FRAGMENT : EvaluationMode.EXPRESSION;
        }
        return super.getEvaluationMode(text, startOffset, endOffset, null);
    }
}

