/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactoryContextWrapper;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.DefaultCodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilder;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.EditorTextProvider;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.CompletionEditor;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggerUtilsEx
extends DebuggerUtils {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.impl.DebuggerUtilsEx");
    private static Set<String> myCharOrIntegers;

    public static List<CodeFragmentFactory> getCodeFragmentFactories(@Nullable PsiElement context) {
        DefaultCodeFragmentFactory defaultFactory = DefaultCodeFragmentFactory.getInstance();
        CodeFragmentFactory[] providers = (CodeFragmentFactory[])ApplicationManager.getApplication().getExtensions(CodeFragmentFactory.EXTENSION_POINT_NAME);
        ArrayList<CodeFragmentFactory> suitableFactories = new ArrayList<CodeFragmentFactory>(providers.length);
        if (providers.length > 0) {
            for (CodeFragmentFactory factory : providers) {
                if (factory == defaultFactory || !factory.isContextAccepted(context)) continue;
                suitableFactories.add(factory);
            }
        }
        suitableFactories.add(defaultFactory);
        return suitableFactories;
    }

    public static PsiMethod findPsiMethod(PsiFile file, int offset) {
        PsiElement element = null;
        while (offset >= 0 && (element = file.findElementAt(offset)) == null) {
            --offset;
        }
        while (element != null) {
            if (element instanceof PsiClass || element instanceof PsiLambdaExpression) {
                return null;
            }
            if (element instanceof PsiMethod) {
                return (PsiMethod)element;
            }
            element = element.getParent();
        }
        return null;
    }

    public static boolean isAssignableFrom(String baseQualifiedName, ReferenceType checkedType) {
        if ("java.lang.Object".equals(baseQualifiedName)) {
            return true;
        }
        return DebuggerUtilsEx.getSuperClass(baseQualifiedName, checkedType) != null;
    }

    public static ReferenceType getSuperClass(String baseQualifiedName, ReferenceType checkedType) {
        if (baseQualifiedName.equals(checkedType.name())) {
            return checkedType;
        }
        if (checkedType instanceof ClassType) {
            ReferenceType superClass;
            ClassType classType = (ClassType)checkedType;
            ClassType superClassType = classType.superclass();
            if (superClassType != null && (superClass = DebuggerUtilsEx.getSuperClass(baseQualifiedName, superClassType)) != null) {
                return superClass;
            }
            List<InterfaceType> interfaces = classType.allInterfaces();
            for (InterfaceType iface : interfaces) {
                ReferenceType superClass2 = DebuggerUtilsEx.getSuperClass(baseQualifiedName, iface);
                if (superClass2 == null) continue;
                return superClass2;
            }
        }
        if (checkedType instanceof InterfaceType) {
            List<InterfaceType> list = ((InterfaceType)checkedType).superinterfaces();
            for (InterfaceType superInterface : list) {
                ReferenceType superClass = DebuggerUtilsEx.getSuperClass(baseQualifiedName, superInterface);
                if (superClass == null) continue;
                return superClass;
            }
        }
        return null;
    }

    public static boolean valuesEqual(Value val1, Value val2) {
        if (val1 == null) {
            return val2 == null;
        }
        if (val2 == null) {
            return false;
        }
        if (val1 instanceof StringReference && val2 instanceof StringReference) {
            return ((StringReference)val1).value().equals(((StringReference)val2).value());
        }
        return val1.equals(val2);
    }

    public static String getValueOrErrorAsString(EvaluationContext evaluationContext, Value value) {
        try {
            return DebuggerUtilsEx.getValueAsString((EvaluationContext)evaluationContext, (Value)value);
        }
        catch (EvaluateException e) {
            return e.getMessage();
        }
    }

    public static boolean isCharOrInteger(Value value) {
        return value instanceof CharValue || DebuggerUtilsEx.isInteger((Value)value);
    }

    public static boolean isCharOrIntegerArray(Value value) {
        if (value == null) {
            return false;
        }
        if (myCharOrIntegers == null) {
            myCharOrIntegers = new HashSet<String>();
            myCharOrIntegers.add("C");
            myCharOrIntegers.add("B");
            myCharOrIntegers.add("S");
            myCharOrIntegers.add("I");
            myCharOrIntegers.add("J");
        }
        String signature = value.type().signature();
        int i = 0;
        while (signature.charAt(i) == '[') {
            ++i;
        }
        if (i == 0) {
            return false;
        }
        signature = signature.substring(i, signature.length());
        return myCharOrIntegers.contains(signature);
    }

    public static ClassFilter create(Element element) throws InvalidDataException {
        ClassFilter filter = new ClassFilter();
        DefaultJDOMExternalizer.readExternal((Object)filter, (Element)element);
        return filter;
    }

    private static boolean isFiltered(ClassFilter classFilter, String qName) {
        if (!classFilter.isEnabled()) {
            return false;
        }
        try {
            if (classFilter.matches(qName)) {
                return true;
            }
        }
        catch (PatternSyntaxException e) {
            LOG.debug((Throwable)e);
        }
        return false;
    }

    public static boolean isFiltered(String qName, ClassFilter[] classFilters) {
        return DebuggerUtilsEx.isFiltered(qName, Arrays.asList(classFilters));
    }

    public static boolean isFiltered(String qName, List<ClassFilter> classFilters) {
        if (qName.indexOf(91) != -1) {
            return false;
        }
        for (ClassFilter filter : classFilters) {
            if (!DebuggerUtilsEx.isFiltered(filter, qName)) continue;
            return true;
        }
        return false;
    }

    public static int getEnabledNumber(ClassFilter[] classFilters) {
        int res = 0;
        for (ClassFilter filter : classFilters) {
            if (!filter.isEnabled()) continue;
            ++res;
        }
        return res;
    }

    public static ClassFilter[] readFilters(List<Element> children) throws InvalidDataException {
        if (ContainerUtil.isEmpty(children)) {
            return ClassFilter.EMPTY_ARRAY;
        }
        ClassFilter[] filters = new ClassFilter[children.size()];
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            filters[i] = DebuggerUtilsEx.create(children.get(i));
        }
        return filters;
    }

    public static void writeFilters(Element parentNode, @NonNls String tagName, ClassFilter[] filters) throws WriteExternalException {
        for (ClassFilter filter : filters) {
            Element element = new Element(tagName);
            parentNode.addContent(element);
            DefaultJDOMExternalizer.writeExternal((Object)filter, (Element)element);
        }
    }

    public static boolean filterEquals(ClassFilter[] filters1, ClassFilter[] filters2) {
        if (filters1.length != filters2.length) {
            return false;
        }
        HashSet f1 = new HashSet(Math.max((int)((float)filters1.length / 0.75f) + 1, 16));
        HashSet f2 = new HashSet(Math.max((int)((float)filters2.length / 0.75f) + 1, 16));
        Collections.addAll(f1, filters1);
        Collections.addAll(f2, filters2);
        return ((Object)f2).equals(f1);
    }

    private static boolean elementListsEqual(List<Element> l1, List<Element> l2) {
        if (l1 == null) {
            return l2 == null;
        }
        if (l2 == null) {
            return false;
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        Iterator<Element> i1 = l1.iterator();
        for (Element aL2 : l2) {
            Element elem1 = i1.next();
            if (DebuggerUtilsEx.elementsEqual(elem1, aL2)) continue;
            return false;
        }
        return true;
    }

    private static boolean attributeListsEqual(List<Attribute> l1, List<Attribute> l2) {
        if (l1 == null) {
            return l2 == null;
        }
        if (l2 == null) {
            return false;
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        Iterator<Attribute> i1 = l1.iterator();
        for (Attribute aL2 : l2) {
            Attribute attr1 = i1.next();
            if (Comparing.equal((String)attr1.getName(), (String)aL2.getName()) && Comparing.equal((String)attr1.getValue(), (String)aL2.getValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean elementsEqual(Element e1, Element e2) {
        if (e1 == null) {
            return e2 == null;
        }
        if (!Comparing.equal((String)e1.getName(), (String)e2.getName())) {
            return false;
        }
        if (!DebuggerUtilsEx.elementListsEqual(e1.getChildren(), e2.getChildren())) {
            return false;
        }
        return DebuggerUtilsEx.attributeListsEqual(e1.getAttributes(), e2.getAttributes());
    }

    public static boolean externalizableEqual(JDOMExternalizable e1, JDOMExternalizable e2) {
        Element root1 = new Element("root");
        Element root2 = new Element("root");
        try {
            e1.writeExternal(root1);
        }
        catch (WriteExternalException e) {
            LOG.debug((Throwable)e);
        }
        try {
            e2.writeExternal(root2);
        }
        catch (WriteExternalException e) {
            LOG.debug((Throwable)e);
        }
        return DebuggerUtilsEx.elementsEqual(root1, root2);
    }

    @NotNull
    public static List<Pair<Breakpoint, Event>> getEventDescriptors(SuspendContextImpl suspendContext) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (suspendContext == null) {
            List<Pair<Breakpoint, Event>> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/DebuggerUtilsEx", "getEventDescriptors"));
            }
            return list;
        }
        EventSet events = suspendContext.getEventSet();
        if (events == null) {
            List<Pair<Breakpoint, Event>> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/DebuggerUtilsEx", "getEventDescriptors"));
            }
            return list;
        }
        SmartList eventDescriptors = new SmartList();
        RequestManagerImpl requestManager = suspendContext.getDebugProcess().getRequestsManager();
        for (Event event : events) {
            Requestor requestor = requestManager.findRequestor(event.request());
            if (!(requestor instanceof Breakpoint)) continue;
            eventDescriptors.add(Pair.create((Object)((Breakpoint)requestor), (Object)event));
        }
        SmartList smartList = eventDescriptors;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/DebuggerUtilsEx", "getEventDescriptors"));
        }
        return smartList;
    }

    public static TextWithImports getEditorText(Editor editor) {
        if (editor == null) {
            return null;
        }
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        String defaultExpression = editor.getSelectionModel().getSelectedText();
        if (defaultExpression == null) {
            TextWithImports editorText;
            EditorTextProvider textProvider;
            PsiElement elementAtCursor;
            int offset = editor.getCaretModel().getOffset();
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (psiFile != null && (elementAtCursor = psiFile.findElementAt(offset)) != null && (textProvider = (EditorTextProvider)EditorTextProvider.EP.forLanguage(elementAtCursor.getLanguage())) != null && (editorText = textProvider.getEditorText(elementAtCursor)) != null) {
                return editorText;
            }
        } else {
            return new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, defaultExpression);
        }
        return null;
    }

    public abstract DebuggerTreeNode getSelectedNode(DataContext var1);

    public abstract EvaluatorBuilder getEvaluatorBuilder();

    public abstract CompletionEditor createEditor(Project var1, PsiElement var2, @NonNls String var3);

    @NotNull
    public static CodeFragmentFactory findAppropriateCodeFragmentFactory(final TextWithImports text, final PsiElement context) {
        CodeFragmentFactory factory = (CodeFragmentFactory)ApplicationManager.getApplication().runReadAction((Computable)new Computable<CodeFragmentFactory>(){

            public CodeFragmentFactory compute() {
                FileType fileType = text.getFileType();
                List<CodeFragmentFactory> factories = DebuggerUtilsEx.getCodeFragmentFactories(context);
                if (fileType == null) {
                    return factories.get(0);
                }
                for (CodeFragmentFactory factory : factories) {
                    if (!factory.getFileType().equals(fileType)) continue;
                    return factory;
                }
                return DefaultCodeFragmentFactory.getInstance();
            }
        });
        CodeFragmentFactoryContextWrapper codeFragmentFactoryContextWrapper = new CodeFragmentFactoryContextWrapper(factory);
        if (codeFragmentFactoryContextWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/DebuggerUtilsEx", "findAppropriateCodeFragmentFactory"));
        }
        return codeFragmentFactoryContextWrapper;
    }

    public static String methodName(Method m) {
        return DebuggerUtilsEx.methodName(DebuggerUtilsEx.signatureToName(m.declaringType().signature()), m.name(), m.signature());
    }

    public static String methodName(final String className, final String methodName, String signature) {
        try {
            return new SigReader(signature){

                @Override
                String getMethodName() {
                    return methodName;
                }

                @Override
                String getClassName() {
                    return className;
                }
            }.getSignature();
        }
        catch (Exception ignored) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Internal error : unknown signature" + signature);
            }
            return className + "." + methodName;
        }
    }

    public static String signatureToName(String s) {
        return new SigReader(s).getSignature();
    }

    public static Value createValue(VirtualMachineProxyImpl vm, String expectedType, double value) {
        if (PsiType.DOUBLE.getPresentableText().equals(expectedType)) {
            return vm.mirrorOf(value);
        }
        if (PsiType.FLOAT.getPresentableText().equals(expectedType)) {
            return vm.mirrorOf((float)value);
        }
        return DebuggerUtilsEx.createValue(vm, expectedType, (long)value);
    }

    public static Value createValue(VirtualMachineProxyImpl vm, String expectedType, long value) {
        if (PsiType.LONG.getPresentableText().equals(expectedType)) {
            return vm.mirrorOf(value);
        }
        if (PsiType.INT.getPresentableText().equals(expectedType)) {
            return vm.mirrorOf((int)value);
        }
        if (PsiType.SHORT.getPresentableText().equals(expectedType)) {
            return vm.mirrorOf((short)value);
        }
        if (PsiType.BYTE.getPresentableText().equals(expectedType)) {
            return vm.mirrorOf((byte)value);
        }
        if (PsiType.CHAR.getPresentableText().equals(expectedType)) {
            return vm.mirrorOf((char)value);
        }
        if (PsiType.DOUBLE.getPresentableText().equals(expectedType)) {
            return vm.mirrorOf((double)value);
        }
        if (PsiType.FLOAT.getPresentableText().equals(expectedType)) {
            return vm.mirrorOf((float)value);
        }
        return null;
    }

    public static Value createValue(VirtualMachineProxyImpl vm, String expectedType, boolean value) {
        if (PsiType.BOOLEAN.getPresentableText().equals(expectedType)) {
            return vm.mirrorOf(value);
        }
        return null;
    }

    public static Value createValue(VirtualMachineProxyImpl vm, String expectedType, char value) {
        if (PsiType.CHAR.getPresentableText().equals(expectedType)) {
            return vm.mirrorOf(value);
        }
        if (PsiType.LONG.getPresentableText().equals(expectedType)) {
            return vm.mirrorOf((long)value);
        }
        if (PsiType.INT.getPresentableText().equals(expectedType)) {
            return vm.mirrorOf((int)value);
        }
        if (PsiType.SHORT.getPresentableText().equals(expectedType)) {
            return vm.mirrorOf((short)value);
        }
        if (PsiType.BYTE.getPresentableText().equals(expectedType)) {
            return vm.mirrorOf((byte)value);
        }
        return null;
    }

    public static String truncateString(String str) {
        if (str.length() > 105) {
            return str.substring(0, 105);
        }
        return str;
    }

    public static String getThreadStatusText(int statusId) {
        switch (statusId) {
            case 3: {
                return DebuggerBundle.message((String)"status.thread.monitor", (Object[])new Object[0]);
            }
            case 5: {
                return DebuggerBundle.message((String)"status.thread.not.started", (Object[])new Object[0]);
            }
            case 1: {
                return DebuggerBundle.message((String)"status.thread.running", (Object[])new Object[0]);
            }
            case 2: {
                return DebuggerBundle.message((String)"status.thread.sleeping", (Object[])new Object[0]);
            }
            case -1: {
                return DebuggerBundle.message((String)"status.thread.unknown", (Object[])new Object[0]);
            }
            case 4: {
                return DebuggerBundle.message((String)"status.thread.wait", (Object[])new Object[0]);
            }
            case 0: {
                return DebuggerBundle.message((String)"status.thread.zombie", (Object[])new Object[0]);
            }
        }
        return DebuggerBundle.message((String)"status.thread.undefined", (Object[])new Object[0]);
    }

    public static String prepareValueText(String text, Project project) {
        text = StringUtil.unquoteString((String)text);
        text = StringUtil.unescapeStringCharacters((String)text);
        int tabSize = CodeStyleSettingsManager.getSettings((Project)project).getTabSize((FileType)StdFileTypes.JAVA);
        if (tabSize < 0) {
            tabSize = 0;
        }
        return text.replace("\t", StringUtil.repeat((String)" ", (int)tabSize));
    }

    @Nullable
    public static XSourcePosition toXSourcePosition(@NotNull SourcePosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/impl/DebuggerUtilsEx", "toXSourcePosition"));
        }
        VirtualFile file = position.getFile().getVirtualFile();
        if (file == null) {
            file = position.getFile().getOriginalFile().getVirtualFile();
        }
        if (file == null) {
            return null;
        }
        return new JavaXSourcePosition(position, file);
    }

    @Nullable
    public static PsiElement findElementAt(@Nullable PsiFile file, int offset) {
        if (file instanceof PsiCompiledFile) {
            file = ((PsiCompiledFile)file).getDecompiledPsiFile();
        }
        if (file == null) {
            return null;
        }
        return file.findElementAt(offset);
    }

    private static class JavaXSourcePosition
    implements XSourcePosition {
        private final SourcePosition mySourcePosition;
        @NotNull
        private final VirtualFile myFile;

        public JavaXSourcePosition(@NotNull SourcePosition sourcePosition, @NotNull VirtualFile file) {
            if (sourcePosition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourcePosition", "com/intellij/debugger/impl/DebuggerUtilsEx$JavaXSourcePosition", "<init>"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/debugger/impl/DebuggerUtilsEx$JavaXSourcePosition", "<init>"));
            }
            this.mySourcePosition = sourcePosition;
            this.myFile = file;
        }

        public int getLine() {
            return this.mySourcePosition.getLine();
        }

        public int getOffset() {
            return this.mySourcePosition.getOffset();
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.myFile;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/DebuggerUtilsEx$JavaXSourcePosition", "getFile"));
            }
            return virtualFile;
        }

        @NotNull
        public Navigatable createNavigatable(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/impl/DebuggerUtilsEx$JavaXSourcePosition", "createNavigatable"));
            }
            OpenFileDescriptor openFileDescriptor = XSourcePositionImpl.createOpenFileDescriptor(project, this);
            if (openFileDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/DebuggerUtilsEx$JavaXSourcePosition", "createNavigatable"));
            }
            return openFileDescriptor;
        }
    }

    private static class SigReader {
        final String buffer;
        int pos = 0;

        SigReader(String s) {
            this.buffer = s;
        }

        int get() {
            return this.buffer.charAt(this.pos++);
        }

        int peek() {
            return this.buffer.charAt(this.pos);
        }

        boolean eof() {
            return this.buffer.length() <= this.pos;
        }

        @NonNls
        String getSignature() {
            if (this.eof()) {
                return "";
            }
            switch (this.get()) {
                case 90: {
                    return "boolean";
                }
                case 66: {
                    return "byte";
                }
                case 67: {
                    return "char";
                }
                case 83: {
                    return "short";
                }
                case 73: {
                    return "int";
                }
                case 74: {
                    return "long";
                }
                case 70: {
                    return "float";
                }
                case 68: {
                    return "double";
                }
                case 86: {
                    return "void";
                }
                case 76: {
                    int start = this.pos;
                    this.pos = this.buffer.indexOf(59, start) + 1;
                    LOG.assertTrue(this.pos > 0);
                    return this.buffer.substring(start, this.pos - 1).replace('/', '.');
                }
                case 91: {
                    return this.getSignature() + "[]";
                }
                case 40: {
                    StringBuilder result = new StringBuilder("(");
                    String separator = "";
                    while (this.peek() != 41) {
                        result.append(separator);
                        result.append(this.getSignature());
                        separator = ", ";
                    }
                    this.get();
                    result.append(")");
                    return this.getSignature() + " " + this.getClassName() + "." + this.getMethodName() + " " + result;
                }
            }
            return null;
        }

        String getMethodName() {
            return "";
        }

        String getClassName() {
            return "";
        }
    }
}

