/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffRequestFactoryImpl
extends DiffRequestFactory {
    private DiffContentFactory myContentFactory = DiffContentFactory.getInstance();

    @NotNull
    public ContentDiffRequest createFromFiles(@Nullable Project project, @NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/diff/DiffRequestFactoryImpl", "createFromFiles"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/diff/DiffRequestFactoryImpl", "createFromFiles"));
        }
        DiffContent content1 = this.myContentFactory.create(project, file1);
        DiffContent content2 = this.myContentFactory.create(project, file2);
        String title1 = this.getContentTitle(file1);
        String title2 = this.getContentTitle(file2);
        String title = this.getTitle(file1, file2);
        SimpleDiffRequest simpleDiffRequest = new SimpleDiffRequest(title, content1, content2, title1, title2);
        if (simpleDiffRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "createFromFiles"));
        }
        return simpleDiffRequest;
    }

    @NotNull
    public ContentDiffRequest createClipboardVsValue(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/diff/DiffRequestFactoryImpl", "createClipboardVsValue"));
        }
        DiffContent content1 = this.myContentFactory.createClipboardContent();
        DocumentContent content2 = this.myContentFactory.create(value, null);
        String title1 = DiffBundle.message((String)"diff.content.clipboard.content.title", (Object[])new Object[0]);
        String title2 = DiffBundle.message((String)"diff.content.selected.value", (Object[])new Object[0]);
        String title = DiffBundle.message((String)"diff.clipboard.vs.value.dialog.title", (Object[])new Object[0]);
        SimpleDiffRequest simpleDiffRequest = new SimpleDiffRequest(title, content1, (DiffContent)content2, title1, title2);
        if (simpleDiffRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "createClipboardVsValue"));
        }
        return simpleDiffRequest;
    }

    @NotNull
    public String getContentTitle(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/DiffRequestFactoryImpl", "getContentTitle"));
        }
        if (file.isDirectory()) {
            String string = file.getPath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getContentTitle"));
            }
            return string;
        }
        VirtualFile parent = file.getParent();
        String string = DiffRequestFactoryImpl.getContentTitle(file.getName(), file.getPath(), parent != null ? parent.getPath() : null);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getContentTitle"));
        }
        return string;
    }

    @NotNull
    public String getTitle(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/diff/DiffRequestFactoryImpl", "getTitle"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/diff/DiffRequestFactoryImpl", "getTitle"));
        }
        if ((file1.isDirectory() || file2.isDirectory()) && file1.getPath().equals(file2.getPath())) {
            String string = file1.getPath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getTitle"));
            }
            return string;
        }
        if (file1.isDirectory() ^ file2.isDirectory()) {
            String string = this.getContentTitle(file1) + " vs " + this.getContentTitle(file2);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getTitle"));
            }
            return string;
        }
        VirtualFile parent1 = file1.getParent();
        VirtualFile parent2 = file2.getParent();
        String string = DiffRequestFactoryImpl.getRequestTitle(file1.getName(), file1.getPath(), parent1 != null ? parent1.getPath() : null, file2.getName(), file2.getPath(), parent2 != null ? parent2.getPath() : null, " vs ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getTitle"));
        }
        return string;
    }

    @NotNull
    public static String getContentTitle(@NotNull FilePath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/diff/DiffRequestFactoryImpl", "getContentTitle"));
        }
        if (path.isDirectory()) {
            String string = path.getPath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getContentTitle"));
            }
            return string;
        }
        FilePath parent = path.getParentPath();
        String string = DiffRequestFactoryImpl.getContentTitle(path.getName(), path.getPath(), parent != null ? parent.getPath() : null);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getContentTitle"));
        }
        return string;
    }

    @NotNull
    public static String getTitle(@NotNull FilePath path1, @NotNull FilePath path2, @NotNull String separator) {
        if (path1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path1", "com/intellij/diff/DiffRequestFactoryImpl", "getTitle"));
        }
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path2", "com/intellij/diff/DiffRequestFactoryImpl", "getTitle"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/diff/DiffRequestFactoryImpl", "getTitle"));
        }
        if ((path1.isDirectory() || path2.isDirectory()) && path1.getPath().equals(path2.getPath())) {
            String string = path1.getPath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getTitle"));
            }
            return string;
        }
        if (path1.isDirectory() ^ path2.isDirectory()) {
            String string = DiffRequestFactoryImpl.getContentTitle(path1) + " vs " + DiffRequestFactoryImpl.getContentTitle(path2);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getTitle"));
            }
            return string;
        }
        FilePath parent1 = path1.getParentPath();
        FilePath parent2 = path2.getParentPath();
        String string = DiffRequestFactoryImpl.getRequestTitle(path1.getName(), path1.getPath(), parent1 != null ? parent1.getPath() : null, path2.getName(), path2.getPath(), parent2 != null ? parent2.getPath() : null, separator);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getTitle"));
        }
        return string;
    }

    @NotNull
    private static String getContentTitle(@NotNull String name, @NotNull String path, @Nullable String parentPath) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/diff/DiffRequestFactoryImpl", "getContentTitle"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/diff/DiffRequestFactoryImpl", "getContentTitle"));
        }
        if (parentPath != null) {
            String string = name + " (" + parentPath + ")";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getContentTitle"));
            }
            return string;
        }
        String string = path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getContentTitle"));
        }
        return string;
    }

    @NotNull
    private static String getRequestTitle(@NotNull String name1, @NotNull String path1, @Nullable String parentPath1, @NotNull String name2, @NotNull String path2, @Nullable String parentPath2, @NotNull String sep) {
        if (name1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name1", "com/intellij/diff/DiffRequestFactoryImpl", "getRequestTitle"));
        }
        if (path1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path1", "com/intellij/diff/DiffRequestFactoryImpl", "getRequestTitle"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name2", "com/intellij/diff/DiffRequestFactoryImpl", "getRequestTitle"));
        }
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path2", "com/intellij/diff/DiffRequestFactoryImpl", "getRequestTitle"));
        }
        if (sep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sep", "com/intellij/diff/DiffRequestFactoryImpl", "getRequestTitle"));
        }
        if (path1.equals(path2)) {
            String string = DiffRequestFactoryImpl.getContentTitle(name1, path1, parentPath1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getRequestTitle"));
            }
            return string;
        }
        if (Comparing.equal((String)parentPath1, (String)parentPath2)) {
            if (parentPath1 != null) {
                String string = name1 + sep + name2 + " (" + parentPath1 + ")";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getRequestTitle"));
                }
                return string;
            }
            String string = path1 + sep + path2;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getRequestTitle"));
            }
            return string;
        }
        if (name1.equals(name2)) {
            if (parentPath1 != null && parentPath2 != null) {
                String string = name1 + " (" + parentPath1 + sep + parentPath2 + ")";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getRequestTitle"));
                }
                return string;
            }
            String string = path1 + sep + path2;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getRequestTitle"));
            }
            return string;
        }
        if (parentPath1 != null && parentPath2 != null) {
            String string = name1 + sep + name2 + " (" + parentPath1 + sep + parentPath2 + ")";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getRequestTitle"));
            }
            return string;
        }
        String string = path1 + sep + path2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getRequestTitle"));
        }
        return string;
    }
}

