/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions.impl;

import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DirectoryContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DocumentContent;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowOldDiffAction
extends DumbAwareAction {
    @NonNls
    public static final Object DO_NOT_TRY_MIGRATE = "doNotTryMigrate";

    public ShowOldDiffAction() {
        super("Show in Old diff", null, AllIcons.Diff.Diff);
    }

    public void update(AnActionEvent e) {
        if (!ApplicationManager.getApplication().isInternal()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        DiffRequest request = (DiffRequest)e.getData(DiffDataKeys.DIFF_REQUEST);
        if (request == null || !(request instanceof ContentDiffRequest)) {
            e.getPresentation().setEnabled(false);
            return;
        }
        DiffContent[] contents = ((ContentDiffRequest)request).getContents();
        if (contents.length != 2) {
            e.getPresentation().setEnabled(false);
            return;
        }
        for (DiffContent content : contents) {
            if (content instanceof EmptyContent || content instanceof com.intellij.diff.contents.DocumentContent || content instanceof FileContent || content instanceof DirectoryContent) continue;
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setEnabled(true);
    }

    public void actionPerformed(AnActionEvent e) {
        ContentDiffRequest request = (ContentDiffRequest)e.getRequiredData(DiffDataKeys.DIFF_REQUEST);
        DiffContent[] contents = request.getContents();
        String[] titles = request.getContentTitles();
        SimpleDiffRequest newRequest = new SimpleDiffRequest(e.getProject(), request.getTitle());
        newRequest.setContentTitles(titles[0], titles[1]);
        newRequest.setContents(ShowOldDiffAction.convert(e.getProject(), contents[0]), ShowOldDiffAction.convert(e.getProject(), contents[1]));
        newRequest.addHint(DO_NOT_TRY_MIGRATE);
        DiffManager.getInstance().getDiffTool().show((com.intellij.openapi.diff.DiffRequest)newRequest);
    }

    @NotNull
    private static com.intellij.openapi.diff.DiffContent convert(@Nullable Project project, @NotNull DiffContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/actions/impl/ShowOldDiffAction", "convert"));
        }
        if (content instanceof EmptyContent) {
            SimpleContent simpleContent = SimpleContent.createEmpty();
            if (simpleContent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/actions/impl/ShowOldDiffAction", "convert"));
            }
            return simpleContent;
        }
        if (content instanceof com.intellij.diff.contents.DocumentContent) {
            Document document = ((com.intellij.diff.contents.DocumentContent)content).getDocument();
            DocumentContent documentContent = new DocumentContent(project, document, content.getContentType());
            if (documentContent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/actions/impl/ShowOldDiffAction", "convert"));
            }
            return documentContent;
        }
        if (content instanceof FileContent) {
            VirtualFile file = ((FileContent)content).getFile();
            com.intellij.openapi.diff.FileContent fileContent = new com.intellij.openapi.diff.FileContent(project, file);
            if (fileContent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/actions/impl/ShowOldDiffAction", "convert"));
            }
            return fileContent;
        }
        if (content instanceof DirectoryContent) {
            VirtualFile file = ((DirectoryContent)content).getFile();
            com.intellij.openapi.diff.FileContent fileContent = new com.intellij.openapi.diff.FileContent(project, file);
            if (fileContent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/actions/impl/ShowOldDiffAction", "convert"));
            }
            return fileContent;
        }
        throw new IllegalArgumentException();
    }
}

