/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.BufferedLineIterator;
import com.intellij.diff.actions.NavigationContextChecker;
import com.intellij.diff.actions.impl.OpenInEditorWithMouseAction;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.fragmented.ChangedBlock;
import com.intellij.diff.tools.fragmented.HighlightRange;
import com.intellij.diff.tools.fragmented.LineNumberConvertor;
import com.intellij.diff.tools.fragmented.OnesideContentPanel;
import com.intellij.diff.tools.fragmented.OnesideDiffChange;
import com.intellij.diff.tools.fragmented.OnesideDiffPanel;
import com.intellij.diff.tools.fragmented.OnesideEditorHighlighter;
import com.intellij.diff.tools.fragmented.OnesideEditorRangeHighlighter;
import com.intellij.diff.tools.fragmented.OnesideFragmentBuilder;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.tools.util.StatusPanel;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffViewerBase;
import com.intellij.diff.tools.util.twoside.TwosideTextDiffViewer;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffNavigationContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.LightweightHint;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.MergingCharSequence;
import gnu.trove.TIntFunction;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnesideDiffViewer
extends TextDiffViewerBase {
    public static final Logger LOG = Logger.getInstance(OnesideDiffViewer.class);
    @NotNull
    private final EditorEx myEditor;
    @NotNull
    private final Document myDocument;
    @NotNull
    private final OnesideDiffPanel myPanel;
    @Nullable
    private final DocumentContent myActualContent1;
    @Nullable
    private final DocumentContent myActualContent2;
    @NotNull
    private final TextDiffViewerBase.MySetEditorSettingsAction myEditorSettingsAction;
    @NotNull
    private final PrevNextDifferenceIterable myPrevNextDifferenceIterable;
    @NotNull
    private final MyStatusPanel myStatusPanel;
    @NotNull
    private final MyScrollToLineHelper myScrollToLineHelper;
    @NotNull
    private final FoldingModelSupport.OnesideFoldingModel myFoldingModel;
    @NotNull
    private Side myMasterSide;
    @Nullable
    private ChangedBlockData myChangedBlockData;

    public OnesideDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "<init>"));
        }
        super(context, (ContentDiffRequest)request);
        this.myScrollToLineHelper = new MyScrollToLineHelper();
        this.myMasterSide = Side.LEFT;
        this.myPrevNextDifferenceIterable = new MyPrevNextDifferenceIterable();
        this.myStatusPanel = new MyStatusPanel();
        DiffContent[] contents = this.myRequest.getContents();
        this.myActualContent1 = contents[0] instanceof DocumentContent ? (DocumentContent)contents[0] : null;
        DocumentContent documentContent = this.myActualContent2 = contents[1] instanceof DocumentContent ? (DocumentContent)contents[1] : null;
        assert (this.myActualContent1 != null || this.myActualContent2 != null);
        this.myDocument = EditorFactory.getInstance().createDocument((CharSequence)"");
        this.myEditor = DiffUtil.createEditor(this.myDocument, this.myProject, true, true);
        List<JComponent> titles = DiffUtil.createTextTitles(this.myRequest, ContainerUtil.list((Object[])new EditorEx[]{this.myEditor, this.myEditor}));
        OnesideContentPanel contentPanel = new OnesideContentPanel(titles, this.myEditor);
        this.myPanel = new OnesideDiffPanel(this.myProject, contentPanel, this.myEditor, this, this.myContext);
        this.myFoldingModel = new FoldingModelSupport.OnesideFoldingModel(this.myEditor, (Disposable)this);
        this.myEditorSettingsAction = new TextDiffViewerBase.MySetEditorSettingsAction(this);
        this.myEditorSettingsAction.applyDefaults();
        new MyOpenInEditorWithMouseAction().register(this.getEditors());
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.processContextHints();
    }

    @Override
    public void onDispose() {
        this.updateContextHints();
        EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
        super.onDispose();
    }

    private void processContextHints() {
        Side side = (Side)DiffUtil.getUserData((DiffRequest)this.myRequest, this.myContext, DiffUserDataKeys.MASTER_SIDE);
        if (side != null) {
            this.myMasterSide = side;
        }
        this.myScrollToLineHelper.processContext();
    }

    private void updateContextHints() {
        this.myScrollToLineHelper.updateContext();
        this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getTextSettings().isExpandByDefault());
    }

    @Override
    @NotNull
    public List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add((AnAction)new MyIgnorePolicySettingAction());
        group.add((AnAction)new MyHighlightPolicySettingAction());
        group.add((AnAction)new MyToggleExpandByDefaultAction());
        group.add((AnAction)this.myEditorSettingsAction);
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "createToolbarActions"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<AnAction> createPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new MyIgnorePolicySettingAction().getPopupGroup());
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new MyHighlightPolicySettingAction().getPopupGroup());
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new MyToggleExpandByDefaultAction());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "createPopupActions"));
        }
        return arrayList;
    }

    @Override
    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myPanel.setLoadingContent();
    }

    @Override
    @NotNull
    protected Runnable performRediff(final @NotNull ProgressIndicator indicator) {
        Runnable runnable;
        block17: {
            block16: {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "performRediff"));
                }
                indicator.checkCanceled();
                assert (this.myActualContent1 != null || this.myActualContent2 != null);
                if (this.myActualContent1 != null) break block16;
                final DocumentContent content = this.myActualContent2;
                final Document document = content.getDocument();
                OnesideDocumentData data = (OnesideDocumentData)ApplicationManager.getApplication().runReadAction((Computable)new Computable<OnesideDocumentData>(){

                    public OnesideDocumentData compute() {
                        EditorHighlighter highlighter = DiffUtil.createEditorHighlighter(OnesideDiffViewer.this.myProject, content);
                        OnesideEditorRangeHighlighter rangeHighlighter = new OnesideEditorRangeHighlighter(OnesideDiffViewer.this.myProject, content.getDocument());
                        return new OnesideDocumentData(document.getImmutableCharSequence(), OnesideDiffViewer.getLineCount(document), highlighter, rangeHighlighter);
                    }
                });
                ArrayList<ChangedBlock> blocks = new ArrayList<ChangedBlock>();
                blocks.add(ChangedBlock.createInserted(data.getText().length() + 1, data.getLines()));
                indicator.checkCanceled();
                LineNumberConvertor convertor = LineNumberConvertor.Builder.createLeft(data.getLines());
                CombinedEditorData editorData = new CombinedEditorData((CharSequence)new MergingCharSequence(data.getText(), (CharSequence)"\n"), data.getHighlighter(), data.getRangeHighlighter(), content.getContentType(), convertor.createConvertor1(), null);
                Runnable runnable2 = this.apply(editorData, blocks, convertor, Collections.<DiffIterableUtil.IntPair>emptyList(), false);
                if (runnable2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "performRediff"));
                }
                return runnable2;
            }
            if (this.myActualContent2 != null) break block17;
            final DocumentContent content = this.myActualContent1;
            final Document document = content.getDocument();
            OnesideDocumentData data = (OnesideDocumentData)ApplicationManager.getApplication().runReadAction((Computable)new Computable<OnesideDocumentData>(){

                public OnesideDocumentData compute() {
                    EditorHighlighter highlighter = DiffUtil.createEditorHighlighter(OnesideDiffViewer.this.myProject, content);
                    OnesideEditorRangeHighlighter rangeHighlighter = new OnesideEditorRangeHighlighter(OnesideDiffViewer.this.myProject, content.getDocument());
                    return new OnesideDocumentData(document.getImmutableCharSequence(), OnesideDiffViewer.getLineCount(document), highlighter, rangeHighlighter);
                }
            });
            ArrayList<ChangedBlock> blocks = new ArrayList<ChangedBlock>();
            blocks.add(ChangedBlock.createDeleted(data.getText().length() + 1, data.getLines()));
            indicator.checkCanceled();
            LineNumberConvertor convertor = LineNumberConvertor.Builder.createRight(data.getLines());
            CombinedEditorData editorData = new CombinedEditorData((CharSequence)new MergingCharSequence(data.getText(), (CharSequence)"\n"), data.getHighlighter(), data.getRangeHighlighter(), content.getContentType(), convertor.createConvertor2(), null);
            Runnable runnable3 = this.apply(editorData, blocks, convertor, Collections.<DiffIterableUtil.IntPair>emptyList(), false);
            if (runnable3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "performRediff"));
            }
            return runnable3;
        }
        try {
            final DocumentContent content1 = this.myActualContent1;
            final DocumentContent content2 = this.myActualContent2;
            final Document document1 = content1.getDocument();
            final Document document2 = content2.getDocument();
            final DiffUtil.DocumentData documentData = (DiffUtil.DocumentData)ApplicationManager.getApplication().runReadAction((Computable)new Computable<DiffUtil.DocumentData>(){

                public DiffUtil.DocumentData compute() {
                    return new DiffUtil.DocumentData(document1.getImmutableCharSequence(), document2.getImmutableCharSequence(), document1.getModificationStamp(), document2.getModificationStamp());
                }
            });
            final List<LineFragment> fragments = DiffUtil.compareWithCache((DiffRequest)this.myRequest, documentData, this.getDiffConfig(), indicator);
            indicator.checkCanceled();
            TwosideDocumentData data = (TwosideDocumentData)ApplicationManager.getApplication().runReadAction((Computable)new Computable<TwosideDocumentData>(){

                public TwosideDocumentData compute() {
                    indicator.checkCanceled();
                    OnesideFragmentBuilder builder = new OnesideFragmentBuilder(fragments, document1, document2, OnesideDiffViewer.this.getHighlightPolicy().isFineFragments(), OnesideDiffViewer.this.myMasterSide);
                    builder.exec();
                    indicator.checkCanceled();
                    EditorHighlighter highlighter = OnesideDiffViewer.this.buildHighlighter(OnesideDiffViewer.this.myProject, content1, content2, documentData.getText1(), documentData.getText2(), builder.getRanges(), builder.getText().length());
                    OnesideEditorRangeHighlighter rangeHighlighter = new OnesideEditorRangeHighlighter(OnesideDiffViewer.this.myProject, document1, document2, builder.getRanges());
                    return new TwosideDocumentData(builder, highlighter, rangeHighlighter);
                }
            });
            OnesideFragmentBuilder builder = data.getBuilder();
            FileType fileType = content2.getContentType() == null ? content1.getContentType() : content2.getContentType();
            LineNumberConvertor convertor = builder.getConvertor();
            List<DiffIterableUtil.IntPair> changedLines = builder.getChangedLines();
            boolean isEqual = builder.isEqual();
            CombinedEditorData editorData = new CombinedEditorData(builder.getText(), data.getHighlighter(), data.getRangeHighlighter(), fileType, convertor.createConvertor1(), convertor.createConvertor2());
            runnable = this.apply(editorData, builder.getBlocks(), convertor, changedLines, isEqual);
        }
        catch (DiffTooBigException ignore) {
            Runnable runnable4 = new Runnable(){

                @Override
                public void run() {
                    OnesideDiffViewer.this.clearDiffPresentation();
                    OnesideDiffViewer.this.myPanel.setTooBigContent();
                }
            };
            if (runnable4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "performRediff"));
            }
            return runnable4;
        }
        catch (ProcessCanceledException ignore) {
            Runnable runnable5 = new Runnable(){

                @Override
                public void run() {
                    OnesideDiffViewer.this.clearDiffPresentation();
                    OnesideDiffViewer.this.myPanel.setOperationCanceledContent();
                }
            };
            if (runnable5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "performRediff"));
            }
            return runnable5;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            Runnable runnable6 = new Runnable(){

                @Override
                public void run() {
                    OnesideDiffViewer.this.clearDiffPresentation();
                    OnesideDiffViewer.this.myPanel.setErrorContent();
                }
            };
            if (runnable6 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "performRediff"));
            }
            return runnable6;
        }
        catch (Error e) {
            Runnable runnable7 = new Runnable(){

                @Override
                public void run() {
                    OnesideDiffViewer.this.clearDiffPresentation();
                    OnesideDiffViewer.this.myPanel.setErrorContent();
                    throw e;
                }
            };
            if (runnable7 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "performRediff"));
            }
            return runnable7;
        }
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "performRediff"));
        }
        return runnable;
    }

    private void clearDiffPresentation() {
        this.myPanel.resetNotifications();
        this.destroyChangedBlockData();
    }

    @Nullable
    private EditorHighlighter buildHighlighter(@Nullable Project project, @NotNull DocumentContent content1, @NotNull DocumentContent content2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<HighlightRange> ranges, int textLength) {
        if (content1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content1", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "buildHighlighter"));
        }
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content2", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "buildHighlighter"));
        }
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "buildHighlighter"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "buildHighlighter"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "buildHighlighter"));
        }
        EditorHighlighter highlighter1 = DiffUtil.initEditorHighlighter(project, content1, text1);
        EditorHighlighter highlighter2 = DiffUtil.initEditorHighlighter(project, content2, text2);
        if (highlighter1 == null && highlighter2 == null) {
            return null;
        }
        if (highlighter1 == null) {
            highlighter1 = DiffUtil.initEmptyEditorHighlighter(project, text1);
        }
        if (highlighter2 == null) {
            highlighter2 = DiffUtil.initEmptyEditorHighlighter(project, text2);
        }
        return new OnesideEditorHighlighter(this.myDocument, highlighter1, highlighter2, ranges, textLength);
    }

    @NotNull
    private Runnable apply(final @NotNull CombinedEditorData data, final @NotNull List<ChangedBlock> blocks, final @NotNull LineNumberConvertor convertor, final @NotNull List<DiffIterableUtil.IntPair> changedLines, final boolean isEqual) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "apply"));
        }
        if (blocks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blocks", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "apply"));
        }
        if (convertor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertor", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "apply"));
        }
        if (changedLines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedLines", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "apply"));
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                OnesideDiffViewer.this.myFoldingModel.updateContext((UserDataHolder)OnesideDiffViewer.this.myRequest, OnesideDiffViewer.this.getTextSettings().isExpandByDefault());
                OnesideDiffViewer.this.clearDiffPresentation();
                if (isEqual) {
                    OnesideDiffViewer.this.myPanel.addContentsEqualNotification();
                }
                TIntFunction separatorLines = OnesideDiffViewer.this.myFoldingModel.getLineNumberConvertor();
                OnesideDiffViewer.this.myEditor.getGutterComponentEx().setLineNumberConvertor(OnesideDiffViewer.mergeConverters(data.getLineConvertor1(), separatorLines), OnesideDiffViewer.mergeConverters(data.getLineConvertor2(), separatorLines));
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        OnesideDiffViewer.this.myDocument.setText(data.getText());
                    }
                });
                if (data.getHighlighter() != null) {
                    OnesideDiffViewer.this.myEditor.setHighlighter(data.getHighlighter());
                }
                DiffUtil.setEditorCodeStyle(OnesideDiffViewer.this.myProject, OnesideDiffViewer.this.myEditor, data.getFileType());
                if (data.getRangeHighlighter() != null) {
                    data.getRangeHighlighter().apply(OnesideDiffViewer.this.myProject, OnesideDiffViewer.this.myDocument);
                }
                ArrayList<OnesideDiffChange> diffChanges = new ArrayList<OnesideDiffChange>(blocks.size());
                for (ChangedBlock block : blocks) {
                    diffChanges.add(new OnesideDiffChange(OnesideDiffViewer.this.myEditor, block));
                }
                OnesideDiffViewer.this.myChangedBlockData = new ChangedBlockData(diffChanges, convertor);
                OnesideDiffViewer.this.myFoldingModel.install(changedLines, (UserDataHolder)OnesideDiffViewer.this.myRequest, OnesideDiffViewer.this.getTextSettings().isExpandByDefault(), OnesideDiffViewer.this.getTextSettings().getContextRange());
                OnesideDiffViewer.this.myScrollToLineHelper.onRediff();
                OnesideDiffViewer.this.myStatusPanel.update();
                OnesideDiffViewer.this.myPanel.setGoodContent();
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "apply"));
        }
        return runnable;
    }

    @Contract(value="!null, _ -> !null")
    private static TIntFunction mergeConverters(final @Nullable TIntFunction convertor, final @NotNull TIntFunction separatorLines) {
        if (separatorLines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separatorLines", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "mergeConverters"));
        }
        if (convertor == null) {
            return null;
        }
        return new TIntFunction(){

            public int execute(int value) {
                return convertor.execute(separatorLines.execute(value));
            }
        };
    }

    private int transferLineToOneside(@NotNull Side side, int line) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "transferLineToOneside"));
        }
        if (this.myChangedBlockData == null) {
            return line;
        }
        LineNumberConvertor lineConvertor = this.myChangedBlockData.getLineNumberConvertor();
        return side.isLeft() ? lineConvertor.convertApproximateInv1(line) : lineConvertor.convertApproximateInv2(line);
    }

    private Pair<int[], Side> transferLineFromOneside(int line) {
        int[] lines = new int[2];
        if (this.myChangedBlockData == null) {
            lines[0] = this.myActualContent1 != null ? line : 0;
            lines[1] = this.myActualContent2 != null ? line : 0;
            return Pair.create((Object)lines, (Object)this.myMasterSide);
        }
        LineNumberConvertor lineConvertor = this.myChangedBlockData.getLineNumberConvertor();
        Side side = this.myMasterSide;
        lines[0] = lineConvertor.convert1(line);
        lines[1] = lineConvertor.convert2(line);
        if (lines[0] == -1 && lines[1] == -1) {
            lines[0] = lineConvertor.convertApproximate1(line);
            lines[1] = lineConvertor.convertApproximate2(line);
        } else if (lines[0] == -1) {
            lines[0] = lineConvertor.convertApproximate1(line);
            side = Side.RIGHT;
        } else if (lines[1] == -1) {
            lines[1] = lineConvertor.convertApproximate2(line);
            side = Side.LEFT;
        }
        return Pair.create((Object)lines, (Object)side);
    }

    private void destroyChangedBlockData() {
        if (this.myChangedBlockData == null) {
            return;
        }
        for (OnesideDiffChange change : this.myChangedBlockData.getDiffChanges()) {
            change.destroyHighlighter();
        }
        this.myChangedBlockData = null;
        this.myFoldingModel.destroy();
        this.myStatusPanel.update();
    }

    @NotNull
    private DiffUtil.DiffConfig getDiffConfig() {
        DiffUtil.DiffConfig diffConfig = new DiffUtil.DiffConfig(this.getIgnorePolicy(), this.getHighlightPolicy());
        if (diffConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "getDiffConfig"));
        }
        return diffConfig;
    }

    @NotNull
    private HighlightPolicy getHighlightPolicy() {
        HighlightPolicy policy = this.getTextSettings().getHighlightPolicy();
        if (policy == HighlightPolicy.DO_NOT_HIGHLIGHT) {
            HighlightPolicy highlightPolicy = HighlightPolicy.BY_LINE;
            if (highlightPolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "getHighlightPolicy"));
            }
            return highlightPolicy;
        }
        HighlightPolicy highlightPolicy = policy;
        if (highlightPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "getHighlightPolicy"));
        }
        return highlightPolicy;
    }

    @NotNull
    private IgnorePolicy getIgnorePolicy() {
        IgnorePolicy policy = this.getTextSettings().getIgnorePolicy();
        if (policy == IgnorePolicy.IGNORE_WHITESPACES_CHUNKS) {
            IgnorePolicy ignorePolicy = IgnorePolicy.IGNORE_WHITESPACES;
            if (ignorePolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "getIgnorePolicy"));
            }
            return ignorePolicy;
        }
        IgnorePolicy ignorePolicy = policy;
        if (ignorePolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "getIgnorePolicy"));
        }
        return ignorePolicy;
    }

    @Override
    protected void onDocumentChange(@NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "onDocumentChange"));
        }
        super.onDocumentChange(e);
        this.myFoldingModel.onDocumentChanged(e);
    }

    @Override
    @NotNull
    protected List<? extends EditorEx> getEditors() {
        List<EditorEx> list = Collections.singletonList(this.myEditor);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "getEditors"));
        }
        return list;
    }

    @Nullable
    List<OnesideDiffChange> getDiffChanges() {
        return this.myChangedBlockData == null ? null : this.myChangedBlockData.getDiffChanges();
    }

    @NotNull
    public JComponent getComponent() {
        OnesideDiffPanel onesideDiffPanel = this.myPanel;
        if (onesideDiffPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "getComponent"));
        }
        return onesideDiffPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.getPreferredFocusedComponent();
    }

    @Override
    @NotNull
    protected JComponent getStatusPanel() {
        MyStatusPanel myStatusPanel = this.myStatusPanel;
        if (myStatusPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "getStatusPanel"));
        }
        return myStatusPanel;
    }

    @Override
    protected boolean tryRediffSynchronously() {
        return this.myPanel.isWindowFocused();
    }

    @Override
    @Nullable
    protected OpenFileDescriptor getOpenFileDescriptor() {
        return this.getOpenFileDescriptor(this.myEditor.getCaretModel().getOffset());
    }

    @Nullable
    protected OpenFileDescriptor getOpenFileDescriptor(int offset) {
        assert (this.myActualContent1 != null || this.myActualContent2 != null);
        if (this.myActualContent2 == null) {
            OpenFileDescriptor descriptor = this.myActualContent1.getOpenFileDescriptor(offset);
            if (descriptor != null) {
                return descriptor;
            }
        } else if (this.myActualContent1 == null) {
            OpenFileDescriptor descriptor = this.myActualContent2.getOpenFileDescriptor(offset);
            if (descriptor != null) {
                return descriptor;
            }
        } else {
            Pair<int[], Side> pair = this.transferLineFromOneside(this.myEditor.offsetToLogicalPosition((int)offset).line);
            OpenFileDescriptor descriptor1 = this.myActualContent1.getOpenFileDescriptor(offset);
            OpenFileDescriptor descriptor2 = this.myActualContent2.getOpenFileDescriptor(offset);
            if (descriptor1 == null) {
                return descriptor2;
            }
            if (descriptor2 == null) {
                return descriptor1;
            }
            ((Side)pair.second).select((Object)descriptor1, (Object)descriptor2);
        }
        return null;
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "canShowRequest"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "canShowRequest"));
        }
        return TwosideTextDiffViewer.canShowRequest(context, request);
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        if (DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.is(dataId)) {
            return this.myPrevNextDifferenceIterable;
        }
        return super.getData(dataId);
    }

    private static class EditorPosition {
        public static final Key<EditorPosition> KEY = Key.create((String)"Diff.OnesideEditorPosition");
        @NotNull
        public final LogicalPosition[] myCaretPosition;
        @NotNull
        public final Point myPoint;

        public EditorPosition(@NotNull LogicalPosition[] caretPosition, @NotNull Point point) {
            if (caretPosition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretPosition", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$EditorPosition", "<init>"));
            }
            if (point == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$EditorPosition", "<init>"));
            }
            this.myCaretPosition = caretPosition;
            this.myPoint = point;
        }

        public boolean isSame(@Nullable LogicalPosition[] caretPosition) {
            if (caretPosition == null) {
                return true;
            }
            if (caretPosition.length != 2) {
                return false;
            }
            if (!caretPosition[0].equals((Object)this.myCaretPosition[0])) {
                return false;
            }
            return caretPosition[1].equals((Object)this.myCaretPosition[1]);
        }
    }

    private class MyScrollToLineHelper {
        protected boolean myShouldScroll = true;
        @Nullable
        private DiffUserDataKeysEx.ScrollToPolicy myScrollToChange;
        @Nullable
        private EditorPosition myEditorPosition;
        @Nullable
        private LogicalPosition[] myCaretPosition;
        @Nullable
        private DiffNavigationContext myNavigationContext;

        private MyScrollToLineHelper() {
        }

        public void processContext() {
            this.myScrollToChange = (DiffUserDataKeysEx.ScrollToPolicy)((Object)OnesideDiffViewer.this.myRequest.getUserData(DiffUserDataKeysEx.SCROLL_TO_CHANGE));
            this.myEditorPosition = (EditorPosition)OnesideDiffViewer.this.myRequest.getUserData(EditorPosition.KEY);
            this.myCaretPosition = (LogicalPosition[])OnesideDiffViewer.this.myRequest.getUserData(DiffUserDataKeysEx.EDITORS_CARET_POSITION);
            this.myNavigationContext = (DiffNavigationContext)OnesideDiffViewer.this.myRequest.getUserData(DiffUserDataKeysEx.NAVIGATION_CONTEXT);
        }

        public void updateContext() {
            LogicalPosition position = OnesideDiffViewer.this.myEditor.getCaretModel().getLogicalPosition();
            Pair pair = OnesideDiffViewer.this.transferLineFromOneside(position.line);
            LogicalPosition[] carets = new LogicalPosition[]{this.getPosition(((int[])pair.first)[0], position.column), this.getPosition(((int[])pair.first)[1], position.column)};
            EditorPosition editorsPosition = new EditorPosition(carets, DiffUtil.getScrollingPoint(OnesideDiffViewer.this.myEditor));
            OnesideDiffViewer.this.myRequest.putUserData(DiffUserDataKeysEx.SCROLL_TO_CHANGE, null);
            OnesideDiffViewer.this.myRequest.putUserData(EditorPosition.KEY, (Object)editorsPosition);
            OnesideDiffViewer.this.myRequest.putUserData(DiffUserDataKeysEx.EDITORS_CARET_POSITION, (Object)carets);
            OnesideDiffViewer.this.myRequest.putUserData(DiffUserDataKeysEx.NAVIGATION_CONTEXT, null);
        }

        public void onRediff() {
            if (this.myShouldScroll && this.myScrollToChange != null) {
                boolean bl = this.myShouldScroll = !this.doScrollToChange(this.myScrollToChange);
            }
            if (this.myShouldScroll && this.myNavigationContext != null) {
                boolean bl = this.myShouldScroll = !this.doScrollToContext(this.myNavigationContext);
            }
            if (this.myShouldScroll && this.myCaretPosition != null && this.myCaretPosition.length == 2) {
                LogicalPosition twosidePosition = (LogicalPosition)OnesideDiffViewer.this.myMasterSide.selectN((Object[])this.myCaretPosition);
                int onesideLine = OnesideDiffViewer.this.transferLineToOneside(OnesideDiffViewer.this.myMasterSide, twosidePosition.line);
                LogicalPosition position = new LogicalPosition(onesideLine, twosidePosition.column);
                OnesideDiffViewer.this.myEditor.getCaretModel().moveToLogicalPosition(position);
                if (this.myEditorPosition != null && this.myEditorPosition.isSame(this.myCaretPosition)) {
                    DiffUtil.scrollToPoint(OnesideDiffViewer.this.myEditor, this.myEditorPosition.myPoint);
                } else {
                    OnesideDiffViewer.this.myEditor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
                }
                this.myShouldScroll = false;
            }
            if (this.myShouldScroll) {
                this.doScrollToChange(DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE);
            }
            this.myShouldScroll = false;
        }

        @NotNull
        private LogicalPosition getPosition(int line, int column) {
            if (line == -1) {
                LogicalPosition logicalPosition = new LogicalPosition(0, 0);
                if (logicalPosition == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$MyScrollToLineHelper", "getPosition"));
                }
                return logicalPosition;
            }
            LogicalPosition logicalPosition = new LogicalPosition(line, column);
            if (logicalPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$MyScrollToLineHelper", "getPosition"));
            }
            return logicalPosition;
        }

        private boolean doScrollToLine(@NotNull Side side, @NotNull LogicalPosition position) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$MyScrollToLineHelper", "doScrollToLine"));
            }
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$MyScrollToLineHelper", "doScrollToLine"));
            }
            int onesideLine = OnesideDiffViewer.this.transferLineToOneside(side, position.line);
            DiffUtil.scrollEditor(OnesideDiffViewer.this.myEditor, onesideLine, position.column);
            return true;
        }

        private boolean doScrollToChange(@NotNull DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
            OnesideDiffChange targetChange;
            if (scrollToChangePolicy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollToChangePolicy", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$MyScrollToLineHelper", "doScrollToChange"));
            }
            if (OnesideDiffViewer.this.myChangedBlockData == null) {
                return false;
            }
            List<OnesideDiffChange> changes = OnesideDiffViewer.this.myChangedBlockData.getDiffChanges();
            if (changes.isEmpty()) {
                return false;
            }
            switch (scrollToChangePolicy) {
                case FIRST_CHANGE: {
                    targetChange = changes.get(0);
                    break;
                }
                case LAST_CHANGE: {
                    targetChange = changes.get(changes.size() - 1);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(scrollToChangePolicy.name());
                }
            }
            DiffUtil.scrollEditor((Editor)OnesideDiffViewer.this.myEditor, targetChange.getLine1());
            return true;
        }

        private boolean doScrollToContext(@NotNull DiffNavigationContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$MyScrollToLineHelper", "doScrollToContext"));
            }
            if (OnesideDiffViewer.this.myChangedBlockData == null) {
                return false;
            }
            if (OnesideDiffViewer.this.myActualContent2 == null) {
                return false;
            }
            ChangedLinesIterator changedLinesIterator = new ChangedLinesIterator(Side.RIGHT, OnesideDiffViewer.this.myChangedBlockData.getDiffChanges());
            NavigationContextChecker checker = new NavigationContextChecker(changedLinesIterator, context);
            int line = checker.contextMatchCheck();
            if (line == -1) {
                AllLinesIterator allLinesIterator = new AllLinesIterator(Side.RIGHT);
                NavigationContextChecker checker2 = new NavigationContextChecker(allLinesIterator, context);
                line = checker2.contextMatchCheck();
            }
            if (line == -1) {
                return false;
            }
            return this.doScrollToLine(Side.RIGHT, new LogicalPosition(line, 0));
        }
    }

    private static class CombinedEditorData {
        @NotNull
        private final CharSequence myText;
        @Nullable
        private final EditorHighlighter myHighlighter;
        @Nullable
        private final OnesideEditorRangeHighlighter myRangeHighlighter;
        @Nullable
        private final FileType myFileType;
        @NotNull
        private final TIntFunction myLineConvertor1;
        @Nullable
        private final TIntFunction myLineConvertor2;

        public CombinedEditorData(@NotNull CharSequence text, @Nullable EditorHighlighter highlighter, @Nullable OnesideEditorRangeHighlighter rangeHighlighter, @Nullable FileType fileType, @NotNull TIntFunction convertor1, @Nullable TIntFunction convertor2) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$CombinedEditorData", "<init>"));
            }
            if (convertor1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertor1", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$CombinedEditorData", "<init>"));
            }
            this.myText = text;
            this.myHighlighter = highlighter;
            this.myRangeHighlighter = rangeHighlighter;
            this.myFileType = fileType;
            this.myLineConvertor1 = convertor1;
            this.myLineConvertor2 = convertor2;
        }

        @NotNull
        public CharSequence getText() {
            CharSequence charSequence = this.myText;
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$CombinedEditorData", "getText"));
            }
            return charSequence;
        }

        @Nullable
        public EditorHighlighter getHighlighter() {
            return this.myHighlighter;
        }

        @Nullable
        public OnesideEditorRangeHighlighter getRangeHighlighter() {
            return this.myRangeHighlighter;
        }

        @Nullable
        public FileType getFileType() {
            return this.myFileType;
        }

        @NotNull
        public TIntFunction getLineConvertor1() {
            TIntFunction tIntFunction = this.myLineConvertor1;
            if (tIntFunction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$CombinedEditorData", "getLineConvertor1"));
            }
            return tIntFunction;
        }

        @Nullable
        public TIntFunction getLineConvertor2() {
            return this.myLineConvertor2;
        }
    }

    private static class ChangedBlockData {
        @NotNull
        private final List<OnesideDiffChange> myDiffChanges;
        @NotNull
        private final LineNumberConvertor myLineNumberConvertor;

        public ChangedBlockData(@NotNull List<OnesideDiffChange> diffChanges, @NotNull LineNumberConvertor lineNumberConvertor) {
            if (diffChanges == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffChanges", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$ChangedBlockData", "<init>"));
            }
            if (lineNumberConvertor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineNumberConvertor", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$ChangedBlockData", "<init>"));
            }
            this.myDiffChanges = diffChanges;
            this.myLineNumberConvertor = lineNumberConvertor;
        }

        @NotNull
        public List<OnesideDiffChange> getDiffChanges() {
            List<OnesideDiffChange> list = this.myDiffChanges;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$ChangedBlockData", "getDiffChanges"));
            }
            return list;
        }

        @NotNull
        public LineNumberConvertor getLineNumberConvertor() {
            LineNumberConvertor lineNumberConvertor = this.myLineNumberConvertor;
            if (lineNumberConvertor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$ChangedBlockData", "getLineNumberConvertor"));
            }
            return lineNumberConvertor;
        }
    }

    private static class TwosideDocumentData {
        @NotNull
        private final OnesideFragmentBuilder myBuilder;
        @Nullable
        private final EditorHighlighter myHighlighter;
        @Nullable
        private final OnesideEditorRangeHighlighter myRangeHighlighter;

        public TwosideDocumentData(@NotNull OnesideFragmentBuilder builder, @Nullable EditorHighlighter highlighter, @Nullable OnesideEditorRangeHighlighter rangeHighlighter) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$TwosideDocumentData", "<init>"));
            }
            this.myBuilder = builder;
            this.myHighlighter = highlighter;
            this.myRangeHighlighter = rangeHighlighter;
        }

        @NotNull
        public OnesideFragmentBuilder getBuilder() {
            OnesideFragmentBuilder onesideFragmentBuilder = this.myBuilder;
            if (onesideFragmentBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$TwosideDocumentData", "getBuilder"));
            }
            return onesideFragmentBuilder;
        }

        @Nullable
        public EditorHighlighter getHighlighter() {
            return this.myHighlighter;
        }

        @Nullable
        public OnesideEditorRangeHighlighter getRangeHighlighter() {
            return this.myRangeHighlighter;
        }
    }

    private static class OnesideDocumentData {
        @NotNull
        private final CharSequence myText;
        private final int myLines;
        @Nullable
        private final EditorHighlighter myHighlighter;
        @Nullable
        private final OnesideEditorRangeHighlighter myRangeHighlighter;

        public OnesideDocumentData(@NotNull CharSequence text, int lines, @Nullable EditorHighlighter highlighter, @Nullable OnesideEditorRangeHighlighter rangeHighlighter) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$OnesideDocumentData", "<init>"));
            }
            this.myText = text;
            this.myLines = lines;
            this.myHighlighter = highlighter;
            this.myRangeHighlighter = rangeHighlighter;
        }

        @NotNull
        public CharSequence getText() {
            CharSequence charSequence = this.myText;
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$OnesideDocumentData", "getText"));
            }
            return charSequence;
        }

        public int getLines() {
            return this.myLines;
        }

        @Nullable
        public EditorHighlighter getHighlighter() {
            return this.myHighlighter;
        }

        @Nullable
        public OnesideEditorRangeHighlighter getRangeHighlighter() {
            return this.myRangeHighlighter;
        }
    }

    private class MyStatusPanel
    extends StatusPanel {
        private MyStatusPanel() {
        }

        @Override
        protected int getChangesCount() {
            return OnesideDiffViewer.this.myChangedBlockData == null ? 0 : OnesideDiffViewer.this.myChangedBlockData.getDiffChanges().size();
        }
    }

    private class ChangedLinesIterator
    extends BufferedLineIterator {
        @NotNull
        private final Side mySide;
        @NotNull
        private final List<OnesideDiffChange> myChanges;
        private int myIndex;

        private ChangedLinesIterator(@NotNull Side side, List<OnesideDiffChange> changes) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$ChangedLinesIterator", "<init>"));
            }
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$ChangedLinesIterator", "<init>"));
            }
            this.myIndex = 0;
            this.mySide = side;
            this.myChanges = changes;
            this.init();
        }

        @Override
        public boolean hasNextBlock() {
            return this.myIndex < this.myChanges.size();
        }

        @Override
        public void loadNextBlock() {
            OnesideDiffChange change = this.myChanges.get(this.myIndex);
            ++this.myIndex;
            int line1 = change.getLine1();
            int line2 = change.getLine2();
            DocumentEx document = OnesideDiffViewer.this.myEditor.getDocument();
            for (int i = line1; i < line2; ++i) {
                int offset1 = document.getLineStartOffset(i);
                int offset2 = document.getLineEndOffset(i);
                if (offset2 < change.getStartOffset2()) continue;
                CharSequence text = document.getImmutableCharSequence().subSequence(offset1, offset2);
                this.addLine(i, text);
            }
        }
    }

    private class AllLinesIterator
    implements Iterator<Pair<Integer, CharSequence>> {
        @NotNull
        private final Side mySide;
        @NotNull
        private final Document myDocument;
        private int myLine;

        private AllLinesIterator(Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$AllLinesIterator", "<init>"));
            }
            this.myLine = 0;
            this.mySide = side;
            DocumentContent content = (DocumentContent)this.mySide.select((Object)OnesideDiffViewer.this.myActualContent1, (Object)OnesideDiffViewer.this.myActualContent2);
            assert (content != null);
            this.myDocument = content.getDocument();
        }

        @Override
        public boolean hasNext() {
            return this.myLine < OnesideDiffViewer.getLineCount(this.myDocument);
        }

        @Override
        public Pair<Integer, CharSequence> next() {
            int offset1 = this.myDocument.getLineStartOffset(this.myLine);
            int offset2 = this.myDocument.getLineEndOffset(this.myLine);
            CharSequence text = this.myDocument.getImmutableCharSequence().subSequence(offset1, offset2);
            Pair pair = new Pair((Object)this.myLine, (Object)text);
            ++this.myLine;
            return pair;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class MyIgnorePolicySettingAction
    extends TextDiffViewerBase.IgnorePolicySettingAction {
        private MyIgnorePolicySettingAction() {
            super(OnesideDiffViewer.this);
        }

        @Override
        @NotNull
        protected IgnorePolicy getCurrentSetting() {
            IgnorePolicy ignorePolicy = OnesideDiffViewer.this.getIgnorePolicy();
            if (ignorePolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$MyIgnorePolicySettingAction", "getCurrentSetting"));
            }
            return ignorePolicy;
        }

        @Override
        @NotNull
        protected List<IgnorePolicy> getAvailableSettings() {
            ArrayList settings = ContainerUtil.newArrayList((Object[])IgnorePolicy.values());
            settings.remove((Object)IgnorePolicy.IGNORE_WHITESPACES_CHUNKS);
            ArrayList arrayList = settings;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$MyIgnorePolicySettingAction", "getAvailableSettings"));
            }
            return arrayList;
        }
    }

    private class MyHighlightPolicySettingAction
    extends TextDiffViewerBase.HighlightPolicySettingAction {
        private MyHighlightPolicySettingAction() {
            super(OnesideDiffViewer.this);
        }

        @Override
        @NotNull
        protected HighlightPolicy getCurrentSetting() {
            HighlightPolicy highlightPolicy = OnesideDiffViewer.this.getHighlightPolicy();
            if (highlightPolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$MyHighlightPolicySettingAction", "getCurrentSetting"));
            }
            return highlightPolicy;
        }

        @Override
        @NotNull
        protected List<HighlightPolicy> getAvailableSettings() {
            ArrayList settings = ContainerUtil.newArrayList((Object[])HighlightPolicy.values());
            settings.remove((Object)HighlightPolicy.DO_NOT_HIGHLIGHT);
            ArrayList arrayList = settings;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$MyHighlightPolicySettingAction", "getAvailableSettings"));
            }
            return arrayList;
        }
    }

    private class MyToggleExpandByDefaultAction
    extends TextDiffViewerBase.ToggleExpandByDefaultAction {
        private MyToggleExpandByDefaultAction() {
            super(OnesideDiffViewer.this);
        }

        @Override
        protected void expandAll(boolean expand) {
            OnesideDiffViewer.this.myFoldingModel.expandAll(expand);
        }
    }

    private class MyOpenInEditorWithMouseAction
    extends OpenInEditorWithMouseAction {
        private MyOpenInEditorWithMouseAction() {
        }

        @Override
        protected OpenFileDescriptor getDescriptor(@NotNull Editor editor, int line) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$MyOpenInEditorWithMouseAction", "getDescriptor"));
            }
            if (editor != OnesideDiffViewer.this.myEditor) {
                return null;
            }
            return OnesideDiffViewer.this.getOpenFileDescriptor(OnesideDiffViewer.this.myEditor.logicalPositionToOffset(new LogicalPosition(line, 0)));
        }
    }

    private class MyPrevNextDifferenceIterable
    implements PrevNextDifferenceIterable {
        private MyPrevNextDifferenceIterable() {
        }

        @Override
        public void notify(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$MyPrevNextDifferenceIterable", "notify"));
            }
            LightweightHint hint = new LightweightHint(HintUtil.createInformationLabel(message));
            HintManagerImpl.getInstanceImpl().showEditorHint(hint, (Editor)OnesideDiffViewer.this.myEditor, (short)2, 42, 0, false);
        }

        @Override
        public boolean canGoNext() {
            List<OnesideDiffChange> diffChanges = OnesideDiffViewer.this.getDiffChanges();
            if (diffChanges == null || diffChanges.isEmpty()) {
                return false;
            }
            int line = ((OnesideDiffViewer)OnesideDiffViewer.this).myEditor.getCaretModel().getLogicalPosition().line;
            OnesideDiffChange lastChange = diffChanges.get(diffChanges.size() - 1);
            return lastChange.getLine1() > line;
        }

        @Override
        public void goNext() {
            List<OnesideDiffChange> diffChanges = OnesideDiffViewer.this.getDiffChanges();
            assert (diffChanges != null);
            int line = ((OnesideDiffViewer)OnesideDiffViewer.this).myEditor.getCaretModel().getLogicalPosition().line;
            OnesideDiffChange next = null;
            for (int i = 0; i < diffChanges.size(); ++i) {
                OnesideDiffChange change = diffChanges.get(i);
                if (change.getLine1() <= line) continue;
                next = change;
                break;
            }
            assert (next != null);
            DiffUtil.scrollToLineAnimated(OnesideDiffViewer.this.myEditor, next.getLine1());
        }

        @Override
        public boolean canGoPrev() {
            List<OnesideDiffChange> diffChanges = OnesideDiffViewer.this.getDiffChanges();
            if (diffChanges == null || diffChanges.isEmpty()) {
                return false;
            }
            int line = ((OnesideDiffViewer)OnesideDiffViewer.this).myEditor.getCaretModel().getLogicalPosition().line;
            OnesideDiffChange firstChange = diffChanges.get(0);
            return firstChange.getLine2() <= line;
        }

        @Override
        public void goPrev() {
            List<OnesideDiffChange> diffChanges = OnesideDiffViewer.this.getDiffChanges();
            assert (diffChanges != null);
            int line = ((OnesideDiffViewer)OnesideDiffViewer.this).myEditor.getCaretModel().getLogicalPosition().line;
            OnesideDiffChange prev = null;
            for (int i = 0; i < diffChanges.size(); ++i) {
                OnesideDiffChange change = diffChanges.get(i);
                if (change.getLine2() <= line) continue;
                prev = diffChanges.get(i - 1);
                break;
            }
            if (prev == null) {
                prev = diffChanges.get(diffChanges.size() - 1);
            }
            DiffUtil.scrollToLineAnimated(OnesideDiffViewer.this.myEditor, prev.getLine1());
        }
    }
}

