/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.tools.fragmented.HighlightRange;
import com.intellij.diff.tools.fragmented.OnesideDiffViewer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnesideEditorRangeHighlighter {
    public static final Logger LOG = OnesideDiffViewer.LOG;
    @NotNull
    private final List<Element> myPieces;

    public OnesideEditorRangeHighlighter(@Nullable Project project, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/tools/fragmented/OnesideEditorRangeHighlighter", "<init>"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        MarkupModelEx model = (MarkupModelEx)DocumentMarkupModel.forDocument(document, project, false);
        this.myPieces = new ArrayList<Element>();
        model.processRangeHighlightersOverlappingWith(0, document.getTextLength(), (Processor<? super RangeHighlighterEx>)new Processor<RangeHighlighterEx>(){

            public boolean process(RangeHighlighterEx marker) {
                int newStart = marker.getStartOffset();
                int newEnd = marker.getEndOffset();
                OnesideEditorRangeHighlighter.this.myPieces.add(new Element(marker, newStart, newEnd));
                return true;
            }
        });
    }

    public OnesideEditorRangeHighlighter(@Nullable Project project, @NotNull Document document1, @NotNull Document document2, @NotNull List<HighlightRange> ranges) {
        if (document1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document1", "com/intellij/diff/tools/fragmented/OnesideEditorRangeHighlighter", "<init>"));
        }
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document2", "com/intellij/diff/tools/fragmented/OnesideEditorRangeHighlighter", "<init>"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/diff/tools/fragmented/OnesideEditorRangeHighlighter", "<init>"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        MarkupModelEx model1 = (MarkupModelEx)DocumentMarkupModel.forDocument(document1, project, false);
        MarkupModelEx model2 = (MarkupModelEx)DocumentMarkupModel.forDocument(document2, project, false);
        this.myPieces = new ArrayList<Element>();
        this.init(model1, model2, ranges);
    }

    private void init(@Nullable MarkupModelEx model1, @Nullable MarkupModelEx model2, @NotNull List<HighlightRange> ranges) {
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/diff/tools/fragmented/OnesideEditorRangeHighlighter", "init"));
        }
        for (HighlightRange range : ranges) {
            if (range.getSide().isLeft()) {
                if (model1 == null) continue;
                this.processRange(model1, range);
                continue;
            }
            if (model2 == null) continue;
            this.processRange(model2, range);
        }
    }

    private void processRange(@NotNull MarkupModelEx model, @NotNull HighlightRange range) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/diff/tools/fragmented/OnesideEditorRangeHighlighter", "processRange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/diff/tools/fragmented/OnesideEditorRangeHighlighter", "processRange"));
        }
        final TextRange base = range.getBase();
        final TextRange changed = range.getChanged();
        final int changedLength = changed.getEndOffset() - changed.getStartOffset();
        model.processRangeHighlightersOverlappingWith(changed.getStartOffset(), changed.getEndOffset(), (Processor<? super RangeHighlighterEx>)new Processor<RangeHighlighterEx>(){

            public boolean process(RangeHighlighterEx marker) {
                int relativeStart = Math.max(marker.getStartOffset() - changed.getStartOffset(), 0);
                int relativeEnd = Math.min(marker.getEndOffset() - changed.getStartOffset(), changedLength);
                int newStart = base.getStartOffset() + relativeStart;
                int newEnd = base.getStartOffset() + relativeEnd;
                if (newEnd - newStart <= 0) {
                    return true;
                }
                OnesideEditorRangeHighlighter.this.myPieces.add(new Element(marker, newStart, newEnd));
                return true;
            }
        });
    }

    public void apply(@Nullable Project project, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/tools/fragmented/OnesideEditorRangeHighlighter", "apply"));
        }
        MarkupModel model = DocumentMarkupModel.forDocument(document, project, true);
        for (Element piece : this.myPieces) {
            RangeHighlighterEx delegate = piece.getDelegate();
            RangeHighlighter highlighter = model.addRangeHighlighter(piece.getStart(), piece.getEnd(), delegate.getLayer(), delegate.getTextAttributes(), delegate.getTargetArea());
            highlighter.setEditorFilter(delegate.getEditorFilter());
            highlighter.setCustomRenderer(delegate.getCustomRenderer());
            highlighter.setErrorStripeMarkColor(delegate.getErrorStripeMarkColor());
            highlighter.setErrorStripeTooltip(delegate.getErrorStripeTooltip());
            highlighter.setGutterIconRenderer(delegate.getGutterIconRenderer());
            highlighter.setLineMarkerRenderer(delegate.getLineMarkerRenderer());
            highlighter.setLineSeparatorColor(delegate.getLineSeparatorColor());
            highlighter.setThinErrorStripeMark(delegate.isThinErrorStripeMark());
            highlighter.setLineSeparatorPlacement(delegate.getLineSeparatorPlacement());
            highlighter.setLineSeparatorRenderer(delegate.getLineSeparatorRenderer());
        }
    }

    private static class Element {
        @NotNull
        private final RangeHighlighterEx myDelegate;
        private final int myStart;
        private final int myEnd;

        public Element(@NotNull RangeHighlighterEx delegate, int start, int end) {
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/diff/tools/fragmented/OnesideEditorRangeHighlighter$Element", "<init>"));
            }
            this.myDelegate = delegate;
            this.myStart = start;
            this.myEnd = end;
        }

        @NotNull
        public RangeHighlighterEx getDelegate() {
            RangeHighlighterEx rangeHighlighterEx = this.myDelegate;
            if (rangeHighlighterEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideEditorRangeHighlighter$Element", "getDelegate"));
            }
            return rangeHighlighterEx;
        }

        public int getStart() {
            return this.myStart;
        }

        public int getEnd() {
            return this.myEnd;
        }
    }
}

