/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.DumbAwareAction;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffOperation
extends GutterIconRenderer {
    @NotNull
    private final String myTooltip;
    @NotNull
    private final Icon myIcon;
    @NotNull
    private final AnAction myAction;

    @NotNull
    public static RangeHighlighter createHighlighter(@NotNull Editor editor, @NotNull DiffOperation operation, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/simple/DiffOperation", "createHighlighter"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/diff/tools/simple/DiffOperation", "createHighlighter"));
        }
        RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(offset, offset, 3000, null, HighlighterTargetArea.LINES_IN_RANGE);
        highlighter.setGutterIconRenderer((GutterIconRenderer)operation);
        RangeHighlighter rangeHighlighter = highlighter;
        if (rangeHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/DiffOperation", "createHighlighter"));
        }
        return rangeHighlighter;
    }

    public DiffOperation(@NotNull String tooltip, @NotNull Icon gutterIcon) {
        if (tooltip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tooltip", "com/intellij/diff/tools/simple/DiffOperation", "<init>"));
        }
        if (gutterIcon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gutterIcon", "com/intellij/diff/tools/simple/DiffOperation", "<init>"));
        }
        this.myTooltip = tooltip;
        this.myIcon = gutterIcon;
        this.myAction = this.createAction();
    }

    public abstract void perform(@NotNull AnActionEvent var1);

    @NotNull
    public Icon getIcon() {
        Icon icon = this.myIcon;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/DiffOperation", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public String getTooltipText() {
        String string = this.myTooltip;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/DiffOperation", "getTooltipText"));
        }
        return string;
    }

    public boolean isNavigateAction() {
        return true;
    }

    @Nullable
    public AnAction getClickAction() {
        return this.myAction;
    }

    @NotNull
    private AnAction createAction() {
        DumbAwareAction dumbAwareAction = new DumbAwareAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/simple/DiffOperation$1", "actionPerformed"));
                }
                DiffOperation.this.perform(e);
            }
        };
        if (dumbAwareAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/DiffOperation", "createAction"));
        }
        return dumbAwareAction;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return System.identityHashCode((Object)this);
    }
}

