/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.tools.simple.DiffOperation;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffIcons;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleDiffChange {
    @NotNull
    private final LineFragment myFragment;
    @Nullable
    private final List<DiffFragment> myInnerFragments;
    @Nullable
    private final EditorEx myEditor1;
    @Nullable
    private final EditorEx myEditor2;
    @NotNull
    private final List<RangeHighlighter> myHighlighters;
    @NotNull
    private final List<RangeHighlighter> myActionHighlighters;
    private boolean myIsValid;
    private int[] myLineStartShifts;
    private int[] myLineEndShifts;

    public SimpleDiffChange(@NotNull LineFragment fragment, @Nullable EditorEx editor1, @Nullable EditorEx editor2, boolean inlineHighlight) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/simple/SimpleDiffChange", "<init>"));
        }
        this.myHighlighters = new ArrayList<RangeHighlighter>();
        this.myActionHighlighters = new ArrayList<RangeHighlighter>();
        this.myIsValid = true;
        this.myLineStartShifts = new int[2];
        this.myLineEndShifts = new int[2];
        this.myFragment = fragment;
        this.myInnerFragments = inlineHighlight ? fragment.getInnerFragments() : null;
        this.myEditor1 = editor1;
        this.myEditor2 = editor2;
        this.installHighlighter();
    }

    public void installHighlighter() {
        assert (this.myHighlighters.isEmpty());
        if (this.myInnerFragments != null) {
            this.doInstallHighlighterWithInner();
        } else {
            this.doInstallHighlighterSimple();
        }
        this.doInstallActionHighlighters();
    }

    public void destroyHighlighter() {
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
        for (RangeHighlighter highlighter : this.myActionHighlighters) {
            highlighter.dispose();
        }
        this.myActionHighlighters.clear();
    }

    private void doInstallHighlighterSimple() {
        this.createHighlighter(Side.LEFT, false);
        this.createHighlighter(Side.RIGHT, false);
    }

    private void doInstallHighlighterWithInner() {
        assert (this.myInnerFragments != null);
        this.createHighlighter(Side.LEFT, true);
        this.createHighlighter(Side.RIGHT, true);
        for (DiffFragment fragment : this.myInnerFragments) {
            this.createInlineHighlighter(fragment, Side.LEFT);
            this.createInlineHighlighter(fragment, Side.RIGHT);
        }
    }

    private void doInstallActionHighlighters() {
        if (this.myEditor1 != null && this.myEditor2 != null) {
            MyReplaceOperation operation;
            if (DiffUtil.isEditable(this.myEditor1)) {
                operation = new MyReplaceOperation(Side.LEFT);
                this.myActionHighlighters.add(DiffOperation.createHighlighter(this.myEditor2, operation, this.myFragment.getStartOffset2()));
            }
            if (DiffUtil.isEditable(this.myEditor2)) {
                operation = new MyReplaceOperation(Side.RIGHT);
                this.myActionHighlighters.add(DiffOperation.createHighlighter(this.myEditor1, operation, this.myFragment.getStartOffset1()));
            }
        }
    }

    private void createHighlighter(@NotNull Side side, boolean ignored) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffChange", "createHighlighter"));
        }
        Editor editor = (Editor)side.select((Object)this.myEditor1, (Object)this.myEditor2);
        if (editor == null) {
            return;
        }
        int start = side.getStartOffset((DiffFragment)this.myFragment);
        int end = side.getEndOffset((DiffFragment)this.myFragment);
        TextDiffType type = DiffUtil.getLineDiffType(this.myFragment);
        this.myHighlighters.add(DiffDrawUtil.createHighlighter(editor, start, end, type, ignored));
        int startLine = side.getStartLine(this.myFragment);
        int endLine = side.getEndLine(this.myFragment);
        if (startLine == endLine) {
            if (startLine != 0) {
                this.myHighlighters.add(DiffDrawUtil.createLineMarker(editor, endLine - 1, type, SeparatorPlacement.BOTTOM, true));
            }
        } else {
            this.myHighlighters.add(DiffDrawUtil.createLineMarker(editor, startLine, type, SeparatorPlacement.TOP));
            this.myHighlighters.add(DiffDrawUtil.createLineMarker(editor, endLine - 1, type, SeparatorPlacement.BOTTOM));
        }
    }

    private void createInlineHighlighter(@NotNull DiffFragment fragment, @NotNull Side side) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/simple/SimpleDiffChange", "createInlineHighlighter"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffChange", "createInlineHighlighter"));
        }
        Editor editor = (Editor)side.select((Object)this.myEditor1, (Object)this.myEditor2);
        if (editor == null) {
            return;
        }
        int start = side.getStartOffset(fragment);
        int end = side.getEndOffset(fragment);
        TextDiffType type = DiffUtil.getDiffType(fragment);
        int startOffset = side.getStartOffset((DiffFragment)this.myFragment);
        RangeHighlighter highlighter = DiffDrawUtil.createInlineHighlighter(editor, start += startOffset, end += startOffset, type);
        this.myHighlighters.add(highlighter);
    }

    public int getStartLine(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffChange", "getStartLine"));
        }
        return side.getStartLine(this.myFragment) + side.select(this.myLineStartShifts);
    }

    public int getEndLine(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffChange", "getEndLine"));
        }
        return side.getEndLine(this.myFragment) + side.select(this.myLineEndShifts);
    }

    @NotNull
    public TextDiffType getDiffType() {
        TextDiffType textDiffType = DiffUtil.getLineDiffType(this.myFragment);
        if (textDiffType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffChange", "getDiffType"));
        }
        return textDiffType;
    }

    public boolean processChange(int oldLine1, int oldLine2, int shift, @NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffChange", "processChange"));
        }
        int line1 = this.getStartLine(side);
        int line2 = this.getEndLine(side);
        if (line2 <= oldLine1) {
            return false;
        }
        if (line1 >= oldLine2) {
            int n = side.getIndex();
            this.myLineStartShifts[n] = this.myLineStartShifts[n] + shift;
            int n2 = side.getIndex();
            this.myLineEndShifts[n2] = this.myLineEndShifts[n2] + shift;
            return false;
        }
        if (line1 <= oldLine1 && line2 >= oldLine2) {
            int n = side.getIndex();
            this.myLineEndShifts[n] = this.myLineEndShifts[n] + shift;
            return false;
        }
        for (RangeHighlighter highlighter : this.myActionHighlighters) {
            highlighter.dispose();
        }
        this.myActionHighlighters.clear();
        this.myIsValid = false;
        return true;
    }

    public boolean isSelectedByLine(int line, @NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffChange", "isSelectedByLine"));
        }
        if (this.myEditor1 == null || this.myEditor2 == null) {
            return false;
        }
        int line1 = this.getStartLine(side);
        int line2 = this.getEndLine(side);
        return DiffUtil.isSelectedByLine(line, line1, line2);
    }

    public void replaceChange(@NotNull Side sourceSide) {
        if (sourceSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSide", "com/intellij/diff/tools/simple/SimpleDiffChange", "replaceChange"));
        }
        assert (this.myEditor1 != null && this.myEditor2 != null);
        if (!this.myIsValid) {
            return;
        }
        DocumentEx document1 = this.myEditor1.getDocument();
        DocumentEx document2 = this.myEditor2.getDocument();
        DiffUtil.applyModification((Document)sourceSide.other().selectN((Object)document1, (Object)document2), this.getStartLine(sourceSide.other()), this.getEndLine(sourceSide.other()), (Document)sourceSide.selectN((Object)document1, (Object)document2), this.getStartLine(sourceSide), this.getEndLine(sourceSide));
        this.destroyHighlighter();
    }

    public void appendChange(@NotNull Side sourceSide) {
        if (sourceSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSide", "com/intellij/diff/tools/simple/SimpleDiffChange", "appendChange"));
        }
        assert (this.myEditor1 != null && this.myEditor2 != null);
        if (!this.myIsValid) {
            return;
        }
        this.destroyHighlighter();
        DocumentEx document1 = this.myEditor1.getDocument();
        DocumentEx document2 = this.myEditor2.getDocument();
        DiffUtil.applyModification((Document)sourceSide.other().selectN((Object)document1, (Object)document2), this.getEndLine(sourceSide.other()), this.getEndLine(sourceSide.other()), (Document)sourceSide.selectN((Object)document1, (Object)document2), this.getStartLine(sourceSide), this.getEndLine(sourceSide));
        this.destroyHighlighter();
    }

    private class MyReplaceOperation
    extends DiffOperation {
        @NotNull
        private final Side mySide;

        public MyReplaceOperation(Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffChange$MyReplaceOperation", "<init>"));
            }
            super("Replace", DiffIcons.getReplaceIcon(Side.RIGHT));
            this.mySide = side;
        }

        @Override
        public void perform(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/simple/SimpleDiffChange$MyReplaceOperation", "perform"));
            }
            Project project = e.getProject();
            assert (SimpleDiffChange.this.myEditor1 != null && SimpleDiffChange.this.myEditor2 != null);
            DocumentEx document1 = SimpleDiffChange.this.myEditor1.getDocument();
            DocumentEx document2 = SimpleDiffChange.this.myEditor2.getDocument();
            if (!SimpleDiffChange.this.myIsValid) {
                return;
            }
            DiffUtil.executeWriteCommand((Document)this.mySide.selectN((Object)document1, (Object)document2), project, "Replace change", new Runnable(){

                @Override
                public void run() {
                    SimpleDiffChange.this.replaceChange(MyReplaceOperation.this.mySide.other());
                }
            });
        }
    }
}

