/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TIntFunction;
import java.awt.Component;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoldingModelSupport {
    public static final String PLACEHOLDER = "     ";

    private static int bound(int value, int min, int max) {
        return Math.min(Math.max(value, min), max);
    }

    @NotNull
    private static RangeHighlighter createFoldingHighlighter(@NotNull Editor editor, @NotNull FoldRegion region) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/util/FoldingModelSupport", "createFoldingHighlighter"));
        }
        if (region == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "region", "com/intellij/diff/tools/util/FoldingModelSupport", "createFoldingHighlighter"));
        }
        RangeHighlighter rangeHighlighter = DiffDrawUtil.createLineSeparatorHighlighter(editor, region.getStartOffset(), region.getEndOffset(), new RangeCondition(region));
        if (rangeHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/FoldingModelSupport", "createFoldingHighlighter"));
        }
        return rangeHighlighter;
    }

    private static class FoldedRange {
        public final int myStartLine;
        public final int myEndLine;
        public final boolean myExpanded;

        public FoldedRange(int startLine, int endLine, boolean expanded) {
            this.myStartLine = startLine;
            this.myEndLine = endLine;
            this.myExpanded = expanded;
        }
    }

    private static class RangeCondition
    implements BooleanGetter {
        @NotNull
        private final FoldRegion myRegion;

        public RangeCondition(@NotNull FoldRegion region) {
            if (region == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "region", "com/intellij/diff/tools/util/FoldingModelSupport$RangeCondition", "<init>"));
            }
            this.myRegion = region;
        }

        public boolean get() {
            return this.myRegion.isValid() && !this.myRegion.isExpanded();
        }
    }

    private static abstract class FoldingModelBase {
        protected static final Key<FoldingCache> CACHE_KEY = Key.create((String)"Diff.FoldingUtil.SimpleCache");
        protected final int myCount;
        @NotNull
        protected final EditorEx[] myEditors;
        @NotNull
        protected final List<FoldedBlock> myFoldings;
        private boolean myDuringSynchronize;
        private boolean myShouldUpdateLineNumbers;

        public FoldingModelBase(@NotNull EditorEx[] editors, @NotNull Disposable disposable) {
            if (editors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/util/FoldingModelSupport$FoldingModelBase", "<init>"));
            }
            if (disposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/diff/tools/util/FoldingModelSupport$FoldingModelBase", "<init>"));
            }
            this.myFoldings = new ArrayList<FoldedBlock>();
            this.myEditors = editors;
            this.myCount = this.myEditors.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void invokeBatchOperation(@NotNull Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/diff/tools/util/FoldingModelSupport$FoldingModelBase", "invokeBatchOperation"));
            }
            Runnable lastRunnable = runnable;
            for (int i = 0; i < this.myCount; ++i) {
                final EditorEx editor = this.myEditors[i];
                final Runnable finalRunnable = lastRunnable;
                lastRunnable = new Runnable(){

                    @Override
                    public void run() {
                        editor.getFoldingModel().runBatchFoldingOperation(new Runnable(){

                            @Override
                            public void run() {
                                finalRunnable.run();
                            }
                        });
                    }
                };
            }
            this.myDuringSynchronize = true;
            try {
                lastRunnable.run();
            }
            finally {
                this.myDuringSynchronize = false;
            }
        }

        @Nullable
        protected static FoldRegion addFolding(@NotNull EditorEx editor, int start, int end, boolean expanded) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/util/FoldingModelSupport$FoldingModelBase", "addFolding"));
            }
            assert (ApplicationManager.getApplication().isReadAccessAllowed());
            if (end - start < 2) {
                return null;
            }
            DocumentEx document = editor.getDocument();
            int startOffset = document.getLineStartOffset(start);
            int endOffset = document.getLineEndOffset(end - 1);
            FoldRegion value = editor.getFoldingModel().addFoldRegion(startOffset, endOffset, FoldingModelSupport.PLACEHOLDER);
            if (value != null) {
                value.setExpanded(expanded);
            }
            return value;
        }

        public void destroy() {
            for (int i = 0; i < this.myCount; ++i) {
                this.destroyFoldings(i);
            }
            for (FoldedBlock folding : this.myFoldings) {
                folding.destroyHighlighter();
            }
            this.myFoldings.clear();
        }

        private void destroyFoldings(final int index) {
            final FoldingModelEx model = this.myEditors[index].getFoldingModel();
            model.runBatchFoldingOperation(new Runnable(){

                @Override
                public void run() {
                    for (FoldedBlock folding : FoldingModelBase.this.myFoldings) {
                        FoldRegion region = folding.getRegion(index);
                        if (region == null) continue;
                        model.removeFoldRegion(region);
                    }
                }
            });
        }

        public void onDocumentChanged(@NotNull DocumentEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/util/FoldingModelSupport$FoldingModelBase", "onDocumentChanged"));
            }
            if (StringUtil.indexOf((CharSequence)e.getOldFragment(), (char)'\n') != -1 || StringUtil.indexOf((CharSequence)e.getNewFragment(), (char)'\n') != -1) {
                this.myShouldUpdateLineNumbers = true;
            }
        }

        @NotNull
        protected TIntFunction getLineConvertor(final int index) {
            TIntFunction tIntFunction = new TIntFunction(){

                public int execute(int value) {
                    if (FoldingModelBase.this.myShouldUpdateLineNumbers) {
                        FoldingModelBase.this.updateLineNumbers();
                    }
                    for (FoldedBlock folding : FoldingModelBase.this.myFoldings) {
                        int line = folding.getLine(index);
                        if (line == -1) continue;
                        if (line > value) break;
                        FoldRegion region = folding.getRegion(index);
                        if (line != value || region == null || region.isExpanded()) continue;
                        return -1;
                    }
                    return value;
                }
            };
            if (tIntFunction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/FoldingModelSupport$FoldingModelBase", "getLineConvertor"));
            }
            return tIntFunction;
        }

        protected void updateLineNumbers() {
            assert (ApplicationManager.getApplication().isReadAccessAllowed());
            for (FoldedBlock folding : this.myFoldings) {
                folding.updateLineNumbers();
            }
            this.myShouldUpdateLineNumbers = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void expandAll(final boolean expanded) {
            if (this.myDuringSynchronize) {
                return;
            }
            this.myDuringSynchronize = true;
            try {
                int i = 0;
                while (i < this.myCount) {
                    final int index = i++;
                    FoldingModelEx model = this.myEditors[index].getFoldingModel();
                    model.runBatchFoldingOperation(new Runnable(){

                        @Override
                        public void run() {
                            for (FoldedBlock folding : FoldingModelBase.this.myFoldings) {
                                FoldRegion region = folding.getRegion(index);
                                if (region == null) continue;
                                region.setExpanded(expanded);
                            }
                        }
                    });
                }
            }
            finally {
                this.myDuringSynchronize = false;
            }
        }

        private void updatePairedRegion(@NotNull FoldRegion region, int index, int pairedIndex) {
            if (region == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "region", "com/intellij/diff/tools/util/FoldingModelSupport$FoldingModelBase", "updatePairedRegion"));
            }
            FoldRegion pairedRegion = null;
            for (FoldedBlock folding : this.myFoldings) {
                if (folding.getRegion(index) != region) continue;
                pairedRegion = folding.getRegion(pairedIndex);
                break;
            }
            if (pairedRegion == null) {
                return;
            }
            if (!region.isValid() || !pairedRegion.isValid()) {
                return;
            }
            pairedRegion.setExpanded(region.isExpanded());
        }

        public void updateContext(@NotNull UserDataHolder context, boolean defaultState) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/FoldingModelSupport$FoldingModelBase", "updateContext"));
            }
            if (this.myFoldings.isEmpty()) {
                return;
            }
            context.putUserData(CACHE_KEY, (Object)this.getFoldingCache(defaultState));
        }

        @NotNull
        private FoldingCache getFoldingCache(final boolean defaultState) {
            FoldingCache foldingCache = (FoldingCache)ApplicationManager.getApplication().runReadAction((Computable)new Computable<FoldingCache>(){

                public FoldingCache compute() {
                    List[] result = new List[FoldingModelBase.this.myCount];
                    for (int i = 0; i < FoldingModelBase.this.myCount; ++i) {
                        result[i] = FoldingModelBase.this.getFoldedRanges(i);
                    }
                    return new FoldingCache(result, defaultState);
                }
            });
            if (foldingCache == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/FoldingModelSupport$FoldingModelBase", "getFoldingCache"));
            }
            return foldingCache;
        }

        @NotNull
        private List<FoldedRange> getFoldedRanges(int index) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            ArrayList<FoldedRange> ranges = new ArrayList<FoldedRange>(this.myFoldings.size());
            for (FoldedBlock folding : this.myFoldings) {
                FoldRegion region = folding.getRegion(index);
                if (region == null || !region.isValid()) continue;
                DocumentEx document = this.myEditors[index].getDocument();
                int line1 = document.getLineNumber(region.getStartOffset());
                int line2 = document.getLineNumber(region.getEndOffset()) + 1;
                ranges.add(new FoldedRange(line1, line2, region.isExpanded()));
            }
            ArrayList<FoldedRange> arrayList = ranges;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/FoldingModelSupport$FoldingModelBase", "getFoldedRanges"));
            }
            return arrayList;
        }

        protected class FoldedBlock {
            @NotNull
            protected final FoldRegion[] myRegions;
            @NotNull
            private final List<RangeHighlighter> myHighlighters;
            private final int[] myLines;

            public FoldedBlock(FoldRegion[] regions) {
                if (regions == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regions", "com/intellij/diff/tools/util/FoldingModelSupport$FoldingModelBase$FoldedBlock", "<init>"));
                }
                this.myHighlighters = new ArrayList<RangeHighlighter>();
                this.myLines = new int[FoldingModelBase.this.myCount];
                assert (regions.length == FoldingModelBase.this.myCount);
                this.myRegions = regions;
                this.installHighlighter();
            }

            public void installHighlighter() {
                assert (this.myHighlighters.isEmpty());
                for (int i = 0; i < FoldingModelBase.this.myCount; ++i) {
                    FoldRegion region = this.myRegions[i];
                    if (region == null || !region.isValid()) continue;
                    this.myHighlighters.add(FoldingModelSupport.createFoldingHighlighter(FoldingModelBase.this.myEditors[i], region));
                }
            }

            public void destroyHighlighter() {
                for (RangeHighlighter highlighter : this.myHighlighters) {
                    highlighter.dispose();
                }
                this.myHighlighters.clear();
            }

            public void updateLineNumbers() {
                for (int i = 0; i < FoldingModelBase.this.myCount; ++i) {
                    FoldRegion region = this.myRegions[i];
                    this.myLines[i] = region == null || !region.isValid() ? -1 : FoldingModelBase.this.myEditors[i].getDocument().getLineNumber(region.getStartOffset());
                }
            }

            @Nullable
            public FoldRegion getRegion(int index) {
                return this.myRegions[index];
            }

            public int getLine(int index) {
                return this.myLines[index];
            }
        }

        protected static class FoldingCache {
            public final boolean myExpandByDefault;
            @NotNull
            public final List<FoldedRange>[] myRanges;

            public FoldingCache(@NotNull List<FoldedRange>[] ranges, boolean expandByDefault) {
                if (ranges == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/diff/tools/util/FoldingModelSupport$FoldingModelBase$FoldingCache", "<init>"));
                }
                this.myRanges = ranges;
                this.myExpandByDefault = expandByDefault;
            }
        }

        protected abstract class ExpandSuggesterBase {
            @Nullable
            private final FoldingCache myCache;
            private final int[] myIndex;
            protected final boolean myDefault;

            public ExpandSuggesterBase(FoldingCache cache, boolean defaultValue) {
                this.myIndex = new int[FoldingModelBase.this.myCount];
                this.myCache = cache;
                this.myDefault = defaultValue;
            }

            protected boolean selectState(Boolean ... sides) {
                Boolean state = null;
                for (Boolean side : sides) {
                    if (side == null) continue;
                    if (state == null) {
                        state = side;
                        continue;
                    }
                    if (state == side) continue;
                    return this.myDefault;
                }
                return state == null ? this.myDefault : state;
            }

            @Nullable
            protected Boolean getCachedExpanded(int start, int end, int index) {
                if (this.myCache == null || this.myCache.myRanges.length != FoldingModelBase.this.myCount) {
                    return null;
                }
                if (start == end) {
                    return null;
                }
                if (this.myDefault != this.myCache.myExpandByDefault) {
                    return this.myDefault;
                }
                List<FoldedRange> ranges = this.myCache.myRanges[index];
                while (this.myIndex[index] < ranges.size()) {
                    FoldedRange range = ranges.get(this.myIndex[index]);
                    if (range.myEndLine > start) {
                        if (range.myStartLine >= end) {
                            return null;
                        }
                        if (range.myStartLine < end && range.myEndLine > start) {
                            return range.myExpanded;
                        }
                    }
                    int n = index;
                    this.myIndex[n] = this.myIndex[n] + 1;
                }
                return null;
            }
        }

        protected class MyPaintable
        implements DiffDividerDrawUtil.DividerSeparatorPaintable {
            private final int myLeft;
            private final int myRight;

            public MyPaintable(int left, int right) {
                this.myLeft = left;
                this.myRight = right;
            }

            @Override
            public void process(@NotNull DiffDividerDrawUtil.DividerSeparatorPaintable.Handler handler) {
                if (handler == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/diff/tools/util/FoldingModelSupport$FoldingModelBase$MyPaintable", "process"));
                }
                for (FoldedBlock folding : FoldingModelBase.this.myFoldings) {
                    if (folding.myRegions[this.myLeft] == null || folding.myRegions[this.myRight] == null || folding.myRegions[this.myLeft].isExpanded() || folding.myRegions[this.myRight].isExpanded()) continue;
                    int line1 = FoldingModelBase.this.myEditors[this.myLeft].getDocument().getLineNumber(folding.myRegions[this.myLeft].getStartOffset());
                    int line2 = FoldingModelBase.this.myEditors[this.myRight].getDocument().getLineNumber(folding.myRegions[this.myRight].getStartOffset());
                    handler.process(line1, line2);
                }
            }

            public void paintOnDivider(@NotNull Graphics2D gg, @NotNull Component divider) {
                if (gg == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gg", "com/intellij/diff/tools/util/FoldingModelSupport$FoldingModelBase$MyPaintable", "paintOnDivider"));
                }
                if (divider == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "divider", "com/intellij/diff/tools/util/FoldingModelSupport$FoldingModelBase$MyPaintable", "paintOnDivider"));
                }
                DiffDividerDrawUtil.paintSeparators(gg, divider.getWidth(), FoldingModelBase.this.myEditors[this.myLeft], FoldingModelBase.this.myEditors[this.myRight], this);
            }

            public void paintOnScrollbar(@NotNull Graphics2D gg, int width) {
                if (gg == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gg", "com/intellij/diff/tools/util/FoldingModelSupport$FoldingModelBase$MyPaintable", "paintOnScrollbar"));
                }
                DiffDividerDrawUtil.paintSeparatorsOnScrollbar(gg, width, FoldingModelBase.this.myEditors[this.myLeft], FoldingModelBase.this.myEditors[this.myRight], this);
            }
        }

        protected class MyListener
        implements FoldingListener {
            private final int myIndex;
            @NotNull
            List<FoldRegion> myModifiedRegions = new ArrayList<FoldRegion>();

            public MyListener(int index) {
                this.myIndex = index;
            }

            @Override
            public void onFoldRegionStateChange(@NotNull FoldRegion region) {
                if (region == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "region", "com/intellij/diff/tools/util/FoldingModelSupport$FoldingModelBase$MyListener", "onFoldRegionStateChange"));
                }
                if (FoldingModelBase.this.myDuringSynchronize) {
                    return;
                }
                this.myModifiedRegions.add(region);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFoldProcessingEnd() {
                FoldingModelBase.this.myDuringSynchronize = true;
                try {
                    for (int i = 0; i < FoldingModelBase.this.myCount; ++i) {
                        if (i == this.myIndex) continue;
                        final int pairedIndex = i;
                        FoldingModelBase.this.myEditors[pairedIndex].getFoldingModel().runBatchFoldingOperation(new Runnable(){

                            @Override
                            public void run() {
                                for (FoldRegion region : MyListener.this.myModifiedRegions) {
                                    FoldingModelBase.this.updatePairedRegion(region, MyListener.this.myIndex, pairedIndex);
                                }
                            }
                        });
                    }
                    this.myModifiedRegions.clear();
                }
                finally {
                    FoldingModelBase.this.myDuringSynchronize = false;
                }
            }
        }
    }

    public static class SimpleThreesideFoldingModel
    extends FoldingModelBase {
        private final FoldingModelBase.MyPaintable myPaintable1;
        private final FoldingModelBase.MyPaintable myPaintable2;

        public SimpleThreesideFoldingModel(@NotNull EditorEx[] editors, @NotNull Disposable disposable) {
            if (editors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/util/FoldingModelSupport$SimpleThreesideFoldingModel", "<init>"));
            }
            if (disposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/diff/tools/util/FoldingModelSupport$SimpleThreesideFoldingModel", "<init>"));
            }
            super(editors, disposable);
            this.myPaintable1 = new FoldingModelBase.MyPaintable(0, 1);
            this.myPaintable2 = new FoldingModelBase.MyPaintable(1, 2);
            assert (editors.length == 3);
            for (int i = 0; i < this.myCount; ++i) {
                this.myEditors[i].getFoldingModel().addListener(new FoldingModelBase.MyListener(i), disposable);
                this.myEditors[i].getGutterComponentEx().setLineNumberConvertor(this.getLineConvertor(i));
            }
        }

        public void install(final @Nullable List<MergeLineFragment> fragments, @NotNull UserDataHolder context, boolean defaultExpanded, final int range) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/FoldingModelSupport$SimpleThreesideFoldingModel", "install"));
            }
            if (fragments == null) {
                return;
            }
            if (range == -1) {
                return;
            }
            final MyExpandSuggester suggester = new MyExpandSuggester((FoldingModelBase.FoldingCache)context.getUserData(CACHE_KEY), defaultExpanded);
            this.invokeBatchOperation(new Runnable(){

                @Override
                public void run() {
                    int last1 = Integer.MIN_VALUE;
                    int last2 = Integer.MIN_VALUE;
                    int last3 = Integer.MIN_VALUE;
                    for (MergeLineFragment fragment : fragments) {
                        SimpleThreesideFoldingModel.this.addRange(last1, fragment.getStartLine(ThreeSide.LEFT), last2, fragment.getStartLine(ThreeSide.BASE), last3, fragment.getStartLine(ThreeSide.RIGHT), range, suggester);
                        last1 = fragment.getEndLine(ThreeSide.LEFT);
                        last2 = fragment.getEndLine(ThreeSide.BASE);
                        last3 = fragment.getEndLine(ThreeSide.RIGHT);
                    }
                    SimpleThreesideFoldingModel.this.addRange(last1, Integer.MAX_VALUE, last2, Integer.MAX_VALUE, last3, Integer.MAX_VALUE, range, suggester);
                }
            });
            this.updateLineNumbers();
        }

        private void addRange(int start1, int end1, int start2, int end2, int start3, int end3, int range, @NotNull MyExpandSuggester suggester) {
            if (suggester == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggester", "com/intellij/diff/tools/util/FoldingModelSupport$SimpleThreesideFoldingModel", "addRange"));
            }
            int count1 = this.myEditors[0].getDocument().getLineCount();
            int count2 = this.myEditors[1].getDocument().getLineCount();
            int count3 = this.myEditors[2].getDocument().getLineCount();
            start1 = FoldingModelSupport.bound(start1 + range, 0, count1);
            start2 = FoldingModelSupport.bound(start2 + range, 0, count2);
            start3 = FoldingModelSupport.bound(start3 + range, 0, count3);
            end1 = FoldingModelSupport.bound(end1 - range, 0, count1);
            end2 = FoldingModelSupport.bound(end2 - range, 0, count2);
            end3 = FoldingModelSupport.bound(end3 - range, 0, count3);
            boolean expanded = suggester.getExpanded(start1, end1, start2, end2, start3, end3);
            FoldRegion region1 = SimpleThreesideFoldingModel.addFolding(this.myEditors[0], start1, end1, expanded);
            FoldRegion region2 = SimpleThreesideFoldingModel.addFolding(this.myEditors[1], start2, end2, expanded);
            FoldRegion region3 = SimpleThreesideFoldingModel.addFolding(this.myEditors[2], start3, end3, expanded);
            if (region1 == null && region2 == null && region3 == null) {
                return;
            }
            this.myFoldings.add(new FoldingModelBase.FoldedBlock(new FoldRegion[]{region1, region2, region3}));
        }

        public void paintOnDivider(@NotNull Graphics2D gg, @NotNull Component divider, @NotNull Side side) {
            if (gg == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gg", "com/intellij/diff/tools/util/FoldingModelSupport$SimpleThreesideFoldingModel", "paintOnDivider"));
            }
            if (divider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "divider", "com/intellij/diff/tools/util/FoldingModelSupport$SimpleThreesideFoldingModel", "paintOnDivider"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/FoldingModelSupport$SimpleThreesideFoldingModel", "paintOnDivider"));
            }
            FoldingModelBase.MyPaintable paintable = (FoldingModelBase.MyPaintable)side.selectN((Object)this.myPaintable1, (Object)this.myPaintable2);
            paintable.paintOnDivider(gg, divider);
        }

        public void paintOnScrollbar(@NotNull Graphics2D gg, int width) {
            if (gg == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gg", "com/intellij/diff/tools/util/FoldingModelSupport$SimpleThreesideFoldingModel", "paintOnScrollbar"));
            }
            this.myPaintable2.paintOnScrollbar(gg, width);
        }

        private class MyExpandSuggester
        extends FoldingModelBase.ExpandSuggesterBase {
            public MyExpandSuggester(FoldingModelBase.FoldingCache cache, boolean defaultValue) {
                super(cache, defaultValue);
            }

            public boolean getExpanded(int start1, int end1, int start2, int end2, int start3, int end3) {
                Boolean expanded1 = this.getCachedExpanded(start1, end1, 0);
                Boolean expanded2 = this.getCachedExpanded(start2, end2, 1);
                Boolean expanded3 = this.getCachedExpanded(start3, end3, 2);
                return this.selectState(expanded1, expanded2, expanded3);
            }
        }
    }

    public static class SimpleFoldingModel
    extends FoldingModelBase {
        private final FoldingModelBase.MyPaintable myPaintable;

        public SimpleFoldingModel(@NotNull EditorEx editor1, @NotNull EditorEx editor2, @NotNull Disposable disposable) {
            if (editor1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor1", "com/intellij/diff/tools/util/FoldingModelSupport$SimpleFoldingModel", "<init>"));
            }
            if (editor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor2", "com/intellij/diff/tools/util/FoldingModelSupport$SimpleFoldingModel", "<init>"));
            }
            if (disposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/diff/tools/util/FoldingModelSupport$SimpleFoldingModel", "<init>"));
            }
            super(new EditorEx[]{editor1, editor2}, disposable);
            this.myPaintable = new FoldingModelBase.MyPaintable(0, 1);
            for (int i = 0; i < this.myCount; ++i) {
                this.myEditors[i].getFoldingModel().addListener(new FoldingModelBase.MyListener(i), disposable);
                this.myEditors[i].getGutterComponentEx().setLineNumberConvertor(this.getLineConvertor(i));
            }
        }

        public void install(final @Nullable List<LineFragment> fragments, @NotNull UserDataHolder context, boolean defaultExpanded, final int range) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/FoldingModelSupport$SimpleFoldingModel", "install"));
            }
            if (fragments == null) {
                return;
            }
            if (range == -1) {
                return;
            }
            final MyExpandSuggester suggester = new MyExpandSuggester((FoldingModelBase.FoldingCache)context.getUserData(CACHE_KEY), defaultExpanded);
            this.invokeBatchOperation(new Runnable(){

                @Override
                public void run() {
                    int last1 = Integer.MIN_VALUE;
                    int last2 = Integer.MIN_VALUE;
                    for (LineFragment fragment : fragments) {
                        SimpleFoldingModel.this.addRange(last1, fragment.getStartLine1(), last2, fragment.getStartLine2(), range, suggester);
                        last1 = fragment.getEndLine1();
                        last2 = fragment.getEndLine2();
                    }
                    SimpleFoldingModel.this.addRange(last1, Integer.MAX_VALUE, last2, Integer.MAX_VALUE, range, suggester);
                }
            });
            this.updateLineNumbers();
        }

        private void addRange(int start1, int end1, int start2, int end2, int range, @NotNull MyExpandSuggester suggester) {
            if (suggester == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggester", "com/intellij/diff/tools/util/FoldingModelSupport$SimpleFoldingModel", "addRange"));
            }
            int count1 = this.myEditors[0].getDocument().getLineCount();
            int count2 = this.myEditors[1].getDocument().getLineCount();
            start1 = FoldingModelSupport.bound(start1 + range, 0, count1);
            start2 = FoldingModelSupport.bound(start2 + range, 0, count2);
            end1 = FoldingModelSupport.bound(end1 - range, 0, count1);
            end2 = FoldingModelSupport.bound(end2 - range, 0, count2);
            boolean expanded = suggester.getExpanded(start1, end1, start2, end2);
            FoldRegion region1 = SimpleFoldingModel.addFolding(this.myEditors[0], start1, end1, expanded);
            FoldRegion region2 = SimpleFoldingModel.addFolding(this.myEditors[1], start2, end2, expanded);
            if (region1 == null && region2 == null) {
                return;
            }
            this.myFoldings.add(new FoldingModelBase.FoldedBlock(new FoldRegion[]{region1, region2}));
        }

        public void paintOnDivider(@NotNull Graphics2D gg, @NotNull Component divider) {
            if (gg == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gg", "com/intellij/diff/tools/util/FoldingModelSupport$SimpleFoldingModel", "paintOnDivider"));
            }
            if (divider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "divider", "com/intellij/diff/tools/util/FoldingModelSupport$SimpleFoldingModel", "paintOnDivider"));
            }
            this.myPaintable.paintOnDivider(gg, divider);
        }

        private class MyExpandSuggester
        extends FoldingModelBase.ExpandSuggesterBase {
            public MyExpandSuggester(FoldingModelBase.FoldingCache cache, boolean defaultValue) {
                super(cache, defaultValue);
            }

            public boolean getExpanded(int start1, int end1, int start2, int end2) {
                Boolean expanded1 = this.getCachedExpanded(start1, end1, 0);
                Boolean expanded2 = this.getCachedExpanded(start2, end2, 1);
                return this.selectState(expanded1, expanded2);
            }
        }
    }

    public static class OnesideFoldingModel
    extends FoldingModelBase {
        public OnesideFoldingModel(@NotNull EditorEx editor, @NotNull Disposable disposable) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/util/FoldingModelSupport$OnesideFoldingModel", "<init>"));
            }
            if (disposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/diff/tools/util/FoldingModelSupport$OnesideFoldingModel", "<init>"));
            }
            super(new EditorEx[]{editor}, disposable);
        }

        public void install(final @Nullable List<DiffIterableUtil.IntPair> changedLines, @NotNull UserDataHolder context, boolean defaultExpanded, final int range) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/FoldingModelSupport$OnesideFoldingModel", "install"));
            }
            if (changedLines == null) {
                return;
            }
            if (range == -1) {
                return;
            }
            final MyExpandSuggester suggester = new MyExpandSuggester((FoldingModelBase.FoldingCache)context.getUserData(CACHE_KEY), defaultExpanded);
            this.invokeBatchOperation(new Runnable(){

                @Override
                public void run() {
                    int last = Integer.MIN_VALUE;
                    for (DiffIterableUtil.IntPair line : changedLines) {
                        OnesideFoldingModel.this.addRange(last, line.val1, range, suggester);
                        last = line.val2;
                    }
                    OnesideFoldingModel.this.addRange(last, Integer.MAX_VALUE, range, suggester);
                }
            });
            this.updateLineNumbers();
        }

        private void addRange(int start1, int end1, int range, @NotNull MyExpandSuggester suggester) {
            boolean expanded;
            if (suggester == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggester", "com/intellij/diff/tools/util/FoldingModelSupport$OnesideFoldingModel", "addRange"));
            }
            int count1 = this.myEditors[0].getDocument().getLineCount();
            FoldRegion region1 = OnesideFoldingModel.addFolding(this.myEditors[0], start1 = FoldingModelSupport.bound(start1 + range, 0, count1), end1 = FoldingModelSupport.bound(end1 - range, 0, count1), expanded = suggester.getExpanded(start1, end1));
            if (region1 == null) {
                return;
            }
            this.myFoldings.add(new FoldingModelBase.FoldedBlock(new FoldRegion[]{region1}));
        }

        @NotNull
        public TIntFunction getLineNumberConvertor() {
            TIntFunction tIntFunction = this.getLineConvertor(0);
            if (tIntFunction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/FoldingModelSupport$OnesideFoldingModel", "getLineNumberConvertor"));
            }
            return tIntFunction;
        }

        private class MyExpandSuggester
        extends FoldingModelBase.ExpandSuggesterBase {
            public MyExpandSuggester(FoldingModelBase.FoldingCache cache, boolean defaultValue) {
                super(cache, defaultValue);
            }

            public boolean getExpanded(int start1, int end1) {
                Boolean expanded1 = this.getCachedExpanded(start1, end1, 0);
                return this.selectState(expanded1);
            }
        }
    }
}

