/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import org.jetbrains.annotations.NotNull;

public enum HighlightPolicy {
    DO_NOT_HIGHLIGHT("Do Not Highlight"),
    BY_LINE("By Line"),
    BY_WORD("By Word"),
    BY_WORD_SPLIT("By Word In Chunks");

    @NotNull
    private final String myText;

    private HighlightPolicy(String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/tools/util/base/HighlightPolicy", "<init>"));
        }
        this.myText = text;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/HighlightPolicy", "getText"));
        }
        return string;
    }

    public boolean isShouldCompare() {
        return this != DO_NOT_HIGHLIGHT;
    }

    public boolean isFineFragments() {
        return this == BY_WORD || this == BY_WORD_SPLIT;
    }

    public boolean isShouldSquash() {
        return this == BY_WORD || this == BY_LINE;
    }
}

