/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.comparison.ComparisonPolicy;
import org.jetbrains.annotations.NotNull;

public enum IgnorePolicy {
    DEFAULT("Do Not Ignore"),
    TRIM_WHITESPACES("Trim Whitespaces"),
    IGNORE_WHITESPACES("Ignore Whitespaces"),
    IGNORE_WHITESPACES_CHUNKS("Ignore Whitespaces And Empty Lines");

    @NotNull
    private final String myText;

    private IgnorePolicy(String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/tools/util/base/IgnorePolicy", "<init>"));
        }
        this.myText = text;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/IgnorePolicy", "getText"));
        }
        return string;
    }

    @NotNull
    public ComparisonPolicy getComparisonPolicy() {
        switch (this) {
            case DEFAULT: {
                ComparisonPolicy comparisonPolicy = ComparisonPolicy.DEFAULT;
                if (comparisonPolicy == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/IgnorePolicy", "getComparisonPolicy"));
                }
                return comparisonPolicy;
            }
            case TRIM_WHITESPACES: {
                ComparisonPolicy comparisonPolicy = ComparisonPolicy.TRIM_WHITESPACES;
                if (comparisonPolicy == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/IgnorePolicy", "getComparisonPolicy"));
                }
                return comparisonPolicy;
            }
            case IGNORE_WHITESPACES: {
                ComparisonPolicy comparisonPolicy = ComparisonPolicy.IGNORE_WHITESPACES;
                if (comparisonPolicy == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/IgnorePolicy", "getComparisonPolicy"));
                }
                return comparisonPolicy;
            }
            case IGNORE_WHITESPACES_CHUNKS: {
                ComparisonPolicy comparisonPolicy = ComparisonPolicy.IGNORE_WHITESPACES;
                if (comparisonPolicy == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/IgnorePolicy", "getComparisonPolicy"));
                }
                return comparisonPolicy;
            }
        }
        throw new IllegalArgumentException(this.name());
    }

    public boolean isShouldTrimChunks() {
        return this == IGNORE_WHITESPACES_CHUNKS;
    }
}

