/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.twoside;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.impl.FocusOppositePaneAction;
import com.intellij.diff.actions.impl.OpenInEditorWithMouseAction;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.base.TextDiffViewerBase;
import com.intellij.diff.tools.util.twoside.TwosideTextContentPanel;
import com.intellij.diff.tools.util.twoside.TwosideTextDiffPanel;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffNavigationContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TwosideTextDiffViewer
extends TextDiffViewerBase {
    public static final Logger LOG = Logger.getInstance(TwosideTextDiffViewer.class);
    @NotNull
    private final EditorFactory myEditorFactory;
    @NotNull
    protected final TwosideTextDiffPanel myPanel;
    @NotNull
    protected final TwosideTextContentPanel myContentPanel;
    @Nullable
    protected final EditorEx myEditor1;
    @Nullable
    protected final EditorEx myEditor2;
    @Nullable
    protected final DocumentContent myActualContent1;
    @Nullable
    protected final DocumentContent myActualContent2;
    @NotNull
    protected final TextDiffViewerBase.MySetEditorSettingsAction myEditorSettingsAction;
    @NotNull
    private final MyEditorFocusListener myEditorFocusListener1;
    @NotNull
    private final MyEditorFocusListener myEditorFocusListener2;
    @NotNull
    private final MyVisibleAreaListener myVisibleAreaListener;
    @NotNull
    private final MyScrollToLineHelper myScrollToLineHelper;
    @Nullable
    private SyncScrollSupport.TwosideSyncScrollSupport mySyncScrollListener;
    @NotNull
    private Side myCurrentSide;

    public TwosideTextDiffViewer(@NotNull DiffContext context, @NotNull ContentDiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "<init>"));
        }
        super(context, request);
        this.myEditorFactory = EditorFactory.getInstance();
        this.myEditorFocusListener1 = new MyEditorFocusListener(Side.LEFT);
        this.myEditorFocusListener2 = new MyEditorFocusListener(Side.RIGHT);
        this.myVisibleAreaListener = new MyVisibleAreaListener();
        this.myScrollToLineHelper = new MyScrollToLineHelper();
        DiffContent[] contents = this.myRequest.getContents();
        this.myActualContent1 = contents[0] instanceof DocumentContent ? (DocumentContent)contents[0] : null;
        DocumentContent documentContent = this.myActualContent2 = contents[1] instanceof DocumentContent ? (DocumentContent)contents[1] : null;
        assert (this.myActualContent1 != null || this.myActualContent2 != null);
        List<EditorEx> editors = this.createEditors();
        List<JComponent> titlePanel = DiffUtil.createTextTitles(this.myRequest, editors);
        this.myEditor1 = editors.get(0);
        this.myEditor2 = editors.get(1);
        assert (this.myEditor1 != null || this.myEditor2 != null);
        this.myCurrentSide = this.myEditor1 == null ? Side.RIGHT : Side.LEFT;
        this.myContentPanel = new TwosideTextContentPanel(titlePanel, this.myEditor1, this.myEditor2);
        this.myPanel = new TwosideTextDiffPanel(this, this.myContentPanel, this, context);
        new MyFocusOppositePaneAction().setupAction(this.myPanel, (Disposable)this);
        this.myEditorSettingsAction = new TextDiffViewerBase.MySetEditorSettingsAction();
        this.myEditorSettingsAction.applyDefaults();
        new MyOpenInEditorWithMouseAction().register(this.getEditors());
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.processContextHints();
    }

    @Override
    protected void onDispose() {
        this.updateContextHints();
        super.onDispose();
    }

    @Override
    protected void onDisposeAwt() {
        this.destroyEditors();
        super.onDisposeAwt();
    }

    protected void processContextHints() {
        if (this.myEditor1 == null) {
            this.myCurrentSide = Side.RIGHT;
        } else if (this.myEditor2 == null) {
            this.myCurrentSide = Side.LEFT;
        } else {
            Side side = (Side)this.myContext.getUserData(DiffUserDataKeys.PREFERRED_FOCUS_SIDE);
            if (side != null) {
                this.myCurrentSide = side;
            }
        }
        this.myScrollToLineHelper.processContext();
    }

    protected void updateContextHints() {
        if (this.myEditor1 != null && this.myEditor2 != null) {
            this.myContext.putUserData(DiffUserDataKeys.PREFERRED_FOCUS_SIDE, (Object)this.myCurrentSide);
        }
        this.myScrollToLineHelper.updateContext();
    }

    @NotNull
    protected List<EditorEx> createEditors() {
        boolean[] forceReadOnly = this.checkForceReadOnly();
        EditorEx editor1 = null;
        EditorEx editor2 = null;
        if (this.myActualContent1 != null) {
            editor1 = DiffUtil.createEditor(this.myActualContent1.getDocument(), this.myProject, forceReadOnly[0], true);
            DiffUtil.configureEditor(editor1, this.myActualContent1, this.myProject);
        }
        if (this.myActualContent2 != null) {
            editor2 = DiffUtil.createEditor(this.myActualContent2.getDocument(), this.myProject, forceReadOnly[1], true);
            DiffUtil.configureEditor(editor2, this.myActualContent2, this.myProject);
        }
        if (editor1 != null && editor2 != null) {
            editor1.setVerticalScrollbarOrientation(0);
        }
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new EditorEx[]{editor1, editor2});
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "createEditors"));
        }
        return arrayList;
    }

    @Override
    protected void onDocumentChange(@NotNull DocumentEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "onDocumentChange"));
        }
        super.onDocumentChange(event);
        this.myContentPanel.repaintDivider();
    }

    protected void scrollOnRediff() {
        this.myScrollToLineHelper.onRediff();
    }

    @Override
    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myScrollToLineHelper.onSlowRediff();
    }

    private void destroyEditors() {
        if (this.myEditor1 != null) {
            this.myEditorFactory.releaseEditor((Editor)this.myEditor1);
        }
        if (this.myEditor2 != null) {
            this.myEditorFactory.releaseEditor((Editor)this.myEditor2);
        }
    }

    @Override
    protected void installEditorListeners() {
        SyncScrollSupport.SyncScrollable scrollable;
        super.installEditorListeners();
        if (this.myEditor1 != null) {
            this.myEditor1.getContentComponent().addFocusListener(this.myEditorFocusListener1);
            this.myEditor1.getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener);
        }
        if (this.myEditor2 != null) {
            this.myEditor2.getContentComponent().addFocusListener(this.myEditorFocusListener2);
            this.myEditor2.getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener);
        }
        if (this.myEditor1 != null && this.myEditor2 != null && (scrollable = this.getSyncScrollable()) != null) {
            this.mySyncScrollListener = new SyncScrollSupport.TwosideSyncScrollSupport(this.myEditor1, this.myEditor2, scrollable);
        }
    }

    @Override
    protected void destroyEditorListeners() {
        super.destroyEditorListeners();
        if (this.myEditor1 != null) {
            this.myEditor1.getContentComponent().removeFocusListener(this.myEditorFocusListener1);
            this.myEditor1.getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener);
        }
        if (this.myEditor2 != null) {
            this.myEditor2.getContentComponent().removeFocusListener(this.myEditorFocusListener2);
            this.myEditor2.getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener);
        }
        if (this.myEditor1 != null && this.myEditor2 != null && this.mySyncScrollListener != null) {
            this.mySyncScrollListener = null;
        }
    }

    protected void disableSyncScrollSupport(boolean disable) {
        if (this.mySyncScrollListener != null) {
            this.mySyncScrollListener.myDuringSyncScroll = disable;
        }
    }

    @Override
    @NotNull
    protected List<? extends EditorEx> getEditors() {
        if (this.myEditor1 != null && this.myEditor2 != null) {
            List list = ContainerUtil.list((Object[])new EditorEx[]{this.myEditor1, this.myEditor2});
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "getEditors"));
            }
            return list;
        }
        if (this.myEditor1 != null) {
            List<EditorEx> list = Collections.singletonList(this.myEditor1);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "getEditors"));
            }
            return list;
        }
        if (this.myEditor2 != null) {
            List<EditorEx> list = Collections.singletonList(this.myEditor2);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "getEditors"));
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "getEditors"));
        }
        return list;
    }

    @NotNull
    public JComponent getComponent() {
        TwosideTextDiffPanel twosideTextDiffPanel = this.myPanel;
        if (twosideTextDiffPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "getComponent"));
        }
        return twosideTextDiffPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.getPreferredFocusedComponent();
    }

    @NotNull
    public Side getCurrentSide() {
        Side side = this.myCurrentSide;
        if (side == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "getCurrentSide"));
        }
        return side;
    }

    @NotNull
    public EditorEx getCurrentEditor() {
        EditorEx editorEx = this.getCurrentSide().isLeft() ? this.myEditor1 : this.myEditor2;
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "getCurrentEditor"));
        }
        return editorEx;
    }

    @Nullable
    protected EditorEx getEditor1() {
        return this.myEditor1;
    }

    @Nullable
    protected EditorEx getEditor2() {
        return this.myEditor2;
    }

    protected void scrollToLine(@NotNull Side side, int line) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "scrollToLine"));
        }
        Editor editor = (Editor)side.select((Object)this.myEditor1, (Object)this.myEditor2);
        if (editor == null) {
            return;
        }
        DiffUtil.scrollEditor(editor, line);
        this.myCurrentSide = side;
    }

    protected boolean doScrollToChange(@NotNull DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        if (scrollToChangePolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollToChangePolicy", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "doScrollToChange"));
        }
        return false;
    }

    protected boolean doScrollToContext(@NotNull DiffNavigationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "doScrollToContext"));
        }
        return false;
    }

    @Nullable
    protected abstract SyncScrollSupport.SyncScrollable getSyncScrollable();

    @Override
    protected boolean tryRediffSynchronously() {
        return this.myPanel.isWindowFocused();
    }

    @Override
    @Nullable
    protected OpenFileDescriptor getOpenFileDescriptor() {
        EditorEx editor = this.getCurrentEditor();
        DocumentContent content = (DocumentContent)this.getCurrentSide().select((Object)this.myActualContent1, (Object)this.myActualContent2);
        if (content == null) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        return content.getOpenFileDescriptor(offset);
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "canShowRequest"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "canShowRequest"));
        }
        if (!(request instanceof ContentDiffRequest)) {
            return false;
        }
        DiffContent[] contents = ((ContentDiffRequest)request).getContents();
        if (contents.length != 2) {
            return false;
        }
        if (!TwosideTextDiffViewer.canShowContent(contents[0])) {
            return false;
        }
        if (!TwosideTextDiffViewer.canShowContent(contents[1])) {
            return false;
        }
        return !(contents[0] instanceof EmptyContent) || !(contents[1] instanceof EmptyContent);
    }

    public static boolean canShowContent(@NotNull DiffContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "canShowContent"));
        }
        if (content instanceof EmptyContent) {
            return true;
        }
        return content instanceof DocumentContent;
    }

    @NotNull
    protected Graphics2D getDividerGraphics(@NotNull Graphics g, @NotNull Component divider) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "getDividerGraphics"));
        }
        if (divider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "divider", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "getDividerGraphics"));
        }
        assert (this.myEditor1 != null && this.myEditor2 != null);
        int width = divider.getWidth();
        int editorHeight = this.myEditor1.getComponent().getHeight();
        int dividerOffset = divider.getLocationOnScreen().y;
        int editorOffset = this.myEditor1.getComponent().getLocationOnScreen().y;
        Graphics2D graphics2D = (Graphics2D)g.create(0, editorOffset - dividerOffset, width, editorHeight);
        if (graphics2D == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer", "getDividerGraphics"));
        }
        return graphics2D;
    }

    private static class EditorsPosition {
        public static final Key<EditorsPosition> KEY = Key.create((String)"Diff.EditorsPosition");
        @NotNull
        public final LogicalPosition[] myCaretPosition;
        @NotNull
        public final Point myPoint1;
        @NotNull
        public final Point myPoint2;

        public EditorsPosition(@NotNull LogicalPosition[] caretPosition, @NotNull Point point1, @NotNull Point point2) {
            if (caretPosition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretPosition", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer$EditorsPosition", "<init>"));
            }
            if (point1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point1", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer$EditorsPosition", "<init>"));
            }
            if (point2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point2", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer$EditorsPosition", "<init>"));
            }
            this.myCaretPosition = caretPosition;
            this.myPoint1 = point1;
            this.myPoint2 = point2;
        }

        public boolean isSame(@Nullable LogicalPosition[] caretPosition) {
            if (caretPosition == null) {
                return true;
            }
            if (caretPosition.length != 2) {
                return false;
            }
            if (!caretPosition[0].equals((Object)this.myCaretPosition[0])) {
                return false;
            }
            return caretPosition[1].equals((Object)this.myCaretPosition[1]);
        }
    }

    private class MyScrollToLineHelper {
        protected boolean myShouldScroll = true;
        @Nullable
        private DiffUserDataKeysEx.ScrollToPolicy myScrollToChange;
        @Nullable
        private EditorsPosition myEditorsPosition;
        @Nullable
        private LogicalPosition[] myCaretPosition;
        @Nullable
        private Pair<Side, Integer> myScrollToLine;
        @Nullable
        private DiffNavigationContext myNavigationContext;

        private MyScrollToLineHelper() {
        }

        public void processContext() {
            this.myScrollToChange = (DiffUserDataKeysEx.ScrollToPolicy)((Object)TwosideTextDiffViewer.this.myRequest.getUserData(DiffUserDataKeysEx.SCROLL_TO_CHANGE));
            this.myEditorsPosition = (EditorsPosition)TwosideTextDiffViewer.this.myRequest.getUserData(EditorsPosition.KEY);
            this.myCaretPosition = (LogicalPosition[])TwosideTextDiffViewer.this.myRequest.getUserData(DiffUserDataKeysEx.EDITORS_CARET_POSITION);
            this.myScrollToLine = (Pair)TwosideTextDiffViewer.this.myRequest.getUserData(DiffUserDataKeys.SCROLL_TO_LINE);
            this.myNavigationContext = (DiffNavigationContext)TwosideTextDiffViewer.this.myRequest.getUserData(DiffUserDataKeysEx.NAVIGATION_CONTEXT);
        }

        public void updateContext() {
            LogicalPosition[] carets = new LogicalPosition[]{this.getPosition(TwosideTextDiffViewer.this.myEditor1), this.getPosition(TwosideTextDiffViewer.this.myEditor2)};
            Point point1 = DiffUtil.getScrollingPoint(TwosideTextDiffViewer.this.myEditor1);
            Point point2 = DiffUtil.getScrollingPoint(TwosideTextDiffViewer.this.myEditor2);
            EditorsPosition editorsPosition = new EditorsPosition(carets, point1, point2);
            TwosideTextDiffViewer.this.myRequest.putUserData(DiffUserDataKeysEx.SCROLL_TO_CHANGE, null);
            TwosideTextDiffViewer.this.myRequest.putUserData(EditorsPosition.KEY, (Object)editorsPosition);
            TwosideTextDiffViewer.this.myRequest.putUserData(DiffUserDataKeysEx.EDITORS_CARET_POSITION, (Object)carets);
            TwosideTextDiffViewer.this.myRequest.putUserData(DiffUserDataKeys.SCROLL_TO_LINE, null);
            TwosideTextDiffViewer.this.myRequest.putUserData(DiffUserDataKeysEx.NAVIGATION_CONTEXT, null);
        }

        public void onSlowRediff() {
            if (this.myScrollToChange != null) {
                return;
            }
            if (this.myNavigationContext != null) {
                return;
            }
            if (this.myShouldScroll && this.myScrollToLine != null) {
                boolean bl = this.myShouldScroll = !this.doScrollToLine();
            }
            if (this.myShouldScroll && this.myCaretPosition != null) {
                this.myShouldScroll = !this.doScrollToPosition();
            }
        }

        public void onRediff() {
            if (this.myShouldScroll && this.myScrollToChange != null) {
                boolean bl = this.myShouldScroll = !TwosideTextDiffViewer.this.doScrollToChange(this.myScrollToChange);
            }
            if (this.myShouldScroll && this.myScrollToLine != null) {
                boolean bl = this.myShouldScroll = !this.doScrollToLine();
            }
            if (this.myShouldScroll && this.myNavigationContext != null) {
                boolean bl = this.myShouldScroll = !TwosideTextDiffViewer.this.doScrollToContext(this.myNavigationContext);
            }
            if (this.myShouldScroll && this.myCaretPosition != null) {
                boolean bl = this.myShouldScroll = !this.doScrollToPosition();
            }
            if (this.myShouldScroll) {
                TwosideTextDiffViewer.this.doScrollToChange(DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE);
            }
            this.myShouldScroll = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean doScrollToPosition() {
            if (this.myCaretPosition == null || this.myCaretPosition.length != 2) {
                return false;
            }
            if (TwosideTextDiffViewer.this.myEditor1 != null) {
                TwosideTextDiffViewer.this.myEditor1.getCaretModel().moveToLogicalPosition(this.myCaretPosition[0]);
            }
            if (TwosideTextDiffViewer.this.myEditor2 != null) {
                TwosideTextDiffViewer.this.myEditor2.getCaretModel().moveToLogicalPosition(this.myCaretPosition[1]);
            }
            if (this.myEditorsPosition != null && this.myEditorsPosition.isSame(this.myCaretPosition)) {
                try {
                    TwosideTextDiffViewer.this.disableSyncScrollSupport(true);
                    DiffUtil.scrollToPoint(TwosideTextDiffViewer.this.myEditor1, this.myEditorsPosition.myPoint1);
                    DiffUtil.scrollToPoint(TwosideTextDiffViewer.this.myEditor2, this.myEditorsPosition.myPoint2);
                }
                finally {
                    TwosideTextDiffViewer.this.disableSyncScrollSupport(false);
                }
            } else {
                TwosideTextDiffViewer.this.getCurrentEditor().getScrollingModel().scrollToCaret(ScrollType.CENTER);
            }
            return true;
        }

        private boolean doScrollToLine() {
            if (this.myScrollToLine == null) {
                return false;
            }
            Side side = (Side)this.myScrollToLine.first;
            Integer line = (Integer)this.myScrollToLine.second;
            if (side.select(TwosideTextDiffViewer.this.getEditors()) == null) {
                return false;
            }
            TwosideTextDiffViewer.this.myCurrentSide = side;
            DiffUtil.scrollEditor((Editor)TwosideTextDiffViewer.this.getCurrentEditor(), line);
            return true;
        }

        @NotNull
        private LogicalPosition getPosition(@Nullable Editor editor) {
            LogicalPosition logicalPosition = editor != null ? editor.getCaretModel().getLogicalPosition() : new LogicalPosition(0, 0);
            if (logicalPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer$MyScrollToLineHelper", "getPosition"));
            }
            return logicalPosition;
        }
    }

    private class MyVisibleAreaListener
    implements VisibleAreaListener {
        private MyVisibleAreaListener() {
        }

        public void visibleAreaChanged(VisibleAreaEvent e) {
            if (TwosideTextDiffViewer.this.mySyncScrollListener != null) {
                TwosideTextDiffViewer.this.mySyncScrollListener.visibleAreaChanged(e);
            }
            if (Registry.is((String)"diff.divider.repainting.fix")) {
                TwosideTextDiffViewer.this.myContentPanel.repaint();
            } else {
                TwosideTextDiffViewer.this.myContentPanel.repaintDivider();
            }
        }
    }

    private class MyEditorFocusListener
    extends FocusAdapter {
        @NotNull
        private final Side mySide;

        private MyEditorFocusListener(Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer$MyEditorFocusListener", "<init>"));
            }
            this.mySide = side;
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (TwosideTextDiffViewer.this.myEditor1 == null || TwosideTextDiffViewer.this.myEditor2 == null) {
                return;
            }
            TwosideTextDiffViewer.this.myCurrentSide = this.mySide;
        }
    }

    private class MyOpenInEditorWithMouseAction
    extends OpenInEditorWithMouseAction {
        private MyOpenInEditorWithMouseAction() {
        }

        @Override
        protected OpenFileDescriptor getDescriptor(@NotNull Editor editor, int line) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer$MyOpenInEditorWithMouseAction", "getDescriptor"));
            }
            if (editor != TwosideTextDiffViewer.this.myEditor1 && editor != TwosideTextDiffViewer.this.myEditor2) {
                return null;
            }
            Side side = Side.fromLeft((editor == TwosideTextDiffViewer.this.myEditor1 ? 1 : 0) != 0);
            DocumentContent content = (DocumentContent)side.select((Object)TwosideTextDiffViewer.this.myActualContent1, (Object)TwosideTextDiffViewer.this.myActualContent2);
            if (content == null) {
                return null;
            }
            int offset = editor.logicalPositionToOffset(new LogicalPosition(line, 0));
            return content.getOpenFileDescriptor(offset);
        }
    }

    private class MyFocusOppositePaneAction
    extends FocusOppositePaneAction {
        private MyFocusOppositePaneAction() {
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/util/twoside/TwosideTextDiffViewer$MyFocusOppositePaneAction", "actionPerformed"));
            }
            if (TwosideTextDiffViewer.this.myEditor1 == null || TwosideTextDiffViewer.this.myEditor2 == null) {
                return;
            }
            TwosideTextDiffViewer.this.myCurrentSide = TwosideTextDiffViewer.this.myCurrentSide.other();
            TwosideTextDiffViewer.this.myPanel.requestFocus();
            TwosideTextDiffViewer.this.getCurrentEditor().getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
    }
}

