/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.push.PushTarget;
import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.RepositoryNodeListener;
import com.intellij.dvcs.push.ui.LoadingIcon;
import com.intellij.dvcs.push.ui.RepositoryNode;
import com.intellij.dvcs.push.ui.SingleRepositoryNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class RepositoryWithBranchPanel<T extends PushTarget>
extends NonOpaquePanel {
    private final JBCheckBox myRepositoryCheckbox;
    private final PushTargetPanel<T> myDestPushTargetPanelComponent;
    private final JBLabel myLocalBranch;
    private final JLabel myArrowLabel;
    private final JLabel myRepositoryLabel;
    private final ColoredTreeCellRenderer myTextRenderer;
    @NotNull
    private final List<RepositoryNodeListener<T>> myListeners;
    private final int myCheckBoxLoadingIconGapH;
    private final int myCheckBoxLoadingIconGapV;
    private final LoadingIcon myLoadingIcon;
    private final int myCheckBoxWidth;
    private final int myCheckBoxHeight;

    public RepositoryWithBranchPanel(final @NotNull Project project, @NotNull String repoName, @NotNull String sourceName, @NotNull PushTargetPanel<T> destPushTargetPanelComponent) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/push/ui/RepositoryWithBranchPanel", "<init>"));
        }
        if (repoName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repoName", "com/intellij/dvcs/push/ui/RepositoryWithBranchPanel", "<init>"));
        }
        if (sourceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceName", "com/intellij/dvcs/push/ui/RepositoryWithBranchPanel", "<init>"));
        }
        if (destPushTargetPanelComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destPushTargetPanelComponent", "com/intellij/dvcs/push/ui/RepositoryWithBranchPanel", "<init>"));
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.setLayout(new BorderLayout());
        this.myRepositoryCheckbox = new JBCheckBox();
        this.myRepositoryCheckbox.setFocusable(false);
        this.myRepositoryCheckbox.setOpaque(false);
        this.myRepositoryCheckbox.setBorder(null);
        this.myRepositoryCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/dvcs/push/ui/RepositoryWithBranchPanel$1", "actionPerformed"));
                }
                RepositoryWithBranchPanel.this.fireOnSelectionChange(RepositoryWithBranchPanel.this.myRepositoryCheckbox.isSelected());
            }
        });
        this.myRepositoryLabel = new JLabel(repoName);
        this.myLocalBranch = new JBLabel(sourceName);
        this.myArrowLabel = new JLabel(" " + UIUtil.rightArrow() + " ");
        this.myDestPushTargetPanelComponent = destPushTargetPanelComponent;
        this.myTextRenderer = new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/dvcs/push/ui/RepositoryWithBranchPanel$2", "customizeCellRenderer"));
                }
            }
        };
        this.myTextRenderer.setOpaque(false);
        this.layoutComponents();
        this.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                ValidationInfo error = RepositoryWithBranchPanel.this.myDestPushTargetPanelComponent.verify();
                if (error != null) {
                    PopupUtil.showBalloonForComponent((Component)error.component, (String)error.message, (MessageType)MessageType.WARNING, (boolean)false, (Disposable)project);
                }
                return error == null;
            }
        });
        JCheckBox emptyBorderCheckBox = new JCheckBox();
        emptyBorderCheckBox.setBorder(null);
        Dimension size = emptyBorderCheckBox.getPreferredSize();
        this.myCheckBoxWidth = size.width;
        this.myCheckBoxHeight = size.height;
        this.myLoadingIcon = LoadingIcon.create(this.myCheckBoxWidth, size.height);
        this.myCheckBoxLoadingIconGapH = this.myCheckBoxWidth - this.myLoadingIcon.getIconWidth();
        this.myCheckBoxLoadingIconGapV = size.height - this.myLoadingIcon.getIconHeight();
    }

    private void layoutComponents() {
        this.add((Component)this.myRepositoryCheckbox, "West");
        NonOpaquePanel panel = new NonOpaquePanel((LayoutManager)new BorderLayout());
        panel.add((Component)this.myTextRenderer, "West");
        panel.add((Component)this.myDestPushTargetPanelComponent, "Center");
        this.add((Component)panel, "Center");
    }

    @NotNull
    public String getRepositoryName() {
        String string = this.myRepositoryLabel.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/RepositoryWithBranchPanel", "getRepositoryName"));
        }
        return string;
    }

    public String getSourceName() {
        return this.myLocalBranch.getText();
    }

    public String getArrow() {
        return this.myArrowLabel.getText();
    }

    @NotNull
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Rectangle bounds = tree.getPathBounds(tree.getPathForRow(row));
        this.invalidate();
        this.myTextRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (!(value instanceof SingleRepositoryNode)) {
            RepositoryNode node = (RepositoryNode)value;
            this.myRepositoryCheckbox.setSelected(node.isChecked());
            this.myRepositoryCheckbox.setVisible(true);
            if (this.myCheckBoxLoadingIconGapH < 0) {
                this.myTextRenderer.append("");
                this.myTextRenderer.appendTextPadding(this.calculateRendererShiftH((SimpleColoredComponent)this.myTextRenderer));
            }
            this.myTextRenderer.append(this.getRepositoryName(), SimpleTextAttributes.GRAY_ATTRIBUTES);
            this.myTextRenderer.appendTextPadding(120);
        } else {
            this.myRepositoryCheckbox.setVisible(false);
            this.myTextRenderer.append(" ");
        }
        this.myTextRenderer.append(this.getSourceName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.myTextRenderer.append(this.getArrow(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (bounds != null) {
            this.setPreferredSize(new Dimension(tree.getVisibleRect().width - bounds.x, bounds.height));
        }
        if (this.myTextRenderer.getTree().hasFocus()) {
            this.myDestPushTargetPanelComponent.requestFocus(true);
        }
        this.revalidate();
        RepositoryWithBranchPanel repositoryWithBranchPanel = this;
        if (repositoryWithBranchPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/RepositoryWithBranchPanel", "getTreeCellEditorComponent"));
        }
        return repositoryWithBranchPanel;
    }

    public void addRepoNodeListener(@NotNull RepositoryNodeListener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/dvcs/push/ui/RepositoryWithBranchPanel", "addRepoNodeListener"));
        }
        this.myListeners.add(listener);
    }

    public void fireOnChange() {
        this.myDestPushTargetPanelComponent.fireOnChange();
        for (RepositoryNodeListener<PushTarget> repositoryNodeListener : this.myListeners) {
            repositoryNodeListener.onTargetChanged(this.myDestPushTargetPanelComponent.getValue());
        }
    }

    public void fireOnSelectionChange(boolean isSelected) {
        for (RepositoryNodeListener<T> listener : this.myListeners) {
            listener.onSelectionChanged(isSelected);
        }
    }

    public void fireOnCancel() {
        this.myDestPushTargetPanelComponent.fireOnCancel();
    }

    public PushTargetPanel getTargetPanel() {
        return this.myDestPushTargetPanelComponent;
    }

    public LoadingIcon getLoadingIcon() {
        return this.myLoadingIcon;
    }

    public int getCheckBoxWidth() {
        return this.myCheckBoxWidth;
    }

    public int getLoadingIconAndCheckBoxGapH() {
        return this.myCheckBoxLoadingIconGapH;
    }

    public int calculateRendererShiftH(@NotNull SimpleColoredComponent coloredRenderer) {
        if (coloredRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coloredRenderer", "com/intellij/dvcs/push/ui/RepositoryWithBranchPanel", "calculateRendererShiftH"));
        }
        int borderOffset = this.getHBorderOffset(coloredRenderer);
        return -this.myCheckBoxLoadingIconGapH + coloredRenderer.getIconTextGap() + coloredRenderer.getIpad().left + borderOffset;
    }

    public int getHBorderOffset(@NotNull SimpleColoredComponent coloredRenderer) {
        if (coloredRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coloredRenderer", "com/intellij/dvcs/push/ui/RepositoryWithBranchPanel", "getHBorderOffset"));
        }
        Border border = coloredRenderer.getMyBorder();
        return border != null ? border.getBorderInsets((Component)coloredRenderer).left : 0;
    }

    public int getLoadingIconAndCheckBoxGapV() {
        return this.myCheckBoxLoadingIconGapV;
    }

    public int getCheckBoxHeight() {
        return this.myCheckBoxHeight;
    }
}

