/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configuration;

import com.google.common.collect.ImmutableMap;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.EnvVariablesTable;
import com.intellij.execution.util.EnvironmentVariable;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnvironmentVariablesTextFieldWithBrowseButton
extends TextFieldWithBrowseButton
implements UserActivityProviderComponent {
    private Map<String, String> myEnvs = Collections.emptyMap();
    private boolean myPassParentEnvs;
    private final List<ChangeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public EnvironmentVariablesTextFieldWithBrowseButton() {
        this.setEditable(false);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new MyEnvironmentVariablesDialog().show();
            }
        });
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map = Collections.unmodifiableMap(this.myEnvs);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton", "getEnvs"));
        }
        return map;
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envs", "com/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton", "setEnvs"));
        }
        this.myEnvs = ImmutableMap.copyOf(envs);
        String envsStr = EnvironmentVariablesTextFieldWithBrowseButton.stringifyEnvs(this.myEnvs);
        this.setText(envsStr);
    }

    @NotNull
    private static String stringifyEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envs", "com/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton", "stringifyEnvs"));
        }
        if (envs.isEmpty()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton", "stringifyEnvs"));
            }
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, String> entry : envs.entrySet()) {
            if (buf.length() > 0) {
                buf.append(";");
            }
            buf.append(entry.getKey()).append("=").append(entry.getValue());
        }
        String string = buf.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton", "stringifyEnvs"));
        }
        return string;
    }

    public boolean isPassParentEnvs() {
        return this.myPassParentEnvs;
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        if (this.myPassParentEnvs != passParentEnvs) {
            this.myPassParentEnvs = passParentEnvs;
            this.fireStateChanged();
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.myListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.myListeners.remove(changeListener);
    }

    private void fireStateChanged() {
        for (ChangeListener listener : this.myListeners) {
            listener.stateChanged(new ChangeEvent((Object)this));
        }
    }

    public static void showParentEnvironmentDialog(@NotNull Component parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton", "showParentEnvironmentDialog"));
        }
        EnvVariablesTable table = new EnvVariablesTable();
        table.setValues(EnvironmentVariablesTextFieldWithBrowseButton.convertToVariables(new TreeMap<String, String>(new GeneralCommandLine().getParentEnvironment()), true));
        table.getActionsPanel().setVisible(false);
        DialogBuilder builder = new DialogBuilder(parent);
        builder.setTitle(ExecutionBundle.message((String)"environment.variables.system.dialog.title", (Object[])new Object[0]));
        builder.centerPanel(table.getComponent());
        builder.addCloseButton();
        builder.show();
    }

    private static List<EnvironmentVariable> convertToVariables(Map<String, String> map, final boolean readOnly) {
        return ContainerUtil.map(map.entrySet(), (Function)new Function<Map.Entry<String, String>, EnvironmentVariable>(){

            public EnvironmentVariable fun(Map.Entry<String, String> entry) {
                return new EnvironmentVariable(entry.getKey(), entry.getValue(), readOnly){

                    public boolean getNameIsWriteable() {
                        return !readOnly;
                    }
                };
            }
        });
    }

    private class MyEnvironmentVariablesDialog
    extends DialogWrapper {
        private final EnvVariablesTable myEnvVariablesTable;
        private final JCheckBox myUseDefaultCb;
        private final JPanel myWholePanel;

        protected MyEnvironmentVariablesDialog() {
            super((Component)((Object)EnvironmentVariablesTextFieldWithBrowseButton.this), true);
            this.myUseDefaultCb = new JCheckBox(ExecutionBundle.message((String)"env.vars.checkbox.title", (Object[])new Object[0]));
            this.myWholePanel = new JPanel(new BorderLayout());
            this.myEnvVariablesTable = new EnvVariablesTable();
            this.myEnvVariablesTable.setValues(EnvironmentVariablesTextFieldWithBrowseButton.convertToVariables(EnvironmentVariablesTextFieldWithBrowseButton.this.myEnvs, false));
            this.myUseDefaultCb.setSelected(EnvironmentVariablesTextFieldWithBrowseButton.this.isPassParentEnvs());
            this.myWholePanel.add((Component)this.myEnvVariablesTable.getComponent(), "Center");
            JPanel useDefaultPanel = new JPanel(new BorderLayout());
            useDefaultPanel.add((Component)this.myUseDefaultCb, "Center");
            HyperlinkLabel showLink = new HyperlinkLabel(ExecutionBundle.message((String)"env.vars.show.system", (Object[])new Object[0]));
            useDefaultPanel.add((Component)showLink, "East");
            showLink.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        EnvironmentVariablesTextFieldWithBrowseButton.showParentEnvironmentDialog(MyEnvironmentVariablesDialog.this.getWindow());
                    }
                }
            });
            this.myWholePanel.add((Component)useDefaultPanel, "South");
            this.setTitle(ExecutionBundle.message((String)"environment.variables.dialog.title", (Object[])new Object[0]));
            this.init();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myWholePanel;
        }

        protected void doOKAction() {
            this.myEnvVariablesTable.stopEditing();
            LinkedHashMap<String, String> envs = new LinkedHashMap<String, String>();
            for (EnvironmentVariable variable : this.myEnvVariablesTable.getEnvironmentVariables()) {
                envs.put(variable.getName(), variable.getValue());
            }
            EnvironmentVariablesTextFieldWithBrowseButton.this.setEnvs(envs);
            EnvironmentVariablesTextFieldWithBrowseButton.this.setPassParentEnvs(this.myUseDefaultCb.isSelected());
            super.doOKAction();
        }
    }
}

