/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ChooseComponentsToExportDialog;
import com.intellij.ide.actions.ExportSettingsAction;
import com.intellij.ide.actions.ImportSettingsFilenameFilter;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.ZipUtil;
import java.awt.Component;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ImportSettingsAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/ImportSettingsAction", "actionPerformed"));
        }
        DataContext dataContext = e.getDataContext();
        Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
        ChooseComponentsToExportDialog.chooseSettingsFile(PathManager.getConfigPath(), component, IdeBundle.message((String)"title.import.file.location", (Object[])new Object[0]), IdeBundle.message((String)"prompt.choose.import.file.path", (Object[])new Object[0])).doWhenDone((Consumer)new Consumer<String>(){

            public void consume(String path) {
                ImportSettingsAction.doImport(path);
            }
        });
    }

    private static void doImport(String path) {
        File saveFile = new File(path);
        try {
            if (!saveFile.exists()) {
                Messages.showErrorDialog((String)IdeBundle.message((String)"error.cannot.find.file", (Object[])new Object[]{ImportSettingsAction.presentableFileName(saveFile)}), (String)IdeBundle.message((String)"title.file.not.found", (Object[])new Object[0]));
                return;
            }
            ZipEntry magicEntry = new ZipFile(saveFile).getEntry("IntelliJ IDEA Global Settings");
            if (magicEntry == null) {
                Messages.showErrorDialog((String)IdeBundle.message((String)"error.file.contains.no.settings.to.import", (Object[])new Object[]{ImportSettingsAction.presentableFileName(saveFile), ImportSettingsAction.promptLocationMessage()}), (String)IdeBundle.message((String)"title.invalid.file", (Object[])new Object[0]));
                return;
            }
            MultiMap<File, ExportableComponent> fileToComponents = ExportSettingsAction.getExportableComponentsMap(false, true);
            List<ExportableComponent> components = ImportSettingsAction.getComponentsStored(saveFile, fileToComponents.values());
            fileToComponents.values().retainAll(components);
            ChooseComponentsToExportDialog dialog = new ChooseComponentsToExportDialog(fileToComponents, false, IdeBundle.message((String)"title.select.components.to.import", (Object[])new Object[0]), IdeBundle.message((String)"prompt.check.components.to.import", (Object[])new Object[0]));
            if (!dialog.showAndGet()) {
                return;
            }
            Set<ExportableComponent> chosenComponents = dialog.getExportableComponents();
            HashSet<String> relativeNamesToExtract = new HashSet<String>();
            for (ExportableComponent chosenComponent : chosenComponents) {
                File[] exportFiles;
                for (File exportFile : exportFiles = chosenComponent.getExportFiles()) {
                    File configPath = new File(PathManager.getConfigPath());
                    String rPath = FileUtil.getRelativePath((File)configPath, (File)exportFile);
                    assert (rPath != null);
                    String relativePath = FileUtil.toSystemIndependentName((String)rPath);
                    relativeNamesToExtract.add(relativePath);
                }
            }
            relativeNamesToExtract.add("installed.txt");
            File tempFile = new File(PathManager.getPluginTempPath() + "/" + saveFile.getName());
            FileUtil.copy((File)saveFile, (File)tempFile);
            File outDir = new File(PathManager.getConfigPath());
            ImportSettingsFilenameFilter filenameFilter = new ImportSettingsFilenameFilter(relativeNamesToExtract);
            StartupActionScriptManager.UnzipCommand unzip = new StartupActionScriptManager.UnzipCommand(tempFile, outDir, (FilenameFilter)filenameFilter);
            StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)unzip);
            StartupActionScriptManager.DeleteCommand deleteTemp = new StartupActionScriptManager.DeleteCommand(tempFile);
            StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)deleteTemp);
            UpdateSettings.getInstance().forceCheckForUpdateAfterRestart();
            String key = ApplicationManager.getApplication().isRestartCapable() ? "message.settings.imported.successfully.restart" : "message.settings.imported.successfully";
            int ret = Messages.showOkCancelDialog((String)IdeBundle.message((String)key, (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName(), ApplicationNamesInfo.getInstance().getFullProductName()}), (String)IdeBundle.message((String)"title.restart.needed", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            if (ret == 0) {
                ((ApplicationEx)ApplicationManager.getApplication()).restart(true);
            }
        }
        catch (ZipException e1) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.reading.settings.file", (Object[])new Object[]{ImportSettingsAction.presentableFileName(saveFile), e1.getMessage(), ImportSettingsAction.promptLocationMessage()}), (String)IdeBundle.message((String)"title.invalid.file", (Object[])new Object[0]));
        }
        catch (IOException e1) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.reading.settings.file.2", (Object[])new Object[]{ImportSettingsAction.presentableFileName(saveFile), e1.getMessage()}), (String)IdeBundle.message((String)"title.error.reading.file", (Object[])new Object[0]));
        }
    }

    private static String presentableFileName(File file) {
        return "'" + FileUtil.toSystemDependentName((String)file.getPath()) + "'";
    }

    private static String promptLocationMessage() {
        return IdeBundle.message((String)"message.please.ensure.correct.settings", (Object[])new Object[0]);
    }

    @NotNull
    private static List<ExportableComponent> getComponentsStored(@NotNull File zipFile, @NotNull Collection<? extends ExportableComponent> registeredComponents) throws IOException {
        if (zipFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "zipFile", "com/intellij/ide/actions/ImportSettingsAction", "getComponentsStored"));
        }
        if (registeredComponents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registeredComponents", "com/intellij/ide/actions/ImportSettingsAction", "getComponentsStored"));
        }
        File configPath = new File(PathManager.getConfigPath());
        ArrayList<ExportableComponent> components = new ArrayList<ExportableComponent>();
        block0: for (ExportableComponent exportableComponent : registeredComponents) {
            for (File exportFile : exportableComponent.getExportFiles()) {
                String rPath = FileUtilRt.getRelativePath((File)configPath, (File)exportFile);
                assert (rPath != null);
                String relativePath = FileUtilRt.toSystemIndependentName((String)rPath);
                if (exportFile.isDirectory()) {
                    relativePath = relativePath + '/';
                }
                if (!ZipUtil.isZipContainsEntry((File)zipFile, (String)relativePath)) continue;
                components.add(exportableComponent);
                continue block0;
            }
        }
        ArrayList<ExportableComponent> arrayList = components;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ImportSettingsAction", "getComponentsStored"));
        }
        return arrayList;
    }
}

