/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.customize;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.customize.AbstractCustomizeWizardStep;
import com.intellij.ide.customize.CustomizePluginsStepPanel;
import com.intellij.ide.customize.PluginGroups;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.ConcurrencyUtil;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class CustomizeFeaturedPluginsStepPanel
extends AbstractCustomizeWizardStep {
    private static final int COLS = 3;
    private static final ScheduledExecutorService ourService = new ScheduledThreadPoolExecutor(4, ConcurrencyUtil.newNamedThreadFactory((String)"FeaturedPlugins", (boolean)true, (int)5));
    public final AtomicBoolean myCanceled = new AtomicBoolean(false);

    public CustomizeFeaturedPluginsStepPanel(PluginGroups pluginGroups) throws OfflineException {
        this.setLayout(new GridLayout(1, 1));
        JPanel gridPanel = new JPanel(new GridLayout(0, 3));
        JBScrollPane scrollPane = CustomizePluginsStepPanel.createScrollPane(gridPanel);
        Map<String, String> config = pluginGroups.getFeaturedPlugins();
        boolean isEmptyOrOffline = true;
        List<IdeaPluginDescriptor> pluginsFromRepository = pluginGroups.getPluginsFromRepository();
        for (Map.Entry<String, String> entry : config.entrySet()) {
            JPanel groupPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 1;
            gbc.anchor = 17;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            String title = entry.getKey();
            String s = entry.getValue();
            int i = s.indexOf(":");
            String topic = s.substring(0, i);
            int j = s.indexOf(":", i + 1);
            String description = s.substring(i + 1, j);
            String pluginId = s.substring(j + 1);
            IdeaPluginDescriptor foundDescriptor = null;
            for (IdeaPluginDescriptor descriptor : pluginsFromRepository) {
                if (!descriptor.getPluginId().getIdString().equals(pluginId) || PluginManagerCore.isBrokenPlugin(descriptor)) continue;
                foundDescriptor = descriptor;
                isEmptyOrOffline = false;
                break;
            }
            if (foundDescriptor == null) continue;
            final IdeaPluginDescriptor descriptor = foundDescriptor;
            JLabel titleLabel = new JLabel("<html><body><h2 style=\"text-align:left;\">" + title + "</h2></body></html>");
            JLabel topicLabel = new JLabel("<html><body><h4 style=\"text-align:left;\">" + topic + "</h4></body></html>");
            JLabel descriptionLabel = new JLabel("<html><body><i>" + description + "</i></body></html>"){

                @Override
                public Dimension getPreferredSize() {
                    Dimension size = super.getPreferredSize();
                    size.width = Math.min(size.width, 200);
                    return size;
                }
            };
            final CardLayout wrapperLayout = new CardLayout();
            final JPanel buttonWrapper = new JPanel(wrapperLayout);
            final JButton installButton = new JButton("Install");
            final JProgressBar progressBar = new JProgressBar(0, 100);
            progressBar.setStringPainted(true);
            JPanel progressPanel = new JPanel((LayoutManager)new VerticalFlowLayout(true, false));
            progressPanel.add(progressBar);
            LinkLabel cancelLink = new LinkLabel("Cancel", AllIcons.Actions.Cancel);
            JPanel linkWrapper = new JPanel(new FlowLayout(1, 0, 0));
            linkWrapper.add((Component)cancelLink);
            progressPanel.add(linkWrapper);
            JPanel buttonPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0));
            buttonPanel.add(installButton);
            buttonWrapper.add((Component)buttonPanel, "button");
            buttonWrapper.add((Component)progressPanel, "progress");
            wrapperLayout.show(buttonWrapper, "button");
            final AbstractProgressIndicatorExBase indicator = new AbstractProgressIndicatorExBase(true){

                @Override
                public void start() {
                    CustomizeFeaturedPluginsStepPanel.this.myCanceled.set(false);
                    super.start();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            wrapperLayout.show(buttonWrapper, "progress");
                        }
                    });
                }

                @Override
                public void processFinish() {
                    super.processFinish();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            wrapperLayout.show(buttonWrapper, "button");
                            installButton.setEnabled(false);
                            installButton.setText("Installed");
                        }
                    });
                }

                @Override
                public void setFraction(final double fraction) {
                    super.setFraction(fraction);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int value = (int)(100.0 * fraction + 0.5);
                            progressBar.setValue(value);
                            progressBar.setString(value + "%");
                        }
                    });
                }

                @Override
                public void cancel() {
                    this.stop();
                    CustomizeFeaturedPluginsStepPanel.this.myCanceled.set(true);
                    super.cancel();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            wrapperLayout.show(buttonWrapper, "button");
                            progressBar.setValue(0);
                        }
                    });
                }
            };
            installButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    wrapperLayout.show(buttonWrapper, "progress");
                    ourService.schedule(new Runnable(){

                        @Override
                        public void run() {
                            block2: {
                                try {
                                    indicator.start();
                                    PluginDownloader downloader = PluginDownloader.createDownloader(descriptor);
                                    downloader.prepareToInstall(indicator);
                                    downloader.install();
                                    indicator.processFinish();
                                }
                                catch (Exception ignored) {
                                    if (CustomizeFeaturedPluginsStepPanel.this.myCanceled.get()) break block2;
                                    this.onFail();
                                }
                            }
                        }

                        void onFail() {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    indicator.stop();
                                    wrapperLayout.show(buttonWrapper, "progress");
                                    progressBar.setString("Cannot download plugin");
                                }
                            });
                        }
                    }, 0L, TimeUnit.SECONDS);
                }
            });
            cancelLink.setListener(new LinkListener(){

                public void linkSelected(LinkLabel aSource, Object aLinkData) {
                    indicator.cancel();
                }
            }, null);
            gbc.insets.bottom = -5;
            groupPanel.add((Component)titleLabel, gbc);
            gbc.insets.bottom = 10;
            groupPanel.add((Component)topicLabel, gbc);
            groupPanel.add((Component)descriptionLabel, gbc);
            gbc.weighty = 1.0;
            groupPanel.add(Box.createVerticalGlue(), gbc);
            gbc.weighty = 0.0;
            groupPanel.add((Component)buttonWrapper, gbc);
            gridPanel.add(groupPanel);
        }
        int cursor = 0;
        Component[] components = gridPanel.getComponents();
        int rowCount = components.length / 3;
        for (Component component : components) {
            ((JComponent)component).setBorder(new CompoundBorder((Border)new CustomLineBorder(ColorUtil.withAlpha((Color)JBColor.foreground(), (double)0.2), 0, 0, cursor / 3 < rowCount ? 1 : 0, cursor % 3 != 2 ? 1 : 0){

                protected Color getColor() {
                    return ColorUtil.withAlpha((Color)JBColor.foreground(), (double)0.2);
                }
            }, BorderFactory.createEmptyBorder(0, 10, 0, 10)));
            ++cursor;
        }
        if (isEmptyOrOffline) {
            throw new OfflineException();
        }
        this.add((Component)scrollPane);
    }

    @Override
    public String getTitle() {
        return "Featured plugins";
    }

    @Override
    public String getHTMLHeader() {
        return "<html><body><h2>Download featured plugins</h2>We have a few plugins in our repository that most users like to download. Perhaps, you need them too?</body></html>";
    }

    @Override
    public String getHTMLFooter() {
        return "New plugins can also be downloaded in " + CommonBundle.settingsTitle() + " | " + "Plugins";
    }

    public static class OfflineException
    extends Exception {
    }
}

