/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.IdeaApplication;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstalledPluginsState {
    private final Object myLock;
    private final Map<PluginId, IdeaPluginDescriptor> myInstalledPlugins;
    private final Map<PluginId, IdeaPluginDescriptor> myUpdatedPlugins;
    private final UpdateSettings myUpdateSettings;

    @Nullable
    public static InstalledPluginsState getInstanceIfLoaded() {
        return IdeaApplication.isLoaded() ? InstalledPluginsState.getInstance() : null;
    }

    public static InstalledPluginsState getInstance() {
        return (InstalledPluginsState)ServiceManager.getService(InstalledPluginsState.class);
    }

    public InstalledPluginsState(@NotNull UpdateSettings updateSettings) {
        if (updateSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateSettings", "com/intellij/ide/plugins/InstalledPluginsState", "<init>"));
        }
        this.myLock = new Object();
        this.myInstalledPlugins = ContainerUtil.newIdentityHashMap();
        this.myUpdatedPlugins = ContainerUtil.newIdentityHashMap();
        this.myUpdateSettings = updateSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<IdeaPluginDescriptor> getInstalledPlugins() {
        Object object = this.myLock;
        // MONITORENTER : object
        Collection<IdeaPluginDescriptor> collection = Collections.unmodifiableCollection(this.myInstalledPlugins.values());
        // MONITOREXIT : object
        if (collection != null) return collection;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/InstalledPluginsState", "getInstalledPlugins"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNewerVersion(@NotNull PluginId id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/ide/plugins/InstalledPluginsState", "hasNewerVersion"));
        }
        Object object = this.myLock;
        synchronized (object) {
            return !this.wasUpdated(id) && this.myUpdateSettings.myOutdatedPlugins.contains((Object)id.getIdString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasInstalled(@NotNull PluginId id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/ide/plugins/InstalledPluginsState", "wasInstalled"));
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myInstalledPlugins.containsKey(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasUpdated(@NotNull PluginId id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/ide/plugins/InstalledPluginsState", "wasUpdated"));
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myUpdatedPlugins.containsKey(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDescriptorDownload(@NotNull IdeaPluginDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/plugins/InstalledPluginsState", "onDescriptorDownload"));
        }
        PluginId id = descriptor.getPluginId();
        IdeaPluginDescriptor existing = PluginManager.getPlugin(id);
        if (existing == null || existing.isBundled() || this.wasUpdated(id)) {
            return;
        }
        boolean newer = PluginDownloader.compareVersionsSkipBroken(existing, descriptor.getVersion()) > 0 && !PluginManagerCore.isIncompatible(descriptor);
        String idString = id.getIdString();
        Object object = this.myLock;
        synchronized (object) {
            if (newer) {
                if (!this.myUpdateSettings.myOutdatedPlugins.contains((Object)idString)) {
                    this.myUpdateSettings.myOutdatedPlugins.add((Object)idString);
                }
            } else {
                this.myUpdateSettings.myOutdatedPlugins.remove((Object)idString);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPluginInstall(@NotNull IdeaPluginDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/plugins/InstalledPluginsState", "onPluginInstall"));
        }
        PluginId id = descriptor.getPluginId();
        boolean existing = PluginManager.isPluginInstalled(id);
        Object object = this.myLock;
        synchronized (object) {
            this.myUpdateSettings.myOutdatedPlugins.remove((Object)id.getIdString());
            if (existing) {
                this.myUpdatedPlugins.put(id, descriptor);
            } else {
                this.myInstalledPlugins.put(id, descriptor);
            }
        }
    }
}

