/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewNodeDecorator;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.projectView.impl.nodes.PackageUtil;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageElementNode
extends ProjectViewNode<PackageElement> {
    public PackageElementNode(@NotNull Project project, PackageElement value, ViewSettings viewSettings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/projectView/impl/nodes/PackageElementNode", "<init>"));
        }
        super(project, (Object)value, viewSettings);
    }

    public PackageElementNode(@NotNull Project project, Object value, ViewSettings viewSettings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/projectView/impl/nodes/PackageElementNode", "<init>"));
        }
        this(project, (PackageElement)value, viewSettings);
    }

    public boolean contains(@NotNull VirtualFile file) {
        PsiDirectory[] directories;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/projectView/impl/nodes/PackageElementNode", "contains"));
        }
        if (!this.isUnderContent(file) || this.getValue() == null) {
            return false;
        }
        for (PsiDirectory directory : directories = ((PackageElement)this.getValue()).getPackage().getDirectories()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)directory.getVirtualFile(), (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private boolean isUnderContent(VirtualFile file) {
        Module module;
        PackageElement element = (PackageElement)this.getValue();
        Module module2 = module = element == null ? null : element.getModule();
        if (module == null) {
            return ModuleUtilCore.projectContainsFile((Project)this.getProject(), (VirtualFile)file, (boolean)this.isLibraryElement());
        }
        return ModuleUtilCore.moduleContainsFile((Module)module, (VirtualFile)file, (boolean)this.isLibraryElement());
    }

    private boolean isLibraryElement() {
        return this.getValue() != null && ((PackageElement)this.getValue()).isLibraryElement();
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        PsiFile[] packageChildren;
        PackageElement value = (PackageElement)this.getValue();
        if (value == null) {
            List<AbstractTreeNode> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/PackageElementNode", "getChildren"));
            }
            return list;
        }
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        Module module = value.getModule();
        PsiPackage aPackage = value.getPackage();
        if (!this.getSettings().isFlattenPackages()) {
            PsiPackage[] subpackages;
            for (PsiPackage subpackage : subpackages = PackageUtil.getSubpackages(aPackage, module, this.isLibraryElement())) {
                PackageUtil.addPackageAsChild(children, subpackage, module, this.getSettings(), this.isLibraryElement());
            }
        }
        GlobalSearchScope scopeToShow = PackageUtil.getScopeToShow(aPackage.getProject(), module, this.isLibraryElement());
        for (PsiFile file : packageChildren = aPackage.getFiles(scopeToShow)) {
            if (file.getVirtualFile() == null) continue;
            children.add((AbstractTreeNode)new PsiFileNode(this.getProject(), file, this.getSettings()));
        }
        ArrayList<AbstractTreeNode> arrayList = children;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/PackageElementNode", "getChildren"));
        }
        return arrayList;
    }

    protected void update(PresentationData presentation) {
        if (this.getValue() != null && ((PackageElement)this.getValue()).getPackage().isValid()) {
            this.updateValidData(presentation);
        } else {
            this.setValue(null);
        }
    }

    private void updateValidData(PresentationData presentation) {
        PackageElement value = (PackageElement)this.getValue();
        PsiPackage aPackage = value.getPackage();
        if (!this.getSettings().isFlattenPackages() && this.getSettings().isHideEmptyMiddlePackages() && PackageUtil.isPackageEmpty(aPackage, value.getModule(), true, this.isLibraryElement())) {
            this.setValue(null);
            return;
        }
        Object parentValue = this.getParentValue();
        PsiPackage parentPackage = parentValue instanceof PackageElement ? ((PackageElement)parentValue).getPackage() : null;
        String qName = aPackage.getQualifiedName();
        String name = PackageUtil.getNodeName(this.getSettings(), aPackage, parentPackage, qName, this.showFQName(aPackage));
        presentation.setPresentableText(name);
        presentation.setIcon(PlatformIcons.PACKAGE_ICON);
        for (ProjectViewNodeDecorator decorator : (ProjectViewNodeDecorator[])Extensions.getExtensions(ProjectViewNodeDecorator.EP_NAME, (AreaInstance)this.myProject)) {
            decorator.decorate(this, presentation);
        }
    }

    private boolean showFQName(PsiPackage aPackage) {
        return this.getSettings().isFlattenPackages() && !aPackage.getQualifiedName().isEmpty();
    }

    public String getTestPresentation() {
        PresentationData presentation = new PresentationData();
        this.update(presentation);
        return "PsiPackage: " + presentation.getPresentableText();
    }

    public boolean valueIsCut() {
        return this.getValue() != null && CopyPasteManager.getInstance().isCutElement((Object)((PackageElement)this.getValue()).getPackage());
    }

    @NotNull
    public VirtualFile[] getVirtualFiles() {
        PackageElement value = (PackageElement)this.getValue();
        if (value == null) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/PackageElementNode", "getVirtualFiles"));
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        PsiDirectory[] directories = PackageUtil.getDirectories(value.getPackage(), value.getModule(), this.isLibraryElement());
        VirtualFile[] result = new VirtualFile[directories.length];
        for (int i = 0; i < directories.length; ++i) {
            PsiDirectory directory = directories[i];
            result[i] = directory.getVirtualFile();
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/PackageElementNode", "getVirtualFiles"));
        }
        return result;
    }

    public boolean canRepresent(Object element) {
        String aPackage;
        PackageElement packageElement;
        String otherPackage;
        if (super.canRepresent(element)) {
            return true;
        }
        PackageElement value = (PackageElement)this.getValue();
        if (value == null) {
            return true;
        }
        if (element instanceof PackageElement && (otherPackage = (packageElement = (PackageElement)element).getPackage().getQualifiedName()).equals(aPackage = value.getPackage().getQualifiedName())) {
            return true;
        }
        if (element instanceof PsiDirectory) {
            PsiDirectory directory = (PsiDirectory)element;
            return Arrays.asList(value.getPackage().getDirectories()).contains(directory);
        }
        return false;
    }

    public int getWeight() {
        return 0;
    }

    public String getTitle() {
        PackageElement packageElement = (PackageElement)this.getValue();
        if (packageElement == null) {
            return super.getTitle();
        }
        return packageElement.getPackage().getQualifiedName();
    }

    @Nullable
    public String getQualifiedNameSortKey() {
        PackageElement packageElement = (PackageElement)this.getValue();
        if (packageElement != null) {
            return packageElement.getPackage().getQualifiedName();
        }
        return null;
    }

    public int getTypeSortWeight(boolean sortByType) {
        return 4;
    }

    public boolean isAlwaysShowPlus() {
        for (VirtualFile dir : this.getVirtualFiles()) {
            if (dir.getChildren().length <= 0) continue;
            return true;
        }
        return false;
    }
}

