/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.icons.AllIcons;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.lang.Language;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ObjectUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScratchRootType
extends RootType {
    @NotNull
    public static ScratchRootType getInstance() {
        ScratchRootType scratchRootType = ScratchRootType.findByClass(ScratchRootType.class);
        if (scratchRootType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchRootType", "getInstance"));
        }
        return scratchRootType;
    }

    ScratchRootType() {
        super("scratches", "Scratches");
    }

    @Override
    public Language substituteLanguage(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/ScratchRootType", "substituteLanguage"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchRootType", "substituteLanguage"));
        }
        PerFileMappings<Language> mapping = ScratchFileService.getInstance().getScratchesMapping();
        Language language = (Language)mapping.getMapping(file);
        return language != null && language != ScratchFileType.INSTANCE.getLanguage() ? LanguageSubstitutors.INSTANCE.substituteLanguage(language, file, project) : language;
    }

    @Override
    @Nullable
    public Icon substituteIcon(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/ScratchRootType", "substituteIcon"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchRootType", "substituteIcon"));
        }
        Icon icon = (Icon)ObjectUtils.chooseNotNull((Object)super.substituteIcon(project, file), (Object)ScratchFileType.INSTANCE.getIcon());
        return LayeredIcon.create((Icon)icon, (Icon)AllIcons.Actions.Scratch);
    }
}

