/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.icons.AllIcons;
import com.intellij.ide.scratch.NewScratchFileAction;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.lang.Language;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.ui.ClickListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ScratchWidget
extends EditorBasedWidget
implements StatusBarWidget.Multiframe,
CustomStatusBarWidget {
    static final String WIDGET_ID = "Scratch";
    private final MyTextPanel myPanel = new MyTextPanel();

    public ScratchWidget(Project project) {
        super(project);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/scratch/ScratchWidget$1", "onClick"));
                }
                Project project = ScratchWidget.this.getProject();
                Editor editor = ScratchWidget.this.getEditor();
                final VirtualFile file = ScratchWidget.this.getSelectedFile();
                if (project == null || editor == null || file == null) {
                    return false;
                }
                final PerFileMappings<Language> fileService = ScratchFileService.getInstance().getScratchesMapping();
                ListPopup popup = NewScratchFileAction.buildLanguagePopup(project, (Language)fileService.getMapping(file), new Consumer<Language>(){

                    public void consume(Language language) {
                        fileService.setMapping(file, (Object)language);
                        ScratchWidget.this.update();
                    }
                });
                Dimension dimension = popup.getContent().getPreferredSize();
                Point at = new Point(0, -dimension.height);
                popup.show(new RelativePoint((Component)ScratchWidget.this.myPanel, at));
                return true;
            }
        }.installOn((Component)this.myPanel);
        this.myConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/ide/scratch/ScratchWidget$2", "after"));
                }
                for (VFileEvent vFileEvent : events) {
                    if (vFileEvent.getRequestor() != "FileContentUtilCore.saveOrReload") continue;
                    ScratchWidget.this.update();
                    break;
                }
            }
        });
    }

    @NotNull
    public String ID() {
        if (WIDGET_ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchWidget", "ID"));
        }
        return WIDGET_ID;
    }

    @Nullable
    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/ide/scratch/ScratchWidget", "getPresentation"));
        }
        return null;
    }

    private void update() {
        Project project = this.getProject();
        if (project == null) {
            return;
        }
        VirtualFile file = this.getSelectedFile();
        if (file == null) {
            return;
        }
        ScratchFileService fileService = ScratchFileService.getInstance();
        if (fileService.getRootType(file) instanceof ScratchRootType) {
            Language lang = (Language)fileService.getScratchesMapping().getMapping(file);
            if (lang == null) {
                lang = LanguageSubstitutors.INSTANCE.substituteLanguage(((LanguageFileType)file.getFileType()).getLanguage(), file, project);
            }
            this.myPanel.setText(lang.getDisplayName());
            this.myPanel.setBorder((Border)StatusBarWidget.WidgetBorder.INSTANCE);
            this.myPanel.setIcon(ScratchWidget.getDefaultIcon(lang));
            this.myPanel.setVisible(true);
        } else {
            this.myPanel.setBorder(null);
            this.myPanel.setVisible(false);
        }
        if (this.myStatusBar != null) {
            this.myStatusBar.updateWidget(WIDGET_ID);
        }
    }

    public StatusBarWidget copy() {
        return new ScratchWidget(this.myProject);
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/ide/scratch/ScratchWidget", "fileOpened"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchWidget", "fileOpened"));
        }
        this.update();
        super.fileOpened(source, file);
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/ide/scratch/ScratchWidget", "fileClosed"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchWidget", "fileClosed"));
        }
        this.update();
        super.fileClosed(source, file);
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/scratch/ScratchWidget", "selectionChanged"));
        }
        this.update();
        super.selectionChanged(event);
    }

    private static Icon getDefaultIcon(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/ide/scratch/ScratchWidget", "getDefaultIcon"));
        }
        LanguageFileType associatedLanguage = language.getAssociatedFileType();
        return associatedLanguage != null ? associatedLanguage.getIcon() : null;
    }

    private static class MyTextPanel
    extends TextPanel {
        private int myIconTextGap = 2;
        private Icon myIcon;

        private MyTextPanel() {
        }

        @Override
        protected void paintComponent(@NotNull Graphics g) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ide/scratch/ScratchWidget$MyTextPanel", "paintComponent"));
            }
            super.paintComponent(g);
            if (this.getText() != null) {
                Rectangle r = this.getBounds();
                Insets insets = this.getInsets();
                AllIcons.Ide.Statusbar_arrows.paintIcon(this, g, r.width - insets.right - AllIcons.Ide.Statusbar_arrows.getIconWidth() - 2, r.height / 2 - AllIcons.Ide.Statusbar_arrows.getIconHeight() / 2);
                if (this.myIcon != null) {
                    this.myIcon.paintIcon(this, g, insets.left - this.myIconTextGap - this.myIcon.getIconWidth(), r.height / 2 - this.myIcon.getIconHeight() / 2);
                }
            }
        }

        @Override
        @NotNull
        public Insets getInsets() {
            Insets insets = super.getInsets();
            if (this.myIcon != null) {
                insets.left += this.myIcon.getIconWidth() + this.myIconTextGap * 2;
            }
            Insets insets2 = insets;
            if (insets2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchWidget$MyTextPanel", "getInsets"));
            }
            return insets2;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            int deltaWidth = AllIcons.Ide.Statusbar_arrows.getIconWidth() + this.myIconTextGap * 2;
            if (this.myIcon != null) {
                deltaWidth += this.myIcon.getIconWidth() + this.myIconTextGap * 2;
            }
            return new Dimension(preferredSize.width + deltaWidth, preferredSize.height);
        }

        public void setIcon(Icon icon) {
            this.myIcon = icon;
        }
    }
}

