/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.injected.editor;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.RangeMarkerWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditReadOnlyListener;
import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.util.Processor;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.ImmutableCharSequence;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentWindowImpl
extends UserDataHolderBase
implements Disposable,
DocumentWindow,
DocumentEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.injected.editor.DocumentWindowImpl");
    private final DocumentEx myDelegate;
    private final boolean myOneLine;
    private Place myShreds;
    private final int myPrefixLineCount;
    private final int mySuffixLineCount;
    private final Object myLock;
    private CachedText myCachedText;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentWindowImpl(@NotNull DocumentEx delegate, boolean oneLine, @NotNull Place shreds) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/injected/editor/DocumentWindowImpl", "<init>"));
        }
        if (shreds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shreds", "com/intellij/injected/editor/DocumentWindowImpl", "<init>"));
        }
        this.myLock = new Object();
        this.myCachedText = null;
        this.myDelegate = delegate;
        this.myOneLine = oneLine;
        Object object = this.myLock;
        synchronized (object) {
            this.myShreds = shreds;
        }
        this.myPrefixLineCount = Math.max(1, 1 + StringUtil.countNewLines((CharSequence)((PsiLanguageInjectionHost.Shred)shreds.get(0)).getPrefix()));
        this.mySuffixLineCount = Math.max(1, 1 + StringUtil.countNewLines((CharSequence)((PsiLanguageInjectionHost.Shred)shreds.get(shreds.size() - 1)).getSuffix()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable(value="null means we were unable to calculate")
    LogicalPosition hostToInjectedInVirtualSpace(@NotNull LogicalPosition hPos) {
        if (hPos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hPos", "com/intellij/injected/editor/DocumentWindowImpl", "hostToInjectedInVirtualSpace"));
        }
        int hLineStartOffset = hPos.line >= this.myDelegate.getLineCount() ? this.myDelegate.getTextLength() : this.myDelegate.getLineStartOffset(hPos.line);
        int iLineStartOffset = this.hostToInjected(hLineStartOffset);
        int iLine = this.getLineNumber(iLineStartOffset);
        Object object = this.myLock;
        synchronized (object) {
            for (int i = this.myShreds.size() - 1; i >= 0; --i) {
                Segment hostRangeMarker;
                PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)this.myShreds.get(i);
                if (!shred.isValid() || (hostRangeMarker = shred.getHostRangeMarker()) == null) continue;
                int hShredEndOffset = hostRangeMarker.getEndOffset();
                int hShredStartOffset = hostRangeMarker.getStartOffset();
                int hShredStartLine = this.myDelegate.getLineNumber(hShredStartOffset);
                int hShredEndLine = this.myDelegate.getLineNumber(hShredEndOffset);
                if (hShredStartLine > hPos.line || hPos.line > hShredEndLine) continue;
                int hColumnOfShredEnd = hShredEndOffset - hLineStartOffset;
                int iColumnOfShredEnd = this.hostToInjected(hShredEndOffset) - iLineStartOffset;
                int iColumn = iColumnOfShredEnd + hPos.column - hColumnOfShredEnd;
                return new LogicalPosition(iLine, iColumn);
            }
        }
        return null;
    }

    public int getLineCount() {
        return 1 + StringUtil.countNewLines((CharSequence)this.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineStartOffset(int line) {
        LOG.assertTrue(line >= 0, (Object)line);
        if (line == 0) {
            return 0;
        }
        String hostText = this.myDelegate.getText();
        int[] pos = new int[2];
        Object object = this.myLock;
        synchronized (object) {
            Iterator i$ = this.myShreds.iterator();
            while (i$.hasNext()) {
                PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)i$.next();
                Segment hostRange = shred.getHostRangeMarker();
                if (hostRange == null) continue;
                int found = DocumentWindowImpl.countNewLinesIn(shred.getPrefix(), pos, line);
                if (found != -1) {
                    return found;
                }
                CharSequence text = hostText.subSequence(hostRange.getStartOffset(), hostRange.getEndOffset());
                found = DocumentWindowImpl.countNewLinesIn(text, pos, line);
                if (found != -1) {
                    return found;
                }
                found = DocumentWindowImpl.countNewLinesIn(shred.getSuffix(), pos, line);
                if (found == -1) continue;
                return found;
            }
        }
        return pos[1];
    }

    private static int countNewLinesIn(CharSequence text, int[] pos, int line) {
        int offsetInside = 0;
        int i = StringUtil.indexOf((CharSequence)text, (char)'\n');
        while (i != -1) {
            int curLine = pos[0] = pos[0] + 1;
            int lineLength = i + 1 - offsetInside;
            int offset = pos[1] = pos[1] + lineLength;
            offsetInside += lineLength;
            if (curLine == line) {
                return offset;
            }
            i = StringUtil.indexOf((CharSequence)text, (char)'\n', (int)offsetInside);
        }
        pos[1] = pos[1] + (text.length() - offsetInside);
        return -1;
    }

    public int getLineEndOffset(int line) {
        LOG.assertTrue(line >= 0, (Object)line);
        if (line == this.getLineCount() - 1) {
            return this.getTextLength();
        }
        int startOffsetOfNextLine = this.getLineStartOffset(line + 1);
        return startOffsetOfNextLine == 0 || this.getText().charAt(startOffsetOfNextLine - 1) != '\n' ? startOffsetOfNextLine : startOffsetOfNextLine - 1;
    }

    @NotNull
    public String getText() {
        CachedText cachedText = this.myCachedText;
        if (cachedText == null || cachedText.getModificationStamp() != this.getModificationStamp()) {
            this.myCachedText = cachedText = new CachedText(this.calcText(), this.getModificationStamp());
        }
        String string = cachedText.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/DocumentWindowImpl", "getText"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private String calcText() {
        StringBuilder text = new StringBuilder();
        CharSequence hostText = this.myDelegate.getCharsSequence();
        Object object = this.myLock;
        synchronized (object) {
            Iterator i$ = this.myShreds.iterator();
            while (i$.hasNext()) {
                PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)i$.next();
                Segment hostRange = shred.getHostRangeMarker();
                if (hostRange == null) continue;
                text.append(shred.getPrefix());
                text.append(hostText, hostRange.getStartOffset(), hostRange.getEndOffset());
                text.append(shred.getSuffix());
            }
        }
        String string = text.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/DocumentWindowImpl", "calcText"));
        }
        return string;
    }

    @NotNull
    public String getText(@NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/injected/editor/DocumentWindowImpl", "getText"));
        }
        String string = range.substring(this.getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/DocumentWindowImpl", "getText"));
        }
        return string;
    }

    @NotNull
    public CharSequence getCharsSequence() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/DocumentWindowImpl", "getCharsSequence"));
        }
        return string;
    }

    @NotNull
    public CharSequence getImmutableCharSequence() {
        CharSequence charSequence = ImmutableCharSequence.asImmutable((CharSequence)this.getText());
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/DocumentWindowImpl", "getImmutableCharSequence"));
        }
        return charSequence;
    }

    @NotNull
    public char[] getChars() {
        char[] cArray = CharArrayUtil.fromSequence((CharSequence)this.getText());
        if (cArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/DocumentWindowImpl", "getChars"));
        }
        return cArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTextLength() {
        int length = 0;
        Object object = this.myLock;
        synchronized (object) {
            Iterator i$ = this.myShreds.iterator();
            while (i$.hasNext()) {
                PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)i$.next();
                Segment hostRange = shred.getHostRangeMarker();
                if (hostRange == null) continue;
                length += shred.getPrefix().length();
                length += hostRange.getEndOffset() - hostRange.getStartOffset();
                length += shred.getSuffix().length();
            }
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineNumber(int offset) {
        int lineNumber = 0;
        String hostText = this.myDelegate.getText();
        Object object = this.myLock;
        synchronized (object) {
            Iterator i$ = this.myShreds.iterator();
            while (i$.hasNext()) {
                PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)i$.next();
                String prefix = shred.getPrefix();
                String suffix = shred.getSuffix();
                lineNumber += StringUtil.getLineBreakCount((CharSequence)prefix.substring(0, Math.min(offset, prefix.length())));
                if (offset < prefix.length()) {
                    return lineNumber;
                }
                offset -= prefix.length();
                Segment currentRange = shred.getHostRangeMarker();
                if (currentRange == null) continue;
                int rangeLength = currentRange.getEndOffset() - currentRange.getStartOffset();
                CharSequence rangeText = hostText.subSequence(currentRange.getStartOffset(), currentRange.getEndOffset());
                lineNumber += StringUtil.getLineBreakCount((CharSequence)rangeText.subSequence(0, Math.min(offset, rangeLength)));
                if (offset < rangeLength) {
                    return lineNumber;
                }
                lineNumber += StringUtil.getLineBreakCount((CharSequence)suffix.substring(0, Math.min(offset -= rangeLength, suffix.length())));
                if (offset < suffix.length()) {
                    return lineNumber;
                }
                offset -= suffix.length();
            }
        }
        lineNumber = this.getLineCount() - 1;
        return lineNumber < 0 ? 0 : lineNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextRange getHostRange(int hostOffset) {
        Object object = this.myLock;
        synchronized (object) {
            Iterator i$ = this.myShreds.iterator();
            while (i$.hasNext()) {
                ProperTextRange textRange;
                PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)i$.next();
                Segment currentRange = shred.getHostRangeMarker();
                if (currentRange == null || !(textRange = ProperTextRange.create((Segment)currentRange)).grown(1).contains(hostOffset)) continue;
                return textRange;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertString(int offset, @NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/injected/editor/DocumentWindowImpl", "insertString"));
        }
        Object object = this.myLock;
        synchronized (object) {
            LOG.assertTrue(offset >= ((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getPrefix().length(), (Object)((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getPrefix());
            LOG.assertTrue(offset <= this.getTextLength() - ((PsiLanguageInjectionHost.Shred)this.myShreds.get(this.myShreds.size() - 1)).getSuffix().length(), (Object)((PsiLanguageInjectionHost.Shred)this.myShreds.get(this.myShreds.size() - 1)).getSuffix());
        }
        if (this.isOneLine()) {
            s = StringUtil.replace((String)((Object)s).toString(), (String)"\n", (String)"");
        }
        this.myDelegate.insertString(this.injectedToHost(offset), s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteString(int startOffset, int endOffset) {
        ArrayList<TextRange> hostRangesToDelete;
        assert (this.intersectWithEditable(new TextRange(startOffset, startOffset)) != null);
        assert (this.intersectWithEditable(new TextRange(endOffset, endOffset)) != null);
        Object object = this.myLock;
        synchronized (object) {
            hostRangesToDelete = new ArrayList<TextRange>(this.myShreds.size());
            int offset = startOffset;
            int curRangeStart = 0;
            Iterator i$ = this.myShreds.iterator();
            while (i$.hasNext()) {
                PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)i$.next();
                if (offset < (curRangeStart += shred.getPrefix().length())) {
                    offset = curRangeStart;
                }
                if (offset >= endOffset) break;
                Segment hostRange = shred.getHostRangeMarker();
                if (hostRange == null) continue;
                int hostRangeLength = hostRange.getEndOffset() - hostRange.getStartOffset();
                TextRange range = TextRange.from((int)curRangeStart, (int)hostRangeLength);
                if (range.contains(offset)) {
                    TextRange rangeToDelete = new TextRange(offset, Math.min(range.getEndOffset(), endOffset));
                    hostRangesToDelete.add(rangeToDelete.shiftRight(hostRange.getStartOffset() - curRangeStart));
                    offset = rangeToDelete.getEndOffset();
                }
                curRangeStart += hostRangeLength;
                curRangeStart += shred.getSuffix().length();
            }
        }
        int delta = 0;
        for (TextRange hostRangeToDelete : hostRangesToDelete) {
            this.myDelegate.deleteString(hostRangeToDelete.getStartOffset() + delta, hostRangeToDelete.getEndOffset() + delta);
            delta -= hostRangeToDelete.getLength();
        }
    }

    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/injected/editor/DocumentWindowImpl", "replaceString"));
        }
        if (this.isOneLine()) {
            s = StringUtil.replace((String)((Object)s).toString(), (String)"\n", (String)"");
        }
        CharSequence chars = this.getCharsSequence();
        CharSequence toDelete = chars.subSequence(startOffset, endOffset);
        int perfixLength = StringUtil.commonPrefixLength((CharSequence)s, (CharSequence)toDelete);
        int suffixLength = StringUtil.commonSuffixLength((CharSequence)toDelete.subSequence(perfixLength, toDelete.length()), (CharSequence)s.subSequence(perfixLength, s.length()));
        s = s.subSequence(perfixLength, s.length() - suffixLength);
        this.doReplaceString(startOffset += perfixLength, endOffset -= suffixLength, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReplaceString(int startOffset, int endOffset, CharSequence s) {
        ArrayList<Pair> hostRangesToModify;
        assert (this.intersectWithEditable(new TextRange(startOffset, startOffset)) != null);
        assert (this.intersectWithEditable(new TextRange(endOffset, endOffset)) != null);
        Object object = this.myLock;
        synchronized (object) {
            hostRangesToModify = new ArrayList<Pair>(this.myShreds.size());
            int offset = startOffset;
            int curRangeStart = 0;
            for (int i = 0; i < this.myShreds.size(); ++i) {
                Segment hostRange;
                PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)this.myShreds.get(i);
                if (offset < (curRangeStart += shred.getPrefix().length())) {
                    offset = curRangeStart;
                }
                if ((hostRange = shred.getHostRangeMarker()) == null) continue;
                int hostRangeLength = hostRange.getEndOffset() - hostRange.getStartOffset();
                TextRange range = TextRange.from((int)curRangeStart, (int)hostRangeLength);
                if (range.contains(offset) || range.getEndOffset() == offset) {
                    TextRange rangeToModify = new TextRange(offset, Math.min(range.getEndOffset(), endOffset));
                    TextRange hostRangeToModify = rangeToModify.shiftRight(hostRange.getStartOffset() - curRangeStart);
                    CharSequence toReplace = i == this.myShreds.size() - 1 || range.getEndOffset() + shred.getSuffix().length() >= endOffset ? s : s.subSequence(0, Math.min(hostRangeToModify.getLength(), s.length()));
                    s = toReplace == s ? "" : s.subSequence(toReplace.length(), s.length());
                    hostRangesToModify.add(Pair.create((Object)hostRangeToModify, (Object)toReplace));
                    offset = rangeToModify.getEndOffset();
                }
                curRangeStart += hostRangeLength;
                if ((curRangeStart += shred.getSuffix().length()) >= endOffset) break;
            }
        }
        int delta = 0;
        for (Pair pair : hostRangesToModify) {
            TextRange hostRange = (TextRange)pair.getFirst();
            CharSequence replace = (CharSequence)pair.getSecond();
            this.myDelegate.replaceString(hostRange.getStartOffset() + delta, hostRange.getEndOffset() + delta, replace);
            delta -= hostRange.getLength() - replace.length();
        }
    }

    @Override
    public void moveText(int srcStart, int srcEnd, int dstOffset) {
        throw new UnsupportedOperationException();
    }

    public boolean isWritable() {
        return this.myDelegate.isWritable();
    }

    public long getModificationStamp() {
        return this.isValid() ? this.myDelegate.getModificationStamp() : -1L;
    }

    public void fireReadOnlyModificationAttempt() {
        this.myDelegate.fireReadOnlyModificationAttempt();
    }

    public void addDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/injected/editor/DocumentWindowImpl", "addDocumentListener"));
        }
        this.myDelegate.addDocumentListener(listener);
    }

    public void addDocumentListener(@NotNull DocumentListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/injected/editor/DocumentWindowImpl", "addDocumentListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/injected/editor/DocumentWindowImpl", "addDocumentListener"));
        }
        this.myDelegate.addDocumentListener(listener, parentDisposable);
    }

    public void removeDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/injected/editor/DocumentWindowImpl", "removeDocumentListener"));
        }
        this.myDelegate.removeDocumentListener(listener);
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset) {
        ProperTextRange hostRange = this.injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        RangeMarker hostMarker = this.myDelegate.createRangeMarker((TextRange)hostRange);
        int startShift = Math.max(0, this.hostToInjected(hostRange.getStartOffset()) - startOffset);
        int endShift = Math.max(0, endOffset - this.hostToInjected(hostRange.getEndOffset()) - startShift);
        RangeMarkerWindow rangeMarkerWindow = new RangeMarkerWindow(this, (RangeMarkerEx)hostMarker, startShift, endShift);
        if (rangeMarkerWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/DocumentWindowImpl", "createRangeMarker"));
        }
        return rangeMarkerWindow;
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset, boolean surviveOnExternalChange) {
        if (!surviveOnExternalChange) {
            RangeMarker rangeMarker = this.createRangeMarker(startOffset, endOffset);
            if (rangeMarker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/DocumentWindowImpl", "createRangeMarker"));
            }
            return rangeMarker;
        }
        ProperTextRange hostRange = this.injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        RangeMarker hostMarker = this.myDelegate.createRangeMarker(hostRange.getStartOffset(), hostRange.getEndOffset(), surviveOnExternalChange);
        int startShift = Math.max(0, this.hostToInjected(hostRange.getStartOffset()) - startOffset);
        int endShift = Math.max(0, endOffset - this.hostToInjected(hostRange.getEndOffset()) - startShift);
        RangeMarkerWindow rangeMarkerWindow = new RangeMarkerWindow(this, (RangeMarkerEx)hostMarker, startShift, endShift);
        if (rangeMarkerWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/DocumentWindowImpl", "createRangeMarker"));
        }
        return rangeMarkerWindow;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/injected/editor/DocumentWindowImpl", "addPropertyChangeListener"));
        }
        this.myDelegate.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/injected/editor/DocumentWindowImpl", "removePropertyChangeListener"));
        }
        this.myDelegate.removePropertyChangeListener(listener);
    }

    public void setReadOnly(boolean isReadOnly) {
        this.myDelegate.setReadOnly(isReadOnly);
    }

    @NotNull
    public RangeMarker createGuardedBlock(int startOffset, int endOffset) {
        ProperTextRange hostRange = this.injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        RangeMarker rangeMarker = this.myDelegate.createGuardedBlock(hostRange.getStartOffset(), hostRange.getEndOffset());
        if (rangeMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/DocumentWindowImpl", "createGuardedBlock"));
        }
        return rangeMarker;
    }

    public void removeGuardedBlock(@NotNull RangeMarker block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/injected/editor/DocumentWindowImpl", "removeGuardedBlock"));
        }
        this.myDelegate.removeGuardedBlock(block);
    }

    public RangeMarker getOffsetGuard(int offset) {
        return this.myDelegate.getOffsetGuard(this.injectedToHost(offset));
    }

    public RangeMarker getRangeGuard(int startOffset, int endOffset) {
        ProperTextRange hostRange = this.injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        return this.myDelegate.getRangeGuard(hostRange.getStartOffset(), hostRange.getEndOffset());
    }

    public void startGuardedBlockChecking() {
        this.myDelegate.startGuardedBlockChecking();
    }

    public void stopGuardedBlockChecking() {
        this.myDelegate.stopGuardedBlockChecking();
    }

    public void setCyclicBufferSize(int bufferSize) {
        this.myDelegate.setCyclicBufferSize(bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/injected/editor/DocumentWindowImpl", "setText"));
        }
        Object object = this.myLock;
        synchronized (object) {
            LOG.assertTrue(((Object)text).toString().startsWith(((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getPrefix()));
            LOG.assertTrue(((Object)text).toString().endsWith(((PsiLanguageInjectionHost.Shred)this.myShreds.get(this.myShreds.size() - 1)).getSuffix()));
            if (this.isOneLine()) {
                text = StringUtil.replace((String)((Object)text).toString(), (String)"\n", (String)"");
            }
            String[] changes = this.calculateMinEditSequence(((Object)text).toString());
            assert (changes.length == this.myShreds.size());
            for (int i = 0; i < changes.length; ++i) {
                Segment hostRange;
                String change = changes[i];
                if (change == null || (hostRange = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getHostRangeMarker()) == null) continue;
                this.myDelegate.replaceString(hostRange.getStartOffset(), hostRange.getEndOffset(), change);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Segment[] getHostRanges() {
        Object object = this.myLock;
        // MONITORENTER : object
        ArrayList<Segment> markers = new ArrayList<Segment>(this.myShreds.size());
        Iterator i$ = this.myShreds.iterator();
        while (i$.hasNext()) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)i$.next();
            Segment hostMarker = shred.getHostRangeMarker();
            if (hostMarker == null) continue;
            markers.add(hostMarker);
        }
        Segment[] segmentArray = markers.isEmpty() ? Segment.EMPTY_ARRAY : markers.toArray(new Segment[markers.size()]);
        // MONITOREXIT : object
        if (segmentArray != null) return segmentArray;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/DocumentWindowImpl", "getHostRanges"));
    }

    @NotNull
    public RangeMarker createRangeMarker(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/injected/editor/DocumentWindowImpl", "createRangeMarker"));
        }
        ProperTextRange properTextRange = new ProperTextRange(textRange);
        RangeMarker rangeMarker = this.createRangeMarker(properTextRange.getStartOffset(), properTextRange.getEndOffset());
        if (rangeMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/DocumentWindowImpl", "createRangeMarker"));
        }
        return rangeMarker;
    }

    @Override
    public void setStripTrailingSpacesEnabled(boolean isEnabled) {
        this.myDelegate.setStripTrailingSpacesEnabled(isEnabled);
    }

    public int getLineSeparatorLength(int line) {
        return this.myDelegate.getLineSeparatorLength(this.injectedToHostLine(line));
    }

    @Override
    @NotNull
    public LineIterator createLineIterator() {
        LineIterator lineIterator = this.myDelegate.createLineIterator();
        if (lineIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/DocumentWindowImpl", "createLineIterator"));
        }
        return lineIterator;
    }

    @Override
    public void setModificationStamp(long modificationStamp) {
        this.myDelegate.setModificationStamp(modificationStamp);
    }

    @Override
    public void addEditReadOnlyListener(@NotNull EditReadOnlyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/injected/editor/DocumentWindowImpl", "addEditReadOnlyListener"));
        }
        this.myDelegate.addEditReadOnlyListener(listener);
    }

    @Override
    public void removeEditReadOnlyListener(@NotNull EditReadOnlyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/injected/editor/DocumentWindowImpl", "removeEditReadOnlyListener"));
        }
        this.myDelegate.removeEditReadOnlyListener(listener);
    }

    @Override
    public void replaceText(@NotNull CharSequence chars, long newModificationStamp) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/injected/editor/DocumentWindowImpl", "replaceText"));
        }
        this.setText(chars);
        this.myDelegate.setModificationStamp(newModificationStamp);
    }

    @Override
    public int getListenersCount() {
        return this.myDelegate.getListenersCount();
    }

    @Override
    public void suppressGuardedExceptions() {
        this.myDelegate.suppressGuardedExceptions();
    }

    @Override
    public void unSuppressGuardedExceptions() {
        this.myDelegate.unSuppressGuardedExceptions();
    }

    @Override
    public boolean isInEventsHandling() {
        return this.myDelegate.isInEventsHandling();
    }

    @Override
    public void clearLineModificationFlags() {
    }

    @Override
    public boolean removeRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/injected/editor/DocumentWindowImpl", "removeRangeMarker"));
        }
        return this.myDelegate.removeRangeMarker(((RangeMarkerWindow)rangeMarker).getDelegate());
    }

    @Override
    public void registerRangeMarker(@NotNull RangeMarkerEx rangeMarker, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/injected/editor/DocumentWindowImpl", "registerRangeMarker"));
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isInBulkUpdate() {
        return false;
    }

    @Override
    public void setInBulkUpdate(boolean value) {
    }

    @NotNull
    public DocumentEx getDelegate() {
        DocumentEx documentEx = this.myDelegate;
        if (documentEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/DocumentWindowImpl", "getDelegate"));
        }
        return documentEx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hostToInjected(int hostOffset) {
        Object object = this.myLock;
        synchronized (object) {
            Segment hostRangeMarker = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getHostRangeMarker();
            if (hostRangeMarker == null || hostOffset < hostRangeMarker.getStartOffset()) {
                return ((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getPrefix().length();
            }
            int offset = 0;
            for (int i = 0; i < this.myShreds.size(); ++i) {
                Segment nextRange;
                offset += ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getPrefix().length();
                Segment currentRange = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getHostRangeMarker();
                if (currentRange == null) continue;
                Segment segment = nextRange = i == this.myShreds.size() - 1 ? null : ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i + 1)).getHostRangeMarker();
                if (nextRange == null || hostOffset < nextRange.getStartOffset()) {
                    if (hostOffset >= currentRange.getEndOffset()) {
                        hostOffset = currentRange.getEndOffset();
                    }
                    return offset + hostOffset - currentRange.getStartOffset();
                }
                offset += currentRange.getEndOffset() - currentRange.getStartOffset();
                offset += ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getSuffix().length();
            }
            return this.getTextLength() - ((PsiLanguageInjectionHost.Shred)this.myShreds.get(this.myShreds.size() - 1)).getSuffix().length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hostToInjectedUnescaped(int hostOffset) {
        Object object = this.myLock;
        synchronized (object) {
            Segment hostRangeMarker = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getHostRangeMarker();
            if (hostRangeMarker == null || hostOffset < hostRangeMarker.getStartOffset()) {
                return ((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getPrefix().length();
            }
            int offset = 0;
            for (int i = 0; i < this.myShreds.size(); ++i) {
                Segment nextRange;
                offset += ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getPrefix().length();
                Segment currentRange = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getHostRangeMarker();
                if (currentRange == null) continue;
                Segment segment = nextRange = i == this.myShreds.size() - 1 ? null : ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i + 1)).getHostRangeMarker();
                if (nextRange == null || hostOffset < nextRange.getStartOffset()) {
                    offset = hostOffset >= currentRange.getEndOffset() ? (offset += ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getRange().getLength()) : (offset += hostOffset - currentRange.getStartOffset());
                    return offset;
                }
                offset += ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getRange().getLength();
                offset += ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getSuffix().length();
            }
            return this.getTextLength() - ((PsiLanguageInjectionHost.Shred)this.myShreds.get(this.myShreds.size() - 1)).getSuffix().length();
        }
    }

    public int injectedToHost(int offset) {
        Editor editor;
        int offsetInRightFragment;
        int offsetInLeftFragment = this.injectedToHost(offset, true);
        if (offsetInLeftFragment == (offsetInRightFragment = this.injectedToHost(offset, false))) {
            return offsetInLeftFragment;
        }
        Editor[] editors = EditorFactory.getInstance().getEditors((Document)this.getDelegate());
        Editor editor2 = editor = editors.length == 0 ? null : editors[0];
        if (editor != null) {
            int caret;
            if (editor instanceof EditorWindow) {
                editor = ((EditorWindow)editor).getDelegate();
            }
            return Math.abs((caret = editor.getCaretModel().getOffset()) - offsetInLeftFragment) < Math.abs(caret - offsetInRightFragment) ? offsetInLeftFragment : offsetInRightFragment;
        }
        return offsetInLeftFragment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int injectedToHost(int offset, boolean preferLeftFragment) {
        Object object = this.myLock;
        synchronized (object) {
            if (offset < ((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getPrefix().length()) {
                Segment hostRangeMarker = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getHostRangeMarker();
                int n = hostRangeMarker == null ? 0 : hostRangeMarker.getStartOffset();
                return n;
            }
            int prevEnd = 0;
            for (int i = 0; i < this.myShreds.size(); ++i) {
                Segment currentRange = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getHostRangeMarker();
                if (currentRange == null) continue;
                int length = currentRange.getEndOffset() - currentRange.getStartOffset();
                if ((offset -= ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getPrefix().length()) < 0) {
                    return preferLeftFragment ? prevEnd : currentRange.getStartOffset() - 1;
                }
                if (offset == 0) {
                    return preferLeftFragment && i != 0 ? prevEnd : currentRange.getStartOffset();
                }
                if (offset < length || offset == length && preferLeftFragment) {
                    return currentRange.getStartOffset() + offset;
                }
                offset -= length;
                offset -= ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getSuffix().length();
                prevEnd = currentRange.getEndOffset();
            }
            Segment hostRangeMarker = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(this.myShreds.size() - 1)).getHostRangeMarker();
            int n = hostRangeMarker == null ? 0 : hostRangeMarker.getEndOffset();
            return n;
        }
    }

    @NotNull
    public ProperTextRange injectedToHost(@NotNull TextRange injected) {
        if (injected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injected", "com/intellij/injected/editor/DocumentWindowImpl", "injectedToHost"));
        }
        int start = this.injectedToHost(injected.getStartOffset(), false);
        int end = this.injectedToHost(injected.getEndOffset(), true);
        if (end < start) {
            end = this.injectedToHost(injected.getEndOffset(), false);
        }
        ProperTextRange properTextRange = new ProperTextRange(start, end);
        if (properTextRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/DocumentWindowImpl", "injectedToHost"));
        }
        return properTextRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int injectedToHostLine(int line) {
        if (line < this.myPrefixLineCount) {
            Object object = this.myLock;
            synchronized (object) {
                Segment hostRangeMarker = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getHostRangeMarker();
                return hostRangeMarker == null ? 0 : this.myDelegate.getLineNumber(hostRangeMarker.getStartOffset());
            }
        }
        int lineCount = this.getLineCount();
        if (line > lineCount - this.mySuffixLineCount) {
            return lineCount;
        }
        int offset = this.getLineStartOffset(line);
        int hostOffset = this.injectedToHost(offset);
        return this.myDelegate.getLineNumber(hostOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsRange(int start, int end) {
        Object object = this.myLock;
        synchronized (object) {
            Segment hostRangeMarker = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getHostRangeMarker();
            if (hostRangeMarker == null || end - start > hostRangeMarker.getEndOffset() - hostRangeMarker.getStartOffset()) {
                return false;
            }
            ProperTextRange query = new ProperTextRange(start, end);
            Iterator i$ = this.myShreds.iterator();
            while (i$.hasNext()) {
                ProperTextRange textRange;
                PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)i$.next();
                Segment hostRange = shred.getHostRangeMarker();
                if (hostRange == null || !(textRange = ProperTextRange.create((Segment)hostRange)).contains((TextRange)query)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @Nullable
    public TextRange intersectWithEditable(@NotNull TextRange rangeToEdit) {
        if (rangeToEdit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeToEdit", "com/intellij/injected/editor/DocumentWindowImpl", "intersectWithEditable"));
        }
        int startOffset = -1;
        int endOffset = -1;
        Object object = this.myLock;
        synchronized (object) {
            int offset = 0;
            Iterator i$ = this.myShreds.iterator();
            while (i$.hasNext()) {
                int length;
                ProperTextRange intersection;
                PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)i$.next();
                Segment hostRange = shred.getHostRangeMarker();
                if (hostRange == null) continue;
                if ((intersection = new ProperTextRange(offset += shred.getPrefix().length(), offset + (length = hostRange.getEndOffset() - hostRange.getStartOffset())).intersection(rangeToEdit)) != null) {
                    if (startOffset == -1) {
                        startOffset = intersection.getStartOffset();
                    }
                    endOffset = intersection.getEndOffset();
                }
                offset += length;
                offset += shred.getSuffix().length();
            }
        }
        if (startOffset == -1) {
            return null;
        }
        return new ProperTextRange(startOffset, endOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] calculateMinEditSequence(String newText) {
        Object object = this.myLock;
        synchronized (object) {
            String[] result = new String[this.myShreds.size()];
            String hostText = this.myDelegate.getText();
            this.calculateMinEditSequence(hostText, newText, result, 0, result.length - 1);
            for (int i = 0; i < result.length; ++i) {
                String change = result[i];
                if (change == null) continue;
                String prefix = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getPrefix();
                String suffix = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getSuffix();
                assert (change.startsWith(prefix)) : change + "/" + prefix;
                assert (change.endsWith(suffix)) : change + "/" + suffix;
                result[i] = StringUtil.trimEnd((String)StringUtil.trimStart((String)change, (String)prefix), (String)suffix);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRangeText(@NotNull String hostText, int hostNum) {
        if (hostText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostText", "com/intellij/injected/editor/DocumentWindowImpl", "getRangeText"));
        }
        Object object = this.myLock;
        synchronized (object) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)this.myShreds.get(hostNum);
            Segment hostRangeMarker = shred.getHostRangeMarker();
            return shred.getPrefix() + (hostRangeMarker == null ? "" : hostText.substring(hostRangeMarker.getStartOffset(), hostRangeMarker.getEndOffset())) + shred.getSuffix();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateMinEditSequence(String hostText, String newText, String[] result, int i, int j) {
        Object object = this.myLock;
        synchronized (object) {
            String rangeText1 = this.getRangeText(hostText, i);
            if (i == j) {
                result[i] = rangeText1.equals(newText) ? null : newText;
                return;
            }
            if (StringUtil.startsWith((CharSequence)newText, (CharSequence)rangeText1)) {
                result[i] = null;
                this.calculateMinEditSequence(hostText, newText.substring(rangeText1.length()), result, i + 1, j);
                return;
            }
            String rangeText2 = this.getRangeText(hostText, j);
            if (StringUtil.endsWith((CharSequence)newText, (CharSequence)rangeText2)) {
                result[j] = null;
                this.calculateMinEditSequence(hostText, newText.substring(0, newText.length() - rangeText2.length()), result, i, j - 1);
                return;
            }
            if (i + 1 == j) {
                String commonPrefix;
                String suffix = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getSuffix();
                String prefix = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(j)).getPrefix();
                String separator = suffix + prefix;
                if (!separator.isEmpty()) {
                    int sep = newText.indexOf(separator);
                    assert (sep != -1);
                    result[i] = newText.substring(0, sep + suffix.length());
                    result[j] = newText.substring(sep + suffix.length() + prefix.length(), newText.length());
                    return;
                }
                result[i] = commonPrefix = StringUtil.commonPrefix((String)rangeText1, (String)newText);
                result[j] = newText.substring(commonPrefix.length());
                return;
            }
            String middleText = this.getRangeText(hostText, i + 1);
            int m = newText.indexOf(middleText);
            if (m != -1) {
                result[i] = newText.substring(0, m);
                result[i + 1] = null;
                this.calculateMinEditSequence(hostText, newText.substring(m + middleText.length(), newText.length()), result, i + 2, j);
                return;
            }
            middleText = this.getRangeText(hostText, j - 1);
            m = newText.lastIndexOf(middleText);
            if (m != -1) {
                result[j] = newText.substring(m + middleText.length());
                result[j - 1] = null;
                this.calculateMinEditSequence(hostText, newText.substring(0, m), result, i, j - 2);
                return;
            }
            result[i] = "";
            result[j] = "";
            this.calculateMinEditSequence(hostText, newText, result, i + 1, j - 1);
        }
    }

    public boolean areRangesEqual(@NotNull DocumentWindow otherd) {
        if (otherd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherd", "com/intellij/injected/editor/DocumentWindowImpl", "areRangesEqual"));
        }
        DocumentWindowImpl window = (DocumentWindowImpl)otherd;
        Place shreds = this.getShreds();
        Place otherShreds = window.getShreds();
        if (shreds.size() != otherShreds.size()) {
            return false;
        }
        for (int i = 0; i < shreds.size(); ++i) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)shreds.get(i);
            PsiLanguageInjectionHost.Shred otherShred = (PsiLanguageInjectionHost.Shred)otherShreds.get(i);
            if (!shred.getPrefix().equals(otherShred.getPrefix())) {
                return false;
            }
            if (!shred.getSuffix().equals(otherShred.getSuffix())) {
                return false;
            }
            Segment hostRange = shred.getHostRangeMarker();
            Segment other = otherShred.getHostRangeMarker();
            if (hostRange == null || other == null || hostRange.getStartOffset() != other.getStartOffset()) {
                return false;
            }
            if (hostRange.getEndOffset() == other.getEndOffset()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        PsiLanguageInjectionHost.Shred[] shreds;
        Object object = this.myLock;
        synchronized (object) {
            shreds = (PsiLanguageInjectionHost.Shred[])this.myShreds.toArray(new PsiLanguageInjectionHost.Shred[this.myShreds.size()]);
        }
        for (PsiLanguageInjectionHost.Shred shred : shreds) {
            if (shred.isValid()) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DocumentWindowImpl)) {
            return false;
        }
        DocumentWindowImpl window = (DocumentWindowImpl)o;
        return this.myDelegate.equals(window.getDelegate()) && this.areRangesEqual(window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.myLock;
        synchronized (object) {
            Segment hostRangeMarker = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getHostRangeMarker();
            return hostRangeMarker == null ? -1 : hostRangeMarker.getStartOffset();
        }
    }

    public boolean isOneLine() {
        return this.myOneLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myLock;
        synchronized (object) {
            this.myShreds.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShreds(@NotNull Place shreds) {
        if (shreds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shreds", "com/intellij/injected/editor/DocumentWindowImpl", "setShreds"));
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myShreds.dispose();
            this.myShreds = shreds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Place getShreds() {
        Object object = this.myLock;
        // MONITORENTER : object
        Place place = this.myShreds;
        // MONITOREXIT : object
        if (place != null) return place;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/DocumentWindowImpl", "getShreds"));
    }

    @Override
    @NotNull
    public List<RangeMarker> getGuardedBlocks() {
        List<RangeMarker> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/DocumentWindowImpl", "getGuardedBlocks"));
        }
        return list;
    }

    @Override
    public boolean processRangeMarkers(@NotNull Processor<RangeMarker> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/injected/editor/DocumentWindowImpl", "processRangeMarkers"));
        }
        return this.myDelegate.processRangeMarkers(processor);
    }

    @Override
    public boolean processRangeMarkersOverlappingWith(int start, int end, @NotNull Processor<RangeMarker> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/injected/editor/DocumentWindowImpl", "processRangeMarkersOverlappingWith"));
        }
        return this.myDelegate.processRangeMarkersOverlappingWith(start, end, processor);
    }

    private static class CachedText {
        private final String text;
        private final long modificationStamp;

        private CachedText(@NotNull String text, long modificationStamp) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/injected/editor/DocumentWindowImpl$CachedText", "<init>"));
            }
            this.text = text;
            this.modificationStamp = modificationStamp;
        }

        @NotNull
        private String getText() {
            String string = this.text;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/DocumentWindowImpl$CachedText", "getText"));
            }
            return string;
        }

        private long getModificationStamp() {
            return this.modificationStamp;
        }
    }
}

