/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.impl.EditorChangeAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Nullable;

public class DocumentUndoProvider
implements Disposable {
    private static final Key<Boolean> UNDOING_EDITOR_CHANGE = Key.create((String)"DocumentUndoProvider.UNDOING_EDITOR_CHANGE");
    private final Project myProject;

    DocumentUndoProvider(Project project) {
        MyEditorDocumentListener documentListener = new MyEditorDocumentListener();
        this.myProject = project;
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)documentListener, (Disposable)this);
    }

    public void dispose() {
    }

    private UndoManagerImpl getUndoManager() {
        return (UndoManagerImpl)(this.myProject == null ? UndoManager.getGlobalInstance() : UndoManager.getInstance((Project)this.myProject));
    }

    public static void startDocumentUndo(@Nullable Document doc) {
        if (doc != null) {
            doc.putUserData(UNDOING_EDITOR_CHANGE, (Object)Boolean.TRUE);
        }
    }

    public static void finishDocumentUndo(@Nullable Document doc) {
        if (doc != null) {
            doc.putUserData(UNDOING_EDITOR_CHANGE, null);
        }
    }

    private class MyEditorDocumentListener
    implements DocumentListener {
        private MyEditorDocumentListener() {
        }

        public void beforeDocumentChange(DocumentEvent e) {
            Document document = e.getDocument();
            if (this.shouldBeIgnored(document)) {
                return;
            }
            UndoManagerImpl undoManager = DocumentUndoProvider.this.getUndoManager();
            if (undoManager.isActive() && this.isUndoable(document) && (undoManager.isUndoInProgress() || undoManager.isRedoInProgress()) && document.getUserData(UNDOING_EDITOR_CHANGE) != Boolean.TRUE) {
                throw new IllegalStateException("Do not change documents during undo as it will break undo sequence.");
            }
        }

        public void documentChanged(DocumentEvent e) {
            Document document = e.getDocument();
            if (this.shouldBeIgnored(document)) {
                return;
            }
            UndoManagerImpl undoManager = DocumentUndoProvider.this.getUndoManager();
            if (undoManager.isActive() && this.isUndoable(document)) {
                this.registerUndoableAction(e);
            } else {
                this.registerNonUndoableAction(document);
            }
        }

        private boolean shouldBeIgnored(Document document) {
            return UndoManagerImpl.isCopy(document) || this.allEditorsAreViewersFor(document) || !this.shouldRecordActions(document);
        }

        private boolean shouldRecordActions(Document document) {
            if (document.getUserData(UndoConstants.DONT_RECORD_UNDO) == Boolean.TRUE) {
                return false;
            }
            VirtualFile vFile = FileDocumentManager.getInstance().getFile(document);
            return vFile == null || vFile.getUserData(UndoConstants.DONT_RECORD_UNDO) != Boolean.TRUE;
        }

        private boolean allEditorsAreViewersFor(Document document) {
            Editor[] editors = EditorFactory.getInstance().getEditors(document);
            if (editors.length == 0) {
                return false;
            }
            for (Editor editor : editors) {
                if (editor.isViewer()) continue;
                return false;
            }
            return true;
        }

        private void registerUndoableAction(DocumentEvent e) {
            DocumentUndoProvider.this.getUndoManager().undoableActionPerformed((UndoableAction)new EditorChangeAction(e));
        }

        private void registerNonUndoableAction(Document document) {
            DocumentReference ref = DocumentReferenceManager.getInstance().create(document);
            DocumentUndoProvider.this.getUndoManager().nonundoableActionPerformed(ref, false);
        }

        private boolean isUndoable(Document document) {
            if (!UndoManagerImpl.isRefresh()) {
                return true;
            }
            return DocumentUndoProvider.this.getUndoManager().isUndoOrRedoAvailable(DocumentReferenceManager.getInstance().create(document));
        }
    }
}

