/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.Patches;
import com.intellij.codeInsight.hint.DocumentFragmentTooltipRenderer;
import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.concurrency.JobScheduler;
import com.intellij.diagnostic.Dumpable;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DataManager;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.MouseGestureManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentFragment;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorDropHandler;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.EditorLinePainter;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.IndentGuideDescriptor;
import com.intellij.openapi.editor.IndentsModel;
import com.intellij.openapi.editor.LineExtensionInfo;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorTextInsertHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.ex.SoftWrapChangeListenerAdapter;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.impl.ArrowPainter;
import com.intellij.openapi.editor.impl.BorderEffect;
import com.intellij.openapi.editor.impl.CaretImpl;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.editor.impl.CharWidthCache;
import com.intellij.openapi.editor.impl.ColorProvider;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.ContextMenuImpl;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorGutterComponentImpl;
import com.intellij.openapi.editor.impl.EditorHighlighterCache;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.impl.EditorSizeAdjustmentStrategy;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.IndentsModelImpl;
import com.intellij.openapi.editor.impl.IterationState;
import com.intellij.openapi.editor.impl.LeftHandScrollbarLayout;
import com.intellij.openapi.editor.impl.ScrollingModelImpl;
import com.intellij.openapi.editor.impl.SelectionModelImpl;
import com.intellij.openapi.editor.impl.SettingsImpl;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.TextDrawingCallback;
import com.intellij.openapi.editor.impl.VisualSizeChangeListener;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDrawingType;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.TraceableDisposable;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.SideBorder;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.Processor;
import com.intellij.util.Producer;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntFunction;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIntHashMap;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TooManyListenersException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorImpl
extends UserDataHolderBase
implements EditorEx,
HighlighterClient,
Queryable,
Dumpable {
    private static final boolean isOracleRetina = UIUtil.isRetina() && SystemInfo.isOracleJvm;
    private static final int MIN_FONT_SIZE = 8;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.EditorImpl");
    private static final Key DND_COMMAND_KEY = Key.create((String)"DndCommand");
    @NonNls
    public static final Object IGNORE_MOUSE_TRACKING = "ignore_mouse_tracking";
    public static final Key<JComponent> PERMANENT_HEADER = Key.create((String)"PERMANENT_HEADER");
    public static final Key<Boolean> DO_DOCUMENT_UPDATE_TEST = Key.create((String)"DoDocumentUpdateTest");
    public static final Key<Boolean> FORCED_SOFT_WRAPS = Key.create((String)"forced.soft.wraps");
    private static final boolean HONOR_CAMEL_HUMPS_ON_TRIPLE_CLICK = Boolean.parseBoolean(System.getProperty("idea.honor.camel.humps.on.triple.click"));
    private static final Key<BufferedImage> BUFFER = Key.create((String)"buffer");
    public static final Color CURSOR_FOREGROUND_LIGHT = Gray._255;
    public static final Color CURSOR_FOREGROUND_DARK = Gray._0;
    @NotNull
    private final DocumentEx myDocument;
    private final JPanel myPanel;
    @NotNull
    private final JScrollPane myScrollPane;
    @NotNull
    private final EditorComponentImpl myEditorComponent;
    @NotNull
    private final EditorGutterComponentImpl myGutterComponent;
    private final TraceableDisposable myTraceableDisposable;
    private int myLinePaintersWidth;
    private final CommandProcessor myCommandProcessor;
    @NotNull
    private final MyScrollBar myVerticalScrollBar;
    private final List<EditorMouseListener> myMouseListeners;
    @NotNull
    private final List<EditorMouseMotionListener> myMouseMotionListeners;
    private int myCharHeight;
    private int myLineHeight;
    private int myDescent;
    private boolean myIsInsertMode;
    @NotNull
    private final CaretCursor myCaretCursor;
    private final ScrollingTimer myScrollingTimer;
    private final Object MOUSE_DRAGGED_GROUP;
    @NotNull
    private final SettingsImpl mySettings;
    private boolean isReleased;
    @Nullable
    private MouseEvent myMousePressedEvent;
    @Nullable
    private MouseEvent myMouseMovedEvent;
    @Nullable
    private EditorMouseEventArea myMousePressArea;
    private int mySavedSelectionStart;
    private int mySavedSelectionEnd;
    private int myLastColumnNumber;
    private final PropertyChangeSupport myPropertyChangeSupport;
    private MyEditable myEditable;
    @NotNull
    private EditorColorsScheme myScheme;
    private ArrowPainter myTabPainter;
    private final boolean myIsViewer;
    @NotNull
    private final SelectionModelImpl mySelectionModel;
    @NotNull
    private final EditorMarkupModelImpl myMarkupModel;
    @NotNull
    private final FoldingModelImpl myFoldingModel;
    @NotNull
    private final ScrollingModelImpl myScrollingModel;
    @NotNull
    private final CaretModelImpl myCaretModel;
    @NotNull
    private final SoftWrapModelImpl mySoftWrapModel;
    @NotNull
    private static final RepaintCursorCommand ourCaretBlinkingCommand;
    private MessageBusConnection myConnection;
    private int myMouseSelectionState;
    @Nullable
    private FoldRegion myMouseSelectedRegion;
    private static final int MOUSE_SELECTION_STATE_NONE = 0;
    private static final int MOUSE_SELECTION_STATE_WORD_SELECTED = 1;
    private static final int MOUSE_SELECTION_STATE_LINE_SELECTED = 2;
    private EditorHighlighter myHighlighter;
    private Disposable myHighlighterDisposable;
    private final TextDrawingCallback myTextDrawingCallback;
    private int myScrollBarOrientation;
    private boolean myMousePressedInsideSelection;
    private FontMetrics myPlainFontMetrics;
    private FontMetrics myBoldFontMetrics;
    private FontMetrics myItalicFontMetrics;
    private FontMetrics myBoldItalicFontMetrics;
    private static final int CACHED_CHARS_BUFFER_SIZE = 300;
    private final ArrayList<CachedFontContent> myFontCache;
    @Nullable
    private FontInfo myCurrentFontType;
    private final EditorSizeContainer mySizeContainer;
    private boolean myUpdateCursor;
    private int myCaretUpdateVShift;
    @Nullable
    private final Project myProject;
    private long myMouseSelectionChangeTimestamp;
    private int mySavedCaretOffsetForDNDUndoHack;
    private final List<FocusChangeListener> myFocusListeners;
    private MyInputMethodHandler myInputMethodRequestsHandler;
    private InputMethodRequests myInputMethodRequestsSwingWrapper;
    private boolean myIsOneLineMode;
    private boolean myIsRendererMode;
    private VirtualFile myVirtualFile;
    private boolean myIsColumnMode;
    @Nullable
    private Color myForcedBackground;
    @Nullable
    private Dimension myPreferredSize;
    private int myVirtualPageHeight;
    private Alarm myAppleRepaintAlarm;
    private final Alarm myMouseSelectionStateAlarm;
    private Runnable myMouseSelectionStateResetRunnable;
    private boolean myEmbeddedIntoDialogWrapper;
    @Nullable
    private CachedFontContent myLastCache;
    private int myDragOnGutterSelectionStartLine;
    private RangeMarker myDraggedRange;
    private boolean mySoftWrapsChanged;
    private VisualPosition mySelectionStartPosition;
    private VisualPosition mySelectionEndPosition;
    private Color myLastBackgroundColor;
    private Point myLastBackgroundPosition;
    private int myLastBackgroundWidth;
    private static final boolean ourIsUnitTestMode;
    @NotNull
    private final JPanel myHeaderPanel;
    @Nullable
    private MouseEvent myInitialMouseEvent;
    private boolean myIgnoreMouseEventsConsecutiveToInitial;
    private EditorDropHandler myDropHandler;
    private char[] myPrefixText;
    private TextAttributes myPrefixAttributes;
    private int myPrefixWidthInPixels;
    @NotNull
    private final IndentsModel myIndentsModel;
    @Nullable
    private CharSequence myPlaceholderText;
    private int myLastPaintedPlaceholderWidth;
    private boolean myShowPlaceholderWhenFocused;
    private boolean myStickySelection;
    private int myStickySelectionStart;
    private boolean myScrollToCaret;
    private boolean myPurePaintingMode;
    private boolean myPaintSelection;
    private final EditorSizeAdjustmentStrategy mySizeAdjustmentStrategy;
    private final Disposable myDisposable;
    private List<CaretState> myCaretStateBeforeLastPress;
    private LogicalPosition myLastMousePressedLocation;
    private VisualPosition myTargetMultiSelectionPosition;
    private boolean myMultiSelectionInProgress;
    private boolean myRectangularSelectionInProgress;
    private boolean myLastPressCreatedCaret;
    private boolean myCurrentDragIsSubstantial;
    private CaretImpl myPrimaryCaret;
    private final boolean myDisableRtl;
    private final TIntFunction myLineNumberAreaWidthFunction;
    private final int[] myLastStartOffsets;
    private final int[] myLastTargetColumns;
    private final int[] myLastXOffsets;
    private final int[] myLastXs;
    private int myCurrentCachePosition;
    private int myLastCacheHits;
    private int myTotalRequests;
    private boolean updatingSize;
    private static final char IDEOGRAPHIC_SPACE = '\u3000';
    private static final String WHITESPACE_CHARS = " \t\u3000";
    private static final Field decrButtonField;
    private static final Field incrButtonField;
    private static final TooltipGroup FOLDING_TOOLTIP_GROUP;
    private static final WhitespacePaintingStrategy PAINT_NO_WHITESPACE;

    EditorImpl(@NotNull Document document, boolean viewer, @Nullable Project project) {
        boolean forceSoftWraps;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/EditorImpl", "<init>"));
        }
        this.myTraceableDisposable = new TraceableDisposable(new Throwable());
        this.myLinePaintersWidth = 0;
        this.myMouseListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myMouseMotionListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myCharHeight = -1;
        this.myLineHeight = -1;
        this.myDescent = -1;
        this.myIsInsertMode = true;
        this.myScrollingTimer = new ScrollingTimer();
        this.MOUSE_DRAGGED_GROUP = new String("MouseDraggedGroup");
        this.isReleased = false;
        this.myMousePressedEvent = null;
        this.myMouseMovedEvent = null;
        this.mySavedSelectionStart = -1;
        this.mySavedSelectionEnd = -1;
        this.myLastColumnNumber = 0;
        this.myPropertyChangeSupport = new PropertyChangeSupport(this);
        this.myMouseSelectionState = 0;
        this.myMouseSelectedRegion = null;
        this.myHighlighterDisposable = Disposer.newDisposable();
        this.myTextDrawingCallback = new MyTextDrawingCallback();
        this.myFontCache = new ArrayList();
        this.myCurrentFontType = null;
        this.mySizeContainer = new EditorSizeContainer();
        this.myFocusListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myIsColumnMode = false;
        this.myForcedBackground = null;
        this.myMouseSelectionStateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myDragOnGutterSelectionStartLine = -1;
        this.myLastBackgroundColor = null;
        this.myLastBackgroundPosition = null;
        this.myScrollToCaret = true;
        this.mySizeAdjustmentStrategy = new EditorSizeAdjustmentStrategy();
        this.myDisposable = Disposer.newDisposable();
        this.myDisableRtl = Registry.is((String)"editor.disable.rtl");
        this.myLineNumberAreaWidthFunction = new TIntFunction(){

            public int execute(int lineNumber) {
                return EditorImpl.this.getFontMetrics(0).stringWidth(Integer.toString(lineNumber + 1)) + 5;
            }
        };
        this.myLastStartOffsets = new int[2];
        this.myLastTargetColumns = new int[this.myLastStartOffsets.length];
        this.myLastXOffsets = new int[this.myLastStartOffsets.length];
        this.myLastXs = new int[this.myLastStartOffsets.length];
        EditorImpl.assertIsDispatchThread();
        this.myProject = project;
        this.myDocument = (DocumentEx)document;
        if (this.myDocument instanceof DocumentImpl) {
            ((DocumentImpl)this.myDocument).requestTabTracking();
        }
        this.myScheme = this.createBoundColorSchemeDelegate(null);
        this.initTabPainter();
        this.myIsViewer = viewer;
        this.mySettings = new SettingsImpl(this, project);
        boolean bl = forceSoftWraps = !this.mySettings.isUseSoftWraps() && EditorImpl.shouldSoftWrapsBeForced(this.myDocument);
        if (forceSoftWraps) {
            this.mySettings.setUseSoftWrapsQuiet();
            this.putUserData(FORCED_SOFT_WRAPS, Boolean.TRUE);
        }
        this.mySelectionModel = new SelectionModelImpl(this);
        this.myMarkupModel = new EditorMarkupModelImpl(this);
        this.myFoldingModel = new FoldingModelImpl(this);
        this.myCaretModel = new CaretModelImpl(this);
        this.mySoftWrapModel = new SoftWrapModelImpl(this);
        this.mySizeContainer.reset();
        this.myCommandProcessor = CommandProcessor.getInstance();
        if (project != null) {
            this.myConnection = project.getMessageBus().connect();
            this.myConnection.subscribe(DocumentBulkUpdateListener.TOPIC, (Object)new EditorDocumentBulkUpdateAdapter());
        }
        MarkupModelListener markupModelListener = new MarkupModelListener(){

            private boolean areRenderersInvolved(@NotNull RangeHighlighterEx highlighter) {
                if (highlighter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/impl/EditorImpl$2", "areRenderersInvolved"));
                }
                return highlighter.getCustomRenderer() != null || highlighter.getGutterIconRenderer() != null || highlighter.getLineMarkerRenderer() != null || highlighter.getLineSeparatorRenderer() != null;
            }

            @Override
            public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
                if (highlighter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/impl/EditorImpl$2", "afterAdded"));
                }
                this.attributesChanged(highlighter, this.areRenderersInvolved(highlighter));
            }

            @Override
            public void beforeRemoved(@NotNull RangeHighlighterEx highlighter) {
                if (highlighter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/impl/EditorImpl$2", "beforeRemoved"));
                }
                this.attributesChanged(highlighter, this.areRenderersInvolved(highlighter));
            }

            @Override
            public void attributesChanged(@NotNull RangeHighlighterEx highlighter, boolean renderersChanged) {
                if (highlighter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/impl/EditorImpl$2", "attributesChanged"));
                }
                if (EditorImpl.this.myDocument.isInBulkUpdate()) {
                    return;
                }
                int textLength = EditorImpl.this.myDocument.getTextLength();
                EditorImpl.this.clearTextWidthCache();
                int start = Math.min(Math.max(highlighter.getAffectedAreaStartOffset(), 0), textLength);
                int end = Math.min(Math.max(highlighter.getAffectedAreaEndOffset(), 0), textLength);
                int startLine = start == -1 ? 0 : EditorImpl.this.myDocument.getLineNumber(start);
                int endLine = end == -1 ? EditorImpl.this.myDocument.getLineCount() : EditorImpl.this.myDocument.getLineNumber(end);
                EditorImpl.this.repaintLines(Math.max(0, startLine - 1), Math.min(endLine + 1, EditorImpl.this.getDocument().getLineCount()));
                if (renderersChanged || highlighter.getErrorStripeMarkColor() != null) {
                    ((EditorMarkupModelImpl)EditorImpl.this.getMarkupModel()).repaint(start, end);
                }
                if (renderersChanged) {
                    EditorImpl.this.updateGutterSize();
                }
                EditorImpl.this.updateCaretCursor();
            }
        };
        ((MarkupModelEx)DocumentMarkupModel.forDocument(this.myDocument, this.myProject, true)).addMarkupModelListener(this.myCaretModel, markupModelListener);
        this.getMarkupModel().addMarkupModelListener(this.myCaretModel, markupModelListener);
        this.myDocument.addDocumentListener(this.myFoldingModel, this.myCaretModel);
        this.myDocument.addDocumentListener(this.myCaretModel, this.myCaretModel);
        this.myDocument.addDocumentListener(this.mySelectionModel, this.myCaretModel);
        this.myDocument.addDocumentListener(new EditorDocumentAdapter(), this.myCaretModel);
        this.myDocument.addDocumentListener(this.mySoftWrapModel, this.myCaretModel);
        this.myFoldingModel.addListener(this.mySoftWrapModel, this.myCaretModel);
        this.myIndentsModel = new IndentsModelImpl(this);
        this.myCaretModel.addCaretListener(new CaretListener(){
            @Nullable
            private LightweightHint myCurrentHint = null;
            @Nullable
            private IndentGuideDescriptor myCurrentCaretGuide = null;

            public void caretPositionChanged(CaretEvent e) {
                IndentGuideDescriptor newGuide;
                if (EditorImpl.this.myStickySelection) {
                    int selectionStart = Math.min(EditorImpl.this.myStickySelectionStart, EditorImpl.this.getDocument().getTextLength() - 1);
                    EditorImpl.this.mySelectionModel.setSelection(selectionStart, EditorImpl.this.myCaretModel.getVisualPosition(), EditorImpl.this.myCaretModel.getOffset());
                }
                if (!Comparing.equal((Object)this.myCurrentCaretGuide, (Object)(newGuide = EditorImpl.this.myIndentsModel.getCaretIndentGuide()))) {
                    EditorImpl.this.repaintGuide(newGuide);
                    EditorImpl.this.repaintGuide(this.myCurrentCaretGuide);
                    this.myCurrentCaretGuide = newGuide;
                    if (this.myCurrentHint != null) {
                        this.myCurrentHint.hide();
                        this.myCurrentHint = null;
                    }
                    if (newGuide != null) {
                        Rectangle visibleArea = EditorImpl.this.getScrollingModel().getVisibleArea();
                        int line = newGuide.startLine;
                        if (EditorImpl.this.logicalLineToY(line) < visibleArea.y) {
                            TextRange textRange = new TextRange(EditorImpl.this.myDocument.getLineStartOffset(line), EditorImpl.this.myDocument.getLineEndOffset(line));
                            this.myCurrentHint = EditorFragmentComponent.showEditorFragmentHint(EditorImpl.this, textRange, false, false);
                        }
                    }
                }
            }

            public void caretAdded(CaretEvent e) {
                if (EditorImpl.this.myPrimaryCaret != null) {
                    EditorImpl.this.myPrimaryCaret.updateVisualPosition();
                }
                EditorImpl.this.repaintCaretRegion(e);
                EditorImpl.this.myPrimaryCaret = EditorImpl.this.myCaretModel.getPrimaryCaret();
            }

            public void caretRemoved(CaretEvent e) {
                EditorImpl.this.repaintCaretRegion(e);
                EditorImpl.this.myPrimaryCaret = EditorImpl.this.myCaretModel.getPrimaryCaret();
                EditorImpl.this.myPrimaryCaret.updateVisualPosition();
            }
        });
        this.myCaretCursor = new CaretCursor();
        this.myFoldingModel.flushCaretShift();
        this.myScrollBarOrientation = 1;
        this.mySoftWrapModel.addSoftWrapChangeListener(new SoftWrapChangeListenerAdapter(){

            @Override
            public void recalculationEnds() {
                if (EditorImpl.this.myCaretModel.isUpToDate()) {
                    EditorImpl.this.myCaretModel.updateVisualPosition();
                }
            }

            @Override
            public void softWrapsChanged() {
                EditorImpl.this.mySoftWrapsChanged = true;
            }
        });
        this.mySoftWrapModel.addVisualSizeChangeListener(new VisualSizeChangeListener(){

            @Override
            public void onLineWidthsChange(int startLine, int oldEndLine, int newEndLine, @NotNull TIntIntHashMap lineWidths) {
                if (lineWidths == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineWidths", "com/intellij/openapi/editor/impl/EditorImpl$5", "onLineWidthsChange"));
                }
                EditorImpl.this.mySizeContainer.update(startLine, newEndLine, oldEndLine);
                for (int i = startLine; i <= newEndLine; ++i) {
                    int width;
                    if (!lineWidths.contains(i) || (width = lineWidths.get(i)) < 0) continue;
                    EditorImpl.this.mySizeContainer.updateLineWidthIfNecessary(i, width);
                }
            }
        });
        EmptyEditorHighlighter highlighter = new EmptyEditorHighlighter(this.myScheme.getAttributes(HighlighterColors.TEXT));
        this.setHighlighter(highlighter);
        this.myEditorComponent = new EditorComponentImpl(this);
        this.myScrollPane = new MyScrollPane();
        this.myVerticalScrollBar = (MyScrollBar)((Object)this.myScrollPane.getVerticalScrollBar());
        this.myVerticalScrollBar.setOpaque(false);
        this.myPanel = new JPanel();
        UIUtil.putClientProperty((JComponent)this.myPanel, (Key)JBSwingUtilities.NOT_IN_HIERARCHY_COMPONENTS, (Object)new Iterable<JComponent>(){

            @Override
            public Iterator<JComponent> iterator() {
                JComponent component = EditorImpl.this.getPermanentHeaderComponent();
                if (component != null && !component.isValid()) {
                    return Collections.singleton(component).iterator();
                }
                return ContainerUtil.emptyIterator();
            }
        });
        this.myHeaderPanel = new MyHeaderPanel();
        this.myGutterComponent = new EditorGutterComponentImpl(this);
        this.initComponent();
        this.myScrollingModel = new ScrollingModelImpl(this);
        if (UISettings.getInstance().PRESENTATION_MODE) {
            this.setFontSize(UISettings.getInstance().PRESENTATION_MODE_FONT_SIZE);
        }
        this.myGutterComponent.setLineNumberAreaWidthFunction(this.myLineNumberAreaWidthFunction);
        this.myGutterComponent.updateSize();
        Dimension preferredSize = this.getPreferredSize();
        this.myEditorComponent.setSize(preferredSize);
        if (Patches.APPLE_BUG_ID_3716835) {
            this.myScrollingModel.addVisibleAreaListener(new VisibleAreaListener(){

                public void visibleAreaChanged(VisibleAreaEvent e) {
                    if (EditorImpl.this.myAppleRepaintAlarm == null) {
                        EditorImpl.this.myAppleRepaintAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
                    }
                    EditorImpl.this.myAppleRepaintAlarm.cancelAllRequests();
                    EditorImpl.this.myAppleRepaintAlarm.addRequest(new Runnable(){

                        @Override
                        public void run() {
                            EditorImpl.this.repaint(0, EditorImpl.this.myDocument.getTextLength());
                        }
                    }, 50, ModalityState.stateForComponent((Component)EditorImpl.this.myEditorComponent));
                }
            });
        }
        this.updateCaretCursor();
        if (!ourIsUnitTestMode) {
            UiNotifyConnector.doWhenFirstShown((JComponent)this.myEditorComponent, (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!EditorImpl.this.isDisposed() && !EditorImpl.this.myScrollingModel.isScrollingNow()) {
                        EditorImpl.this.myScrollingModel.disableAnimation();
                        EditorImpl.this.myScrollingModel.scrollHorizontally(0);
                        EditorImpl.this.myScrollingModel.enableAnimation();
                    }
                }
            });
        }
    }

    private static boolean shouldSoftWrapsBeForced(Document document) {
        int lineWidthLimit = Registry.intValue((String)"editor.soft.wrap.force.limit");
        for (int i = 0; i < document.getLineCount(); ++i) {
            if (document.getLineEndOffset(i) - document.getLineStartOffset(i) <= lineWidthLimit) continue;
            return true;
        }
        return false;
    }

    @NotNull
    static Color adjustThumbColor(@NotNull Color base, boolean dark) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/openapi/editor/impl/EditorImpl", "adjustThumbColor"));
        }
        Color color = dark ? ColorUtil.withAlpha((Color)ColorUtil.shift((Color)base, (double)1.35), (double)0.5) : ColorUtil.withAlpha((Color)ColorUtil.shift((Color)base, (double)0.68), (double)0.4);
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "adjustThumbColor"));
        }
        return color;
    }

    boolean isDarkEnough() {
        return ColorUtil.isDark((Color)this.getBackgroundColor());
    }

    private void repaintCaretRegion(CaretEvent e) {
        CaretImpl caretImpl = (CaretImpl)e.getCaret();
        if (caretImpl != null) {
            caretImpl.updateVisualPosition();
            if (caretImpl.hasSelection()) {
                this.repaint(caretImpl.getSelectionStart(), caretImpl.getSelectionEnd());
            }
        }
    }

    @Override
    @NotNull
    public EditorColorsScheme createBoundColorSchemeDelegate(@Nullable EditorColorsScheme customGlobalScheme) {
        MyColorSchemeDelegate myColorSchemeDelegate = new MyColorSchemeDelegate(customGlobalScheme);
        if (myColorSchemeDelegate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "createBoundColorSchemeDelegate"));
        }
        return myColorSchemeDelegate;
    }

    private void repaintGuide(@Nullable IndentGuideDescriptor guide) {
        if (guide != null) {
            this.repaintLines(guide.startLine, guide.endLine);
        }
    }

    @Override
    public int getPrefixTextWidthInPixels() {
        return this.myPrefixWidthInPixels;
    }

    @Override
    public void setPrefixTextAndAttributes(@Nullable String prefixText, @Nullable TextAttributes attributes) {
        this.myPrefixText = prefixText == null ? null : prefixText.toCharArray();
        this.myPrefixAttributes = attributes;
        this.myPrefixWidthInPixels = 0;
        if (this.myPrefixText != null) {
            for (char c : this.myPrefixText) {
                LOG.assertTrue(this.myPrefixAttributes != null);
                if (this.myPrefixAttributes == null) continue;
                this.myPrefixWidthInPixels += EditorUtil.charWidth(c, this.myPrefixAttributes.getFontType(), this);
            }
        }
        this.mySoftWrapModel.recalculate();
    }

    @Override
    public boolean isPurePaintingMode() {
        return this.myPurePaintingMode;
    }

    @Override
    public void setPurePaintingMode(boolean enabled) {
        this.myPurePaintingMode = enabled;
    }

    @Override
    public void registerScrollBarRepaintCallback(@Nullable ButtonlessScrollBarUI.ScrollbarRepaintCallback callback) {
        this.myVerticalScrollBar.registerRepaintCallback(callback);
    }

    public boolean isViewer() {
        return this.myIsViewer || this.myIsRendererMode;
    }

    @Override
    public boolean isRendererMode() {
        return this.myIsRendererMode;
    }

    @Override
    public void setRendererMode(boolean isRendererMode) {
        this.myIsRendererMode = isRendererMode;
    }

    @Override
    public void setFile(VirtualFile vFile) {
        this.myVirtualFile = vFile;
        this.reinitSettings();
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    @Override
    public void setSoftWrapAppliancePlace(@NotNull SoftWrapAppliancePlaces place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/openapi/editor/impl/EditorImpl", "setSoftWrapAppliancePlace"));
        }
        this.getSoftWrapModel().setPlace(place);
        this.mySettings.setSoftWrapAppliancePlace(place);
    }

    @NotNull
    public SelectionModelImpl getSelectionModel() {
        SelectionModelImpl selectionModelImpl = this.mySelectionModel;
        if (selectionModelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getSelectionModel"));
        }
        return selectionModelImpl;
    }

    @Override
    @NotNull
    public MarkupModelEx getMarkupModel() {
        EditorMarkupModelImpl editorMarkupModelImpl = this.myMarkupModel;
        if (editorMarkupModelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getMarkupModel"));
        }
        return editorMarkupModelImpl;
    }

    @Override
    @NotNull
    public FoldingModelImpl getFoldingModel() {
        FoldingModelImpl foldingModelImpl = this.myFoldingModel;
        if (foldingModelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getFoldingModel"));
        }
        return foldingModelImpl;
    }

    @NotNull
    public CaretModelImpl getCaretModel() {
        CaretModelImpl caretModelImpl = this.myCaretModel;
        if (caretModelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getCaretModel"));
        }
        return caretModelImpl;
    }

    @Override
    @NotNull
    public ScrollingModelEx getScrollingModel() {
        ScrollingModelImpl scrollingModelImpl = this.myScrollingModel;
        if (scrollingModelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getScrollingModel"));
        }
        return scrollingModelImpl;
    }

    @Override
    @NotNull
    public SoftWrapModelImpl getSoftWrapModel() {
        SoftWrapModelImpl softWrapModelImpl = this.mySoftWrapModel;
        if (softWrapModelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getSoftWrapModel"));
        }
        return softWrapModelImpl;
    }

    @NotNull
    public EditorSettings getSettings() {
        EditorImpl.assertReadAccess();
        SettingsImpl settingsImpl = this.mySettings;
        if (settingsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getSettings"));
        }
        return settingsImpl;
    }

    public void resetSizes() {
        this.mySizeContainer.reset();
    }

    @Override
    public void reinitSettings() {
        EditorImpl.assertIsDispatchThread();
        this.clearSettingsCache();
        this.reinitDocumentIndentOptions();
        EditorColorsScheme scheme = this.myScheme;
        while (scheme instanceof DelegateColorScheme) {
            if (scheme instanceof MyColorSchemeDelegate) {
                ((MyColorSchemeDelegate)scheme).updateGlobalScheme();
                break;
            }
            scheme = ((DelegateColorScheme)scheme).getDelegate();
        }
        boolean softWrapsUsedBefore = this.mySoftWrapModel.isSoftWrappingEnabled();
        this.mySettings.reinitSettings();
        this.mySoftWrapModel.reinitSettings();
        this.myCaretModel.reinitSettings();
        this.mySelectionModel.reinitSettings();
        EditorImpl.ourCaretBlinkingCommand.setBlinkCaret(this.mySettings.isBlinkCaret());
        EditorImpl.ourCaretBlinkingCommand.setBlinkPeriod(this.mySettings.getCaretBlinkPeriod());
        this.mySizeContainer.reset();
        this.myFoldingModel.rebuild();
        if (softWrapsUsedBefore ^ this.mySoftWrapModel.isSoftWrappingEnabled()) {
            this.mySizeContainer.reset();
            this.validateSize();
        }
        this.myHighlighter.setColorScheme(this.myScheme);
        this.myFoldingModel.refreshSettings();
        this.myGutterComponent.reinitSettings();
        this.myGutterComponent.revalidate();
        this.myEditorComponent.repaint();
        this.initTabPainter();
        this.updateCaretCursor();
        if (this.myInitialMouseEvent != null) {
            this.myIgnoreMouseEventsConsecutiveToInitial = true;
        }
        this.myCaretModel.updateVisualPosition();
        for (Caret caret : this.getCaretModel().getAllCarets()) {
            caret.moveToOffset(caret.getOffset());
        }
    }

    private void clearSettingsCache() {
        this.myCharHeight = -1;
        this.myLineHeight = -1;
        this.myDescent = -1;
        this.myPlainFontMetrics = null;
        this.clearTextWidthCache();
    }

    private void reinitDocumentIndentOptions() {
        if (this.myProject != null && !this.myProject.isDisposed()) {
            CodeStyleSettingsManager.updateDocumentIndentOptions((Project)this.myProject, (Document)this.myDocument);
        }
    }

    private void initTabPainter() {
        this.myTabPainter = new ArrowPainter(ColorProvider.byColorsScheme(this.myScheme, EditorColors.WHITESPACES_COLOR), (Computable<Integer>)new Computable.PredefinedValueComputable((Object)EditorUtil.getSpaceWidth(0, this)), new Computable<Integer>(){

            public Integer compute() {
                return EditorImpl.this.getCharHeight();
            }
        });
    }

    public void throwDisposalError(@NonNls @NotNull String msg) {
        if (msg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/intellij/openapi/editor/impl/EditorImpl", "throwDisposalError"));
        }
        this.myTraceableDisposable.throwDisposalError(msg);
    }

    public void release() {
        EditorImpl.assertIsDispatchThread();
        if (this.isReleased) {
            this.throwDisposalError("Double release of editor:");
        }
        this.myTraceableDisposable.kill(null);
        this.isReleased = true;
        this.clearSettingsCache();
        this.myFoldingModel.dispose();
        this.mySoftWrapModel.release();
        this.myMarkupModel.dispose();
        this.myScrollingModel.dispose();
        this.myGutterComponent.dispose();
        this.myMousePressedEvent = null;
        this.myMouseMovedEvent = null;
        Disposer.dispose((Disposable)this.myCaretModel);
        Disposer.dispose((Disposable)this.mySoftWrapModel);
        this.clearCaretThread();
        this.myFocusListeners.clear();
        this.myMouseListeners.clear();
        this.myMouseMotionListeners.clear();
        if (this.myConnection != null) {
            this.myConnection.disconnect();
        }
        if (this.myDocument instanceof DocumentImpl) {
            ((DocumentImpl)this.myDocument).giveUpTabTracking();
        }
        Disposer.dispose((Disposable)this.myDisposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCaretThread() {
        RepaintCursorCommand repaintCursorCommand = ourCaretBlinkingCommand;
        synchronized (repaintCursorCommand) {
            if (ourCaretBlinkingCommand.myEditor == this) {
                ourCaretBlinkingCommand.myEditor = null;
            }
        }
    }

    private void initComponent() {
        this.myPanel.setLayout(new BorderLayout());
        this.myPanel.add((Component)this.myHeaderPanel, "North");
        this.myGutterComponent.setOpaque(true);
        this.myScrollPane.setViewportView(this.myEditorComponent);
        this.myScrollPane.setVerticalScrollBarPolicy(22);
        this.myScrollPane.setHorizontalScrollBarPolicy(30);
        this.myScrollPane.setRowHeaderView(this.myGutterComponent);
        this.myEditorComponent.setTransferHandler(new MyTransferHandler());
        this.myEditorComponent.setAutoscrolls(true);
        if (this.mayShowToolbar()) {
            JBLayeredPane layeredPane = new JBLayeredPane(){

                public void doLayout() {
                    Component[] components = this.getComponents();
                    Rectangle r = this.getBounds();
                    for (Component c : components) {
                        if (c instanceof JScrollPane) {
                            c.setBounds(0, 0, r.width, r.height);
                            continue;
                        }
                        Dimension d = c.getPreferredSize();
                        MyScrollBar scrollBar = EditorImpl.this.getVerticalScrollBar();
                        c.setBounds(r.width - d.width - scrollBar.getWidth() - 30, 20, d.width, d.height);
                    }
                }
            };
            layeredPane.add((Component)this.myScrollPane, JLayeredPane.DEFAULT_LAYER);
            this.myPanel.add((Component)layeredPane);
            new ContextMenuImpl((JLayeredPane)layeredPane, this.myScrollPane, this);
        } else {
            this.myPanel.add(this.myScrollPane);
        }
        this.myEditorComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(@NotNull KeyEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/EditorImpl$11", "keyTyped"));
                }
                if (Patches.APPLE_BUG_ID_3337563) {
                    return;
                }
                if (event.isConsumed()) {
                    return;
                }
                if (EditorImpl.this.processKeyTyped(event)) {
                    event.consume();
                }
            }
        });
        MyMouseAdapter mouseAdapter = new MyMouseAdapter();
        this.myEditorComponent.addMouseListener(mouseAdapter);
        this.myGutterComponent.addMouseListener(mouseAdapter);
        MyMouseMotionListener mouseMotionListener = new MyMouseMotionListener();
        this.myEditorComponent.addMouseMotionListener(mouseMotionListener);
        this.myGutterComponent.addMouseMotionListener(mouseMotionListener);
        this.myEditorComponent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(@NotNull FocusEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$12", "focusGained"));
                }
                EditorImpl.this.myCaretCursor.activate();
                for (Caret caret : EditorImpl.this.myCaretModel.getAllCarets()) {
                    int caretLine = caret.getLogicalPosition().line;
                    EditorImpl.this.repaintLines(caretLine, caretLine);
                }
                EditorImpl.this.fireFocusGained();
            }

            @Override
            public void focusLost(@NotNull FocusEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$12", "focusLost"));
                }
                EditorImpl.this.clearCaretThread();
                for (Caret caret : EditorImpl.this.myCaretModel.getAllCarets()) {
                    int caretLine = caret.getLogicalPosition().line;
                    EditorImpl.this.repaintLines(caretLine, caretLine);
                }
                EditorImpl.this.fireFocusLost();
            }
        });
        UiNotifyConnector connector = new UiNotifyConnector((Component)this.myEditorComponent, (Activatable)new Activatable.Adapter(){

            public void showNotify() {
                EditorImpl.this.myGutterComponent.updateSize();
            }
        });
        Disposer.register((Disposable)this.getDisposable(), (Disposable)connector);
        try {
            DropTarget dropTarget = this.myEditorComponent.getDropTarget();
            if (dropTarget != null) {
                dropTarget.addDropTargetListener(new DropTargetAdapter(){

                    @Override
                    public void drop(@NotNull DropTargetDropEvent e) {
                        if (e == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$14", "drop"));
                        }
                    }

                    @Override
                    public void dragOver(@NotNull DropTargetDragEvent e) {
                        if (e == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$14", "dragOver"));
                        }
                        Point location = e.getLocation();
                        EditorImpl.this.getCaretModel().moveToLogicalPosition(EditorImpl.this.getLogicalPositionForScreenPos(location.x, location.y, true));
                        EditorImpl.this.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                    }
                });
            }
        }
        catch (TooManyListenersException e) {
            LOG.error((Throwable)e);
        }
        this.myPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(@NotNull ComponentEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$15", "componentResized"));
                }
                EditorImpl.this.myMarkupModel.recalcEditorDimensions();
                EditorImpl.this.myMarkupModel.repaint(-1, -1);
            }
        });
    }

    private boolean mayShowToolbar() {
        return !this.isEmbeddedIntoDialogWrapper() && !this.isOneLineMode() && ContextMenuImpl.mayShowToolbar(this.myDocument);
    }

    @Override
    public void setFontSize(int fontSize) {
        this.setFontSize(fontSize, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFontSize(int fontSize, @Nullable Point zoomCenter) {
        int oldFontSize = this.myScheme.getEditorFontSize();
        Rectangle visibleArea = this.myScrollingModel.getVisibleArea();
        Point zoomCenterRelative = zoomCenter == null ? new Point() : zoomCenter;
        Point zoomCenterAbsolute = new Point(visibleArea.x + zoomCenterRelative.x, visibleArea.y + zoomCenterRelative.y);
        LogicalPosition zoomCenterLogical = this.xyToLogicalPosition(zoomCenterAbsolute).withoutVisualPositionInfo();
        int oldLineHeight = this.getLineHeight();
        int intraLineOffset = zoomCenterAbsolute.y % oldLineHeight;
        this.myScheme.setEditorFontSize(fontSize);
        this.myPropertyChangeSupport.firePropertyChange("fontSize", oldFontSize, fontSize);
        this.myScrollPane.getViewport().invalidate();
        Point shiftedZoomCenterAbsolute = this.logicalPositionToXY(zoomCenterLogical);
        this.myScrollingModel.disableAnimation();
        try {
            this.myScrollingModel.scrollToOffsets(visibleArea.x == 0 ? 0 : shiftedZoomCenterAbsolute.x - zoomCenterRelative.x, shiftedZoomCenterAbsolute.y - zoomCenterRelative.y + (intraLineOffset * this.getLineHeight() + oldLineHeight / 2) / oldLineHeight);
        }
        finally {
            this.myScrollingModel.enableAnimation();
        }
    }

    public int getFontSize() {
        return this.myScheme.getEditorFontSize();
    }

    @NotNull
    public ActionCallback type(final @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/EditorImpl", "type"));
        }
        final ActionCallback result = new ActionCallback();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < text.length(); ++i) {
                    if (EditorImpl.this.processKeyTyped(text.charAt(i))) continue;
                    result.setRejected();
                    return;
                }
                result.setDone();
            }
        });
        ActionCallback actionCallback = result;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "type"));
        }
        return actionCallback;
    }

    private boolean processKeyTyped(char c) {
        IdeEventQueue queue = IdeEventQueue.getInstance();
        if (queue.shouldNotTypeInEditor() || ProgressManager.getInstance().hasModalProgressIndicator()) {
            return false;
        }
        FileDocumentManager manager = FileDocumentManager.getInstance();
        VirtualFile file = manager.getFile((Document)this.myDocument);
        if (file != null && !file.isValid()) {
            return false;
        }
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        DataContext dataContext = this.getDataContext();
        actionManager.fireBeforeEditorTyping(c, dataContext);
        MacUIUtil.hideCursor();
        EditorActionManager.getInstance().getTypedAction().actionPerformed((Editor)this, c, dataContext);
        return true;
    }

    private void fireFocusLost() {
        for (FocusChangeListener listener : this.myFocusListeners) {
            listener.focusLost(this);
        }
    }

    private void fireFocusGained() {
        for (FocusChangeListener listener : this.myFocusListeners) {
            listener.focusGained(this);
        }
    }

    @Override
    public void setHighlighter(final @NotNull EditorHighlighter highlighter) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/impl/EditorImpl", "setHighlighter"));
        }
        EditorImpl.assertIsDispatchThread();
        final DocumentEx document = this.getDocument();
        Disposer.dispose((Disposable)this.myHighlighterDisposable);
        document.addDocumentListener((DocumentListener)highlighter);
        this.myHighlighter = highlighter;
        this.myHighlighterDisposable = new Disposable(){

            public void dispose() {
                document.removeDocumentListener((DocumentListener)highlighter);
            }
        };
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myHighlighterDisposable);
        highlighter.setEditor((HighlighterClient)this);
        highlighter.setText(document.getImmutableCharSequence());
        EditorHighlighterCache.rememberEditorHighlighterForCachesOptimization(document, highlighter);
        if (this.myPanel != null) {
            this.reinitSettings();
        }
    }

    @Override
    @NotNull
    public EditorHighlighter getHighlighter() {
        EditorImpl.assertReadAccess();
        EditorHighlighter editorHighlighter = this.myHighlighter;
        if (editorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getHighlighter"));
        }
        return editorHighlighter;
    }

    @NotNull
    public EditorComponentImpl getContentComponent() {
        EditorComponentImpl editorComponentImpl = this.myEditorComponent;
        if (editorComponentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getContentComponent"));
        }
        return editorComponentImpl;
    }

    @Override
    @NotNull
    public EditorGutterComponentEx getGutterComponentEx() {
        EditorGutterComponentImpl editorGutterComponentImpl = this.myGutterComponent;
        if (editorGutterComponentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getGutterComponentEx"));
        }
        return editorGutterComponentImpl;
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/EditorImpl", "addPropertyChangeListener"));
        }
        this.myPropertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/EditorImpl", "removePropertyChangeListener"));
        }
        this.myPropertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void setInsertMode(boolean mode) {
        EditorImpl.assertIsDispatchThread();
        boolean oldValue = this.myIsInsertMode;
        this.myIsInsertMode = mode;
        this.myPropertyChangeSupport.firePropertyChange("insertMode", oldValue, mode);
        this.myCaretCursor.repaint();
    }

    public boolean isInsertMode() {
        return this.myIsInsertMode;
    }

    @Override
    public void setColumnMode(boolean mode) {
        EditorImpl.assertIsDispatchThread();
        boolean oldValue = this.myIsColumnMode;
        this.myIsColumnMode = mode;
        this.myPropertyChangeSupport.firePropertyChange("columnMode", oldValue, mode);
    }

    public boolean isColumnMode() {
        return this.myIsColumnMode;
    }

    private int yPositionToVisibleLine(int y) {
        assert (y >= 0) : y;
        return y / this.getLineHeight();
    }

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point p) {
        int charWidth;
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/openapi/editor/impl/EditorImpl", "xyToVisualPosition"));
        }
        int line = this.yPositionToVisibleLine(Math.max(p.y, 0));
        int px = p.x;
        if (line == 0 && this.myPrefixText != null) {
            px -= this.myPrefixWidthInPixels;
        }
        int textLength = this.myDocument.getTextLength();
        LogicalPosition logicalPosition = this.visualToLogicalPosition(new VisualPosition(line, 0));
        int offset = this.logicalPositionToOffset(logicalPosition);
        int plainSpaceSize = EditorUtil.getSpaceWidth(0, this);
        if (offset >= textLength) {
            VisualPosition visualPosition = new VisualPosition(line, EditorUtil.columnsNumber(p.x, plainSpaceSize));
            if (visualPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "xyToVisualPosition"));
            }
            return visualPosition;
        }
        boolean activeSoftWrapProcessed = logicalPosition.softWrapLinesOnCurrentLogicalLine <= 0;
        CharSequence text = this.myDocument.getImmutableCharSequence();
        LogicalPosition endLogicalPosition = this.visualToLogicalPosition(new VisualPosition(line + 1, 0));
        int endOffset = this.logicalPositionToOffset(endLogicalPosition);
        if (offset > endOffset) {
            LogMessageEx.error(LOG, "Detected invalid (x; y)->VisualPosition processing", String.format("Given point: %s, mapped to visual line %d. Visual(%d; %d) is mapped to logical position '%s' which is mapped to offset %d (start offset). Visual(%d; %d) is mapped to logical '%s' which is mapped to offset %d (end offset). State: %s", p, line, line, 0, logicalPosition, offset, line + 1, 0, endLogicalPosition, endOffset, this.dumpState()));
            VisualPosition visualPosition = new VisualPosition(line, EditorUtil.columnsNumber(p.x, plainSpaceSize));
            if (visualPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "xyToVisualPosition"));
            }
            return visualPosition;
        }
        IterationState state = new IterationState(this, offset, endOffset, false);
        int fontType = state.getMergedAttributes().getFontType();
        int x = 0;
        boolean onSoftWrapDrawing = false;
        char c = ' ';
        int prevX = 0;
        int column = 0;
        block0: while (true) {
            FoldRegion region;
            SoftWrap softWrap;
            charWidth = -1;
            if (offset >= textLength) break;
            if (offset >= state.getEndOffset()) {
                state.advance();
                fontType = state.getMergedAttributes().getFontType();
            }
            if ((softWrap = this.mySoftWrapModel.getSoftWrap(offset)) != null) {
                if (activeSoftWrapProcessed) {
                    prevX = x;
                    charWidth = this.getSoftWrapModel().getMinDrawingWidthInPixels(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED);
                    if ((x += charWidth) >= px) {
                        onSoftWrapDrawing = true;
                        break;
                    }
                    ++column;
                    break;
                }
                CharSequence softWrapText = softWrap.getText();
                for (int i = 1; i < softWrapText.length(); ++i) {
                    c = softWrapText.charAt(i);
                    prevX = x;
                    if ((x += (charWidth = this.charToVisibleWidth(c, fontType, x))) >= px) break block0;
                    column += EditorUtil.columnsNumber(c, x, prevX, plainSpaceSize);
                }
                prevX = x;
                charWidth = this.mySoftWrapModel.getMinDrawingWidthInPixels(SoftWrapDrawingType.AFTER_SOFT_WRAP);
                if ((x += charWidth) >= px) {
                    onSoftWrapDrawing = true;
                    break;
                }
                ++column;
                activeSoftWrapProcessed = true;
            }
            if ((region = state.getCurrentFold()) != null) {
                char[] placeholder;
                for (char aPlaceholder : placeholder = region.getPlaceholderText().toCharArray()) {
                    c = aPlaceholder;
                    if ((x += EditorUtil.charWidth(c, fontType, this)) >= px) break block0;
                    ++column;
                }
                offset = region.getEndOffset();
                continue;
            }
            prevX = x;
            c = text.charAt(offset);
            if (c == '\n' || (x += (charWidth = this.charToVisibleWidth(c, fontType, x))) >= px) break;
            column += EditorUtil.columnsNumber(c, x, prevX, plainSpaceSize);
            ++offset;
        }
        if (charWidth < 0) {
            charWidth = EditorUtil.charWidth(c, fontType, this);
        }
        if (charWidth < 0) {
            charWidth = plainSpaceSize;
        }
        if (x >= px && c == '\t' && !onSoftWrapDrawing) {
            if (this.mySettings.isCaretInsideTabs()) {
                column += (px - prevX) / plainSpaceSize;
                if ((px - prevX) % plainSpaceSize > plainSpaceSize / 2) {
                    ++column;
                }
            } else if ((x - px) * 2 < x - prevX) {
                column += EditorUtil.columnsNumber(c, x, prevX, plainSpaceSize);
            }
        } else if (x >= px) {
            if (c != '\n' && (x - px) * 2 < charWidth) {
                ++column;
            }
        } else {
            int diff = px - x;
            column += diff / plainSpaceSize;
            if (diff % plainSpaceSize * 2 >= plainSpaceSize) {
                ++column;
            }
        }
        VisualPosition visualPosition = new VisualPosition(line, column);
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "xyToVisualPosition"));
        }
        return visualPosition;
    }

    private int charToVisibleWidth(char c, @JdkConstants.FontStyle int fontType, int currentX) {
        if (c == '\n') {
            return 0;
        }
        if (c == '\t') {
            return EditorUtil.nextTabStop(currentX, this) - currentX;
        }
        return EditorUtil.charWidth(c, fontType, this);
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset) {
        VisualPosition visualPosition = this.logicalToVisualPosition(this.offsetToLogicalPosition(offset));
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "offsetToVisualPosition"));
        }
        return visualPosition;
    }

    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset) {
        LogicalPosition logicalPosition = this.offsetToLogicalPosition(offset, true);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "offsetToLogicalPosition"));
        }
        return logicalPosition;
    }

    @Override
    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset, boolean softWrapAware) {
        if (softWrapAware) {
            LogicalPosition logicalPosition = this.mySoftWrapModel.offsetToLogicalPosition(offset);
            if (logicalPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "offsetToLogicalPosition"));
            }
            return logicalPosition;
        }
        int line = this.offsetToLogicalLine(offset);
        int column = this.calcColumnNumber(offset, line, false, this.myDocument.getImmutableCharSequence());
        LogicalPosition logicalPosition = new LogicalPosition(line, column);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "offsetToLogicalPosition"));
        }
        return logicalPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCaretActive() {
        RepaintCursorCommand repaintCursorCommand = ourCaretBlinkingCommand;
        synchronized (repaintCursorCommand) {
            ourCaretBlinkingCommand.myEditor = this;
        }
    }

    public int offsetToVisualLine(int offset) {
        SoftWrap softWrap;
        int textLength = this.getDocument().getTextLength();
        if (offset >= textLength) {
            return Math.max(0, this.getVisibleLineCount() - 1);
        }
        int line = this.offsetToLogicalLine(offset);
        int lineStartOffset = line >= this.myDocument.getLineCount() ? this.myDocument.getTextLength() : this.myDocument.getLineStartOffset(line);
        int result = this.logicalToVisualLine(line);
        int i = this.getSoftWrapModel().getSoftWrapIndex(lineStartOffset);
        if (i < 0) {
            i = -i - 1;
        }
        List<? extends SoftWrap> softWraps = this.getSoftWrapModel().getRegisteredSoftWraps();
        while (i < softWraps.size() && (softWrap = softWraps.get(i)).getStart() <= offset) {
            ++result;
            ++i;
        }
        return result;
    }

    private int logicalToVisualLine(int line) {
        EditorImpl.assertReadAccess();
        return this.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)line, (int)0)).line;
    }

    @NotNull
    public LogicalPosition xyToLogicalPosition(@NotNull Point p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/openapi/editor/impl/EditorImpl", "xyToLogicalPosition"));
        }
        Point pp = p.x >= 0 && p.y >= 0 ? p : new Point(Math.max(p.x, 0), Math.max(p.y, 0));
        LogicalPosition logicalPosition = this.visualToLogicalPosition(this.xyToVisualPosition(pp));
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "xyToLogicalPosition"));
        }
        return logicalPosition;
    }

    private int logicalLineToY(int line) {
        VisualPosition visible = this.logicalToVisualPosition(new LogicalPosition(line, 0));
        return this.visibleLineToY(visible.line);
    }

    @NotNull
    public Point logicalPositionToXY(@NotNull LogicalPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/EditorImpl", "logicalPositionToXY"));
        }
        VisualPosition visible = this.logicalToVisualPosition(pos);
        Point point = this.visualPositionToXY(visible);
        if (point == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "logicalPositionToXY"));
        }
        return point;
    }

    @NotNull
    public Point visualPositionToXY(@NotNull VisualPosition visible) {
        if (visible == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visible", "com/intellij/openapi/editor/impl/EditorImpl", "visualPositionToXY"));
        }
        int y = this.visibleLineToY(visible.line);
        LogicalPosition logical = this.visualToLogicalPosition(new VisualPosition(visible.line, 0));
        int logLine = logical.line;
        int lineStartOffset = -1;
        int reserved = 0;
        int column = visible.column;
        if (logical.softWrapLinesOnCurrentLogicalLine > 0) {
            int linesToSkip = logical.softWrapLinesOnCurrentLogicalLine;
            List<? extends SoftWrap> softWraps = this.getSoftWrapModel().getSoftWrapsForLine(logLine);
            for (SoftWrap softWrap : softWraps) {
                if (this.myFoldingModel.isOffsetCollapsed(softWrap.getStart()) && this.myFoldingModel.isOffsetCollapsed(softWrap.getStart() - 1) || --linesToSkip > 0) continue;
                lineStartOffset = softWrap.getStart();
                int widthInColumns = softWrap.getIndentInColumns();
                int widthInPixels = softWrap.getIndentInPixels();
                if (widthInColumns <= column) {
                    column -= widthInColumns;
                    reserved = widthInPixels;
                    break;
                }
                char[] softWrapChars = softWrap.getChars();
                int i = CharArrayUtil.lastIndexOf((char[])softWrapChars, (char)'\n', (int)0, (int)softWrapChars.length);
                int start = 0;
                if (i >= 0) {
                    start = i + 1;
                }
                Point point = new Point(EditorUtil.textWidth(this, softWrap.getText(), start, column + 1, 0, 0), y);
                if (point == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "visualPositionToXY"));
                }
                return point;
            }
        }
        if (logLine < 0) {
            lineStartOffset = 0;
        } else if (lineStartOffset < 0) {
            lineStartOffset = logLine >= this.myDocument.getLineCount() ? this.myDocument.getTextLength() : this.myDocument.getLineStartOffset(logLine);
        }
        int x = this.getTabbedTextWidth(lineStartOffset, column, reserved);
        Point point = new Point(x, y);
        if (point == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "visualPositionToXY"));
        }
        return point;
    }

    private int calcEndOffset(int startOffset, int visualColumn) {
        FoldRegion[] regions = this.myFoldingModel.fetchTopLevel();
        if (regions == null) {
            return startOffset + visualColumn;
        }
        int low = 0;
        int high = regions.length - 1;
        int i = -1;
        while (low <= high) {
            int mid = low + high >>> 1;
            FoldRegion midVal = regions[mid];
            if (midVal.getStartOffset() <= startOffset && midVal.getEndOffset() > startOffset) {
                i = mid;
                break;
            }
            if (midVal.getStartOffset() < startOffset) {
                low = mid + 1;
                continue;
            }
            if (midVal.getStartOffset() <= startOffset) continue;
            high = mid - 1;
        }
        if (i < 0) {
            i = low;
        }
        int result = startOffset;
        int columnsToProcess = visualColumn;
        while (i < regions.length) {
            FoldRegion region = regions[i];
            int nonFoldTextColumnsNumber = region.getStartOffset() - result;
            if (nonFoldTextColumnsNumber >= columnsToProcess) {
                return result + columnsToProcess;
            }
            int placeHolderLength = region.getPlaceholderText().length();
            if (placeHolderLength >= (columnsToProcess -= nonFoldTextColumnsNumber)) {
                return region.getEndOffset();
            }
            result = region.getEndOffset();
            columnsToProcess -= placeHolderLength;
            ++i;
        }
        return result + columnsToProcess;
    }

    private int getTabbedTextWidth(int startOffset, int targetColumn, int xOffset) {
        int x = xOffset;
        if (startOffset == 0 && this.myPrefixText != null) {
            x += this.myPrefixWidthInPixels;
        }
        if (targetColumn <= 0) {
            return x;
        }
        ++this.myTotalRequests;
        for (int i = 0; i < this.myLastStartOffsets.length; ++i) {
            if (startOffset != this.myLastStartOffsets[i] || targetColumn != this.myLastTargetColumns[i] || xOffset != this.myLastXOffsets[i]) continue;
            ++this.myLastCacheHits;
            if ((this.myLastCacheHits & 0xFFF) == 0) {
                PsiFile file = this.myProject != null ? PsiDocumentManager.getInstance((Project)this.myProject).getCachedPsiFile((Document)this.myDocument) : null;
                LOG.info("Cache hits:" + this.myLastCacheHits + ", total requests:" + this.myTotalRequests + "," + (file != null ? file.getViewProvider().getVirtualFile() : null));
            }
            return this.myLastXs[i];
        }
        int offset = startOffset;
        CharSequence text = this.myDocument.getImmutableCharSequence();
        int textLength = this.myDocument.getTextLength();
        IterationState state = new IterationState(this, startOffset, this.calcEndOffset(startOffset, targetColumn), false);
        int fontType = state.getMergedAttributes().getFontType();
        int plainSpaceSize = EditorUtil.getSpaceWidth(0, this);
        int column = 0;
        block1: while (column < targetColumn && offset < textLength) {
            SoftWrap softWrap;
            if (offset >= state.getEndOffset()) {
                state.advance();
                fontType = state.getMergedAttributes().getFontType();
            }
            if ((softWrap = this.getSoftWrapModel().getSoftWrap(offset)) != null && offset > startOffset) {
                ++column;
                x += this.getSoftWrapModel().getMinDrawingWidthInPixels(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED);
                break;
            }
            FoldRegion region = state.getCurrentFold();
            if (region != null) {
                char[] placeholder;
                for (char aPlaceholder : placeholder = region.getPlaceholderText().toCharArray()) {
                    x += EditorUtil.charWidth(aPlaceholder, fontType, this);
                    if (++column >= targetColumn) break block1;
                }
                offset = region.getEndOffset();
                continue;
            }
            char c = text.charAt(offset);
            if (c == '\n') break;
            if (c == '\t') {
                int prevX = x;
                x = EditorUtil.nextTabStop(x, this);
                int columnDiff = (x - prevX) / plainSpaceSize;
                if ((x - prevX) % plainSpaceSize > 0) {
                    ++columnDiff;
                }
                column += columnDiff;
            } else {
                x += EditorUtil.charWidth(c, fontType, this);
                ++column;
            }
            ++offset;
        }
        if (column != targetColumn) {
            x += EditorUtil.getSpaceWidth(fontType, this) * (targetColumn - column);
        }
        this.myLastTargetColumns[this.myCurrentCachePosition] = targetColumn;
        this.myLastStartOffsets[this.myCurrentCachePosition] = startOffset;
        this.myLastXs[this.myCurrentCachePosition] = x;
        this.myLastXOffsets[this.myCurrentCachePosition] = xOffset;
        this.myCurrentCachePosition = (this.myCurrentCachePosition + 1) % this.myLastStartOffsets.length;
        return x;
    }

    private void clearTextWidthCache() {
        for (int i = 0; i < this.myLastStartOffsets.length; ++i) {
            this.myLastTargetColumns[i] = -1;
            this.myLastStartOffsets[i] = -1;
            this.myLastXs[i] = -1;
            this.myLastXOffsets[i] = -1;
        }
    }

    public int visibleLineToY(int line) {
        if (line < 0) {
            throw new IndexOutOfBoundsException("Wrong line: " + line);
        }
        return line * this.getLineHeight();
    }

    @Override
    public void repaint(int startOffset, int endOffset) {
        if (!this.isShowing() || this.myDocument.isInBulkUpdate()) {
            return;
        }
        endOffset = Math.min(endOffset, this.myDocument.getTextLength());
        EditorImpl.assertIsDispatchThread();
        if (startOffset <= endOffset) {
            int startLine = this.myDocument.getLineNumber(startOffset);
            int endLine = this.myDocument.getLineNumber(endOffset);
            this.repaintLines(startLine, endLine);
        }
    }

    private boolean isShowing() {
        return this.myGutterComponent.isShowing();
    }

    private void repaintToScreenBottom(int startLine) {
        Rectangle visibleArea = this.getScrollingModel().getVisibleArea();
        int yStartLine = this.logicalLineToY(startLine);
        int yEndLine = visibleArea.y + visibleArea.height;
        this.myEditorComponent.repaintEditorComponent(visibleArea.x, yStartLine, visibleArea.x + visibleArea.width, yEndLine - yStartLine);
        this.myGutterComponent.repaint(0, yStartLine, this.myGutterComponent.getWidth(), yEndLine - yStartLine);
        ((EditorMarkupModelImpl)this.getMarkupModel()).repaint(-1, -1);
    }

    public void repaintLines(int startLine, int endLine) {
        if (!this.isShowing()) {
            return;
        }
        Rectangle visibleArea = this.getScrollingModel().getVisibleArea();
        int yStartLine = this.logicalLineToY(startLine);
        int endVisLine = this.myDocument.getTextLength() <= 0 ? 0 : this.offsetToVisualLine(this.myDocument.getLineEndOffset(Math.min(this.myDocument.getLineCount() - 1, endLine)));
        int height = endVisLine * this.getLineHeight() - yStartLine + this.getLineHeight() + 2;
        this.myEditorComponent.repaintEditorComponent(visibleArea.x, yStartLine, visibleArea.x + visibleArea.width, height);
        this.myGutterComponent.repaint(0, yStartLine, this.myGutterComponent.getWidth(), height);
    }

    private void bulkUpdateStarted() {
        this.saveCaretRelativePosition();
        this.myCaretModel.onBulkDocumentUpdateStarted();
        this.mySoftWrapModel.onBulkDocumentUpdateStarted();
        this.myFoldingModel.onBulkDocumentUpdateStarted();
    }

    private void bulkUpdateFinished() {
        this.myFoldingModel.onBulkDocumentUpdateFinished();
        this.mySoftWrapModel.onBulkDocumentUpdateFinished();
        this.myCaretModel.onBulkDocumentUpdateFinished();
        this.clearTextWidthCache();
        this.setMouseSelectionState(0);
        this.mySizeContainer.reset();
        this.validateSize();
        this.updateGutterSize();
        this.repaintToScreenBottom(0);
        this.updateCaretCursor();
        this.restoreCaretRelativePosition();
    }

    private void beforeChangedUpdate(@NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "beforeChangedUpdate"));
        }
        if (this.isStickySelection()) {
            this.setStickySelection(false);
        }
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        this.saveCaretRelativePosition();
        if (!this.mySoftWrapModel.isSoftWrappingEnabled()) {
            this.mySizeContainer.beforeChange(e);
        }
    }

    private void changedUpdate(DocumentEvent e) {
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        this.clearTextWidthCache();
        this.setMouseSelectionState(0);
        if (!this.mySoftWrapModel.isSoftWrappingEnabled()) {
            this.mySizeContainer.changedUpdate(e);
        }
        this.validateSize();
        int startLine = this.offsetToLogicalLine(e.getOffset());
        int endLine = this.offsetToLogicalLine(e.getOffset() + e.getNewLength());
        boolean painted = false;
        if (this.myDocument.getTextLength() > 0) {
            int startDocLine = this.myDocument.getLineNumber(e.getOffset());
            int endDocLine = this.myDocument.getLineNumber(e.getOffset() + e.getNewLength());
            if (e.getOldLength() > e.getNewLength() || startDocLine != endDocLine || StringUtil.indexOf((CharSequence)e.getOldFragment(), (char)'\n') != -1) {
                this.updateGutterSize();
            }
            if (EditorImpl.countLineFeeds(e.getOldFragment()) != EditorImpl.countLineFeeds(e.getNewFragment())) {
                this.repaintToScreenBottom(startLine);
                painted = true;
            }
        }
        this.updateCaretCursor();
        if (!painted) {
            this.repaintLines(startLine, endLine);
        }
        if (this.getCaretModel().getOffset() < e.getOffset() || this.getCaretModel().getOffset() > e.getOffset() + e.getNewLength()) {
            this.restoreCaretRelativePosition();
        }
    }

    private void saveCaretRelativePosition() {
        Rectangle visibleArea = this.getScrollingModel().getVisibleArea();
        Point pos = this.visualPositionToXY(this.getCaretModel().getVisualPosition());
        this.myCaretUpdateVShift = pos.y - visibleArea.y;
    }

    private void restoreCaretRelativePosition() {
        Point caretLocation = this.visualPositionToXY(this.getCaretModel().getVisualPosition());
        int scrollOffset = caretLocation.y - this.myCaretUpdateVShift;
        this.getScrollingModel().disableAnimation();
        this.getScrollingModel().scrollVertically(scrollOffset);
        this.getScrollingModel().enableAnimation();
    }

    public boolean hasTabs() {
        return !(this.myDocument instanceof DocumentImpl) || ((DocumentImpl)this.myDocument).mightContainTabs();
    }

    public boolean isScrollToCaret() {
        return this.myScrollToCaret;
    }

    public void setScrollToCaret(boolean scrollToCaret) {
        this.myScrollToCaret = scrollToCaret;
    }

    @NotNull
    public Disposable getDisposable() {
        Disposable disposable = this.myDisposable;
        if (disposable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getDisposable"));
        }
        return disposable;
    }

    private static int countLineFeeds(@NotNull CharSequence c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/openapi/editor/impl/EditorImpl", "countLineFeeds"));
        }
        return StringUtil.countNewLines((CharSequence)c);
    }

    private void updateGutterSize() {
        EditorImpl.assertIsDispatchThread();
        if (!this.updatingSize) {
            this.updatingSize = true;
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (!EditorImpl.this.isDisposed()) {
                            EditorImpl.this.myGutterComponent.updateSize();
                        }
                    }
                    finally {
                        EditorImpl.this.updatingSize = false;
                    }
                }
            });
        }
    }

    void validateSize() {
        Dimension dim = this.getPreferredSize();
        if (!dim.equals(this.myPreferredSize) && !this.myDocument.isInBulkUpdate()) {
            if ((dim = this.mySizeAdjustmentStrategy.adjust(dim, this.myPreferredSize, this)) == null) {
                return;
            }
            this.myPreferredSize = dim;
            this.myGutterComponent.updateSize();
            this.myEditorComponent.setSize(dim);
            this.myEditorComponent.fireResized();
            this.myMarkupModel.recalcEditorDimensions();
            this.myMarkupModel.repaint(-1, -1);
        }
    }

    void recalculateSizeAndRepaint() {
        this.mySizeContainer.reset();
        this.validateSize();
        this.myEditorComponent.repaintEditorComponent();
    }

    @Override
    @NotNull
    public DocumentEx getDocument() {
        DocumentEx documentEx = this.myDocument;
        if (documentEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getDocument"));
        }
        return documentEx;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getComponent"));
        }
        return jPanel;
    }

    public void addEditorMouseListener(@NotNull EditorMouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/EditorImpl", "addEditorMouseListener"));
        }
        this.myMouseListeners.add(listener);
    }

    public void removeEditorMouseListener(@NotNull EditorMouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/EditorImpl", "removeEditorMouseListener"));
        }
        boolean success = this.myMouseListeners.remove(listener);
        LOG.assertTrue(success || this.isReleased);
    }

    public void addEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/EditorImpl", "addEditorMouseMotionListener"));
        }
        this.myMouseMotionListeners.add(listener);
    }

    public void removeEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/EditorImpl", "removeEditorMouseMotionListener"));
        }
        boolean success = this.myMouseMotionListeners.remove(listener);
        LOG.assertTrue(success || this.isReleased);
    }

    @Override
    public boolean isStickySelection() {
        return this.myStickySelection;
    }

    @Override
    public void setStickySelection(boolean enable) {
        this.myStickySelection = enable;
        if (enable) {
            this.myStickySelectionStart = this.getCaretModel().getOffset();
        } else {
            this.mySelectionModel.removeSelection();
        }
    }

    public boolean isDisposed() {
        return this.isReleased;
    }

    public void stopDumbLater() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        Runnable stopDumbRunnable = new Runnable(){

            @Override
            public void run() {
                EditorImpl.this.stopDumb();
            }
        };
        ApplicationManager.getApplication().invokeLater(stopDumbRunnable, ModalityState.current());
    }

    void resetPaintersWidth() {
        this.myLinePaintersWidth = 0;
    }

    public void stopDumb() {
        this.putUserData(BUFFER, null);
    }

    public void startDumb() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        EditorComponentImpl component = this.getContentComponent();
        Rectangle rect = ((JViewport)component.getParent()).getViewRect();
        BufferedImage image = UIUtil.createImage((int)rect.width, (int)rect.height, (int)1);
        Graphics2D graphics = image.createGraphics();
        UISettings.setupAntialiasing((Graphics)graphics);
        graphics.translate(-rect.x, -rect.y);
        graphics.setClip(rect.x, rect.y, rect.width, rect.height);
        this.paint(graphics);
        graphics.dispose();
        this.putUserData(BUFFER, image);
    }

    void paint(@NotNull Graphics2D g) {
        BufferedImage buffer;
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl", "paint"));
        }
        Rectangle clip = g.getClipBounds();
        if (clip == null) {
            return;
        }
        if (Registry.is((String)"editor.dumb.mode.available") && (buffer = (BufferedImage)this.getUserData(BUFFER)) != null) {
            Rectangle rect = this.getContentComponent().getVisibleRect();
            UIUtil.drawImage((Graphics)g, (BufferedImage)buffer, null, (int)rect.x, (int)rect.y);
            return;
        }
        if (this.myUpdateCursor) {
            this.setCursorPosition();
            this.myUpdateCursor = false;
        }
        if (this.isReleased) {
            g.setColor((Color)new JBColor(new Color(128, 255, 128), new Color(128, 255, 128)));
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
            return;
        }
        if (this.myProject != null && this.myProject.isDisposed()) {
            return;
        }
        VisualPosition clipStartVisualPos = this.xyToVisualPosition(new Point(0, clip.y));
        LogicalPosition clipStartPosition = this.visualToLogicalPosition(clipStartVisualPos);
        int clipStartOffset = this.logicalPositionToOffset(clipStartPosition);
        LogicalPosition clipEndPosition = this.xyToLogicalPosition(new Point(0, clip.y + clip.height + this.getLineHeight()));
        int clipEndOffset = this.logicalPositionToOffset(clipEndPosition);
        this.paintBackgrounds(g, clip, clipStartPosition, clipStartVisualPos, clipStartOffset, clipEndOffset);
        if (this.paintPlaceholderText(g, clip)) {
            this.paintCaretCursor(g);
            return;
        }
        this.paintRightMargin(g, clip);
        this.paintCustomRenderers(g, clipStartOffset, clipEndOffset);
        MarkupModelEx docMarkup = (MarkupModelEx)DocumentMarkupModel.forDocument(this.myDocument, this.myProject, true);
        this.paintLineMarkersSeparators(g, clip, docMarkup, clipStartOffset, clipEndOffset);
        this.paintLineMarkersSeparators(g, clip, this.myMarkupModel, clipStartOffset, clipEndOffset);
        this.paintText(g, clip, clipStartPosition, clipStartOffset, clipEndOffset);
        this.paintSegmentHighlightersBorderAndAfterEndOfLine(g, clip, clipStartOffset, clipEndOffset, docMarkup);
        BorderEffect borderEffect = new BorderEffect(this, g, clipStartOffset, clipEndOffset);
        borderEffect.paintHighlighters(this.getHighlighter());
        borderEffect.paintHighlighters(docMarkup);
        borderEffect.paintHighlighters(this.myMarkupModel);
        this.paintCaretCursor(g);
        this.paintComposedTextDecoration(g);
    }

    private void paintCustomRenderers(final @NotNull Graphics2D g, final int clipStartOffset, final int clipEndOffset) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl", "paintCustomRenderers"));
        }
        this.myMarkupModel.processRangeHighlightersOverlappingWith(clipStartOffset, clipEndOffset, (Processor<? super RangeHighlighterEx>)new Processor<RangeHighlighterEx>(){

            public boolean process(@NotNull RangeHighlighterEx highlighter) {
                if (highlighter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/impl/EditorImpl$20", "process"));
                }
                if (!highlighter.getEditorFilter().avaliableIn((Editor)EditorImpl.this)) {
                    return true;
                }
                CustomHighlighterRenderer customRenderer = highlighter.getCustomRenderer();
                if (customRenderer != null && clipStartOffset < highlighter.getEndOffset() && highlighter.getStartOffset() < clipEndOffset) {
                    customRenderer.paint((Editor)EditorImpl.this, (RangeHighlighter)highlighter, (Graphics)g);
                }
                return true;
            }
        });
    }

    @NotNull
    public IndentsModel getIndentsModel() {
        IndentsModel indentsModel = this.myIndentsModel;
        if (indentsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getIndentsModel"));
        }
        return indentsModel;
    }

    public void setHeaderComponent(JComponent header) {
        this.myHeaderPanel.removeAll();
        JComponent jComponent = header = header == null ? this.getPermanentHeaderComponent() : header;
        if (header != null) {
            this.myHeaderPanel.add(header);
        }
        this.myHeaderPanel.revalidate();
    }

    public boolean hasHeaderComponent() {
        JComponent header = this.getHeaderComponent();
        return header != null && header != this.getPermanentHeaderComponent();
    }

    @Override
    @Nullable
    public JComponent getPermanentHeaderComponent() {
        return (JComponent)this.getUserData(PERMANENT_HEADER);
    }

    @Override
    public void setPermanentHeaderComponent(@Nullable JComponent component) {
        this.putUserData(PERMANENT_HEADER, component);
    }

    @Nullable
    public JComponent getHeaderComponent() {
        if (this.myHeaderPanel.getComponentCount() > 0) {
            return (JComponent)this.myHeaderPanel.getComponent(0);
        }
        return null;
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.myScrollPane.setBackground(color);
        if (this.getBackgroundIgnoreForced().equals(color)) {
            this.myForcedBackground = null;
            return;
        }
        this.myForcedBackground = color;
    }

    @NotNull
    private Color getForegroundColor() {
        Color color = this.myScheme.getDefaultForeground();
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getForegroundColor"));
        }
        return color;
    }

    @Override
    @NotNull
    public Color getBackgroundColor() {
        if (this.myForcedBackground != null) {
            Color color = this.myForcedBackground;
            if (color == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getBackgroundColor"));
            }
            return color;
        }
        Color color = this.getBackgroundIgnoreForced();
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getBackgroundColor"));
        }
        return color;
    }

    @Override
    @NotNull
    public TextDrawingCallback getTextDrawingCallback() {
        TextDrawingCallback textDrawingCallback = this.myTextDrawingCallback;
        if (textDrawingCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getTextDrawingCallback"));
        }
        return textDrawingCallback;
    }

    @Override
    public void setPlaceholder(@Nullable CharSequence text) {
        this.myPlaceholderText = text;
    }

    @Override
    public void setShowPlaceholderWhenFocused(boolean show) {
        this.myShowPlaceholderWhenFocused = show;
    }

    Color getBackgroundColor(@NotNull TextAttributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/openapi/editor/impl/EditorImpl", "getBackgroundColor"));
        }
        Color attrColor = attributes.getBackgroundColor();
        return Comparing.equal((Object)attrColor, (Object)this.myScheme.getDefaultBackground()) ? this.getBackgroundColor() : attrColor;
    }

    @NotNull
    private Color getBackgroundIgnoreForced() {
        Color color = this.myScheme.getDefaultBackground();
        if (this.myDocument.isWritable()) {
            Color color2 = color;
            if (color2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getBackgroundIgnoreForced"));
            }
            return color2;
        }
        Color readOnlyColor = this.myScheme.getColor(EditorColors.READONLY_BACKGROUND_COLOR);
        Color color3 = readOnlyColor != null ? readOnlyColor : color;
        if (color3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getBackgroundIgnoreForced"));
        }
        return color3;
    }

    private void paintComposedTextDecoration(@NotNull Graphics2D g) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl", "paintComposedTextDecoration"));
        }
        if (this.myInputMethodRequestsHandler != null && this.myInputMethodRequestsHandler.composedText != null && this.myInputMethodRequestsHandler.composedTextRange != null) {
            VisualPosition visStart = this.offsetToVisualPosition(Math.min(this.myInputMethodRequestsHandler.composedTextRange.getStartOffset(), this.myDocument.getTextLength()));
            int y = this.visibleLineToY(visStart.line) + this.getAscent() + 1;
            Point p1 = this.visualPositionToXY(visStart);
            Point p2 = this.logicalPositionToXY(this.offsetToLogicalPosition(Math.min(this.myInputMethodRequestsHandler.composedTextRange.getEndOffset(), this.myDocument.getTextLength())));
            Stroke saved = g.getStroke();
            BasicStroke dotted = new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{0.0f, 2.0f, 0.0f, 2.0f}, 0.0f);
            g.setStroke(dotted);
            UIUtil.drawLine((Graphics)g, (int)p1.x, (int)y, (int)p2.x, (int)y);
            g.setStroke(saved);
        }
    }

    private void paintRightMargin(@NotNull Graphics g, @NotNull Rectangle clip) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl", "paintRightMargin"));
        }
        if (clip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clip", "com/intellij/openapi/editor/impl/EditorImpl", "paintRightMargin"));
        }
        Color rightMargin = this.myScheme.getColor(EditorColors.RIGHT_MARGIN_COLOR);
        if (!this.mySettings.isRightMarginShown() || rightMargin == null) {
            return;
        }
        int x = this.mySettings.getRightMargin(this.myProject) * EditorUtil.getSpaceWidth(0, this);
        if (x >= clip.x && x < clip.x + clip.width) {
            g.setColor(rightMargin);
            UIUtil.drawLine((Graphics)g, (int)x, (int)clip.y, (int)x, (int)(clip.y + clip.height));
        }
    }

    private void paintSegmentHighlightersBorderAndAfterEndOfLine(final @NotNull Graphics g, @NotNull Rectangle clip, int clipStartOffset, int clipEndOffset, @NotNull MarkupModelEx docMarkup) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl", "paintSegmentHighlightersBorderAndAfterEndOfLine"));
        }
        if (clip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clip", "com/intellij/openapi/editor/impl/EditorImpl", "paintSegmentHighlightersBorderAndAfterEndOfLine"));
        }
        if (docMarkup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docMarkup", "com/intellij/openapi/editor/impl/EditorImpl", "paintSegmentHighlightersBorderAndAfterEndOfLine"));
        }
        if (this.myDocument.getLineCount() == 0) {
            return;
        }
        final int startLine = this.yPositionToVisibleLine(clip.y);
        final int endLine = this.yPositionToVisibleLine(clip.y + clip.height) + 1;
        Processor<RangeHighlighterEx> paintProcessor = new Processor<RangeHighlighterEx>(){

            public boolean process(@NotNull RangeHighlighterEx highlighter) {
                if (highlighter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/impl/EditorImpl$21", "process"));
                }
                if (!highlighter.getEditorFilter().avaliableIn((Editor)EditorImpl.this)) {
                    return true;
                }
                EditorImpl.this.paintSegmentHighlighterAfterEndOfLine(g, highlighter, startLine, endLine);
                return true;
            }
        };
        docMarkup.processRangeHighlightersOverlappingWith(clipStartOffset, clipEndOffset, (Processor<? super RangeHighlighterEx>)paintProcessor);
        this.myMarkupModel.processRangeHighlightersOverlappingWith(clipStartOffset, clipEndOffset, (Processor<? super RangeHighlighterEx>)paintProcessor);
    }

    private void paintSegmentHighlighterAfterEndOfLine(@NotNull Graphics g, @NotNull RangeHighlighterEx segmentHighlighter, int startLine, int endLine) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl", "paintSegmentHighlighterAfterEndOfLine"));
        }
        if (segmentHighlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segmentHighlighter", "com/intellij/openapi/editor/impl/EditorImpl", "paintSegmentHighlighterAfterEndOfLine"));
        }
        if (!segmentHighlighter.isAfterEndOfLine()) {
            return;
        }
        int startOffset = segmentHighlighter.getStartOffset();
        int visibleStartLine = this.offsetToVisualLine(startOffset);
        if (this.getFoldingModel().isOffsetCollapsed(startOffset)) {
            return;
        }
        if (visibleStartLine >= startLine && visibleStartLine <= endLine) {
            int logStartLine = this.offsetToLogicalLine(startOffset);
            if (logStartLine >= this.myDocument.getLineCount()) {
                return;
            }
            LogicalPosition logPosition = this.offsetToLogicalPosition(this.myDocument.getLineEndOffset(logStartLine));
            Point end = this.logicalPositionToXY(logPosition);
            int charWidth = EditorUtil.getSpaceWidth(0, this);
            int lineHeight = this.getLineHeight();
            TextAttributes attributes = segmentHighlighter.getTextAttributes();
            if (attributes != null && this.getBackgroundColor(attributes) != null) {
                g.setColor(this.getBackgroundColor(attributes));
                g.fillRect(end.x, end.y, charWidth, lineHeight);
            }
            if (attributes != null && attributes.getEffectColor() != null) {
                int y = this.visibleLineToY(visibleStartLine) + this.getAscent() + 1;
                g.setColor(attributes.getEffectColor());
                if (attributes.getEffectType() == EffectType.WAVE_UNDERSCORE) {
                    UIUtil.drawWave((Graphics2D)((Graphics2D)g), (Rectangle)new Rectangle(end.x, y, charWidth - 1, 2));
                } else if (attributes.getEffectType() == EffectType.BOLD_DOTTED_LINE) {
                    int dottedAt = SystemInfo.isMac ? y - 1 : y;
                    UIUtil.drawBoldDottedLine((Graphics2D)((Graphics2D)g), (int)end.x, (int)(end.x + charWidth - 1), (int)dottedAt, (Color)this.getBackgroundColor(attributes), (Color)attributes.getEffectColor(), (boolean)false);
                } else if (attributes.getEffectType() == EffectType.STRIKEOUT) {
                    int y1 = y - this.getCharHeight() / 2 - 1;
                    UIUtil.drawLine((Graphics)g, (int)end.x, (int)y1, (int)(end.x + charWidth - 1), (int)y1);
                } else if (attributes.getEffectType() == EffectType.BOLD_LINE_UNDERSCORE) {
                    UIUtil.drawLine((Graphics)g, (int)end.x, (int)(y - 1), (int)(end.x + charWidth - 1), (int)(y - 1));
                    UIUtil.drawLine((Graphics)g, (int)end.x, (int)y, (int)(end.x + charWidth - 1), (int)y);
                } else if (attributes.getEffectType() != EffectType.BOXED) {
                    UIUtil.drawLine((Graphics)g, (int)end.x, (int)y, (int)(end.x + charWidth - 1), (int)y);
                }
            }
        }
    }

    @Override
    public int getMaxWidthInRange(int startOffset, int endOffset) {
        int width = 0;
        int start = this.offsetToVisualLine(startOffset);
        int end = this.offsetToVisualLine(endOffset);
        for (int i = start; i <= end; ++i) {
            int lastColumn = EditorUtil.getLastVisualLineColumnNumber(this, i) + 1;
            int lineWidth = this.visualPositionToXY((VisualPosition)new VisualPosition((int)i, (int)lastColumn)).x;
            if (lineWidth <= width) continue;
            width = lineWidth;
        }
        return width;
    }

    private void paintBackgrounds(@NotNull Graphics g, @NotNull Rectangle clip, @NotNull LogicalPosition clipStartPosition, @NotNull VisualPosition clipStartVisualPos, int clipStartOffset, int clipEndOffset) {
        CharArrayCharSequence prefixText;
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl", "paintBackgrounds"));
        }
        if (clip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clip", "com/intellij/openapi/editor/impl/EditorImpl", "paintBackgrounds"));
        }
        if (clipStartPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clipStartPosition", "com/intellij/openapi/editor/impl/EditorImpl", "paintBackgrounds"));
        }
        if (clipStartVisualPos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clipStartVisualPos", "com/intellij/openapi/editor/impl/EditorImpl", "paintBackgrounds"));
        }
        Color defaultBackground = this.getBackgroundColor();
        if (this.myEditorComponent.isOpaque()) {
            g.setColor(defaultBackground);
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
        }
        int lineHeight = this.getLineHeight();
        int visibleLine = this.yPositionToVisibleLine(clip.y);
        Point position = new Point(0, visibleLine * lineHeight);
        CharArrayCharSequence charArrayCharSequence = prefixText = this.myPrefixText == null ? null : new CharArrayCharSequence(this.myPrefixText);
        if (clipStartVisualPos.line == 0 && prefixText != null) {
            position.x = this.drawBackground(g, this.myPrefixAttributes.getBackgroundColor(), (CharSequence)prefixText, 0, prefixText.length(), position, this.myPrefixAttributes.getFontType(), defaultBackground, clip);
        }
        if (clipStartPosition.line >= this.myDocument.getLineCount() || clipStartPosition.line < 0) {
            if (position.x > 0) {
                this.flushBackground(g, clip);
            }
            return;
        }
        this.myLastBackgroundPosition = null;
        this.myLastBackgroundColor = null;
        this.mySelectionStartPosition = null;
        this.mySelectionEndPosition = null;
        int start = clipStartOffset;
        if (!this.myPurePaintingMode) {
            this.getSoftWrapModel().registerSoftWrapsIfNecessary();
        }
        LineIterator lIterator = this.createLineIterator();
        lIterator.start(start);
        if (lIterator.atEnd()) {
            return;
        }
        IterationState iterationState = new IterationState(this, start, clipEndOffset, this.isPaintSelection());
        TextAttributes attributes = iterationState.getMergedAttributes();
        Color backColor = this.getBackgroundColor(attributes);
        int fontType = attributes.getFontType();
        int lastLineIndex = Math.max(0, this.myDocument.getLineCount() - 1);
        TIntHashSet softWrapsToSkip = new TIntHashSet();
        SoftWrap softWrap = this.getSoftWrapModel().getSoftWrap(start);
        if (softWrap != null) {
            softWrapsToSkip.add(softWrap.getStart());
            Color color = null;
            if (backColor != null && !backColor.equals(defaultBackground)) {
                color = backColor;
            }
            if (color == null && position.y == this.getCaretModel().getVisualPosition().line * this.getLineHeight()) {
                Color color2 = color = this.mySettings.isCaretRowShown() ? this.getColorsScheme().getColor(EditorColors.CARET_ROW_COLOR) : null;
            }
            if (color != null) {
                this.drawBackground(g, color, softWrap.getIndentInPixels(), position, defaultBackground, clip);
            }
            position.x = softWrap.getIndentInPixels();
        }
        boolean[] caretRowPainted = new boolean[1];
        CharSequence text = this.myDocument.getImmutableCharSequence();
        while (!iterationState.atEnd() && !lIterator.atEnd()) {
            String chars;
            FoldRegion collapsedFolderAt;
            int lEnd;
            int hEnd = iterationState.getEndOffset();
            if (hEnd >= (lEnd = lIterator.getEnd())) {
                collapsedFolderAt = this.myFoldingModel.getCollapsedRegionAtOffset(start);
                if (collapsedFolderAt == null) {
                    position.x = this.drawSoftWrapAwareBackground(g, backColor, text, start, lEnd - lIterator.getSeparatorLength(), position, fontType, defaultBackground, clip, softWrapsToSkip, caretRowPainted);
                    this.paintAfterLineEndBackgroundSegments(g, iterationState, position, defaultBackground, lineHeight);
                    if (lIterator.getLineNumber() < lastLineIndex) {
                        if (backColor != null && !backColor.equals(defaultBackground)) {
                            g.setColor(backColor);
                            g.fillRect(position.x, position.y, clip.x + clip.width - position.x, lineHeight);
                        }
                    } else {
                        if (iterationState.hasPastFileEndBackgroundSegments()) {
                            this.paintAfterLineEndBackgroundSegments(g, iterationState, position, defaultBackground, lineHeight);
                        }
                        this.paintAfterFileEndBackground(iterationState, g, position, clip, lineHeight, defaultBackground, caretRowPainted);
                        break;
                    }
                    position.x = 0;
                    if (position.y > clip.y + clip.height) break;
                    position.y += lineHeight;
                    start = lEnd;
                } else if (collapsedFolderAt.getEndOffset() == clipEndOffset) {
                    softWrap = this.mySoftWrapModel.getSoftWrap(collapsedFolderAt.getStartOffset());
                    if (softWrap != null) {
                        position.x = this.drawSoftWrapAwareBackground(g, backColor, text, collapsedFolderAt.getStartOffset(), collapsedFolderAt.getStartOffset(), position, fontType, defaultBackground, clip, softWrapsToSkip, caretRowPainted);
                    }
                    chars = collapsedFolderAt.getPlaceholderText();
                    position.x = this.drawBackground(g, backColor, chars, 0, chars.length(), position, fontType, defaultBackground, clip);
                }
                lIterator.advance();
                continue;
            }
            collapsedFolderAt = iterationState.getCurrentFold();
            if (collapsedFolderAt != null) {
                softWrap = this.mySoftWrapModel.getSoftWrap(collapsedFolderAt.getStartOffset());
                if (softWrap != null) {
                    position.x = this.drawSoftWrapAwareBackground(g, backColor, text, collapsedFolderAt.getStartOffset(), collapsedFolderAt.getStartOffset(), position, fontType, defaultBackground, clip, softWrapsToSkip, caretRowPainted);
                }
                chars = collapsedFolderAt.getPlaceholderText();
                position.x = this.drawBackground(g, backColor, chars, 0, chars.length(), position, fontType, defaultBackground, clip);
            } else {
                position.x = hEnd > lEnd - lIterator.getSeparatorLength() ? this.drawSoftWrapAwareBackground(g, backColor, text, start, lEnd - lIterator.getSeparatorLength(), position, fontType, defaultBackground, clip, softWrapsToSkip, caretRowPainted) : this.drawSoftWrapAwareBackground(g, backColor, text, start, hEnd, position, fontType, defaultBackground, clip, softWrapsToSkip, caretRowPainted);
            }
            iterationState.advance();
            attributes = iterationState.getMergedAttributes();
            backColor = this.getBackgroundColor(attributes);
            fontType = attributes.getFontType();
            start = iterationState.getStartOffset();
        }
        this.flushBackground(g, clip);
        if (lIterator.getLineNumber() >= lastLineIndex && position.y <= clip.y + clip.height) {
            this.paintAfterFileEndBackground(iterationState, g, position, clip, lineHeight, defaultBackground, caretRowPainted);
        }
        if (this.mySoftWrapsChanged) {
            this.mySoftWrapsChanged = false;
            this.clearTextWidthCache();
            this.validateSize();
            this.repaintToScreenBottom(EditorUtil.yPositionToLogicalLine((Editor)this, position));
            this.myGutterComponent.repaint(0, clip.y, this.myGutterComponent.getWidth(), this.myGutterComponent.getHeight() - clip.y);
        }
    }

    private void paintAfterLineEndBackgroundSegments(@NotNull Graphics g, @NotNull IterationState iterationState, @NotNull Point position, @NotNull Color defaultBackground, int lineHeight) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl", "paintAfterLineEndBackgroundSegments"));
        }
        if (iterationState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterationState", "com/intellij/openapi/editor/impl/EditorImpl", "paintAfterLineEndBackgroundSegments"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/EditorImpl", "paintAfterLineEndBackgroundSegments"));
        }
        if (defaultBackground == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultBackground", "com/intellij/openapi/editor/impl/EditorImpl", "paintAfterLineEndBackgroundSegments"));
        }
        while (iterationState.hasPastLineEndBackgroundSegment()) {
            TextAttributes backgroundAttributes = iterationState.getPastLineEndBackgroundAttributes();
            int width = EditorUtil.getSpaceWidth(backgroundAttributes.getFontType(), this) * iterationState.getPastLineEndBackgroundSegmentWidth();
            Color color = this.getBackgroundColor(backgroundAttributes);
            if (color != null && !color.equals(defaultBackground)) {
                g.setColor(color);
                g.fillRect(position.x, position.y, width, lineHeight);
            }
            position.x += width;
            iterationState.advanceToNextPastLineEndBackgroundSegment();
        }
    }

    private void paintAfterFileEndBackground(@NotNull IterationState iterationState, @NotNull Graphics g, @NotNull Point position, @NotNull Rectangle clip, int lineHeight, @NotNull Color defaultBackground, @NotNull boolean[] caretRowPainted) {
        if (iterationState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterationState", "com/intellij/openapi/editor/impl/EditorImpl", "paintAfterFileEndBackground"));
        }
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl", "paintAfterFileEndBackground"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/EditorImpl", "paintAfterFileEndBackground"));
        }
        if (clip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clip", "com/intellij/openapi/editor/impl/EditorImpl", "paintAfterFileEndBackground"));
        }
        if (defaultBackground == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultBackground", "com/intellij/openapi/editor/impl/EditorImpl", "paintAfterFileEndBackground"));
        }
        if (caretRowPainted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretRowPainted", "com/intellij/openapi/editor/impl/EditorImpl", "paintAfterFileEndBackground"));
        }
        Color backColor = iterationState.getPastFileEndBackground();
        if (backColor == null || backColor.equals(defaultBackground)) {
            return;
        }
        if (caretRowPainted[0] && backColor.equals(this.getColorsScheme().getColor(EditorColors.CARET_ROW_COLOR))) {
            return;
        }
        g.setColor(backColor);
        g.fillRect(position.x, position.y, clip.x + clip.width - position.x, lineHeight);
    }

    private int drawSoftWrapAwareBackground(@NotNull Graphics g, Color backColor, @NotNull CharSequence text, int start, int end, @NotNull Point position, @JdkConstants.FontStyle int fontType, @NotNull Color defaultBackground, @NotNull Rectangle clip, @NotNull TIntHashSet softWrapsToSkip, @NotNull boolean[] caretRowPainted) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl", "drawSoftWrapAwareBackground"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/EditorImpl", "drawSoftWrapAwareBackground"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/EditorImpl", "drawSoftWrapAwareBackground"));
        }
        if (defaultBackground == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultBackground", "com/intellij/openapi/editor/impl/EditorImpl", "drawSoftWrapAwareBackground"));
        }
        if (clip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clip", "com/intellij/openapi/editor/impl/EditorImpl", "drawSoftWrapAwareBackground"));
        }
        if (softWrapsToSkip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "softWrapsToSkip", "com/intellij/openapi/editor/impl/EditorImpl", "drawSoftWrapAwareBackground"));
        }
        if (caretRowPainted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretRowPainted", "com/intellij/openapi/editor/impl/EditorImpl", "drawSoftWrapAwareBackground"));
        }
        int startToUse = start;
        int softWrapRetrievalEndOffset = end;
        if (end > start) {
            --softWrapRetrievalEndOffset;
        }
        List<? extends SoftWrap> softWraps = this.getSoftWrapModel().getSoftWrapsForRange(start, softWrapRetrievalEndOffset);
        for (SoftWrap softWrap : softWraps) {
            int softWrapStart = softWrap.getStart();
            if (softWrapsToSkip.contains(softWrapStart)) continue;
            if (startToUse < softWrapStart) {
                position.x = this.drawBackground(g, backColor, text, startToUse, softWrapStart, position, fontType, defaultBackground, clip);
            }
            boolean drawCustomBackgroundAtSoftWrapVirtualSpace = !Comparing.equal((Object)backColor, (Object)defaultBackground) && (softWrapStart > start || Comparing.equal((Object)this.myLastBackgroundColor, (Object)backColor));
            this.drawSoftWrap(g, softWrap, position, fontType, backColor, drawCustomBackgroundAtSoftWrapVirtualSpace, defaultBackground, clip, caretRowPainted);
            startToUse = softWrapStart;
        }
        if (startToUse < end) {
            position.x = this.drawBackground(g, backColor, text, startToUse, end, position, fontType, defaultBackground, clip);
        }
        return position.x;
    }

    private void drawSoftWrap(@NotNull Graphics g, @NotNull SoftWrap softWrap, @NotNull Point position, @JdkConstants.FontStyle int fontType, @Nullable Color backColor, boolean drawCustomBackgroundAtSoftWrapVirtualSpace, @NotNull Color defaultBackground, @NotNull Rectangle clip, @NotNull boolean[] caretRowPainted) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl", "drawSoftWrap"));
        }
        if (softWrap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "softWrap", "com/intellij/openapi/editor/impl/EditorImpl", "drawSoftWrap"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/EditorImpl", "drawSoftWrap"));
        }
        if (defaultBackground == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultBackground", "com/intellij/openapi/editor/impl/EditorImpl", "drawSoftWrap"));
        }
        if (clip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clip", "com/intellij/openapi/editor/impl/EditorImpl", "drawSoftWrap"));
        }
        if (caretRowPainted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretRowPainted", "com/intellij/openapi/editor/impl/EditorImpl", "drawSoftWrap"));
        }
        CharSequence softWrapText = softWrap.getText();
        int activeRowY = this.getCaretModel().getVisualPosition().line * this.getLineHeight();
        int afterSoftWrapWidth = clip.x + clip.width - position.x;
        if (drawCustomBackgroundAtSoftWrapVirtualSpace && backColor != null) {
            this.drawBackground(g, backColor, afterSoftWrapWidth, position, defaultBackground, clip);
        } else if (position.y == activeRowY) {
            Color caretRowColor = this.mySettings.isCaretRowShown() ? this.getColorsScheme().getColor(EditorColors.CARET_ROW_COLOR) : null;
            this.drawBackground(g, caretRowColor, afterSoftWrapWidth, position, defaultBackground, clip);
            caretRowPainted[0] = true;
        }
        this.paintSelectionOnFirstSoftWrapLineIfNecessary(g, position, clip, defaultBackground, fontType);
        int i = CharArrayUtil.lastIndexOf((CharSequence)softWrapText, (String)"\n", (int)softWrapText.length()) + 1;
        int width = this.getTextSegmentWidth(softWrapText, i, softWrapText.length(), 0, fontType, clip) + this.getSoftWrapModel().getMinDrawingWidthInPixels(SoftWrapDrawingType.AFTER_SOFT_WRAP);
        position.x = 0;
        position.y += this.getLineHeight();
        if (drawCustomBackgroundAtSoftWrapVirtualSpace && backColor != null) {
            this.drawBackground(g, backColor, width, position, defaultBackground, clip);
        } else if (position.y == activeRowY) {
            Color caretRowColor = this.mySettings.isCaretRowShown() ? this.getColorsScheme().getColor(EditorColors.CARET_ROW_COLOR) : null;
            this.drawBackground(g, caretRowColor, width, position, defaultBackground, clip);
        }
        position.x = 0;
        this.paintSelectionOnSecondSoftWrapLineIfNecessary(g, position, clip, defaultBackground, fontType, softWrap);
        position.x = width;
    }

    private VisualPosition getSelectionStartPositionForPaint() {
        if (this.mySelectionStartPosition == null) {
            this.mySelectionStartPosition = this.getSelectionModel().getSelectionStartPosition();
        }
        return this.mySelectionStartPosition;
    }

    private VisualPosition getSelectionEndPositionForPaint() {
        if (this.mySelectionEndPosition == null) {
            this.mySelectionEndPosition = this.getSelectionModel().getSelectionEndPosition();
        }
        return this.mySelectionEndPosition;
    }

    private void paintSelectionOnFirstSoftWrapLineIfNecessary(@NotNull Graphics g, @NotNull Point position, @NotNull Rectangle clip, @NotNull Color defaultBackground, @JdkConstants.FontStyle int fontType) {
        VisualPosition selectionEndPosition;
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl", "paintSelectionOnFirstSoftWrapLineIfNecessary"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/EditorImpl", "paintSelectionOnFirstSoftWrapLineIfNecessary"));
        }
        if (clip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clip", "com/intellij/openapi/editor/impl/EditorImpl", "paintSelectionOnFirstSoftWrapLineIfNecessary"));
        }
        if (defaultBackground == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultBackground", "com/intellij/openapi/editor/impl/EditorImpl", "paintSelectionOnFirstSoftWrapLineIfNecessary"));
        }
        VisualPosition selectionStartPosition = this.getSelectionStartPositionForPaint();
        if (selectionStartPosition.equals((Object)(selectionEndPosition = this.getSelectionEndPositionForPaint()))) {
            return;
        }
        int currentVisualLine = position.y / this.getLineHeight();
        int lastColumn = EditorUtil.getLastVisualLineColumnNumber(this, currentVisualLine);
        if (currentVisualLine < selectionStartPosition.line || currentVisualLine > selectionEndPosition.line || currentVisualLine == selectionEndPosition.line && selectionEndPosition.column <= lastColumn) {
            return;
        }
        int columnsToSkip = selectionStartPosition.column - lastColumn;
        if (columnsToSkip > 0) {
            position.x += this.getSoftWrapModel().getMinDrawingWidthInPixels(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED);
            position.x += (columnsToSkip - 1) * EditorUtil.getSpaceWidth(0, this);
        }
        int width = selectionEndPosition.line > currentVisualLine ? clip.x + clip.width - position.x : (selectionStartPosition.line < currentVisualLine || selectionStartPosition.column <= lastColumn ? this.getSoftWrapModel().getMinDrawingWidthInPixels(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED) + (selectionEndPosition.column - lastColumn - 1) * EditorUtil.getSpaceWidth(fontType, this) : (selectionEndPosition.column - selectionStartPosition.column) * EditorUtil.getSpaceWidth(fontType, this));
        this.drawBackground(g, this.getColorsScheme().getColor(EditorColors.SELECTION_BACKGROUND_COLOR), width, position, defaultBackground, clip);
    }

    private void paintSelectionOnSecondSoftWrapLineIfNecessary(@NotNull Graphics g, @NotNull Point position, @NotNull Rectangle clip, @NotNull Color defaultBackground, @JdkConstants.FontStyle int fontType, @NotNull SoftWrap softWrap) {
        VisualPosition selectionEndPosition;
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl", "paintSelectionOnSecondSoftWrapLineIfNecessary"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/EditorImpl", "paintSelectionOnSecondSoftWrapLineIfNecessary"));
        }
        if (clip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clip", "com/intellij/openapi/editor/impl/EditorImpl", "paintSelectionOnSecondSoftWrapLineIfNecessary"));
        }
        if (defaultBackground == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultBackground", "com/intellij/openapi/editor/impl/EditorImpl", "paintSelectionOnSecondSoftWrapLineIfNecessary"));
        }
        if (softWrap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "softWrap", "com/intellij/openapi/editor/impl/EditorImpl", "paintSelectionOnSecondSoftWrapLineIfNecessary"));
        }
        VisualPosition selectionStartPosition = this.getSelectionStartPositionForPaint();
        if (selectionStartPosition.equals((Object)(selectionEndPosition = this.getSelectionEndPositionForPaint()))) {
            return;
        }
        int currentVisualLine = position.y / this.getLineHeight();
        if (currentVisualLine < selectionStartPosition.line || currentVisualLine > selectionEndPosition.line || currentVisualLine == selectionStartPosition.line && selectionStartPosition.column >= softWrap.getIndentInColumns()) {
            return;
        }
        if (selectionStartPosition.line == currentVisualLine && selectionStartPosition.column > 0) {
            position.x += selectionStartPosition.column * EditorUtil.getSpaceWidth(fontType, this);
        }
        int width = selectionEndPosition.line > currentVisualLine || selectionEndPosition.column >= softWrap.getIndentInColumns() ? softWrap.getIndentInPixels() - position.x : selectionEndPosition.column * EditorUtil.getSpaceWidth(fontType, this) - position.x;
        this.drawBackground(g, this.getColorsScheme().getColor(EditorColors.SELECTION_BACKGROUND_COLOR), width, position, defaultBackground, clip);
    }

    private int drawBackground(@NotNull Graphics g, Color backColor, @NotNull CharSequence text, int start, int end, @NotNull Point position, @JdkConstants.FontStyle int fontType, @NotNull Color defaultBackground, @NotNull Rectangle clip) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl", "drawBackground"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/EditorImpl", "drawBackground"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/EditorImpl", "drawBackground"));
        }
        if (defaultBackground == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultBackground", "com/intellij/openapi/editor/impl/EditorImpl", "drawBackground"));
        }
        if (clip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clip", "com/intellij/openapi/editor/impl/EditorImpl", "drawBackground"));
        }
        int width = this.getTextSegmentWidth(text, start, end, position.x, fontType, clip);
        return this.drawBackground(g, backColor, width, position, defaultBackground, clip);
    }

    private int drawBackground(@NotNull Graphics g, @Nullable Color backColor, int width, @NotNull Point position, @NotNull Color defaultBackground, @NotNull Rectangle clip) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl", "drawBackground"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/EditorImpl", "drawBackground"));
        }
        if (defaultBackground == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultBackground", "com/intellij/openapi/editor/impl/EditorImpl", "drawBackground"));
        }
        if (clip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clip", "com/intellij/openapi/editor/impl/EditorImpl", "drawBackground"));
        }
        if (backColor != null && !backColor.equals(defaultBackground) && clip.intersects(position.x, position.y, width, this.getLineHeight())) {
            if (backColor.equals(this.myLastBackgroundColor) && this.myLastBackgroundPosition.y == position.y && this.myLastBackgroundPosition.x + this.myLastBackgroundWidth == position.x) {
                this.myLastBackgroundWidth += width;
            } else {
                this.flushBackground(g, clip);
                this.myLastBackgroundColor = backColor;
                this.myLastBackgroundPosition = new Point(position);
                this.myLastBackgroundWidth = width;
            }
        }
        return position.x + width;
    }

    private void flushBackground(@NotNull Graphics g, @NotNull Rectangle clip) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl", "flushBackground"));
        }
        if (clip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clip", "com/intellij/openapi/editor/impl/EditorImpl", "flushBackground"));
        }
        if (this.myLastBackgroundColor != null) {
            Point position = this.myLastBackgroundPosition;
            int w = this.myLastBackgroundWidth;
            int height = this.getLineHeight();
            if (clip.intersects(position.x, position.y, w, height)) {
                g.setColor(this.myLastBackgroundColor);
                g.fillRect(position.x, position.y, w, height);
            }
            this.myLastBackgroundColor = null;
        }
    }

    @NotNull
    private LineIterator createLineIterator() {
        LineIterator lineIterator = this.myDocument.createLineIterator();
        if (lineIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "createLineIterator"));
        }
        return lineIterator;
    }

    private void paintText(@NotNull Graphics g, @NotNull Rectangle clip, @NotNull LogicalPosition clipStartPosition, int clipStartOffset, int clipEndOffset) {
        SoftWrap softWrap;
        FoldRegion collapsedFolderAt;
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl", "paintText"));
        }
        if (clip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clip", "com/intellij/openapi/editor/impl/EditorImpl", "paintText"));
        }
        if (clipStartPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clipStartPosition", "com/intellij/openapi/editor/impl/EditorImpl", "paintText"));
        }
        this.myCurrentFontType = null;
        this.myLastCache = null;
        int lineHeight = this.getLineHeight();
        int visibleLine = clip.y / lineHeight;
        int startLine = clipStartPosition.line;
        int start = clipStartOffset;
        Point position = new Point(0, visibleLine * lineHeight);
        if (startLine == 0 && this.myPrefixText != null) {
            position.x = this.drawStringWithSoftWraps(g, (CharSequence)new CharArrayCharSequence(this.myPrefixText), 0, this.myPrefixText.length, position, clip, this.myPrefixAttributes.getEffectColor(), this.myPrefixAttributes.getEffectType(), this.myPrefixAttributes.getFontType(), this.myPrefixAttributes.getForegroundColor(), -1, PAINT_NO_WHITESPACE);
        }
        if (startLine >= this.myDocument.getLineCount() || startLine < 0) {
            if (position.x > 0) {
                this.flushCachedChars(g);
            }
            return;
        }
        LineIterator lIterator = this.createLineIterator();
        lIterator.start(start);
        if (lIterator.atEnd()) {
            return;
        }
        IterationState iterationState = new IterationState(this, start, clipEndOffset, this.isPaintSelection());
        TextAttributes attributes = iterationState.getMergedAttributes();
        Color currentColor = attributes.getForegroundColor();
        if (currentColor == null) {
            currentColor = this.getForegroundColor();
        }
        Color effectColor = attributes.getEffectColor();
        EffectType effectType = attributes.getEffectType();
        int fontType = attributes.getFontType();
        g.setColor(currentColor);
        CharSequence chars = this.myDocument.getImmutableCharSequence();
        LineWhitespacePaintingStrategy context = new LineWhitespacePaintingStrategy();
        context.update(chars, lIterator);
        while (!iterationState.atEnd() && !lIterator.atEnd()) {
            int lEnd;
            int hEnd = iterationState.getEndOffset();
            if (hEnd >= (lEnd = lIterator.getEnd())) {
                FoldRegion collapsedFolderAt2 = this.myFoldingModel.getCollapsedRegionAtOffset(start);
                if (collapsedFolderAt2 == null) {
                    this.drawStringWithSoftWraps(g, chars, start, lEnd - lIterator.getSeparatorLength(), position, clip, effectColor, effectType, fontType, currentColor, clipStartOffset, context);
                    VirtualFile file = this.getVirtualFile();
                    if (this.myProject != null && file != null && !this.isOneLineMode()) {
                        int offset = position.x;
                        String additionalText = "";
                        for (EditorLinePainter painter : (EditorLinePainter[])EditorLinePainter.EP_NAME.getExtensions()) {
                            Collection<LineExtensionInfo> extensions = painter.getLineExtensions(this.myProject, file, lIterator.getLineNumber());
                            if (extensions == null || extensions.isEmpty()) continue;
                            for (LineExtensionInfo info : extensions) {
                                String text = info.getText();
                                additionalText = additionalText + text;
                                this.drawStringWithSoftWraps(g, text, 0, text.length(), position, clip, info.getEffectColor() == null ? effectColor : info.getEffectColor(), info.getEffectType() == null ? effectType : info.getEffectType(), info.getFontType(), info.getColor() == null ? currentColor : info.getColor(), clipStartOffset, context);
                            }
                        }
                        for (char ch : additionalText.toCharArray()) {
                            offset += EditorUtil.charWidth(ch, 2, this);
                        }
                        this.myLinePaintersWidth = Math.max(this.myLinePaintersWidth, offset);
                    }
                    position.x = 0;
                    if (position.y > clip.y + clip.height) break;
                    position.y += lineHeight;
                    start = lEnd;
                }
                lIterator.advance();
                if (lIterator.atEnd()) continue;
                context.update(chars, lIterator);
                continue;
            }
            FoldRegion collapsedFolderAt2 = iterationState.getCurrentFold();
            if (collapsedFolderAt2 != null) {
                SoftWrap softWrap2 = this.mySoftWrapModel.getSoftWrap(collapsedFolderAt2.getStartOffset());
                if (softWrap2 != null) {
                    position.x = this.drawStringWithSoftWraps(g, chars, collapsedFolderAt2.getStartOffset(), collapsedFolderAt2.getStartOffset(), position, clip, effectColor, effectType, fontType, currentColor, clipStartOffset, context);
                }
                int foldingXStart = position.x;
                position.x = this.drawString(g, collapsedFolderAt2.getPlaceholderText(), position, clip, effectColor, effectType, fontType, currentColor, PAINT_NO_WHITESPACE);
                BorderEffect.paintFoldedEffect(g, foldingXStart, position.y, position.x, this.getLineHeight(), effectColor, effectType);
            } else {
                position.x = this.drawStringWithSoftWraps(g, chars, start, Math.min(hEnd, lEnd - lIterator.getSeparatorLength()), position, clip, effectColor, effectType, fontType, currentColor, clipStartOffset, context);
            }
            iterationState.advance();
            attributes = iterationState.getMergedAttributes();
            currentColor = attributes.getForegroundColor();
            if (currentColor == null) {
                currentColor = this.getForegroundColor();
            }
            effectColor = attributes.getEffectColor();
            effectType = attributes.getEffectType();
            fontType = attributes.getFontType();
            start = iterationState.getStartOffset();
        }
        if ((collapsedFolderAt = iterationState.getCurrentFold()) != null) {
            int foldingXStart = position.x;
            int foldingXEnd = this.drawStringWithSoftWraps(g, collapsedFolderAt.getPlaceholderText(), position, clip, effectColor, effectType, fontType, currentColor, clipStartOffset, PAINT_NO_WHITESPACE);
            BorderEffect.paintFoldedEffect(g, foldingXStart, position.y, foldingXEnd, this.getLineHeight(), effectColor, effectType);
        }
        if ((softWrap = this.mySoftWrapModel.getSoftWrap(clipEndOffset)) != null) {
            this.mySoftWrapModel.paint(g, SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED, position.x, position.y, this.getLineHeight());
        }
        this.flushCachedChars(g);
    }

    private boolean paintPlaceholderText(@NotNull Graphics g, @NotNull Rectangle clip) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl", "paintPlaceholderText"));
        }
        if (clip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clip", "com/intellij/openapi/editor/impl/EditorImpl", "paintPlaceholderText"));
        }
        CharSequence hintText = this.myPlaceholderText;
        if (this.myDocument.getTextLength() > 0 || hintText == null || hintText.length() == 0) {
            return false;
        }
        if (KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() == this.myEditorComponent && !this.myShowPlaceholderWhenFocused) {
            this.myLastBackgroundColor = this.getBackgroundColor();
            this.myLastBackgroundPosition = new Point(0, 0);
            this.myLastBackgroundWidth = this.myLastPaintedPlaceholderWidth;
            this.flushBackground(g, clip);
            return false;
        }
        hintText = SwingUtilities.layoutCompoundLabel(g.getFontMetrics(), ((Object)hintText).toString(), null, 0, 0, 0, 0, this.myEditorComponent.getBounds(), new Rectangle(), new Rectangle(), 0);
        this.myLastPaintedPlaceholderWidth = this.drawString(g, hintText, 0, hintText.length(), new Point(0, 0), clip, null, null, 0, this.myFoldingModel.getPlaceholderAttributes().getForegroundColor(), PAINT_NO_WHITESPACE);
        this.flushCachedChars(g);
        return true;
    }

    public boolean isPaintSelection() {
        return this.myPaintSelection || !this.isOneLineMode() || IJSwingUtilities.hasFocus(this.getContentComponent());
    }

    public void setPaintSelection(boolean paintSelection) {
        this.myPaintSelection = paintSelection;
    }

    @NotNull
    @NonNls
    public String dumpState() {
        String string = "prefix: '" + (this.myPrefixText == null ? "none" : new String(this.myPrefixText)) + "', allow caret inside tab: " + this.mySettings.isCaretInsideTabs() + ", allow caret after line end: " + this.mySettings.isVirtualSpace() + ", soft wraps: " + (this.mySoftWrapModel.isSoftWrappingEnabled() ? "on" : "off") + ", soft wraps data: " + this.getSoftWrapModel().dumpState() + "\n\nfolding data: " + this.getFoldingModel().dumpState() + (this.myDocument instanceof DocumentImpl ? "\n\ndocument info: " + ((DocumentImpl)this.myDocument).dumpState() : "") + "\nfont preferences: " + this.myScheme.getFontPreferences();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "dumpState"));
        }
        return string;
    }

    private static boolean isRtlCharacter(char c) {
        byte directionality = Character.getDirectionality(c);
        return directionality == 1 || directionality == 2 || directionality == 16 || directionality == 17;
    }

    private void flushCachedChars(@NotNull Graphics g) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl", "flushCachedChars"));
        }
        for (CachedFontContent cache : this.myFontCache) {
            cache.flushContent(g);
        }
        this.myLastCache = null;
    }

    private void paintCaretCursor(@NotNull Graphics g) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl", "paintCaretCursor"));
        }
        this.myCaretCursor.paint(g);
    }

    private void paintLineMarkersSeparators(final @NotNull Graphics g, final @NotNull Rectangle clip, @NotNull MarkupModelEx markupModel, int clipStartOffset, int clipEndOffset) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl", "paintLineMarkersSeparators"));
        }
        if (clip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clip", "com/intellij/openapi/editor/impl/EditorImpl", "paintLineMarkersSeparators"));
        }
        if (markupModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markupModel", "com/intellij/openapi/editor/impl/EditorImpl", "paintLineMarkersSeparators"));
        }
        markupModel.processRangeHighlightersOverlappingWith(clipStartOffset, clipEndOffset, (Processor<? super RangeHighlighterEx>)new Processor<RangeHighlighterEx>(){

            public boolean process(@NotNull RangeHighlighterEx lineMarker) {
                if (lineMarker == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineMarker", "com/intellij/openapi/editor/impl/EditorImpl$22", "process"));
                }
                if (!lineMarker.getEditorFilter().avaliableIn((Editor)EditorImpl.this)) {
                    return true;
                }
                EditorImpl.this.paintLineMarkerSeparator(lineMarker, clip, g);
                return true;
            }
        });
    }

    private void paintLineMarkerSeparator(@NotNull RangeHighlighter marker, @NotNull Rectangle clip, @NotNull Graphics g) {
        int line;
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/openapi/editor/impl/EditorImpl", "paintLineMarkerSeparator"));
        }
        if (clip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clip", "com/intellij/openapi/editor/impl/EditorImpl", "paintLineMarkerSeparator"));
        }
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl", "paintLineMarkerSeparator"));
        }
        Color separatorColor = marker.getLineSeparatorColor();
        LineSeparatorRenderer lineSeparatorRenderer = marker.getLineSeparatorRenderer();
        if (separatorColor == null && lineSeparatorRenderer == null) {
            return;
        }
        int n = line = marker.getLineSeparatorPlacement() == SeparatorPlacement.TOP ? marker.getDocument().getLineNumber(marker.getStartOffset()) : marker.getDocument().getLineNumber(marker.getEndOffset());
        if (line < 0 || line >= this.myDocument.getLineCount()) {
            return;
        }
        SeparatorPlacement placement = marker.getLineSeparatorPlacement();
        int y = placement == SeparatorPlacement.TOP ? this.visibleLineToY(this.logicalToVisualLine(line)) : (line + 1 >= this.myDocument.getLineCount() ? this.visibleLineToY(this.offsetToVisualLine(this.myDocument.getTextLength()) + 1) : this.logicalLineToY(line + 1));
        if (y < clip.y || y > clip.y + clip.height) {
            return;
        }
        int endShift = clip.x + clip.width;
        g.setColor(separatorColor);
        if (this.mySettings.isRightMarginShown() && this.myScheme.getColor(EditorColors.RIGHT_MARGIN_COLOR) != null) {
            endShift = Math.min(endShift, this.mySettings.getRightMargin(this.myProject) * EditorUtil.getSpaceWidth(0, this));
        }
        if (lineSeparatorRenderer != null) {
            lineSeparatorRenderer.drawLine(g, 0, endShift, y - 1);
        } else {
            UIUtil.drawLine((Graphics)g, (int)0, (int)(y - 1), (int)endShift, (int)(y - 1));
        }
    }

    private int drawStringWithSoftWraps(@NotNull Graphics g, @NotNull String text, @NotNull Point position, @NotNull Rectangle clip, Color effectColor, EffectType effectType, @JdkConstants.FontStyle int fontType, Color fontColor, int startDrawingOffset, WhitespacePaintingStrategy context) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl", "drawStringWithSoftWraps"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/EditorImpl", "drawStringWithSoftWraps"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/EditorImpl", "drawStringWithSoftWraps"));
        }
        if (clip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clip", "com/intellij/openapi/editor/impl/EditorImpl", "drawStringWithSoftWraps"));
        }
        return this.drawStringWithSoftWraps(g, text, 0, text.length(), position, clip, effectColor, effectType, fontType, fontColor, startDrawingOffset, context);
    }

    private int drawStringWithSoftWraps(@NotNull Graphics g, CharSequence text, int start, int end, @NotNull Point position, @NotNull Rectangle clip, Color effectColor, EffectType effectType, @JdkConstants.FontStyle int fontType, Color fontColor, int startDrawingOffset, WhitespacePaintingStrategy context) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl", "drawStringWithSoftWraps"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/EditorImpl", "drawStringWithSoftWraps"));
        }
        if (clip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clip", "com/intellij/openapi/editor/impl/EditorImpl", "drawStringWithSoftWraps"));
        }
        if (start >= end && this.getSoftWrapModel().getSoftWrap(start) == null) {
            return position.x;
        }
        int softWrapRetrievalEndOffset = end;
        if (start < end) {
            --softWrapRetrievalEndOffset;
        }
        block0: for (SoftWrap softWrap : this.getSoftWrapModel().getSoftWrapsForRange(start, softWrapRetrievalEndOffset)) {
            char[] softWrapChars = softWrap.getChars();
            CharArrayCharSequence softWrapSeq = new CharArrayCharSequence(softWrapChars);
            if (softWrap.getStart() == startDrawingOffset) {
                int i = CharArrayUtil.lastIndexOf((char[])softWrapChars, (char)'\n', (int)0, (int)softWrapChars.length);
                if (i < softWrapChars.length - 1) {
                    position.x = 0;
                    position.x = this.drawString(g, (CharSequence)softWrapSeq, i + 1, softWrapChars.length, position, clip, null, null, fontType, fontColor, context);
                }
                position.x += this.mySoftWrapModel.paint(g, SoftWrapDrawingType.AFTER_SOFT_WRAP, position.x, position.y, this.getLineHeight());
                continue;
            }
            if (softWrap.getStart() > start) {
                position.x = this.drawString(g, text, start, softWrap.getStart(), position, clip, null, null, fontType, fontColor, context);
            }
            start = softWrap.getStart();
            int softWrapSegmentStartIndex = 0;
            for (int i = 0; i < softWrapChars.length; ++i) {
                if (softWrapChars[i] != '\n') continue;
                if (i - softWrapSegmentStartIndex > 0) {
                    this.drawString(g, (CharSequence)softWrapSeq, softWrapSegmentStartIndex, i, position, clip, null, null, fontType, fontColor, context);
                }
                this.mySoftWrapModel.paint(g, SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED, position.x, position.y, this.getLineHeight());
                position.x = 0;
                if (position.y > clip.y + clip.height) break block0;
                position.y += this.getLineHeight();
                softWrapSegmentStartIndex = i + 1;
            }
            if (softWrapSegmentStartIndex < softWrapChars.length) {
                position.x += this.drawString(g, (CharSequence)softWrapSeq, softWrapSegmentStartIndex, softWrapChars.length, position, clip, null, null, fontType, fontColor, context);
            }
            position.x += this.mySoftWrapModel.paint(g, SoftWrapDrawingType.AFTER_SOFT_WRAP, position.x, position.y, this.getLineHeight());
        }
        position.x = this.drawString(g, text, start, end, position, clip, effectColor, effectType, fontType, fontColor, context);
        return position.x;
    }

    private int drawString(@NotNull Graphics g, CharSequence text, int start, int end, @NotNull Point position, @NotNull Rectangle clip, @Nullable Color effectColor, @Nullable EffectType effectType, @JdkConstants.FontStyle int fontType, Color fontColor, WhitespacePaintingStrategy context) {
        boolean isInClip;
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl", "drawString"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/EditorImpl", "drawString"));
        }
        if (clip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clip", "com/intellij/openapi/editor/impl/EditorImpl", "drawString"));
        }
        if (start >= end) {
            return position.x;
        }
        boolean bl = isInClip = this.getLineHeight() + position.y >= clip.y && position.y <= clip.y + clip.height;
        if (!isInClip) {
            return position.x;
        }
        int y = this.getAscent() + position.y;
        int x = position.x;
        return this.drawTabbedString(g, text, start, end, x, y, effectColor, effectType, fontType, fontColor, clip, context);
    }

    public int getAscent() {
        return this.getLineHeight() - this.getDescent();
    }

    private int drawString(@NotNull Graphics g, @NotNull String text, @NotNull Point position, @NotNull Rectangle clip, Color effectColor, EffectType effectType, @JdkConstants.FontStyle int fontType, Color fontColor, WhitespacePaintingStrategy context) {
        boolean isInClip;
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl", "drawString"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/EditorImpl", "drawString"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/EditorImpl", "drawString"));
        }
        if (clip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clip", "com/intellij/openapi/editor/impl/EditorImpl", "drawString"));
        }
        boolean bl = isInClip = this.getLineHeight() + position.y >= clip.y && position.y <= clip.y + clip.height;
        if (!isInClip) {
            return position.x;
        }
        int y = this.getAscent() + position.y;
        int x = position.x;
        return this.drawTabbedString(g, text, 0, text.length(), x, y, effectColor, effectType, fontType, fontColor, clip, context);
    }

    private int drawTabbedString(@NotNull Graphics g, CharSequence text, int start, int end, int x, int y, @Nullable Color effectColor, EffectType effectType, @JdkConstants.FontStyle int fontType, Color fontColor, @NotNull Rectangle clip, WhitespacePaintingStrategy context) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl", "drawTabbedString"));
        }
        if (clip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clip", "com/intellij/openapi/editor/impl/EditorImpl", "drawTabbedString"));
        }
        int xStart = x;
        for (int i = start; i < end; ++i) {
            if (text.charAt(i) != '\t') continue;
            x = this.drawTablessString(text, start, i, g, x, y, fontType, fontColor, clip, context);
            int x1 = EditorUtil.nextTabStop(x, this);
            this.drawTabPlacer(g, y, x, x1, i, context);
            x = x1;
            start = i + 1;
        }
        x = this.drawTablessString(text, start, end, g, x, y, fontType, fontColor, clip, context);
        if (effectColor != null) {
            Color savedColor = g.getColor();
            int xEnd = x;
            if (xStart < clip.x && xEnd < clip.x || xStart > clip.x + clip.width && xEnd > clip.x + clip.width) {
                return x;
            }
            if (xEnd > clip.x + clip.width) {
                xEnd = clip.x + clip.width;
            }
            if (xStart < clip.x) {
                xStart = clip.x;
            }
            if (effectType == EffectType.LINE_UNDERSCORE) {
                g.setColor(effectColor);
                UIUtil.drawLine((Graphics)g, (int)xStart, (int)(y + 1), (int)xEnd, (int)(y + 1));
                g.setColor(savedColor);
            } else if (effectType == EffectType.BOLD_LINE_UNDERSCORE) {
                g.setColor(effectColor);
                UIUtil.drawLine((Graphics)g, (int)xStart, (int)y, (int)xEnd, (int)y);
                UIUtil.drawLine((Graphics)g, (int)xStart, (int)(y + 1), (int)xEnd, (int)(y + 1));
                g.setColor(savedColor);
            } else if (effectType == EffectType.STRIKEOUT) {
                g.setColor(effectColor);
                int y1 = y - this.getCharHeight() / 2;
                UIUtil.drawLine((Graphics)g, (int)xStart, (int)y1, (int)xEnd, (int)y1);
                g.setColor(savedColor);
            } else if (effectType == EffectType.WAVE_UNDERSCORE) {
                g.setColor(effectColor);
                UIUtil.drawWave((Graphics2D)((Graphics2D)g), (Rectangle)new Rectangle(xStart, y + 1, xEnd - xStart, this.getDescent() - 1));
                g.setColor(savedColor);
            } else if (effectType == EffectType.BOLD_DOTTED_LINE) {
                Color bgColor = this.getBackgroundColor();
                int dottedAt = SystemInfo.isMac ? y : y + 1;
                UIUtil.drawBoldDottedLine((Graphics2D)((Graphics2D)g), (int)xStart, (int)xEnd, (int)dottedAt, (Color)bgColor, (Color)effectColor, (boolean)false);
            }
        }
        return x;
    }

    private int drawTablessString(CharSequence text, int start, int end, @NotNull Graphics g, int x, int y, @JdkConstants.FontStyle int fontType, Color fontColor, @NotNull Rectangle clip, WhitespacePaintingStrategy context) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl", "drawTablessString"));
        }
        if (clip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clip", "com/intellij/openapi/editor/impl/EditorImpl", "drawTablessString"));
        }
        int endX = x;
        if (start < end) {
            FontInfo font = null;
            boolean drawWhitespace = false;
            for (int j = start; j < end; ++j) {
                boolean isRtlChar;
                if (x > clip.x + clip.width) {
                    return endX;
                }
                char c = text.charAt(j);
                FontInfo newFont = EditorUtil.fontForChar(c, fontType, this);
                boolean newDrawWhitespace = context.showWhitespaceAtOffset(j);
                boolean bl = isRtlChar = this.myDisableRtl && EditorImpl.isRtlCharacter(c);
                if (j > start && (endX < clip.x || endX > clip.x + clip.width || newFont != font || newDrawWhitespace != drawWhitespace || isRtlChar)) {
                    if (EditorImpl.isOverlappingRange(clip, x, endX)) {
                        this.drawCharsCached(g, text, start, j, x, y, fontType, fontColor, drawWhitespace);
                    }
                    start = j;
                    x = endX;
                }
                font = newFont;
                drawWhitespace = newDrawWhitespace;
                endX += font.charWidth(c);
                if ((!font.hasGlyphsToBreakDrawingIteration() || !font.getSymbolsToBreakDrawingIteration().contains((int)c)) && !isRtlChar) continue;
                this.drawCharsCached(g, text, start, j + 1, x, y, fontType, fontColor, drawWhitespace);
                start = j + 1;
                x = endX;
            }
            if (EditorImpl.isOverlappingRange(clip, x, endX)) {
                this.drawCharsCached(g, text, start, end, x, y, fontType, fontColor, drawWhitespace);
            }
        }
        return endX;
    }

    private static boolean isOverlappingRange(Rectangle clip, int xStart, int xEnd) {
        return !(xStart < clip.x && xEnd < clip.x || xStart > clip.x + clip.width && xEnd > clip.x + clip.width);
    }

    private void drawTabPlacer(Graphics g, int y, int start, int stop, int offset, WhitespacePaintingStrategy context) {
        if (context.showWhitespaceAtOffset(offset)) {
            this.myTabPainter.paint(g, y, start, stop);
        }
    }

    private void drawCharsCached(@NotNull Graphics g, CharSequence data, int start, int end, int x, int y, @JdkConstants.FontStyle int fontType, Color color, boolean drawWhitespace) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl", "drawCharsCached"));
        }
        FontInfo fnt = EditorUtil.fontForChar(data.charAt(start), fontType, this);
        if (this.myLastCache != null && EditorImpl.spacesOnly(data, start, end) && fnt.charWidth(' ') == this.myLastCache.spaceWidth) {
            this.myLastCache.addContent(g, data, start, end, x, y, null, drawWhitespace);
        } else {
            this.drawCharsCached(g, data, start, end, x, y, fnt, color, drawWhitespace);
        }
    }

    private void drawCharsCached(@NotNull Graphics g, @NotNull CharSequence data, int start, int end, int x, int y, @NotNull FontInfo fnt, Color color, boolean drawWhitespace) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl", "drawCharsCached"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/editor/impl/EditorImpl", "drawCharsCached"));
        }
        if (fnt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fnt", "com/intellij/openapi/editor/impl/EditorImpl", "drawCharsCached"));
        }
        CachedFontContent cache = null;
        for (CachedFontContent fontCache : this.myFontCache) {
            if (fontCache.myFontType != fnt) continue;
            cache = fontCache;
            break;
        }
        if (cache == null) {
            cache = new CachedFontContent(fnt);
            this.myFontCache.add(cache);
        }
        this.myLastCache = cache;
        cache.addContent(g, data, start, end, x, y, color, drawWhitespace);
    }

    private static boolean spacesOnly(CharSequence chars, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (chars.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    private void drawChars(@NotNull Graphics g, CharSequence data, int start, int end, int x, int y, boolean drawWhitespace) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl", "drawChars"));
        }
        g.drawString(((Object)data.subSequence(start, end)).toString(), x, y);
        if (drawWhitespace) {
            Color oldColor = g.getColor();
            g.setColor(this.myScheme.getColor(EditorColors.WHITESPACES_COLOR));
            FontMetrics metrics = g.getFontMetrics();
            for (int i = start; i < end; ++i) {
                int charWidth;
                char c = data.charAt(i);
                int n = charWidth = isOracleRetina ? GraphicsUtil.charWidth((char)c, (Font)g.getFont()) : metrics.charWidth(c);
                if (c == ' ') {
                    g.fillRect(x + (charWidth >> 1), y, 1, 1);
                } else if (c == '\u3000') {
                    int charHeight = this.getCharHeight();
                    g.drawRect(x + 2, y - charHeight, charWidth - 4, charHeight);
                }
                x += charWidth;
            }
            g.setColor(oldColor);
        }
    }

    private int getTextSegmentWidth(@NotNull CharSequence text, int start, int end, int xStart, @JdkConstants.FontStyle int fontType, @NotNull Rectangle clip) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/EditorImpl", "getTextSegmentWidth"));
        }
        if (clip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clip", "com/intellij/openapi/editor/impl/EditorImpl", "getTextSegmentWidth"));
        }
        int x = xStart;
        for (int i = start; i < end && xStart < clip.x + clip.width; ++i) {
            char c = text.charAt(i);
            x = c == '\t' ? EditorUtil.nextTabStop(x, this) : (x += EditorUtil.charWidth(c, fontType, this));
            if (x > clip.x + clip.width) break;
        }
        return x - xStart;
    }

    public int getLineHeight() {
        EditorImpl.assertReadAccess();
        int lineHeight = this.myLineHeight;
        if (lineHeight < 0) {
            FontMetrics fontMetrics = this.myEditorComponent.getFontMetrics(this.myScheme.getFont(EditorFontType.PLAIN));
            int fontMetricsHeight = fontMetrics.getHeight();
            lineHeight = (int)((float)fontMetricsHeight * (this.isOneLineMode() ? 1.0f : this.myScheme.getLineSpacing()));
            if (lineHeight <= 0 && (lineHeight = fontMetricsHeight) <= 0) {
                lineHeight = 12;
            }
            assert (lineHeight > 0) : lineHeight;
            this.myLineHeight = lineHeight;
        }
        return lineHeight;
    }

    public int getDescent() {
        if (this.myDescent != -1) {
            return this.myDescent;
        }
        FontMetrics fontMetrics = this.myEditorComponent.getFontMetrics(this.myScheme.getFont(EditorFontType.PLAIN));
        this.myDescent = fontMetrics.getDescent();
        return this.myDescent;
    }

    @NotNull
    public FontMetrics getFontMetrics(@JdkConstants.FontStyle int fontType) {
        if (this.myPlainFontMetrics == null) {
            EditorImpl.assertIsDispatchThread();
            this.myPlainFontMetrics = this.myEditorComponent.getFontMetrics(this.myScheme.getFont(EditorFontType.PLAIN));
            this.myBoldFontMetrics = this.myEditorComponent.getFontMetrics(this.myScheme.getFont(EditorFontType.BOLD));
            this.myItalicFontMetrics = this.myEditorComponent.getFontMetrics(this.myScheme.getFont(EditorFontType.ITALIC));
            this.myBoldItalicFontMetrics = this.myEditorComponent.getFontMetrics(this.myScheme.getFont(EditorFontType.BOLD_ITALIC));
        }
        if (fontType == 0) {
            FontMetrics fontMetrics = this.myPlainFontMetrics;
            if (fontMetrics == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getFontMetrics"));
            }
            return fontMetrics;
        }
        if (fontType == 1) {
            FontMetrics fontMetrics = this.myBoldFontMetrics;
            if (fontMetrics == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getFontMetrics"));
            }
            return fontMetrics;
        }
        if (fontType == 2) {
            FontMetrics fontMetrics = this.myItalicFontMetrics;
            if (fontMetrics == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getFontMetrics"));
            }
            return fontMetrics;
        }
        if (fontType == 3) {
            FontMetrics fontMetrics = this.myBoldItalicFontMetrics;
            if (fontMetrics == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getFontMetrics"));
            }
            return fontMetrics;
        }
        LOG.error("Unknown font type: " + fontType);
        FontMetrics fontMetrics = this.myPlainFontMetrics;
        if (fontMetrics == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getFontMetrics"));
        }
        return fontMetrics;
    }

    private int getCharHeight() {
        if (this.myCharHeight == -1) {
            EditorImpl.assertIsDispatchThread();
            FontMetrics fontMetrics = this.myEditorComponent.getFontMetrics(this.myScheme.getFont(EditorFontType.PLAIN));
            this.myCharHeight = fontMetrics.charWidth('a');
        }
        return this.myCharHeight;
    }

    public int getPreferredHeight() {
        if (ourIsUnitTestMode && this.getUserData(DO_DOCUMENT_UPDATE_TEST) == null) {
            return 1;
        }
        if (this.isOneLineMode()) {
            return this.getLineHeight();
        }
        int size = Math.max(this.mySizeContainer.getContentHeight(), this.getLineHeight());
        if (this.mySettings.isAdditionalPageAtBottom()) {
            int lineHeight = this.getLineHeight();
            int visibleAreaHeight = this.getScrollingModel().getVisibleArea().height;
            if (visibleAreaHeight > 0 || this.myVirtualPageHeight <= 0) {
                this.myVirtualPageHeight = Math.max(visibleAreaHeight - 2 * lineHeight, lineHeight);
            }
            return size + Math.max(this.myVirtualPageHeight, 0);
        }
        return size + this.mySettings.getAdditionalLinesCount() * this.getLineHeight();
    }

    public Dimension getPreferredSize() {
        int additionalSpace;
        if (ourIsUnitTestMode && this.getUserData(DO_DOCUMENT_UPDATE_TEST) == null) {
            return new Dimension(1, 1);
        }
        Dimension draft = this.getSizeWithoutCaret();
        int n = additionalSpace = this.shouldRespectAdditionalColumns() ? this.mySettings.getAdditionalColumnsCount() * EditorUtil.getSpaceWidth(0, this) : 0;
        if (!this.myDocument.isInBulkUpdate()) {
            for (Caret caret : this.myCaretModel.getAllCarets()) {
                if (!caret.isUpToDate()) continue;
                int caretX = this.visualPositionToXY((VisualPosition)caret.getVisualPosition()).x;
                draft.width = Math.max(caretX, draft.width);
            }
        }
        draft.width += additionalSpace;
        return draft;
    }

    private boolean shouldRespectAdditionalColumns() {
        return !this.mySoftWrapModel.isSoftWrappingEnabled() || this.mySoftWrapModel.isRespectAdditionalColumns() || this.mySizeContainer.getContentSize().getWidth() > this.myScrollingModel.getVisibleArea().getWidth();
    }

    private Dimension getSizeWithoutCaret() {
        Dimension size = this.mySizeContainer.getContentSize();
        return new Dimension(size.width, this.getPreferredHeight());
    }

    @Override
    @NotNull
    public Dimension getContentSize() {
        Dimension size = this.mySizeContainer.getContentSize();
        Dimension dimension = new Dimension(size.width, size.height + this.mySettings.getAdditionalLinesCount() * this.getLineHeight());
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getContentSize"));
        }
        return dimension;
    }

    @Override
    @NotNull
    public JScrollPane getScrollPane() {
        JScrollPane jScrollPane = this.myScrollPane;
        if (jScrollPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getScrollPane"));
        }
        return jScrollPane;
    }

    public void setBorder(Border border) {
        this.myScrollPane.setBorder(border);
    }

    public Insets getInsets() {
        return this.myScrollPane.getInsets();
    }

    public int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/EditorImpl", "logicalPositionToOffset"));
        }
        return this.logicalPositionToOffset(pos, true);
    }

    @Override
    public int logicalPositionToOffset(@NotNull LogicalPosition pos, boolean softWrapAware) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/EditorImpl", "logicalPositionToOffset"));
        }
        if (softWrapAware) {
            return this.mySoftWrapModel.logicalPositionToOffset(pos);
        }
        EditorImpl.assertReadAccess();
        if (this.myDocument.getLineCount() == 0) {
            return 0;
        }
        if (pos.line < 0) {
            throw new IndexOutOfBoundsException("Wrong line: " + pos.line);
        }
        if (pos.column < 0) {
            throw new IndexOutOfBoundsException("Wrong column:" + pos.column);
        }
        if (pos.line >= this.myDocument.getLineCount()) {
            return this.myDocument.getTextLength();
        }
        int start = this.myDocument.getLineStartOffset(pos.line);
        if (pos.column == 0) {
            return start;
        }
        int end = this.myDocument.getLineEndOffset(pos.line);
        int x = this.getDocument().getLineNumber(start) == 0 ? this.getPrefixTextWidthInPixels() : 0;
        int result = EditorUtil.calcSoftWrapUnawareOffset(this, this.myDocument.getImmutableCharSequence(), start, end, pos.column, EditorUtil.getTabSize(this), x, new int[]{0}, null);
        if (result >= 0) {
            return result;
        }
        return end;
    }

    @Override
    public void setLastColumnNumber(int val) {
        EditorImpl.assertIsDispatchThread();
        this.myLastColumnNumber = val;
    }

    @Override
    public int getLastColumnNumber() {
        EditorImpl.assertReadAccess();
        return this.myLastColumnNumber;
    }

    public int getVisibleLineCount() {
        return this.getVisibleLogicalLinesCount() + this.getSoftWrapModel().getSoftWrapsIntroducedLinesNumber();
    }

    private int getVisibleLogicalLinesCount() {
        return this.getDocument().getLineCount() - this.myFoldingModel.getFoldedLinesCountBefore(this.getDocument().getTextLength() + 1);
    }

    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition logicalPos) {
        if (logicalPos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalPos", "com/intellij/openapi/editor/impl/EditorImpl", "logicalToVisualPosition"));
        }
        VisualPosition visualPosition = this.logicalToVisualPosition(logicalPos, true);
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "logicalToVisualPosition"));
        }
        return visualPosition;
    }

    @Override
    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition logicalPos, boolean softWrapAware) {
        if (logicalPos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalPos", "com/intellij/openapi/editor/impl/EditorImpl", "logicalToVisualPosition"));
        }
        VisualPosition visualPosition = this.doLogicalToVisualPosition(logicalPos, softWrapAware, 0);
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "logicalToVisualPosition"));
        }
        return visualPosition;
    }

    @NotNull
    private VisualPosition doLogicalToVisualPosition(@NotNull LogicalPosition logicalPos, boolean softWrapAware, int stackDepth) {
        if (logicalPos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalPos", "com/intellij/openapi/editor/impl/EditorImpl", "doLogicalToVisualPosition"));
        }
        EditorImpl.assertReadAccess();
        if (!this.myFoldingModel.isFoldingEnabled() && !this.mySoftWrapModel.isSoftWrappingEnabled()) {
            VisualPosition visualPosition = new VisualPosition(logicalPos.line, logicalPos.column);
            if (visualPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "doLogicalToVisualPosition"));
            }
            return visualPosition;
        }
        int offset = this.logicalPositionToOffset(logicalPos);
        FoldRegion outermostCollapsed = this.myFoldingModel.getCollapsedRegionAtOffset(offset);
        if (outermostCollapsed != null && offset > outermostCollapsed.getStartOffset()) {
            if (offset < this.getDocument().getTextLength()) {
                offset = outermostCollapsed.getStartOffset();
                LogicalPosition foldStart = this.offsetToLogicalPosition(offset);
                if (stackDepth > 15) {
                    LOG.error("Detected potential StackOverflowError at logical->visual position mapping. Given logical position: '" + logicalPos + "'. State: " + this.dumpState());
                    stackDepth = -1;
                }
                VisualPosition visualPosition = this.doLogicalToVisualPosition(foldStart, true, stackDepth + 1);
                if (visualPosition == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "doLogicalToVisualPosition"));
                }
                return visualPosition;
            }
            offset = outermostCollapsed.getEndOffset() + 3;
        }
        int line = logicalPos.line;
        int column = logicalPos.column;
        int foldedLinesCountBefore = this.myFoldingModel.getFoldedLinesCountBefore(offset);
        if ((line -= foldedLinesCountBefore) < 0) {
            LogMessageEx.error(LOG, "Invalid LogicalPosition -> VisualPosition processing", String.format("Given logical position: %s; matched line: %d; fold lines before: %d, state: %s", logicalPos, line, foldedLinesCountBefore, this.dumpState()));
        }
        FoldRegion[] topLevel = this.myFoldingModel.fetchTopLevel();
        LogicalPosition anchorFoldingPosition = logicalPos;
        for (int idx = this.myFoldingModel.getLastCollapsedRegionBefore(offset); idx >= 0 && topLevel != null; --idx) {
            FoldRegion region = topLevel[idx];
            if (!region.isValid()) continue;
            if (region.getDocument().getLineNumber(region.getEndOffset()) != anchorFoldingPosition.line || region.getEndOffset() > offset) break;
            LogicalPosition foldStart = this.offsetToLogicalPosition(region.getStartOffset());
            LogicalPosition foldEnd = this.offsetToLogicalPosition(region.getEndOffset());
            column += foldStart.column + region.getPlaceholderText().length() - foldEnd.column;
            offset = region.getStartOffset();
            anchorFoldingPosition = foldStart;
        }
        VisualPosition softWrapUnawarePosition = new VisualPosition(line, Math.max(0, column));
        if (softWrapAware) {
            VisualPosition visualPosition = this.mySoftWrapModel.adjustVisualPosition(logicalPos, softWrapUnawarePosition);
            if (visualPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "doLogicalToVisualPosition"));
            }
            return visualPosition;
        }
        VisualPosition visualPosition = softWrapUnawarePosition;
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "doLogicalToVisualPosition"));
        }
        return visualPosition;
    }

    @Nullable
    private FoldRegion getLastCollapsedBeforePosition(@NotNull VisualPosition visualPos) {
        FoldRegion region;
        if (visualPos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visualPos", "com/intellij/openapi/editor/impl/EditorImpl", "getLastCollapsedBeforePosition"));
        }
        FoldRegion[] topLevelCollapsed = this.myFoldingModel.fetchTopLevel();
        if (topLevelCollapsed == null) {
            return null;
        }
        int start = 0;
        int end = topLevelCollapsed.length - 1;
        int i = 0;
        while (start <= end) {
            i = (start + end) / 2;
            region = topLevelCollapsed[i];
            if (!region.isValid()) {
                return null;
            }
            int regionVisualLine = this.offsetToVisualLine(region.getEndOffset() - 1);
            if (regionVisualLine < visualPos.line) {
                start = i + 1;
                continue;
            }
            if (regionVisualLine > visualPos.line) {
                end = i - 1;
                continue;
            }
            VisualPosition visFoldEnd = this.offsetToVisualPosition(region.getEndOffset() - 1);
            if (visFoldEnd.column < visualPos.column) {
                start = i + 1;
                continue;
            }
            if (visFoldEnd.column > visualPos.column) {
                end = i - 1;
                continue;
            }
            --i;
            break;
        }
        while (i >= 0 && i < topLevelCollapsed.length && !topLevelCollapsed[i].isValid()) {
            --i;
        }
        if (i >= 0 && i < topLevelCollapsed.length) {
            region = topLevelCollapsed[i];
            VisualPosition visFoldEnd = this.offsetToVisualPosition(region.getEndOffset() - 1);
            if (visFoldEnd.line > visualPos.line || visFoldEnd.line == visualPos.line && visFoldEnd.column > visualPos.column) {
                if (--i >= 0) {
                    return topLevelCollapsed[i];
                }
                return null;
            }
            return region;
        }
        return null;
    }

    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition visiblePos) {
        if (visiblePos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visiblePos", "com/intellij/openapi/editor/impl/EditorImpl", "visualToLogicalPosition"));
        }
        LogicalPosition logicalPosition = this.visualToLogicalPosition(visiblePos, true);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "visualToLogicalPosition"));
        }
        return logicalPosition;
    }

    @Override
    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition visiblePos, boolean softWrapAware) {
        if (visiblePos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visiblePos", "com/intellij/openapi/editor/impl/EditorImpl", "visualToLogicalPosition"));
        }
        EditorImpl.assertReadAccess();
        if (softWrapAware) {
            LogicalPosition logicalPosition = this.mySoftWrapModel.visualToLogicalPosition(visiblePos);
            if (logicalPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "visualToLogicalPosition"));
            }
            return logicalPosition;
        }
        if (!this.myFoldingModel.isFoldingEnabled()) {
            LogicalPosition logicalPosition = new LogicalPosition(visiblePos.line, visiblePos.column);
            if (logicalPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "visualToLogicalPosition"));
            }
            return logicalPosition;
        }
        int line = visiblePos.line;
        int column = visiblePos.column;
        FoldRegion lastCollapsedBefore = this.getLastCollapsedBeforePosition(visiblePos);
        if (lastCollapsedBefore != null) {
            int logFoldEndLine = this.offsetToLogicalLine(lastCollapsedBefore.getEndOffset());
            int visFoldEndLine = this.logicalToVisualLine(logFoldEndLine);
            line = logFoldEndLine + visiblePos.line - visFoldEndLine;
            if (visFoldEndLine == visiblePos.line) {
                LogicalPosition logFoldEnd = this.offsetToLogicalPosition(lastCollapsedBefore.getEndOffset(), false);
                VisualPosition visFoldEnd = this.logicalToVisualPosition(logFoldEnd, false);
                if (visiblePos.column >= visFoldEnd.column) {
                    column = logFoldEnd.column + visiblePos.column - visFoldEnd.column;
                } else {
                    LogicalPosition logicalPosition = this.offsetToLogicalPosition(lastCollapsedBefore.getStartOffset(), false);
                    if (logicalPosition == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "visualToLogicalPosition"));
                    }
                    return logicalPosition;
                }
            }
        }
        if (column < 0) {
            column = 0;
        }
        LogicalPosition logicalPosition = new LogicalPosition(line, column);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "visualToLogicalPosition"));
        }
        return logicalPosition;
    }

    int offsetToLogicalLine(int offset) {
        int textLength = this.myDocument.getTextLength();
        if (textLength == 0) {
            return 0;
        }
        if (offset > textLength || offset < 0) {
            throw new IndexOutOfBoundsException("Wrong offset: " + offset + " textLength: " + textLength);
        }
        int lineIndex = this.myDocument.getLineNumber(offset);
        LOG.assertTrue(lineIndex >= 0 && lineIndex < this.myDocument.getLineCount());
        return lineIndex;
    }

    @Override
    public int calcColumnNumber(int offset, int lineIndex) {
        return this.calcColumnNumber(offset, lineIndex, true, this.myDocument.getImmutableCharSequence());
    }

    public int calcColumnNumber(int offset, int lineIndex, boolean softWrapAware, @NotNull CharSequence documentCharSequence) {
        if (documentCharSequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentCharSequence", "com/intellij/openapi/editor/impl/EditorImpl", "calcColumnNumber"));
        }
        if (this.myDocument.getTextLength() == 0) {
            return 0;
        }
        int lineStartOffset = this.myDocument.getLineStartOffset(lineIndex);
        if (lineStartOffset == offset) {
            return 0;
        }
        int column = EditorUtil.calcColumnNumber(this, documentCharSequence, lineStartOffset, offset);
        if (softWrapAware) {
            int line = this.offsetToLogicalLine(offset);
            return this.mySoftWrapModel.adjustLogicalPosition((LogicalPosition)new LogicalPosition((int)line, (int)column), (int)offset).column;
        }
        return column;
    }

    private LogicalPosition getLogicalPositionForScreenPos(int x, int y, boolean trimToLineWidth) {
        int lineEndOffset;
        int lineEndColumn;
        int totalLines;
        if (x < 0) {
            x = 0;
        }
        LogicalPosition pos = this.xyToLogicalPosition(new Point(x, y));
        int column = pos.column;
        int line = pos.line;
        int softWrapLinesBeforeTargetLogicalLine = pos.softWrapLinesBeforeCurrentLogicalLine;
        int softWrapLinesOnTargetLogicalLine = pos.softWrapLinesOnCurrentLogicalLine;
        int softWrapColumns = pos.softWrapColumnDiff;
        if (line < 0) {
            line = 0;
            column = 0;
            softWrapLinesBeforeTargetLogicalLine = 0;
            softWrapLinesOnTargetLogicalLine = 0;
            softWrapColumns = 0;
        }
        if ((totalLines = this.myDocument.getLineCount()) <= 0) {
            return new LogicalPosition(0, 0);
        }
        if (line >= totalLines && totalLines > 0) {
            int newY;
            int visibleLineCount = this.getVisibleLineCount();
            int n = newY = visibleLineCount > 0 ? this.visibleLineToY(visibleLineCount - 1) : 0;
            if (newY > 0 && newY == y) {
                newY = this.visibleLineToY(this.getVisibleLogicalLinesCount());
            }
            if (newY >= y) {
                LogMessageEx.error(LOG, "cycled moveCaretToScreenPos() detected", String.format("x=%d, y=%d\nstate=%s", x, y, this.dumpState()));
                throw new IllegalStateException("cycled moveCaretToScreenPos() detected");
            }
            return this.getLogicalPositionForScreenPos(x, newY, trimToLineWidth);
        }
        if (!this.mySettings.isVirtualSpace() && trimToLineWidth && column > (lineEndColumn = this.calcColumnNumber(lineEndOffset = this.myDocument.getLineEndOffset(line), line))) {
            column = lineEndColumn;
            if (softWrapColumns != 0) {
                softWrapColumns -= column - lineEndColumn;
            }
        }
        if (!this.mySettings.isCaretInsideTabs()) {
            int offset = this.logicalPositionToOffset(new LogicalPosition(line, column));
            CharSequence text = this.myDocument.getImmutableCharSequence();
            if (offset >= 0 && offset < this.myDocument.getTextLength() && text.charAt(offset) == '\t') {
                column = this.calcColumnNumber(offset, line);
            }
        }
        return new LogicalPosition(line, column, softWrapLinesBeforeTargetLogicalLine, softWrapLinesOnTargetLogicalLine, softWrapColumns, pos.foldedLines, pos.foldingColumnDiff);
    }

    private boolean checkIgnore(@NotNull MouseEvent e, boolean isFinalCheck) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "checkIgnore"));
        }
        if (!this.myIgnoreMouseEventsConsecutiveToInitial) {
            this.myInitialMouseEvent = null;
            return false;
        }
        if (!(this.myInitialMouseEvent == null || e.getComponent() == this.myInitialMouseEvent.getComponent() && e.getPoint().equals(this.myInitialMouseEvent.getPoint()))) {
            this.myIgnoreMouseEventsConsecutiveToInitial = false;
            this.myInitialMouseEvent = null;
            return false;
        }
        if (isFinalCheck) {
            this.myIgnoreMouseEventsConsecutiveToInitial = false;
            this.myInitialMouseEvent = null;
        }
        e.consume();
        return true;
    }

    private void processMouseReleased(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "processMouseReleased"));
        }
        if (this.checkIgnore(e, true)) {
            return;
        }
        if (!(e.getSource() != this.myGutterComponent || this.myMousePressedEvent != null && this.myMousePressedEvent.isConsumed())) {
            this.myGutterComponent.mouseReleased(e);
        }
        if (this.getMouseEventArea(e) != EditorMouseEventArea.EDITING_AREA || e.getY() < 0 || e.getX() < 0) {
            return;
        }
        final FoldRegion region = this.getFoldingModel().getFoldingPlaceholderAt(e.getPoint());
        if (e.getX() >= 0 && e.getY() >= 0 && region != null && region == this.myMouseSelectedRegion) {
            this.getFoldingModel().runBatchFoldingOperation(new Runnable(){

                @Override
                public void run() {
                    EditorImpl.this.myFoldingModel.flushCaretShift();
                    region.setExpanded(true);
                }
            });
            this.myGutterComponent.updateSize();
        }
        if (!(this.myMousePressedEvent == null || this.myMousePressedEvent.getClickCount() != 1 || !this.myMousePressedInsideSelection || this.myMousePressedEvent.isShiftDown() || this.myMousePressedEvent.isPopupTrigger() || EditorImpl.isToggleCaretEvent(this.myMousePressedEvent) || EditorImpl.isCreateRectangularSelectionEvent(this.myMousePressedEvent))) {
            this.getSelectionModel().removeSelection();
        }
    }

    @Override
    @NotNull
    public DataContext getDataContext() {
        DataContext dataContext = this.getProjectAwareDataContext(DataManager.getInstance().getDataContext((Component)this.getContentComponent()));
        if (dataContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getDataContext"));
        }
        return dataContext;
    }

    @NotNull
    private DataContext getProjectAwareDataContext(final @NotNull DataContext original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/openapi/editor/impl/EditorImpl", "getProjectAwareDataContext"));
        }
        if (CommonDataKeys.PROJECT.getData(original) == this.myProject) {
            DataContext dataContext = original;
            if (dataContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getProjectAwareDataContext"));
            }
            return dataContext;
        }
        DataContext dataContext = new DataContext(){

            public Object getData(String dataId) {
                if (CommonDataKeys.PROJECT.is(dataId)) {
                    return EditorImpl.this.myProject;
                }
                return original.getData(dataId);
            }
        };
        if (dataContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getProjectAwareDataContext"));
        }
        return dataContext;
    }

    public EditorMouseEventArea getMouseEventArea(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "getMouseEventArea"));
        }
        if (this.myGutterComponent != e.getSource()) {
            return EditorMouseEventArea.EDITING_AREA;
        }
        int x = this.myGutterComponent.convertX(e.getX());
        return this.myGutterComponent.getEditorMouseAreaByOffset(x);
    }

    private void requestFocus() {
        IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.myProject);
        if (focusManager.getFocusOwner() != this.myEditorComponent) {
            focusManager.requestFocus((Component)this.myEditorComponent, true);
        }
    }

    private void validateMousePointer(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "validateMousePointer"));
        }
        if (e.getSource() == this.myGutterComponent) {
            FoldRegion foldingAtCursor = this.myGutterComponent.findFoldingAnchorAt(e.getX(), e.getY());
            this.myGutterComponent.setActiveFoldRegion(foldingAtCursor);
            if (foldingAtCursor != null) {
                this.myGutterComponent.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                this.myGutterComponent.setCursor(Cursor.getPredefinedCursor(0));
            }
        } else {
            this.myGutterComponent.setActiveFoldRegion(null);
            if (this.getSelectionModel().hasSelection() && (e.getModifiersEx() & 0xC00) == 0) {
                int offset = this.logicalPositionToOffset(this.xyToLogicalPosition(e.getPoint()));
                if (this.getSelectionModel().getSelectionStart() <= offset && offset < this.getSelectionModel().getSelectionEnd()) {
                    this.myEditorComponent.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
            }
            this.myEditorComponent.setCursor(UIUtil.getTextCursor((Color)this.getBackgroundColor()));
        }
    }

    private void runMouseDraggedCommand(final @NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "runMouseDraggedCommand"));
        }
        if (this.myCommandProcessor == null || this.myMousePressedEvent != null && this.myMousePressedEvent.isConsumed()) {
            return;
        }
        this.myCommandProcessor.executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                EditorImpl.this.processMouseDragged(e);
            }
        }, "", this.MOUSE_DRAGGED_GROUP, UndoConfirmationPolicy.DEFAULT, (Document)this.getDocument());
    }

    private void processMouseDragged(@NotNull MouseEvent e) {
        boolean columnSelectionDrag;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "processMouseDragged"));
        }
        if (JBSwingUtilities.isRightMouseButton((MouseEvent)e)) {
            return;
        }
        if (this.getMouseEventArea(e) == EditorMouseEventArea.LINE_MARKERS_AREA) {
            if (this.myDragOnGutterSelectionStartLine >= 0) {
                this.mySelectionModel.removeSelection();
                this.myCaretModel.moveToOffset(this.myDragOnGutterSelectionStartLine < this.myDocument.getLineCount() ? this.myDocument.getLineStartOffset(this.myDragOnGutterSelectionStartLine) : this.myDocument.getTextLength());
            }
            this.myDragOnGutterSelectionStartLine = -1;
        }
        boolean columnSelectionDragEvent = EditorImpl.isColumnSelectionDragEvent(e);
        boolean toggleCaretEvent = EditorImpl.isToggleCaretEvent(e);
        boolean addRectangularSelectionEvent = EditorImpl.isAddRectangularSelectionEvent(e);
        boolean bl = columnSelectionDrag = this.isColumnMode() && !this.myLastPressCreatedCaret || columnSelectionDragEvent;
        if (!columnSelectionDragEvent && toggleCaretEvent && !this.myLastPressCreatedCaret) {
            return;
        }
        Rectangle visibleArea = this.getScrollingModel().getVisibleArea();
        int x = e.getX();
        if (e.getSource() == this.myGutterComponent) {
            x = 0;
        }
        int dx = 0;
        if (x < visibleArea.x && visibleArea.x > 0) {
            dx = x - visibleArea.x;
        } else if (x > visibleArea.x + visibleArea.width) {
            dx = x - visibleArea.x - visibleArea.width;
        }
        int dy = 0;
        int y = e.getY();
        if (y < visibleArea.y && visibleArea.y > 0) {
            dy = y - visibleArea.y;
        } else if (y > visibleArea.y + visibleArea.height) {
            dy = y - visibleArea.y - visibleArea.height;
        }
        if (dx == 0 && dy == 0) {
            this.myScrollingTimer.stop();
            SelectionModelImpl selectionModel = this.getSelectionModel();
            Caret leadCaret = this.getLeadCaret();
            int oldSelectionStart = leadCaret.getLeadSelectionOffset();
            VisualPosition oldVisLeadSelectionStart = leadCaret.getLeadSelectionPosition();
            int oldCaretOffset = this.getCaretModel().getOffset();
            boolean multiCaretSelection = columnSelectionDrag || toggleCaretEvent;
            LogicalPosition newLogicalCaret = this.getLogicalPositionForScreenPos(x, y, !multiCaretSelection);
            if (multiCaretSelection) {
                this.myMultiSelectionInProgress = true;
                this.myRectangularSelectionInProgress = columnSelectionDrag || addRectangularSelectionEvent;
                this.myTargetMultiSelectionPosition = this.xyToVisualPosition(new Point(Math.max(x, 0), Math.max(y, 0)));
                this.getScrollingModel().scrollTo(newLogicalCaret, ScrollType.RELATIVE);
            } else {
                this.getCaretModel().moveToLogicalPosition(newLogicalCaret);
                this.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
            int newCaretOffset = this.getCaretModel().getOffset();
            VisualPosition newVisualCaret = this.getCaretModel().getVisualPosition();
            int caretShift = newCaretOffset - this.mySavedSelectionStart;
            if (this.myMousePressedEvent != null && this.getMouseEventArea(this.myMousePressedEvent) != EditorMouseEventArea.EDITING_AREA && this.getMouseEventArea(this.myMousePressedEvent) != EditorMouseEventArea.LINE_NUMBERS_AREA) {
                selectionModel.setSelection(oldSelectionStart, newCaretOffset);
            } else if (multiCaretSelection) {
                if (this.myLastMousePressedLocation != null && (this.myCurrentDragIsSubstantial || !newLogicalCaret.equals((Object)this.myLastMousePressedLocation))) {
                    this.createSelectionTill(newLogicalCaret);
                    this.blockActionsIfNeeded(e, this.myLastMousePressedLocation, newLogicalCaret);
                }
            } else {
                if (this.getMouseSelectionState() != 0) {
                    if (caretShift < 0) {
                        int newSelection = newCaretOffset;
                        if (this.getMouseSelectionState() == 1) {
                            newSelection = this.myCaretModel.getWordAtCaretStart();
                        } else if (this.getMouseSelectionState() == 2) {
                            newSelection = this.logicalPositionToOffset(this.visualToLogicalPosition(new VisualPosition(this.getCaretModel().getVisualPosition().line, 0)));
                        }
                        if (newSelection < 0) {
                            newSelection = newCaretOffset;
                        }
                        selectionModel.setSelection(this.mySavedSelectionEnd, newSelection);
                        this.getCaretModel().moveToOffset(newSelection);
                    } else {
                        int newSelection = newCaretOffset;
                        if (this.getMouseSelectionState() == 1) {
                            newSelection = this.myCaretModel.getWordAtCaretEnd();
                        } else if (this.getMouseSelectionState() == 2) {
                            newSelection = this.logicalPositionToOffset(this.visualToLogicalPosition(new VisualPosition(this.getCaretModel().getVisualPosition().line + 1, 0)));
                        }
                        if (newSelection < 0) {
                            newSelection = newCaretOffset;
                        }
                        selectionModel.setSelection(this.mySavedSelectionStart, newSelection);
                        this.getCaretModel().moveToOffset(newSelection);
                    }
                    this.cancelAutoResetForMouseSelectionState();
                    return;
                }
                if (!this.myMousePressedInsideSelection) {
                    if ((this.myMousePressArea == EditorMouseEventArea.LINE_NUMBERS_AREA || this.myMousePressArea == EditorMouseEventArea.LINE_MARKERS_AREA) && selectionModel.hasSelection()) {
                        if (newCaretOffset >= selectionModel.getSelectionEnd()) {
                            oldSelectionStart = selectionModel.getSelectionStart();
                            oldVisLeadSelectionStart = selectionModel.getSelectionStartPosition();
                        } else if (newCaretOffset <= selectionModel.getSelectionStart()) {
                            oldSelectionStart = selectionModel.getSelectionEnd();
                            oldVisLeadSelectionStart = selectionModel.getSelectionEndPosition();
                        }
                    }
                    if (oldVisLeadSelectionStart != null) {
                        this.setSelectionAndBlockActions(e, oldVisLeadSelectionStart, oldSelectionStart, newVisualCaret, newCaretOffset);
                    } else {
                        this.setSelectionAndBlockActions(e, oldSelectionStart, newCaretOffset);
                    }
                    this.cancelAutoResetForMouseSelectionState();
                } else if (caretShift != 0 && this.myMousePressedEvent != null) {
                    if (this.mySettings.isDndEnabled()) {
                        if (this.myDraggedRange == null) {
                            boolean isCopy = UIUtil.isControlKeyDown((MouseEvent)e) || this.isViewer() || !this.getDocument().isWritable();
                            this.mySavedCaretOffsetForDNDUndoHack = oldCaretOffset;
                            this.getContentComponent().getTransferHandler().exportAsDrag(this.getContentComponent(), e, isCopy ? 1 : 2);
                        }
                    } else {
                        selectionModel.removeSelection();
                    }
                }
            }
        } else {
            this.myScrollingTimer.start(dx, dy);
            this.onSubstantialDrag(e);
        }
    }

    private void clearDraggedRange() {
        if (this.myDraggedRange != null) {
            this.myDraggedRange.dispose();
            this.myDraggedRange = null;
        }
    }

    private void createSelectionTill(@NotNull LogicalPosition targetPosition) {
        if (targetPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetPosition", "com/intellij/openapi/editor/impl/EditorImpl", "createSelectionTill"));
        }
        ArrayList<CaretState> caretStates = new ArrayList<CaretState>(this.myCaretStateBeforeLastPress);
        if (this.myRectangularSelectionInProgress) {
            caretStates.addAll(EditorModificationUtil.calcBlockSelectionState((Editor)this, (LogicalPosition)this.myLastMousePressedLocation, (LogicalPosition)targetPosition));
        } else {
            LogicalPosition selectionStart = this.myLastMousePressedLocation;
            LogicalPosition selectionEnd = targetPosition;
            if (this.getMouseSelectionState() != 0) {
                int newCaretOffset = this.logicalPositionToOffset(targetPosition);
                if (newCaretOffset < this.mySavedSelectionStart) {
                    selectionStart = this.offsetToLogicalPosition(this.mySavedSelectionEnd);
                    if (this.getMouseSelectionState() == 2) {
                        targetPosition = selectionEnd = this.visualToLogicalPosition(new VisualPosition(this.offsetToVisualLine(newCaretOffset), 0));
                    }
                } else {
                    selectionStart = this.offsetToLogicalPosition(this.mySavedSelectionStart);
                    int selectionEndOffset = Math.max(newCaretOffset, this.mySavedSelectionEnd);
                    if (this.getMouseSelectionState() == 1) {
                        targetPosition = selectionEnd = this.offsetToLogicalPosition(selectionEndOffset);
                    } else if (this.getMouseSelectionState() == 2) {
                        targetPosition = selectionEnd = this.visualToLogicalPosition(new VisualPosition(this.offsetToVisualLine(selectionEndOffset) + 1, 0));
                    }
                }
                this.cancelAutoResetForMouseSelectionState();
            }
            caretStates.add(new CaretState(targetPosition, selectionStart, selectionEnd));
        }
        this.myCaretModel.setCaretsAndSelections(caretStates);
    }

    private Caret getLeadCaret() {
        List<Caret> allCarets = this.myCaretModel.getAllCarets();
        Caret firstCaret = allCarets.get(0);
        if (firstCaret == this.myCaretModel.getPrimaryCaret()) {
            return allCarets.get(allCarets.size() - 1);
        }
        return firstCaret;
    }

    private void setSelectionAndBlockActions(@NotNull MouseEvent mouseDragEvent, int startOffset, int endOffset) {
        if (mouseDragEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mouseDragEvent", "com/intellij/openapi/editor/impl/EditorImpl", "setSelectionAndBlockActions"));
        }
        this.mySelectionModel.setSelection(startOffset, endOffset);
        if (this.myCurrentDragIsSubstantial || startOffset != endOffset) {
            this.onSubstantialDrag(mouseDragEvent);
        }
    }

    private void setSelectionAndBlockActions(@NotNull MouseEvent mouseDragEvent, VisualPosition startPosition, int startOffset, VisualPosition endPosition, int endOffset) {
        if (mouseDragEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mouseDragEvent", "com/intellij/openapi/editor/impl/EditorImpl", "setSelectionAndBlockActions"));
        }
        this.mySelectionModel.setSelection(startPosition, startOffset, endPosition, endOffset);
        if (this.myCurrentDragIsSubstantial || startOffset != endOffset || !Comparing.equal((Object)startPosition, (Object)endPosition)) {
            this.onSubstantialDrag(mouseDragEvent);
        }
    }

    private void blockActionsIfNeeded(@NotNull MouseEvent mouseDragEvent, @NotNull LogicalPosition startPosition, @NotNull LogicalPosition endPosition) {
        if (mouseDragEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mouseDragEvent", "com/intellij/openapi/editor/impl/EditorImpl", "blockActionsIfNeeded"));
        }
        if (startPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startPosition", "com/intellij/openapi/editor/impl/EditorImpl", "blockActionsIfNeeded"));
        }
        if (endPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endPosition", "com/intellij/openapi/editor/impl/EditorImpl", "blockActionsIfNeeded"));
        }
        if (this.myCurrentDragIsSubstantial || !startPosition.equals((Object)endPosition)) {
            this.onSubstantialDrag(mouseDragEvent);
        }
    }

    private void onSubstantialDrag(@NotNull MouseEvent mouseDragEvent) {
        if (mouseDragEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mouseDragEvent", "com/intellij/openapi/editor/impl/EditorImpl", "onSubstantialDrag"));
        }
        IdeEventQueue.getInstance().blockNextEvents(mouseDragEvent, IdeEventQueue.BlockMode.ACTIONS);
        this.myCurrentDragIsSubstantial = true;
    }

    void updateCaretCursor() {
        this.myUpdateCursor = true;
    }

    private void setCursorPosition() {
        ArrayList<CaretRectangle> caretPoints = new ArrayList<CaretRectangle>();
        for (Caret caret : this.getCaretModel().getAllCarets()) {
            VisualPosition caretPosition = caret.getVisualPosition();
            Point pos1 = this.visualPositionToXY(caretPosition);
            Point pos2 = this.visualPositionToXY(new VisualPosition(caretPosition.line, caretPosition.column + 1));
            caretPoints.add(new CaretRectangle(pos1, pos2.x - pos1.x, caret));
        }
        this.myCaretCursor.setPositions(caretPoints.toArray(new CaretRectangle[caretPoints.size()]));
    }

    @Override
    public boolean setCaretVisible(boolean b) {
        boolean old = this.myCaretCursor.isActive();
        if (b) {
            this.myCaretCursor.activate();
        } else {
            this.myCaretCursor.passivate();
        }
        return old;
    }

    @Override
    public boolean setCaretEnabled(boolean enabled) {
        boolean old = this.myCaretCursor.isEnabled();
        this.myCaretCursor.setEnabled(enabled);
        return old;
    }

    @Override
    public void addFocusListener(@NotNull FocusChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/EditorImpl", "addFocusListener"));
        }
        this.myFocusListeners.add(listener);
    }

    @Override
    public void addFocusListener(@NotNull FocusChangeListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/EditorImpl", "addFocusListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/editor/impl/EditorImpl", "addFocusListener"));
        }
        ContainerUtil.add((Object)listener, this.myFocusListeners, (Disposable)parentDisposable);
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public boolean isOneLineMode() {
        return this.myIsOneLineMode;
    }

    @Override
    public boolean isEmbeddedIntoDialogWrapper() {
        return this.myEmbeddedIntoDialogWrapper;
    }

    @Override
    public void setEmbeddedIntoDialogWrapper(boolean b) {
        EditorImpl.assertIsDispatchThread();
        this.myEmbeddedIntoDialogWrapper = b;
        this.myScrollPane.setFocusable(!b);
        this.myEditorComponent.setFocusCycleRoot(!b);
        this.myEditorComponent.setFocusable(b);
    }

    @Override
    public void setOneLineMode(boolean isOneLineMode) {
        this.myIsOneLineMode = isOneLineMode;
        this.getScrollPane().setInputMap(1, null);
        this.reinitSettings();
    }

    @Override
    public void stopOptimizedScrolling() {
    }

    boolean paintBlockCaret() {
        return this.myIsInsertMode == this.mySettings.isBlockCursor();
    }

    private MyEditable getViewer() {
        if (this.myEditable == null) {
            this.myEditable = new MyEditable();
        }
        return this.myEditable;
    }

    @Override
    public CopyProvider getCopyProvider() {
        return this.getViewer();
    }

    @Override
    public CutProvider getCutProvider() {
        return this.getViewer();
    }

    @Override
    public PasteProvider getPasteProvider() {
        return this.getViewer();
    }

    @Override
    public DeleteProvider getDeleteProvider() {
        return this.getViewer();
    }

    @Override
    public void setColorsScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/editor/impl/EditorImpl", "setColorsScheme"));
        }
        EditorImpl.assertIsDispatchThread();
        this.myScheme = scheme;
        this.reinitSettings();
    }

    @NotNull
    public EditorColorsScheme getColorsScheme() {
        EditorColorsScheme editorColorsScheme = this.myScheme;
        if (editorColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getColorsScheme"));
        }
        return editorColorsScheme;
    }

    static void assertIsDispatchThread() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    private static void assertReadAccess() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
    }

    @Override
    public void setVerticalScrollbarOrientation(int type) {
        EditorImpl.assertIsDispatchThread();
        int currentHorOffset = this.myScrollingModel.getHorizontalScrollOffset();
        this.myScrollBarOrientation = type;
        if (type == 0) {
            this.myScrollPane.setLayout(new LeftHandScrollbarLayout());
        } else {
            this.myScrollPane.setLayout(new ScrollPaneLayout());
        }
        this.myScrollingModel.scrollHorizontally(currentHorOffset);
    }

    @Override
    public void setVerticalScrollbarVisible(boolean b) {
        this.myScrollPane.setVerticalScrollBarPolicy(b ? 22 : 21);
    }

    @Override
    public void setHorizontalScrollbarVisible(boolean b) {
        this.myScrollPane.setHorizontalScrollBarPolicy(b ? 30 : 31);
    }

    @Override
    public int getVerticalScrollbarOrientation() {
        return this.myScrollBarOrientation;
    }

    public boolean isMirrored() {
        return this.myScrollBarOrientation != 1;
    }

    @NotNull
    MyScrollBar getVerticalScrollBar() {
        MyScrollBar myScrollBar = this.myVerticalScrollBar;
        if (myScrollBar == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getVerticalScrollBar"));
        }
        return myScrollBar;
    }

    @NotNull
    MyScrollBar getHorizontalScrollBar() {
        MyScrollBar myScrollBar = (MyScrollBar)((Object)this.myScrollPane.getHorizontalScrollBar());
        if (myScrollBar == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getHorizontalScrollBar"));
        }
        return myScrollBar;
    }

    private int getMouseSelectionState() {
        return this.myMouseSelectionState;
    }

    private void setMouseSelectionState(int mouseSelectionState) {
        if (this.getMouseSelectionState() == mouseSelectionState) {
            return;
        }
        this.myMouseSelectionState = mouseSelectionState;
        this.myMouseSelectionChangeTimestamp = System.currentTimeMillis();
        this.myMouseSelectionStateAlarm.cancelAllRequests();
        if (this.myMouseSelectionState != 0) {
            if (this.myMouseSelectionStateResetRunnable == null) {
                this.myMouseSelectionStateResetRunnable = new Runnable(){

                    @Override
                    public void run() {
                        EditorImpl.this.resetMouseSelectionState(null);
                    }
                };
            }
            this.myMouseSelectionStateAlarm.addRequest(this.myMouseSelectionStateResetRunnable, Registry.intValue((String)"editor.mouseSelectionStateResetTimeout"), ModalityState.stateForComponent((Component)this.myEditorComponent));
        }
    }

    private void resetMouseSelectionState(@Nullable MouseEvent event) {
        MouseEvent e;
        this.setMouseSelectionState(0);
        MouseEvent mouseEvent = e = event != null ? event : this.myMouseMovedEvent;
        if (e != null) {
            this.validateMousePointer(e);
        }
    }

    private void cancelAutoResetForMouseSelectionState() {
        this.myMouseSelectionStateAlarm.cancelAllRequests();
    }

    void replaceInputMethodText(@NotNull InputMethodEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "replaceInputMethodText"));
        }
        this.getInputMethodRequests();
        this.myInputMethodRequestsHandler.replaceInputMethodText(e);
    }

    void inputMethodCaretPositionChanged(@NotNull InputMethodEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "inputMethodCaretPositionChanged"));
        }
        this.getInputMethodRequests();
        this.myInputMethodRequestsHandler.setInputMethodCaretPosition(e);
    }

    @NotNull
    InputMethodRequests getInputMethodRequests() {
        if (this.myInputMethodRequestsHandler == null) {
            this.myInputMethodRequestsHandler = new MyInputMethodHandler();
            this.myInputMethodRequestsSwingWrapper = new MyInputMethodHandleSwingThreadWrapper(this.myInputMethodRequestsHandler);
        }
        InputMethodRequests inputMethodRequests = this.myInputMethodRequestsSwingWrapper;
        if (inputMethodRequests == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getInputMethodRequests"));
        }
        return inputMethodRequests;
    }

    @Override
    public boolean processKeyTyped(@NotNull KeyEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "processKeyTyped"));
        }
        if (e.getID() != 400) {
            return false;
        }
        char c = e.getKeyChar();
        if (UIUtil.isReallyTypedEvent((KeyEvent)e)) {
            this.processKeyTyped(c);
            return true;
        }
        return false;
    }

    void beforeModalityStateChanged() {
        this.myScrollingModel.beforeModalityStateChanged();
    }

    public EditorDropHandler getDropHandler() {
        return this.myDropHandler;
    }

    public void setDropHandler(@NotNull EditorDropHandler dropHandler) {
        if (dropHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dropHandler", "com/intellij/openapi/editor/impl/EditorImpl", "setDropHandler"));
        }
        this.myDropHandler = dropHandler;
    }

    private static boolean isColumnSelectionDragEvent(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "isColumnSelectionDragEvent"));
        }
        return e.isAltDown() && !e.isShiftDown() && !e.isControlDown() && !e.isMetaDown();
    }

    private static boolean isToggleCaretEvent(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "isToggleCaretEvent"));
        }
        return KeymapUtil.isMouseActionEvent((MouseEvent)e, (String)"EditorAddOrRemoveCaret") || EditorImpl.isAddRectangularSelectionEvent(e);
    }

    private static boolean isAddRectangularSelectionEvent(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "isAddRectangularSelectionEvent"));
        }
        return KeymapUtil.isMouseActionEvent((MouseEvent)e, (String)"EditorAddRectangularSelectionOnMouseDrag");
    }

    private static boolean isCreateRectangularSelectionEvent(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "isCreateRectangularSelectionEvent"));
        }
        return KeymapUtil.isMouseActionEvent((MouseEvent)e, (String)"EditorCreateRectangularSelection");
    }

    private void selectWordAtCaret(boolean honorCamelCase) {
        this.mySelectionModel.selectWordAtCaret(honorCamelCase);
        this.setMouseSelectionState(1);
        this.mySavedSelectionStart = this.mySelectionModel.getSelectionStart();
        this.mySavedSelectionEnd = this.mySelectionModel.getSelectionEnd();
        this.getCaretModel().moveToOffset(this.mySavedSelectionEnd);
    }

    private boolean tweakSelectionEvent(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "tweakSelectionEvent"));
        }
        return this.getSelectionModel().hasSelection() && e.getButton() == 1 && e.isShiftDown() && this.getMouseEventArea(e) == EditorMouseEventArea.LINE_NUMBERS_AREA;
    }

    private boolean tweakSelectionIfNecessary(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "tweakSelectionIfNecessary"));
        }
        if (!this.tweakSelectionEvent(e)) {
            return false;
        }
        int startSelectionOffset = this.getSelectionModel().getSelectionStart();
        int startVisLine = this.offsetToVisualLine(startSelectionOffset);
        int endSelectionOffset = this.getSelectionModel().getSelectionEnd();
        int endVisLine = this.offsetToVisualLine(endSelectionOffset - 1);
        int clickVisLine = this.yPositionToVisibleLine(e.getPoint().y);
        if (clickVisLine < startVisLine) {
            int startOffset = this.logicalPositionToOffset(this.visualToLogicalPosition(new VisualPosition(clickVisLine, 0)));
            this.getSelectionModel().setSelection(startOffset, endSelectionOffset);
            this.getCaretModel().moveToOffset(startOffset);
        } else if (clickVisLine > endVisLine) {
            int endLineOffset = EditorUtil.getVisualLineEndOffset(this, clickVisLine);
            this.getSelectionModel().setSelection(this.getSelectionModel().getSelectionStart(), endLineOffset);
            this.getCaretModel().moveToOffset(endLineOffset, true);
        } else if (startVisLine == endVisLine) {
            this.getSelectionModel().removeSelection();
        } else if (this.getSelectionModel().getLeadSelectionOffset() == endSelectionOffset) {
            if (clickVisLine == startVisLine) {
                ++clickVisLine;
            }
            int startOffset = this.logicalPositionToOffset(this.visualToLogicalPosition(new VisualPosition(clickVisLine, 0)));
            this.getSelectionModel().setSelection(startOffset, endSelectionOffset);
            this.getCaretModel().moveToOffset(startOffset);
        } else {
            if (clickVisLine == endVisLine) {
                --clickVisLine;
            }
            int endLineOffset = EditorUtil.getVisualLineEndOffset(this, clickVisLine);
            this.getSelectionModel().setSelection(startSelectionOffset, endLineOffset);
            this.getCaretModel().moveToOffset(endLineOffset);
        }
        e.consume();
        return true;
    }

    @NotNull
    public EditorGutter getGutter() {
        EditorGutterComponentEx editorGutterComponentEx = this.getGutterComponentEx();
        if (editorGutterComponentEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getGutter"));
        }
        return editorGutterComponentEx;
    }

    @Override
    public int calcColumnNumber(@NotNull CharSequence text, int start, int offset, int tabSize) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/EditorImpl", "calcColumnNumber"));
        }
        IterationState state = new IterationState(this, start, offset, false);
        int fontType = state.getMergedAttributes().getFontType();
        int column = 0;
        int x = 0;
        int plainSpaceSize = EditorUtil.getSpaceWidth(0, this);
        for (int i = start; i < offset; ++i) {
            char c;
            SoftWrap softWrap;
            if (i >= state.getEndOffset()) {
                state.advance();
                fontType = state.getMergedAttributes().getFontType();
            }
            if ((softWrap = this.getSoftWrapModel().getSoftWrap(i)) != null) {
                x = softWrap.getIndentInPixels();
            }
            if ((c = text.charAt(i)) == '\t') {
                int prevX = x;
                x = EditorUtil.nextTabStop(x, this);
                column += EditorUtil.columnsNumber(c, x, prevX, plainSpaceSize);
                continue;
            }
            x += EditorUtil.charWidth(c, fontType, this);
            ++column;
        }
        return column;
    }

    boolean isInDistractionFreeMode() {
        return EditorUtil.isRealFileEditor(this) && (Registry.is((String)"editor.distraction.free.mode") || this.isInPresentationMode());
    }

    boolean isInPresentationMode() {
        return UISettings.getInstance().PRESENTATION_MODE && EditorUtil.isRealFileEditor(this);
    }

    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/editor/impl/EditorImpl", "putInfo"));
        }
        VisualPosition visual = this.getCaretModel().getVisualPosition();
        info.put("caret", visual.getLine() + ":" + visual.getColumn());
    }

    static {
        ComplementaryFontsRegistry.getFontAbleToDisplay(' ', 0, 0, UIManager.getFont("Label.font").getFamily());
        ourCaretBlinkingCommand = new RepaintCursorCommand();
        ourIsUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        ourCaretBlinkingCommand.start();
        decrButtonField = ReflectionUtil.getDeclaredField(BasicScrollBarUI.class, (String)"decrButton");
        incrButtonField = ReflectionUtil.getDeclaredField(BasicScrollBarUI.class, (String)"incrButton");
        FOLDING_TOOLTIP_GROUP = new TooltipGroup("FOLDING_TOOLTIP_GROUP", 10);
        PAINT_NO_WHITESPACE = new WhitespacePaintingStrategy(){

            @Override
            public boolean showWhitespaceAtOffset(int offset) {
                return false;
            }
        };
    }

    private class LineWhitespacePaintingStrategy
    implements WhitespacePaintingStrategy {
        private final boolean myWhitespaceShown;
        private final boolean myLeadingWhitespaceShown;
        private final boolean myInnerWhitespaceShown;
        private final boolean myTrailingWhitespaceShown;
        private int currentLeadingEdge;
        private int currentTrailingEdge;

        private LineWhitespacePaintingStrategy() {
            this.myWhitespaceShown = EditorImpl.this.mySettings.isWhitespacesShown();
            this.myLeadingWhitespaceShown = EditorImpl.this.mySettings.isLeadingWhitespaceShown();
            this.myInnerWhitespaceShown = EditorImpl.this.mySettings.isInnerWhitespaceShown();
            this.myTrailingWhitespaceShown = EditorImpl.this.mySettings.isTrailingWhitespaceShown();
        }

        private void update(CharSequence chars, LineIterator iterator) {
            if (!(!this.myWhitespaceShown || !this.myLeadingWhitespaceShown && !this.myInnerWhitespaceShown && !this.myTrailingWhitespaceShown || this.myLeadingWhitespaceShown && this.myInnerWhitespaceShown && this.myTrailingWhitespaceShown)) {
                int lineStart = iterator.getStart();
                int lineEnd = iterator.getEnd() - iterator.getSeparatorLength();
                this.currentTrailingEdge = CharArrayUtil.shiftBackward((CharSequence)chars, (int)lineStart, (int)(lineEnd - 1), (String)EditorImpl.WHITESPACE_CHARS) + 1;
                this.currentLeadingEdge = CharArrayUtil.shiftForward((CharSequence)chars, (int)lineStart, (int)this.currentTrailingEdge, (String)EditorImpl.WHITESPACE_CHARS);
            }
        }

        @Override
        public boolean showWhitespaceAtOffset(int offset) {
            return this.myWhitespaceShown && (offset < this.currentLeadingEdge ? this.myLeadingWhitespaceShown : (offset >= this.currentTrailingEdge ? this.myTrailingWhitespaceShown : this.myInnerWhitespaceShown));
        }
    }

    private static interface WhitespacePaintingStrategy {
        public boolean showWhitespaceAtOffset(int var1);
    }

    private class MyTextDrawingCallback
    implements TextDrawingCallback {
        private MyTextDrawingCallback() {
        }

        @Override
        public void drawChars(@NotNull Graphics g, @NotNull char[] data, int start, int end, int x, int y, Color color, @NotNull FontInfo fontInfo) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl$MyTextDrawingCallback", "drawChars"));
            }
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/editor/impl/EditorImpl$MyTextDrawingCallback", "drawChars"));
            }
            if (fontInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontInfo", "com/intellij/openapi/editor/impl/EditorImpl$MyTextDrawingCallback", "drawChars"));
            }
            EditorImpl.this.drawCharsCached(g, (CharSequence)new CharArrayCharSequence(data), start, end, x, y, fontInfo, color, false);
        }
    }

    private class MyHeaderPanel
    extends JPanel {
        private int myOldHeight;

        private MyHeaderPanel() {
            super(new BorderLayout());
            this.myOldHeight = 0;
        }

        @Override
        public void revalidate() {
            this.myOldHeight = this.getHeight();
            super.revalidate();
        }

        @Override
        protected void validateTree() {
            int height = this.myOldHeight;
            super.validateTree();
            if ((height -= this.getHeight()) != 0) {
                EditorImpl.this.myVerticalScrollBar.setValue(EditorImpl.this.myVerticalScrollBar.getValue() - height);
            }
            this.myOldHeight = this.getHeight();
        }
    }

    private class TablessBorder
    extends SideBorder {
        private TablessBorder() {
            super(JBColor.border(), 15);
        }

        public void paintBorder(@NotNull Component c, @NotNull Graphics g, int x, int y, int width, int height) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/openapi/editor/impl/EditorImpl$TablessBorder", "paintBorder"));
            }
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl$TablessBorder", "paintBorder"));
            }
            if (c instanceof JComponent) {
                Insets insets = ((JComponent)c).getInsets();
                if (insets.left > 0) {
                    super.paintBorder(c, g, x, y, width, height);
                } else {
                    g.setColor(UIUtil.getPanelBackground());
                    g.fillRect(x, y, width, 1);
                    g.setColor(Gray._50.withAlpha(90));
                    g.fillRect(x, y, width, 1);
                }
            }
        }

        @NotNull
        public Insets getBorderInsets(Component c) {
            boolean paintTop;
            Container splitters = SwingUtilities.getAncestorOfClass(EditorsSplitters.class, c);
            boolean thereIsSomethingAbove = !SystemInfo.isMac || UISettings.getInstance().SHOW_MAIN_TOOLBAR || UISettings.getInstance().SHOW_NAVIGATION_BAR || this.toolWindowIsNotEmpty();
            Component header = EditorImpl.this.myHeaderPanel == null ? null : (Component)ArrayUtil.getFirstElement((Object[])EditorImpl.this.myHeaderPanel.getComponents());
            boolean bl = paintTop = thereIsSomethingAbove && header == null && UISettings.getInstance().EDITOR_TAB_PLACEMENT != 1;
            Insets insets = splitters == null ? super.getBorderInsets(c) : new Insets(paintTop ? 1 : 0, 0, 0, 0);
            if (insets == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl$TablessBorder", "getBorderInsets"));
            }
            return insets;
        }

        public boolean toolWindowIsNotEmpty() {
            if (EditorImpl.this.myProject == null) {
                return false;
            }
            ToolWindowManagerEx m = ToolWindowManagerEx.getInstanceEx(EditorImpl.this.myProject);
            return m != null && !m.getIdsOn(ToolWindowAnchor.TOP).isEmpty();
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    private class MyScrollPane
    extends JBScrollPane {
        private MyScrollPane() {
            super(0);
            this.setupCorners();
        }

        public void layout() {
            if (EditorImpl.this.isInDistractionFreeMode()) {
                EditorImpl.this.myGutterComponent.updateSize(true);
            }
            super.layout();
        }

        protected void processMouseWheelEvent(@NotNull MouseWheelEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyScrollPane", "processMouseWheelEvent"));
            }
            if (EditorImpl.this.mySettings.isWheelFontChangeEnabled() && !MouseGestureManager.getInstance().hasTrackpad() && EditorUtil.isChangeFontSize(e)) {
                int size = EditorImpl.this.myScheme.getEditorFontSize() - e.getWheelRotation();
                if (size >= 8) {
                    EditorImpl.this.setFontSize(size, SwingUtilities.convertPoint((Component)((Object)this), e.getPoint(), this.getViewport()));
                }
                return;
            }
            super.processMouseWheelEvent(e);
        }

        @NotNull
        public JScrollBar createVerticalScrollBar() {
            MyScrollBar myScrollBar = new MyScrollBar(1);
            if (myScrollBar == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl$MyScrollPane", "createVerticalScrollBar"));
            }
            return myScrollBar;
        }

        public JScrollBar createHorizontalScrollBar() {
            return new MyScrollBar(0);
        }

        protected void setupCorners() {
            super.setupCorners();
            this.setBorder((Border)((Object)new TablessBorder()));
        }

        protected boolean isOverlaidScrollbar(@Nullable JScrollBar scrollbar) {
            ScrollBarUI vsbUI = scrollbar == null ? null : scrollbar.getUI();
            return vsbUI instanceof ButtonlessScrollBarUI && !((ButtonlessScrollBarUI)vsbUI).alwaysShowTrack();
        }
    }

    private class EditorSizeContainer {
        private TIntArrayList myLineWidths;
        private int maxCalculatedLine = -1;
        private volatile boolean myIsDirty;
        private int myOldEndLine;
        private Dimension mySize;
        private int myMaxWidth = -1;

        private EditorSizeContainer() {
        }

        public synchronized void reset() {
            int lineCount = EditorImpl.this.getDocument().getLineCount();
            this.myLineWidths = new TIntArrayList(lineCount + 300);
            this.insertNewLines(lineCount, 0);
            this.maxCalculatedLine = -1;
            this.myIsDirty = true;
        }

        private void insertNewLines(int lineCount, int index) {
            int[] values = new int[lineCount];
            Arrays.fill(values, -1);
            this.myLineWidths.insert(index, values);
            if (index <= this.maxCalculatedLine) {
                this.maxCalculatedLine += lineCount;
            }
        }

        public synchronized void beforeChange(@NotNull DocumentEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$EditorSizeContainer", "beforeChange"));
            }
            if (EditorImpl.this.myDocument.isInBulkUpdate()) {
                this.myMaxWidth = this.mySize == null ? -1 : this.mySize.width;
            }
            this.myOldEndLine = EditorImpl.this.offsetToLogicalLine(e.getOffset() + e.getOldLength());
        }

        public synchronized void update(int startLine, int newEndLine, int oldEndLine) {
            int lineWidthSize = this.myLineWidths.size();
            if (lineWidthSize == 0 || EditorImpl.this.myDocument.getTextLength() <= 0) {
                this.reset();
            } else {
                boolean toAddNewLines;
                int min = Math.min(oldEndLine, newEndLine);
                boolean bl = toAddNewLines = min >= lineWidthSize;
                if (toAddNewLines) {
                    this.insertNewLines(min - lineWidthSize + 1, lineWidthSize);
                }
                for (int i = min; i > startLine - 1; --i) {
                    this.myLineWidths.set(i, -1);
                    if (this.maxCalculatedLine != i) continue;
                    --this.maxCalculatedLine;
                }
                if (newEndLine > oldEndLine) {
                    this.insertNewLines(newEndLine - oldEndLine, oldEndLine + 1);
                } else if (oldEndLine > newEndLine && !toAddNewLines && newEndLine + 1 < lineWidthSize) {
                    int length = Math.min(oldEndLine, lineWidthSize) - newEndLine - 1;
                    int index = newEndLine + 1;
                    this.myLineWidths.remove(index, length);
                    if (index <= this.maxCalculatedLine) {
                        this.maxCalculatedLine -= length;
                    }
                }
                this.myIsDirty = true;
            }
        }

        public synchronized void updateLineWidthIfNecessary(int logicalLine, int widthInPixels) {
            if (logicalLine < this.myLineWidths.size()) {
                int currentWidth = this.myLineWidths.get(logicalLine);
                if (widthInPixels > currentWidth) {
                    this.myLineWidths.set(logicalLine, widthInPixels);
                }
                if (widthInPixels > this.myMaxWidth) {
                    this.myMaxWidth = widthInPixels;
                }
                this.maxCalculatedLine = Math.max(this.maxCalculatedLine, logicalLine);
            }
        }

        public synchronized void changedUpdate(@NotNull DocumentEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$EditorSizeContainer", "changedUpdate"));
            }
            int startLine = e.getOldLength() == 0 ? this.myOldEndLine : EditorImpl.this.myDocument.getLineNumber(e.getOffset());
            int newEndLine = e.getNewLength() == 0 ? startLine : EditorImpl.this.myDocument.getLineNumber(e.getOffset() + e.getNewLength());
            int oldEndLine = this.myOldEndLine;
            this.update(startLine, newEndLine, oldEndLine);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void validateSizes() {
            if (!this.myIsDirty && EditorImpl.this.myLinePaintersWidth <= this.myMaxWidth) {
                return;
            }
            EditorSizeContainer editorSizeContainer = this;
            synchronized (editorSizeContainer) {
                if (!this.myIsDirty) {
                    return;
                }
                int lineCount = Math.min(this.myLineWidths.size(), EditorImpl.this.myDocument.getLineCount());
                if (this.myMaxWidth != -1 && EditorImpl.this.myDocument.isInBulkUpdate()) {
                    this.mySize = new Dimension(this.myMaxWidth, EditorImpl.this.getLineHeight() * lineCount);
                    this.myIsDirty = false;
                    return;
                }
                CharSequence text = EditorImpl.this.myDocument.getImmutableCharSequence();
                int documentLength = EditorImpl.this.myDocument.getTextLength();
                int x = 0;
                boolean lastLineLengthCalculated = false;
                List<? extends SoftWrap> softWraps = EditorImpl.this.getSoftWrapModel().getRegisteredSoftWraps();
                int softWrapsIndex = -1;
                CharWidthCache charWidthCache = new CharWidthCache(EditorImpl.this);
                block3: for (int line = 0; line < lineCount; ++line) {
                    int endLine;
                    if (this.myLineWidths.getQuick(line) != -1) continue;
                    if (line == lineCount - 1) {
                        lastLineLengthCalculated = true;
                    }
                    x = 0;
                    int offset = EditorImpl.this.myDocument.getLineStartOffset(line);
                    if (offset >= EditorImpl.this.myDocument.getTextLength()) {
                        this.myLineWidths.set(line, 0);
                        this.maxCalculatedLine = Math.max(this.maxCalculatedLine, line);
                        break;
                    }
                    if (softWrapsIndex < 0 && (softWrapsIndex = EditorImpl.this.getSoftWrapModel().getSoftWrapIndex(offset)) < 0) {
                        softWrapsIndex = -softWrapsIndex - 1;
                    }
                    if (this.maxCalculatedLine < line + 1) {
                        endLine = lineCount;
                    } else {
                        for (endLine = line + 1; endLine < this.maxCalculatedLine && this.myLineWidths.getQuick(endLine) == -1; ++endLine) {
                        }
                    }
                    int endOffset = endLine >= lineCount ? documentLength : EditorImpl.this.myDocument.getLineEndOffset(endLine);
                    FoldRegion region = EditorImpl.this.myFoldingModel.getCollapsedRegionAtOffset(endOffset);
                    while (region != null && endOffset < EditorImpl.this.myDocument.getTextLength()) {
                        int lineNumber = EditorImpl.this.myDocument.getLineNumber(region.getEndOffset());
                        endOffset = EditorImpl.this.myDocument.getLineEndOffset(lineNumber);
                        region = EditorImpl.this.myFoldingModel.getCollapsedRegionAtOffset(endOffset);
                    }
                    if (endOffset > EditorImpl.this.myDocument.getTextLength()) break;
                    IterationState state = new IterationState(EditorImpl.this, offset, endOffset, false);
                    int fontType = state.getMergedAttributes().getFontType();
                    int maxPreviousSoftWrappedWidth = -1;
                    while (offset < documentLength && line < lineCount) {
                        SoftWrap softWrap;
                        char c = text.charAt(offset);
                        if (offset >= state.getEndOffset()) {
                            state.advance();
                            fontType = state.getMergedAttributes().getFontType();
                        }
                        while (softWrapsIndex < softWraps.size() && line < lineCount && (softWrap = softWraps.get(softWrapsIndex)).getStart() <= offset) {
                            ++softWrapsIndex;
                            if (softWrap.getStart() != offset) continue;
                            maxPreviousSoftWrappedWidth = Math.max(maxPreviousSoftWrappedWidth, x);
                            x = softWrap.getIndentInPixels();
                        }
                        FoldRegion collapsed = state.getCurrentFold();
                        if (collapsed != null) {
                            String placeholder = collapsed.getPlaceholderText();
                            for (int i = 0; i < placeholder.length(); ++i) {
                                x += charWidthCache.charWidth(placeholder.charAt(i), fontType);
                            }
                            offset = collapsed.getEndOffset();
                            line = EditorImpl.this.myDocument.getLineNumber(offset);
                            continue;
                        }
                        if (c == '\t') {
                            x = EditorUtil.nextTabStop(x, EditorImpl.this);
                            ++offset;
                            continue;
                        }
                        if (c == '\n') {
                            int width = Math.max(x, maxPreviousSoftWrappedWidth);
                            this.myLineWidths.set(line, width);
                            this.maxCalculatedLine = Math.max(this.maxCalculatedLine, line);
                            if (line + 1 >= lineCount || this.myLineWidths.getQuick(line + 1) != -1) continue block3;
                            ++offset;
                            x = 0;
                            if (++line != lineCount - 1) continue;
                            lastLineLengthCalculated = true;
                            continue;
                        }
                        x += charWidthCache.charWidth(c, fontType);
                        ++offset;
                    }
                }
                if (lineCount > 0 && lastLineLengthCalculated) {
                    this.myLineWidths.set(lineCount - 1, x);
                    this.maxCalculatedLine = Math.max(this.maxCalculatedLine, lineCount - 1);
                }
                int startToUse = 0;
                int endToUse = Math.min(lineCount, this.myLineWidths.size());
                if (endToUse > 0 && EditorImpl.this.getSoftWrapModel().isSoftWrappingEnabled()) {
                    Rectangle visibleArea = EditorImpl.this.getScrollingModel().getVisibleArea();
                    startToUse = EditorUtil.yPositionToLogicalLine((Editor)EditorImpl.this, visibleArea.getLocation());
                    if ((endToUse = Math.min(endToUse, EditorUtil.yPositionToLogicalLine((Editor)EditorImpl.this, visibleArea.y + visibleArea.height))) <= startToUse) {
                        endToUse = Math.min(this.myLineWidths.size(), startToUse + 1);
                    }
                }
                int maxWidth = 0;
                for (int i = startToUse; i < endToUse; ++i) {
                    maxWidth = Math.max(maxWidth, this.myLineWidths.getQuick(i));
                }
                this.mySize = new Dimension(maxWidth, EditorImpl.this.getLineHeight() * Math.max(EditorImpl.this.getVisibleLineCount(), 1));
                this.myIsDirty = false;
            }
        }

        @NotNull
        private Dimension getContentSize() {
            this.validateSizes();
            Dimension dimension = new Dimension(Math.max(this.mySize.width, EditorImpl.this.myLinePaintersWidth), this.mySize.height);
            if (dimension == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl$EditorSizeContainer", "getContentSize"));
            }
            return dimension;
        }

        private int getContentHeight() {
            return EditorImpl.this.getVisibleLineCount() * EditorImpl.this.getLineHeight();
        }
    }

    private class EditorDocumentBulkUpdateAdapter
    implements DocumentBulkUpdateListener {
        private EditorDocumentBulkUpdateAdapter() {
        }

        @Override
        public void updateStarted(@NotNull Document doc) {
            if (doc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/openapi/editor/impl/EditorImpl$EditorDocumentBulkUpdateAdapter", "updateStarted"));
            }
            if (doc != EditorImpl.this.getDocument()) {
                return;
            }
            EditorImpl.this.bulkUpdateStarted();
        }

        @Override
        public void updateFinished(@NotNull Document doc) {
            if (doc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/openapi/editor/impl/EditorImpl$EditorDocumentBulkUpdateAdapter", "updateFinished"));
            }
            if (doc != EditorImpl.this.getDocument()) {
                return;
            }
            EditorImpl.this.bulkUpdateFinished();
        }
    }

    class EditorDocumentAdapter
    implements PrioritizedDocumentListener {
        EditorDocumentAdapter() {
        }

        public void beforeDocumentChange(@NotNull DocumentEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$EditorDocumentAdapter", "beforeDocumentChange"));
            }
            EditorImpl.this.beforeChangedUpdate(e);
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$EditorDocumentAdapter", "documentChanged"));
            }
            EditorImpl.this.changedUpdate(e);
        }

        @Override
        public int getPriority() {
            return 160;
        }
    }

    private static class MyTransferHandler
    extends TransferHandler {
        private MyTransferHandler() {
        }

        private static EditorImpl getEditor(@NotNull JComponent comp) {
            if (comp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comp", "com/intellij/openapi/editor/impl/EditorImpl$MyTransferHandler", "getEditor"));
            }
            EditorComponentImpl editorComponent = (EditorComponentImpl)comp;
            return editorComponent.getEditor();
        }

        @Override
        public boolean importData(@NotNull JComponent comp, final @NotNull Transferable t) {
            if (comp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comp", "com/intellij/openapi/editor/impl/EditorImpl$MyTransferHandler", "importData"));
            }
            if (t == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/openapi/editor/impl/EditorImpl$MyTransferHandler", "importData"));
            }
            final EditorImpl editor = MyTransferHandler.getEditor(comp);
            EditorDropHandler dropHandler = editor.getDropHandler();
            if (dropHandler != null && dropHandler.canHandleDrop(t.getTransferDataFlavors())) {
                dropHandler.handleDrop(t, editor.getProject(), null);
                return true;
            }
            final int caretOffset = editor.getCaretModel().getOffset();
            if (editor.myDraggedRange != null && editor.myDraggedRange.getStartOffset() <= caretOffset && caretOffset < editor.myDraggedRange.getEndOffset()) {
                return false;
            }
            if (editor.myDraggedRange != null) {
                editor.getCaretModel().moveToOffset(editor.mySavedCaretOffsetForDNDUndoHack);
            }
            CommandProcessor.getInstance().executeCommand(editor.myProject, new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                int offset;
                                editor.getSelectionModel().removeSelection();
                                if (editor.myDraggedRange != null) {
                                    editor.getCaretModel().moveToOffset(caretOffset);
                                    offset = caretOffset;
                                } else {
                                    offset = editor.getCaretModel().getOffset();
                                }
                                if (editor.getDocument().getRangeGuard(offset, offset) != null) {
                                    return;
                                }
                                editor.putUserData(EditorEx.LAST_PASTED_REGION, null);
                                EditorActionHandler pasteHandler = EditorActionManager.getInstance().getActionHandler("EditorPaste");
                                LOG.assertTrue(pasteHandler instanceof EditorTextInsertHandler);
                                ((EditorTextInsertHandler)pasteHandler).execute((Editor)editor, editor.getDataContext(), (Producer)new Producer<Transferable>(){

                                    public Transferable produce() {
                                        return t;
                                    }
                                });
                                TextRange range = (TextRange)editor.getUserData(EditorEx.LAST_PASTED_REGION);
                                if (range != null) {
                                    editor.getCaretModel().moveToOffset(range.getStartOffset());
                                    editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
                                }
                            }
                            catch (Exception exception) {
                                LOG.error((Throwable)exception);
                            }
                        }
                    });
                }
            }, EditorBundle.message((String)"paste.command.name", (Object[])new Object[0]), (Object)DND_COMMAND_KEY, UndoConfirmationPolicy.DEFAULT, (Document)editor.getDocument());
            return true;
        }

        @Override
        public boolean canImport(@NotNull JComponent comp, @NotNull DataFlavor[] transferFlavors) {
            if (comp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comp", "com/intellij/openapi/editor/impl/EditorImpl$MyTransferHandler", "canImport"));
            }
            if (transferFlavors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transferFlavors", "com/intellij/openapi/editor/impl/EditorImpl$MyTransferHandler", "canImport"));
            }
            EditorImpl editor = MyTransferHandler.getEditor(comp);
            EditorDropHandler dropHandler = editor.getDropHandler();
            if (dropHandler != null && dropHandler.canHandleDrop(transferFlavors)) {
                return true;
            }
            if (editor.isViewer()) {
                return false;
            }
            int offset = editor.getCaretModel().getOffset();
            if (editor.getDocument().getRangeGuard(offset, offset) != null) {
                return false;
            }
            for (DataFlavor transferFlavor : transferFlavors) {
                if (!transferFlavor.equals(DataFlavor.stringFlavor)) continue;
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        protected Transferable createTransferable(JComponent c) {
            EditorImpl editor = MyTransferHandler.getEditor(c);
            String s = editor.getSelectionModel().getSelectedText();
            if (s == null) {
                return null;
            }
            int selectionStart = editor.getSelectionModel().getSelectionStart();
            int selectionEnd = editor.getSelectionModel().getSelectionEnd();
            editor.myDraggedRange = editor.getDocument().createRangeMarker(selectionStart, selectionEnd);
            return new StringSelection(s);
        }

        @Override
        public int getSourceActions(@NotNull JComponent c) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/openapi/editor/impl/EditorImpl$MyTransferHandler", "getSourceActions"));
            }
            return 3;
        }

        @Override
        protected void exportDone(@NotNull JComponent source, @Nullable Transferable data, int action) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/openapi/editor/impl/EditorImpl$MyTransferHandler", "exportDone"));
            }
            if (data == null) {
                return;
            }
            Component last = DnDManager.getInstance().getLastDropHandler();
            if (last != null && !(last instanceof EditorComponentImpl)) {
                return;
            }
            final EditorImpl editor = MyTransferHandler.getEditor(source);
            if (action == 2 && !editor.isViewer() && editor.myDraggedRange != null) {
                if (!FileDocumentManager.getInstance().requestWriting((Document)editor.getDocument(), editor.getProject())) {
                    return;
                }
                CommandProcessor.getInstance().executeCommand(editor.myProject, new Runnable(){

                    @Override
                    public void run() {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                DocumentEx doc = editor.getDocument();
                                doc.startGuardedBlockChecking();
                                try {
                                    doc.deleteString(editor.myDraggedRange.getStartOffset(), editor.myDraggedRange.getEndOffset());
                                }
                                catch (ReadOnlyFragmentModificationException e) {
                                    EditorActionManager.getInstance().getReadonlyFragmentModificationHandler((Document)doc).handle(e);
                                }
                                finally {
                                    doc.stopGuardedBlockChecking();
                                }
                            }
                        });
                    }
                }, EditorBundle.message((String)"move.selection.command.name", (Object[])new Object[0]), (Object)DND_COMMAND_KEY, UndoConfirmationPolicy.DEFAULT, (Document)editor.getDocument());
            }
            editor.clearDraggedRange();
        }
    }

    private class MyColorSchemeDelegate
    extends DelegateColorScheme {
        private final FontPreferences myFontPreferences;
        private final Map<TextAttributesKey, TextAttributes> myOwnAttributes;
        private final Map<ColorKey, Color> myOwnColors;
        private final EditorColorsScheme myCustomGlobalScheme;
        private Map<EditorFontType, Font> myFontsMap;
        private int myMaxFontSize;
        private int myFontSize;
        private String myFaceName;

        private MyColorSchemeDelegate(EditorColorsScheme globalScheme) {
            super(globalScheme == null ? EditorColorsManager.getInstance().getGlobalScheme() : globalScheme);
            this.myFontPreferences = new FontPreferences();
            this.myOwnAttributes = ContainerUtilRt.newHashMap();
            this.myOwnColors = ContainerUtilRt.newHashMap();
            this.myFontsMap = null;
            this.myMaxFontSize = 40;
            this.myFontSize = -1;
            this.myFaceName = null;
            this.myCustomGlobalScheme = globalScheme;
            this.updateGlobalScheme();
        }

        private void reinitFonts() {
            String editorFontName = this.getEditorFontName();
            int editorFontSize = this.getEditorFontSize();
            this.myFontPreferences.clear();
            this.myFontPreferences.register(editorFontName, editorFontSize);
            EditorColorsScheme delegate = this.getDelegate();
            List secondaryFonts = delegate != null ? delegate.getFontPreferences().getRealFontFamilies() : ContainerUtil.emptyList();
            boolean first = true;
            for (String font : secondaryFonts) {
                if (!first) {
                    this.myFontPreferences.register(font, editorFontSize);
                }
                first = false;
            }
            this.myFontsMap = new EnumMap<EditorFontType, Font>(EditorFontType.class);
            Font plainFont = new Font(editorFontName, 0, editorFontSize);
            Font boldFont = new Font(editorFontName, 1, editorFontSize);
            Font italicFont = new Font(editorFontName, 2, editorFontSize);
            Font boldItalicFont = new Font(editorFontName, 3, editorFontSize);
            this.myFontsMap.put(EditorFontType.PLAIN, plainFont);
            this.myFontsMap.put(EditorFontType.BOLD, boldFont);
            this.myFontsMap.put(EditorFontType.ITALIC, italicFont);
            this.myFontsMap.put(EditorFontType.BOLD_ITALIC, boldItalicFont);
        }

        protected void reinitFontsAndSettings() {
            this.reinitFonts();
            EditorImpl.this.reinitSettings();
        }

        @Override
        public TextAttributes getAttributes(TextAttributesKey key) {
            if (this.myOwnAttributes.containsKey(key)) {
                return this.myOwnAttributes.get(key);
            }
            return this.getDelegate().getAttributes(key);
        }

        @Override
        public void setAttributes(TextAttributesKey key, TextAttributes attributes) {
            this.myOwnAttributes.put(key, attributes);
        }

        @Override
        @Nullable
        public Color getColor(ColorKey key) {
            if (this.myOwnColors.containsKey(key)) {
                return this.myOwnColors.get(key);
            }
            return this.getDelegate().getColor(key);
        }

        @Override
        public void setColor(ColorKey key, Color color) {
            this.myOwnColors.put(key, color);
            EditorImpl.this.myCaretModel.reinitSettings();
            EditorImpl.this.mySelectionModel.reinitSettings();
        }

        @Override
        public int getEditorFontSize() {
            if (this.myFontSize == -1) {
                return this.getDelegate().getEditorFontSize();
            }
            return this.myFontSize;
        }

        @Override
        public void setEditorFontSize(int fontSize) {
            if (fontSize < 8) {
                fontSize = 8;
            }
            if (fontSize > this.myMaxFontSize) {
                fontSize = this.myMaxFontSize;
            }
            if (fontSize == this.myFontSize) {
                return;
            }
            this.myFontSize = fontSize;
            this.reinitFontsAndSettings();
        }

        @Override
        @NotNull
        public FontPreferences getFontPreferences() {
            FontPreferences fontPreferences = this.myFontPreferences.getEffectiveFontFamilies().isEmpty() ? this.getDelegate().getFontPreferences() : this.myFontPreferences;
            if (fontPreferences == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl$MyColorSchemeDelegate", "getFontPreferences"));
            }
            return fontPreferences;
        }

        @Override
        public void setFontPreferences(@NotNull FontPreferences preferences) {
            if (preferences == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/impl/EditorImpl$MyColorSchemeDelegate", "setFontPreferences"));
            }
            if (Comparing.equal((Object)preferences, (Object)this.myFontPreferences)) {
                return;
            }
            preferences.copyTo(this.myFontPreferences);
            this.reinitFontsAndSettings();
        }

        @Override
        public String getEditorFontName() {
            if (this.myFaceName == null) {
                return this.getDelegate().getEditorFontName();
            }
            return this.myFaceName;
        }

        @Override
        public void setEditorFontName(String fontName) {
            if (Comparing.equal((String)fontName, (String)this.myFaceName)) {
                return;
            }
            this.myFaceName = fontName;
            this.reinitFontsAndSettings();
        }

        @Override
        public Font getFont(EditorFontType key) {
            Font font;
            if (this.myFontsMap != null && (font = this.myFontsMap.get(key)) != null) {
                return font;
            }
            return this.getDelegate().getFont(key);
        }

        @Override
        public void setFont(EditorFontType key, Font font) {
            if (this.myFontsMap == null) {
                this.reinitFontsAndSettings();
            }
            this.myFontsMap.put(key, font);
            EditorImpl.this.reinitSettings();
        }

        @Override
        @Nullable
        public Object clone() {
            return null;
        }

        public void updateGlobalScheme() {
            this.setDelegate(this.myCustomGlobalScheme == null ? EditorColorsManager.getInstance().getGlobalScheme() : this.myCustomGlobalScheme);
        }

        @Override
        public void setDelegate(@NotNull EditorColorsScheme delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/openapi/editor/impl/EditorImpl$MyColorSchemeDelegate", "setDelegate"));
            }
            super.setDelegate(delegate);
            int globalFontSize = this.getDelegate().getEditorFontSize();
            this.myMaxFontSize = Math.max(40, globalFontSize);
            this.reinitFonts();
            EditorImpl.this.clearSettingsCache();
        }

        @Override
        public void setConsoleFontSize(int fontSize) {
            this.getDelegate().setConsoleFontSize(fontSize);
            EditorImpl.this.reinitSettings();
        }
    }

    private class MyMouseMotionListener
    implements MouseMotionListener {
        private MyMouseMotionListener() {
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseMotionListener", "mouseDragged"));
            }
            EditorImpl.this.validateMousePointer(e);
            EditorImpl.this.runMouseDraggedCommand(e);
            EditorMouseEvent event = new EditorMouseEvent((Editor)EditorImpl.this, e, EditorImpl.this.getMouseEventArea(e));
            if (event.getArea() == EditorMouseEventArea.LINE_MARKERS_AREA) {
                EditorImpl.this.myGutterComponent.mouseDragged(e);
            }
            for (EditorMouseMotionListener listener : EditorImpl.this.myMouseMotionListeners) {
                listener.mouseDragged(event);
            }
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseMotionListener", "mouseMoved"));
            }
            if (EditorImpl.this.getMouseSelectionState() != 0) {
                if (EditorImpl.this.myMousePressedEvent != null && EditorImpl.this.myMousePressedEvent.getComponent() == e.getComponent()) {
                    Point lastPoint = EditorImpl.this.myMousePressedEvent.getPoint();
                    Point point = e.getPoint();
                    int deadZone = Registry.intValue((String)"editor.mouseSelectionStateResetDeadZone");
                    if (Math.abs(lastPoint.x - point.x) >= deadZone || Math.abs(lastPoint.y - point.y) >= deadZone) {
                        EditorImpl.this.resetMouseSelectionState(e);
                    }
                } else {
                    EditorImpl.this.validateMousePointer(e);
                }
            } else {
                EditorImpl.this.validateMousePointer(e);
            }
            EditorImpl.this.myMouseMovedEvent = e;
            EditorMouseEvent event = new EditorMouseEvent((Editor)EditorImpl.this, e, EditorImpl.this.getMouseEventArea(e));
            if (e.getSource() == EditorImpl.this.myGutterComponent) {
                EditorImpl.this.myGutterComponent.mouseMoved(e);
            }
            if (event.getArea() == EditorMouseEventArea.EDITING_AREA) {
                FoldRegion fold = EditorImpl.this.myFoldingModel.getFoldingPlaceholderAt(e.getPoint());
                TooltipController controller = TooltipController.getInstance();
                if (fold != null && !fold.shouldNeverExpand()) {
                    DocumentFragment range = this.createDocumentFragment(fold);
                    Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), EditorImpl.this.getComponent().getRootPane().getLayeredPane());
                    controller.showTooltip((Editor)EditorImpl.this, p, new DocumentFragmentTooltipRenderer(range), false, FOLDING_TOOLTIP_GROUP);
                } else {
                    controller.cancelTooltip(FOLDING_TOOLTIP_GROUP, e, true);
                }
            }
            for (EditorMouseMotionListener listener : EditorImpl.this.myMouseMotionListeners) {
                listener.mouseMoved(event);
            }
        }

        @NotNull
        private DocumentFragment createDocumentFragment(@NotNull FoldRegion fold) {
            int endOffset;
            if (fold == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fold", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseMotionListener", "createDocumentFragment"));
            }
            FoldingGroup group = fold.getGroup();
            int foldStart = fold.getStartOffset();
            if (group != null && EditorImpl.this.offsetToVisualLine(endOffset = EditorImpl.this.myFoldingModel.getEndOffset(group)) == EditorImpl.this.offsetToVisualLine(foldStart)) {
                DocumentFragment documentFragment = new DocumentFragment((Document)EditorImpl.this.myDocument, foldStart, endOffset);
                if (documentFragment == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseMotionListener", "createDocumentFragment"));
                }
                return documentFragment;
            }
            int oldEnd = fold.getEndOffset();
            DocumentFragment documentFragment = new DocumentFragment((Document)EditorImpl.this.myDocument, foldStart, oldEnd);
            if (documentFragment == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseMotionListener", "createDocumentFragment"));
            }
            return documentFragment;
        }
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private boolean mySelectionTweaked;

        private MyMouseAdapter() {
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseAdapter", "mousePressed"));
            }
            EditorImpl.this.requestFocus();
            this.runMousePressedCommand(e);
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseAdapter", "mouseReleased"));
            }
            EditorImpl.this.myMousePressArea = null;
            this.runMouseReleasedCommand(e);
            if (!e.isConsumed() && EditorImpl.this.myMousePressedEvent != null && !EditorImpl.this.myMousePressedEvent.isConsumed() && Math.abs(e.getX() - EditorImpl.this.myMousePressedEvent.getX()) < EditorUtil.getSpaceWidth(0, EditorImpl.this) && Math.abs(e.getY() - EditorImpl.this.myMousePressedEvent.getY()) < EditorImpl.this.getLineHeight()) {
                this.runMouseClickedCommand(e);
            }
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseAdapter", "mouseEntered"));
            }
            this.runMouseEnteredCommand(e);
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseAdapter", "mouseExited"));
            }
            this.runMouseExitedCommand(e);
            EditorMouseEvent event = new EditorMouseEvent((Editor)EditorImpl.this, e, EditorImpl.this.getMouseEventArea(e));
            if (event.getArea() == EditorMouseEventArea.LINE_MARKERS_AREA) {
                EditorImpl.this.myGutterComponent.mouseExited(e);
            }
            TooltipController.getInstance().cancelTooltip(FOLDING_TOOLTIP_GROUP, e, true);
        }

        private void runMousePressedCommand(final @NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseAdapter", "runMousePressedCommand"));
            }
            EditorImpl.this.myLastMousePressedLocation = EditorImpl.this.xyToLogicalPosition(e.getPoint());
            EditorImpl.this.myCaretStateBeforeLastPress = EditorImpl.isToggleCaretEvent(e) ? EditorImpl.this.myCaretModel.getCaretsAndSelections() : Collections.emptyList();
            EditorImpl.this.myCurrentDragIsSubstantial = false;
            EditorImpl.this.clearDraggedRange();
            int clickOffset = EditorImpl.this.logicalPositionToOffset(EditorImpl.this.myLastMousePressedLocation);
            EditorImpl.this.putUserData(EditorActionUtil.EXPECTED_CARET_OFFSET, clickOffset);
            this.mySelectionTweaked = false;
            EditorImpl.this.myMousePressedEvent = e;
            EditorMouseEvent event = new EditorMouseEvent((Editor)EditorImpl.this, e, EditorImpl.this.getMouseEventArea(e));
            for (EditorMouseListener mouseListener : EditorImpl.this.myMouseListeners) {
                mouseListener.mousePressed(event);
            }
            EditorImpl.this.putUserData(EditorActionUtil.EXPECTED_CARET_OFFSET, null);
            if (event.getArea() == EditorMouseEventArea.LINE_MARKERS_AREA) {
                EditorImpl.this.myDragOnGutterSelectionStartLine = EditorUtil.yPositionToLogicalLine((Editor)EditorImpl.this, e);
            }
            if (event.isConsumed() && !event.getMouseEvent().isPopupTrigger() && event.getArea() != EditorMouseEventArea.EDITING_AREA) {
                return;
            }
            if (EditorImpl.this.myCommandProcessor != null) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (MyMouseAdapter.this.processMousePressed(e) && EditorImpl.this.myProject != null && !EditorImpl.this.myProject.isDefault()) {
                            IdeDocumentHistory.getInstance(EditorImpl.this.myProject).includeCurrentCommandAsNavigation();
                        }
                    }
                };
                EditorImpl.this.myCommandProcessor.executeCommand(EditorImpl.this.myProject, runnable, "", (Object)DocCommandGroupId.noneGroupId((Document)EditorImpl.this.getDocument()), UndoConfirmationPolicy.DEFAULT, (Document)EditorImpl.this.getDocument());
            } else {
                this.processMousePressed(e);
            }
        }

        private void runMouseClickedCommand(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseAdapter", "runMouseClickedCommand"));
            }
            EditorMouseEvent event = new EditorMouseEvent((Editor)EditorImpl.this, e, EditorImpl.this.getMouseEventArea(e));
            for (EditorMouseListener listener : EditorImpl.this.myMouseListeners) {
                listener.mouseClicked(event);
                if (!event.isConsumed()) continue;
                e.consume();
                return;
            }
        }

        private void runMouseReleasedCommand(final @NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseAdapter", "runMouseReleasedCommand"));
            }
            EditorImpl.this.myMultiSelectionInProgress = false;
            EditorImpl.this.myDragOnGutterSelectionStartLine = -1;
            if (!this.mySelectionTweaked) {
                EditorImpl.this.tweakSelectionIfNecessary(e);
            }
            if (e.isConsumed()) {
                return;
            }
            EditorImpl.this.myScrollingTimer.stop();
            EditorMouseEvent event = new EditorMouseEvent((Editor)EditorImpl.this, e, EditorImpl.this.getMouseEventArea(e));
            for (EditorMouseListener listener : EditorImpl.this.myMouseListeners) {
                listener.mouseReleased(event);
                if (!event.isConsumed()) continue;
                e.consume();
                return;
            }
            if (EditorImpl.this.myCommandProcessor != null) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        EditorImpl.this.processMouseReleased(e);
                    }
                };
                EditorImpl.this.myCommandProcessor.executeCommand(EditorImpl.this.myProject, runnable, "", (Object)DocCommandGroupId.noneGroupId((Document)EditorImpl.this.getDocument()), UndoConfirmationPolicy.DEFAULT, (Document)EditorImpl.this.getDocument());
            } else {
                EditorImpl.this.processMouseReleased(e);
            }
        }

        private void runMouseEnteredCommand(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseAdapter", "runMouseEnteredCommand"));
            }
            EditorMouseEvent event = new EditorMouseEvent((Editor)EditorImpl.this, e, EditorImpl.this.getMouseEventArea(e));
            for (EditorMouseListener listener : EditorImpl.this.myMouseListeners) {
                listener.mouseEntered(event);
                if (!event.isConsumed()) continue;
                e.consume();
                return;
            }
        }

        private void runMouseExitedCommand(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseAdapter", "runMouseExitedCommand"));
            }
            EditorMouseEvent event = new EditorMouseEvent((Editor)EditorImpl.this, e, EditorImpl.this.getMouseEventArea(e));
            for (EditorMouseListener listener : EditorImpl.this.myMouseListeners) {
                listener.mouseExited(event);
                if (!event.isConsumed()) continue;
                e.consume();
                return;
            }
        }

        private boolean processMousePressed(final @NotNull MouseEvent e) {
            FoldRegion range;
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseAdapter", "processMousePressed"));
            }
            EditorImpl.this.myInitialMouseEvent = e;
            if (EditorImpl.this.myMouseSelectionState != 0 && System.currentTimeMillis() - EditorImpl.this.myMouseSelectionChangeTimestamp > (long)Registry.intValue((String)"editor.mouseSelectionStateResetTimeout")) {
                EditorImpl.this.resetMouseSelectionState(e);
            }
            int x = e.getX();
            int y = e.getY();
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            EditorMouseEventArea eventArea = EditorImpl.this.getMouseEventArea(e);
            EditorImpl.this.myMousePressArea = eventArea;
            boolean isNavigation = false;
            if (eventArea == EditorMouseEventArea.FOLDING_OUTLINE_AREA && (range = EditorImpl.this.myGutterComponent.findFoldingAnchorAt(x, y)) != null) {
                final boolean expansion = !range.isExpanded();
                int scrollShift = y - EditorImpl.this.getScrollingModel().getVerticalScrollOffset();
                Runnable processor = new Runnable(){

                    @Override
                    public void run() {
                        EditorImpl.this.myFoldingModel.flushCaretShift();
                        range.setExpanded(expansion);
                        if (e.isAltDown()) {
                            for (FoldRegion region : EditorImpl.this.myFoldingModel.getAllFoldRegions()) {
                                if (region.getStartOffset() < range.getStartOffset() || region.getEndOffset() > range.getEndOffset()) continue;
                                region.setExpanded(expansion);
                            }
                        }
                    }
                };
                EditorImpl.this.getFoldingModel().runBatchFoldingOperation(processor);
                y = EditorImpl.this.myGutterComponent.getHeadCenterY(range);
                EditorImpl.this.getScrollingModel().scrollVertically(y - scrollShift);
                EditorImpl.this.myGutterComponent.updateSize();
                EditorImpl.this.validateMousePointer(e);
                e.consume();
                return isNavigation;
            }
            if (e.getSource() == EditorImpl.this.myGutterComponent) {
                if (eventArea == EditorMouseEventArea.LINE_MARKERS_AREA || eventArea == EditorMouseEventArea.ANNOTATIONS_AREA || eventArea == EditorMouseEventArea.LINE_NUMBERS_AREA) {
                    if (EditorImpl.this.tweakSelectionIfNecessary(e)) {
                        this.mySelectionTweaked = true;
                    } else {
                        EditorImpl.this.myGutterComponent.mousePressed(e);
                    }
                    if (e.isConsumed()) {
                        return isNavigation;
                    }
                }
                x = 0;
            }
            int oldSelectionStart = EditorImpl.this.mySelectionModel.getLeadSelectionOffset();
            int oldStart = EditorImpl.this.mySelectionModel.getSelectionStart();
            int oldEnd = EditorImpl.this.mySelectionModel.getSelectionEnd();
            boolean toggleCaret = e.getSource() != EditorImpl.this.myGutterComponent && EditorImpl.isToggleCaretEvent(e);
            boolean lastPressCreatedCaret = EditorImpl.this.myLastPressCreatedCaret;
            if (e.getClickCount() == 1) {
                EditorImpl.this.myLastPressCreatedCaret = false;
            }
            if (e.getSource() != EditorImpl.this.myGutterComponent || eventArea != EditorMouseEventArea.LINE_MARKERS_AREA && eventArea != EditorMouseEventArea.ANNOTATIONS_AREA) {
                LogicalPosition pos = EditorImpl.this.getLogicalPositionForScreenPos(x, y, true);
                if (toggleCaret) {
                    VisualPosition visualPosition = EditorImpl.this.logicalToVisualPosition(pos);
                    Caret caret = EditorImpl.this.getCaretModel().getCaretAt(visualPosition);
                    if (e.getClickCount() == 1) {
                        if (caret == null) {
                            EditorImpl.this.myLastPressCreatedCaret = EditorImpl.this.getCaretModel().addCaret(visualPosition) != null;
                        } else {
                            EditorImpl.this.getCaretModel().removeCaret(caret);
                        }
                    } else if (e.getClickCount() == 3 && lastPressCreatedCaret) {
                        EditorImpl.this.getCaretModel().moveToLogicalPosition(pos);
                    }
                } else if (EditorImpl.this.myCaretModel.supportsMultipleCarets() && e.getSource() != EditorImpl.this.myGutterComponent && EditorImpl.isCreateRectangularSelectionEvent(e)) {
                    EditorImpl.this.mySelectionModel.setBlockSelection(EditorImpl.this.myCaretModel.getLogicalPosition(), pos);
                } else {
                    EditorImpl.this.getCaretModel().removeSecondaryCarets();
                    EditorImpl.this.getCaretModel().moveToLogicalPosition(pos);
                }
            }
            if (e.isPopupTrigger()) {
                return isNavigation;
            }
            EditorImpl.this.requestFocus();
            int caretOffset = EditorImpl.this.getCaretModel().getOffset();
            int newStart = EditorImpl.this.mySelectionModel.getSelectionStart();
            int newEnd = EditorImpl.this.mySelectionModel.getSelectionEnd();
            if (oldStart != newStart && oldEnd != newEnd && oldStart == oldEnd && newStart == newEnd) {
                isNavigation = true;
            }
            EditorImpl.this.myMouseSelectedRegion = EditorImpl.this.myFoldingModel.getFoldingPlaceholderAt(new Point(x, y));
            EditorImpl.this.myMousePressedInsideSelection = EditorImpl.this.mySelectionModel.hasSelection() && caretOffset >= EditorImpl.this.mySelectionModel.getSelectionStart() && caretOffset <= EditorImpl.this.mySelectionModel.getSelectionEnd();
            if (EditorImpl.this.getMouseEventArea(e) == EditorMouseEventArea.LINE_NUMBERS_AREA && e.getClickCount() == 1) {
                EditorImpl.this.mySelectionModel.selectLineAtCaret();
                EditorImpl.this.setMouseSelectionState(2);
                EditorImpl.this.mySavedSelectionStart = EditorImpl.this.mySelectionModel.getSelectionStart();
                EditorImpl.this.mySavedSelectionEnd = EditorImpl.this.mySelectionModel.getSelectionEnd();
                return isNavigation;
            }
            if (e.isShiftDown() && !e.isControlDown() && !e.isAltDown()) {
                if (EditorImpl.this.getMouseSelectionState() != 0) {
                    if (caretOffset < EditorImpl.this.mySavedSelectionStart) {
                        EditorImpl.this.mySelectionModel.setSelection(EditorImpl.this.mySavedSelectionEnd, caretOffset);
                    } else {
                        EditorImpl.this.mySelectionModel.setSelection(EditorImpl.this.mySavedSelectionStart, caretOffset);
                    }
                } else {
                    int startToUse = oldSelectionStart;
                    if (EditorImpl.this.mySelectionModel.isUnknownDirection() && caretOffset > startToUse) {
                        startToUse = Math.min(oldStart, oldEnd);
                    }
                    EditorImpl.this.mySelectionModel.setSelection(startToUse, caretOffset);
                }
            } else if (!EditorImpl.this.myMousePressedInsideSelection && EditorImpl.this.getSelectionModel().hasSelection()) {
                EditorImpl.this.setMouseSelectionState(0);
                EditorImpl.this.mySelectionModel.setSelection(caretOffset, caretOffset);
            } else if (!(e.isPopupTrigger() || eventArea != EditorMouseEventArea.EDITING_AREA && eventArea != EditorMouseEventArea.LINE_NUMBERS_AREA || toggleCaret && !lastPressCreatedCaret)) {
                switch (e.getClickCount()) {
                    case 2: {
                        EditorImpl.this.selectWordAtCaret(EditorImpl.this.mySettings.isMouseClickSelectionHonorsCamelWords() && EditorImpl.this.mySettings.isCamelWords());
                        break;
                    }
                    case 3: {
                        if (HONOR_CAMEL_HUMPS_ON_TRIPLE_CLICK && EditorImpl.this.mySettings.isCamelWords()) {
                            EditorImpl.this.selectWordAtCaret(false);
                            break;
                        }
                    }
                    case 4: {
                        EditorImpl.this.mySelectionModel.selectLineAtCaret();
                        EditorImpl.this.setMouseSelectionState(2);
                        EditorImpl.this.mySavedSelectionStart = EditorImpl.this.mySelectionModel.getSelectionStart();
                        EditorImpl.this.mySavedSelectionEnd = EditorImpl.this.mySelectionModel.getSelectionEnd();
                        EditorImpl.this.mySelectionModel.setUnknownDirection(true);
                    }
                }
            }
            return isNavigation;
        }
    }

    private class MyInputMethodHandler
    implements InputMethodRequests {
        private String composedText;
        private ProperTextRange composedTextRange;

        private MyInputMethodHandler() {
        }

        @Override
        @NotNull
        public Rectangle getTextLocation(TextHitInfo offset) {
            Point caret = EditorImpl.this.logicalPositionToXY(EditorImpl.this.getCaretModel().getLogicalPosition());
            Rectangle r = new Rectangle(caret, new Dimension(1, EditorImpl.this.getLineHeight()));
            Point p = EditorImpl.this.getContentComponent().getLocationOnScreen();
            r.translate(p.x, p.y);
            Rectangle rectangle = r;
            if (rectangle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl$MyInputMethodHandler", "getTextLocation"));
            }
            return rectangle;
        }

        @Override
        @Nullable
        public TextHitInfo getLocationOffset(int x, int y) {
            if (this.composedText != null) {
                Point p = EditorImpl.this.getContentComponent().getLocationOnScreen();
                p.x = x - p.x;
                p.y = y - p.y;
                int pos = EditorImpl.this.logicalPositionToOffset(EditorImpl.this.xyToLogicalPosition(p));
                if (this.composedTextRange.containsOffset(pos)) {
                    return TextHitInfo.leading(pos - this.composedTextRange.getStartOffset());
                }
            }
            return null;
        }

        @Override
        public int getInsertPositionOffset() {
            int caretIndex;
            int composedStartIndex = 0;
            int composedEndIndex = 0;
            if (this.composedText != null) {
                composedStartIndex = this.composedTextRange.getStartOffset();
                composedEndIndex = this.composedTextRange.getEndOffset();
            }
            if ((caretIndex = EditorImpl.this.getCaretModel().getOffset()) < composedStartIndex) {
                return caretIndex;
            }
            if (caretIndex < composedEndIndex) {
                return composedStartIndex;
            }
            return caretIndex - (composedEndIndex - composedStartIndex);
        }

        private String getText(int startIdx, int endIdx) {
            if (startIdx >= 0 && endIdx > startIdx) {
                CharSequence chars = EditorImpl.this.getDocument().getImmutableCharSequence();
                return ((Object)chars.subSequence(startIdx, endIdx)).toString();
            }
            return "";
        }

        @Override
        @NotNull
        public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
            String committed;
            int composedStartIndex = 0;
            int composedEndIndex = 0;
            if (this.composedText != null) {
                composedStartIndex = this.composedTextRange.getStartOffset();
                composedEndIndex = this.composedTextRange.getEndOffset();
            }
            if (beginIndex < composedStartIndex) {
                if (endIndex <= composedStartIndex) {
                    committed = this.getText(beginIndex, endIndex - beginIndex);
                } else {
                    int firstPartLength = composedStartIndex - beginIndex;
                    committed = this.getText(beginIndex, firstPartLength) + this.getText(composedEndIndex, endIndex - beginIndex - firstPartLength);
                }
            } else {
                committed = this.getText(beginIndex + composedEndIndex - composedStartIndex, endIndex - beginIndex);
            }
            AttributedCharacterIterator attributedCharacterIterator = new AttributedString(committed).getIterator();
            if (attributedCharacterIterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl$MyInputMethodHandler", "getCommittedText"));
            }
            return attributedCharacterIterator;
        }

        @Override
        public int getCommittedTextLength() {
            int length = EditorImpl.this.getDocument().getTextLength();
            if (this.composedText != null) {
                length -= this.composedText.length();
            }
            return length;
        }

        @Override
        @Nullable
        public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
            return null;
        }

        @Override
        @Nullable
        public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
            String text = EditorImpl.this.getSelectionModel().getSelectedText();
            return text == null ? null : new AttributedString(text).getIterator();
        }

        private void createComposedString(int composedIndex, @NotNull AttributedCharacterIterator text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/EditorImpl$MyInputMethodHandler", "createComposedString"));
            }
            StringBuffer strBuf = new StringBuffer();
            char c = text.setIndex(composedIndex);
            while (c != '\uffff') {
                strBuf.append(c);
                c = text.next();
            }
            this.composedText = new String(strBuf);
        }

        private void setInputMethodCaretPosition(@NotNull InputMethodEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyInputMethodHandler", "setInputMethodCaretPosition"));
            }
            if (this.composedText != null) {
                int dot = this.composedTextRange.getStartOffset();
                TextHitInfo caretPos = e.getCaret();
                if (caretPos != null) {
                    dot += caretPos.getInsertionIndex();
                }
                EditorImpl.this.getCaretModel().moveToOffset(dot);
                EditorImpl.this.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        }

        private void runUndoTransparent(final @NotNull Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/editor/impl/EditorImpl$MyInputMethodHandler", "runUndoTransparent"));
            }
            CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(){

                @Override
                public void run() {
                    CommandProcessor.getInstance().executeCommand(EditorImpl.this.myProject, new Runnable(){

                        @Override
                        public void run() {
                            ApplicationManager.getApplication().runWriteAction(runnable);
                        }
                    }, "", (Object)EditorImpl.this.getDocument(), UndoConfirmationPolicy.DEFAULT, (Document)EditorImpl.this.getDocument());
                }
            });
        }

        private void replaceInputMethodText(@NotNull InputMethodEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyInputMethodHandler", "replaceInputMethodText"));
            }
            int commitCount = e.getCommittedCharacterCount();
            AttributedCharacterIterator text = e.getText();
            final DocumentEx doc = EditorImpl.this.getDocument();
            if (this.composedText != null) {
                if (!EditorImpl.this.isViewer() && doc.isWritable()) {
                    this.runUndoTransparent(new Runnable(){

                        @Override
                        public void run() {
                            int docLength = doc.getTextLength();
                            ProperTextRange range = MyInputMethodHandler.this.composedTextRange.intersection(new TextRange(0, docLength));
                            if (range != null) {
                                doc.deleteString(range.getStartOffset(), range.getEndOffset());
                            }
                        }
                    });
                }
                this.composedText = null;
            }
            if (text != null) {
                int composedTextIndex;
                text.first();
                if (commitCount > 0) {
                    char c = text.current();
                    while (commitCount > 0) {
                        if (c >= ' ' && c != '\u007f') {
                            EditorImpl.this.processKeyTyped(c);
                        }
                        c = text.next();
                        --commitCount;
                    }
                }
                if (!EditorImpl.this.isViewer() && doc.isWritable() && (composedTextIndex = text.getIndex()) < text.getEndIndex()) {
                    this.createComposedString(composedTextIndex, text);
                    this.runUndoTransparent(new Runnable(){

                        @Override
                        public void run() {
                            EditorModificationUtil.insertStringAtCaret((Editor)EditorImpl.this, (String)MyInputMethodHandler.this.composedText, (boolean)false, (boolean)false);
                        }
                    });
                    this.composedTextRange = ProperTextRange.from((int)EditorImpl.this.getCaretModel().getOffset(), (int)this.composedText.length());
                }
            }
        }
    }

    private static class MyInputMethodHandleSwingThreadWrapper
    implements InputMethodRequests {
        private final InputMethodRequests myDelegate;

        private MyInputMethodHandleSwingThreadWrapper(InputMethodRequests delegate) {
            this.myDelegate = delegate;
        }

        @Override
        @NotNull
        public Rectangle getTextLocation(final TextHitInfo offset) {
            Rectangle rectangle = MyInputMethodHandleSwingThreadWrapper.execute(new Computable<Rectangle>(){

                public Rectangle compute() {
                    return MyInputMethodHandleSwingThreadWrapper.this.myDelegate.getTextLocation(offset);
                }
            });
            if (rectangle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl$MyInputMethodHandleSwingThreadWrapper", "getTextLocation"));
            }
            return rectangle;
        }

        @Override
        public TextHitInfo getLocationOffset(final int x, final int y) {
            return MyInputMethodHandleSwingThreadWrapper.execute(new Computable<TextHitInfo>(){

                public TextHitInfo compute() {
                    return MyInputMethodHandleSwingThreadWrapper.this.myDelegate.getLocationOffset(x, y);
                }
            });
        }

        @Override
        public int getInsertPositionOffset() {
            return MyInputMethodHandleSwingThreadWrapper.execute(new Computable<Integer>(){

                public Integer compute() {
                    return MyInputMethodHandleSwingThreadWrapper.this.myDelegate.getInsertPositionOffset();
                }
            });
        }

        @Override
        @NotNull
        public AttributedCharacterIterator getCommittedText(final int beginIndex, final int endIndex, final AttributedCharacterIterator.Attribute[] attributes) {
            AttributedCharacterIterator attributedCharacterIterator = MyInputMethodHandleSwingThreadWrapper.execute(new Computable<AttributedCharacterIterator>(){

                public AttributedCharacterIterator compute() {
                    return MyInputMethodHandleSwingThreadWrapper.this.myDelegate.getCommittedText(beginIndex, endIndex, attributes);
                }
            });
            if (attributedCharacterIterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl$MyInputMethodHandleSwingThreadWrapper", "getCommittedText"));
            }
            return attributedCharacterIterator;
        }

        @Override
        public int getCommittedTextLength() {
            return MyInputMethodHandleSwingThreadWrapper.execute(new Computable<Integer>(){

                public Integer compute() {
                    return MyInputMethodHandleSwingThreadWrapper.this.myDelegate.getCommittedTextLength();
                }
            });
        }

        @Override
        @Nullable
        public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
            return null;
        }

        @Override
        public AttributedCharacterIterator getSelectedText(final AttributedCharacterIterator.Attribute[] attributes) {
            return MyInputMethodHandleSwingThreadWrapper.execute(new Computable<AttributedCharacterIterator>(){

                public AttributedCharacterIterator compute() {
                    return MyInputMethodHandleSwingThreadWrapper.this.myDelegate.getSelectedText(attributes);
                }
            });
        }

        private static <T> T execute(final Computable<T> computable) {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                return (T)computable.compute();
            }
            final Ref ref = Ref.create();
            try {
                GuiUtils.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ref.set(computable.compute());
                    }
                });
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.error((Throwable)e);
            }
            return (T)ref.get();
        }
    }

    private class MyEditable
    implements CutProvider,
    CopyProvider,
    PasteProvider,
    DeleteProvider {
        private MyEditable() {
        }

        public void performCopy(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/editor/impl/EditorImpl$MyEditable", "performCopy"));
            }
            this.executeAction("EditorCopy", dataContext);
        }

        public boolean isCopyEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/editor/impl/EditorImpl$MyEditable", "isCopyEnabled"));
            }
            return true;
        }

        public boolean isCopyVisible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/editor/impl/EditorImpl$MyEditable", "isCopyVisible"));
            }
            return EditorImpl.this.getSelectionModel().hasSelection(true);
        }

        public void performCut(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/editor/impl/EditorImpl$MyEditable", "performCut"));
            }
            this.executeAction("EditorCut", dataContext);
        }

        public boolean isCutEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/editor/impl/EditorImpl$MyEditable", "isCutEnabled"));
            }
            return !EditorImpl.this.isViewer();
        }

        public boolean isCutVisible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/editor/impl/EditorImpl$MyEditable", "isCutVisible"));
            }
            if (!this.isCutEnabled(dataContext)) {
                return false;
            }
            return EditorImpl.this.getSelectionModel().hasSelection(true);
        }

        public void performPaste(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/editor/impl/EditorImpl$MyEditable", "performPaste"));
            }
            this.executeAction("EditorPaste", dataContext);
        }

        public boolean isPastePossible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/editor/impl/EditorImpl$MyEditable", "isPastePossible"));
            }
            return !EditorImpl.this.isViewer();
        }

        public boolean isPasteEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/editor/impl/EditorImpl$MyEditable", "isPasteEnabled"));
            }
            return !EditorImpl.this.isViewer();
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/editor/impl/EditorImpl$MyEditable", "deleteElement"));
            }
            this.executeAction("EditorDelete", dataContext);
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/editor/impl/EditorImpl$MyEditable", "canDeleteElement"));
            }
            return !EditorImpl.this.isViewer();
        }

        private void executeAction(@NotNull String actionId, @NotNull DataContext dataContext) {
            if (actionId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/openapi/editor/impl/EditorImpl$MyEditable", "executeAction"));
            }
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/editor/impl/EditorImpl$MyEditable", "executeAction"));
            }
            EditorAction action = (EditorAction)ActionManager.getInstance().getAction(actionId);
            if (action != null) {
                action.actionPerformed((Editor)EditorImpl.this, dataContext);
            }
        }
    }

    class MyScrollBar
    extends JBScrollBar
    implements IdeGlassPane.TopComponent {
        @NonNls
        private static final String APPLE_LAF_AQUA_SCROLL_BAR_UI_CLASS = "apple.laf.AquaScrollBarUI";
        private ScrollBarUI myPersistentUI;

        private MyScrollBar(int orientation) {
            super(orientation);
        }

        void setPersistentUI(ScrollBarUI ui) {
            this.myPersistentUI = ui;
            this.setUI(ui);
        }

        public boolean canBePreprocessed(MouseEvent e) {
            return JBScrollPane.canBePreprocessed((MouseEvent)e, (JScrollBar)((Object)this));
        }

        public void setUI(ScrollBarUI ui) {
            if (this.myPersistentUI == null) {
                this.myPersistentUI = ui;
            }
            super.setUI(this.myPersistentUI);
            this.setOpaque(false);
        }

        int getDecScrollButtonHeight() {
            ScrollBarUI barUI = this.getUI();
            Insets insets = this.getInsets();
            int top = Math.max(0, insets.top);
            if (barUI instanceof ButtonlessScrollBarUI) {
                return top + ((ButtonlessScrollBarUI)barUI).getDecrementButtonHeight();
            }
            if (barUI instanceof BasicScrollBarUI) {
                try {
                    JButton decrButtonValue = (JButton)decrButtonField.get(barUI);
                    LOG.assertTrue(decrButtonValue != null);
                    return top + decrButtonValue.getHeight();
                }
                catch (Exception exc) {
                    throw new IllegalStateException(exc);
                }
            }
            return top + 15;
        }

        int getIncScrollButtonHeight() {
            ScrollBarUI barUI = this.getUI();
            Insets insets = this.getInsets();
            if (barUI instanceof ButtonlessScrollBarUI) {
                return insets.top + ((ButtonlessScrollBarUI)barUI).getIncrementButtonHeight();
            }
            if (barUI instanceof BasicScrollBarUI) {
                try {
                    JButton incrButtonValue = (JButton)incrButtonField.get(barUI);
                    LOG.assertTrue(incrButtonValue != null);
                    return insets.bottom + incrButtonValue.getHeight();
                }
                catch (Exception exc) {
                    throw new IllegalStateException(exc);
                }
            }
            if (APPLE_LAF_AQUA_SCROLL_BAR_UI_CLASS.equals(barUI.getClass().getName())) {
                return insets.bottom + 30;
            }
            return insets.bottom + 15;
        }

        public int getUnitIncrement(int direction) {
            JViewport vp = EditorImpl.this.myScrollPane.getViewport();
            Rectangle vr = vp.getViewRect();
            return EditorImpl.this.myEditorComponent.getScrollableUnitIncrement(vr, 1, direction);
        }

        public int getBlockIncrement(int direction) {
            JViewport vp = EditorImpl.this.myScrollPane.getViewport();
            Rectangle vr = vp.getViewRect();
            return EditorImpl.this.myEditorComponent.getScrollableBlockIncrement(vr, 1, direction);
        }

        public void registerRepaintCallback(@Nullable ButtonlessScrollBarUI.ScrollbarRepaintCallback callback) {
            if (this.myPersistentUI instanceof ButtonlessScrollBarUI) {
                ((ButtonlessScrollBarUI)this.myPersistentUI).registerRepaintCallback(callback);
            }
        }
    }

    private class ScrollingTimer {
        Timer myTimer;
        private static final int TIMER_PERIOD = 100;
        private static final int CYCLE_SIZE = 20;
        private int myXCycles;
        private int myYCycles;
        private int myDx;
        private int myDy;
        private int xPassedCycles = 0;
        private int yPassedCycles = 0;

        private ScrollingTimer() {
        }

        private void start(int dx, int dy) {
            this.myDx = 0;
            this.myDy = 0;
            if (dx > 0) {
                this.myXCycles = 20 / dx + 1;
                this.myDx = 1 + dx / 20;
            } else if (dx < 0) {
                this.myXCycles = -20 / dx + 1;
                this.myDx = -1 + dx / 20;
            }
            if (dy > 0) {
                this.myYCycles = 20 / dy + 1;
                this.myDy = 1 + dy / 20;
            } else if (dy < 0) {
                this.myYCycles = -20 / dy + 1;
                this.myDy = -1 + dy / 20;
            }
            if (this.myTimer != null) {
                return;
            }
            this.myTimer = UIUtil.createNamedTimer((String)"Editor scroll timer", (int)100, (ActionListener)new ActionListener(){

                @Override
                public void actionPerformed(@NotNull ActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$ScrollingTimer$1", "actionPerformed"));
                    }
                    EditorImpl.this.myCommandProcessor.executeCommand(EditorImpl.this.myProject, (Runnable)new DocumentRunnable(EditorImpl.this.myDocument, EditorImpl.this.myProject){

                        public void run() {
                            if (EditorImpl.this.isDisposed()) {
                                ScrollingTimer.this.myTimer.stop();
                                return;
                            }
                            int oldSelectionStart = EditorImpl.this.mySelectionModel.getLeadSelectionOffset();
                            VisualPosition caretPosition = EditorImpl.this.myMultiSelectionInProgress ? EditorImpl.this.myTargetMultiSelectionPosition : EditorImpl.this.getCaretModel().getVisualPosition();
                            int column = caretPosition.column;
                            ScrollingTimer.this.xPassedCycles++;
                            if (ScrollingTimer.this.xPassedCycles >= ScrollingTimer.this.myXCycles) {
                                ScrollingTimer.this.xPassedCycles = 0;
                                column += ScrollingTimer.this.myDx;
                            }
                            int line = caretPosition.line;
                            ScrollingTimer.this.yPassedCycles++;
                            if (ScrollingTimer.this.yPassedCycles >= ScrollingTimer.this.myYCycles) {
                                ScrollingTimer.this.yPassedCycles = 0;
                                line += ScrollingTimer.this.myDy;
                            }
                            line = Math.max(0, line);
                            column = Math.max(0, column);
                            VisualPosition pos = new VisualPosition(line, column);
                            if (!EditorImpl.this.myMultiSelectionInProgress) {
                                EditorImpl.this.getCaretModel().moveToVisualPosition(pos);
                                EditorImpl.this.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                            }
                            int newCaretOffset = EditorImpl.this.getCaretModel().getOffset();
                            int caretShift = newCaretOffset - EditorImpl.this.mySavedSelectionStart;
                            if (EditorImpl.this.getMouseSelectionState() != 0) {
                                if (caretShift < 0) {
                                    int newSelection = newCaretOffset;
                                    if (EditorImpl.this.getMouseSelectionState() == 1) {
                                        newSelection = EditorImpl.this.myCaretModel.getWordAtCaretStart();
                                    } else if (EditorImpl.this.getMouseSelectionState() == 2) {
                                        newSelection = EditorImpl.this.logicalPositionToOffset(EditorImpl.this.visualToLogicalPosition(new VisualPosition(EditorImpl.this.getCaretModel().getVisualPosition().line, 0)));
                                    }
                                    if (newSelection < 0) {
                                        newSelection = newCaretOffset;
                                    }
                                    EditorImpl.this.mySelectionModel.setSelection(ScrollingTimer.this.validateOffset(EditorImpl.this.mySavedSelectionEnd), newSelection);
                                    EditorImpl.this.getCaretModel().moveToOffset(newSelection);
                                } else {
                                    int newSelection = newCaretOffset;
                                    if (EditorImpl.this.getMouseSelectionState() == 1) {
                                        newSelection = EditorImpl.this.myCaretModel.getWordAtCaretEnd();
                                    } else if (EditorImpl.this.getMouseSelectionState() == 2) {
                                        newSelection = EditorImpl.this.logicalPositionToOffset(EditorImpl.this.visualToLogicalPosition(new VisualPosition(EditorImpl.this.getCaretModel().getVisualPosition().line + 1, 0)));
                                    }
                                    if (newSelection < 0) {
                                        newSelection = newCaretOffset;
                                    }
                                    EditorImpl.this.mySelectionModel.setSelection(ScrollingTimer.this.validateOffset(EditorImpl.this.mySavedSelectionStart), newSelection);
                                    EditorImpl.this.getCaretModel().moveToOffset(newSelection);
                                }
                                return;
                            }
                            if (EditorImpl.this.myMultiSelectionInProgress && EditorImpl.this.myLastMousePressedLocation != null) {
                                EditorImpl.this.myTargetMultiSelectionPosition = pos;
                                LogicalPosition newLogicalPosition = EditorImpl.this.visualToLogicalPosition(pos);
                                EditorImpl.this.getScrollingModel().scrollTo(newLogicalPosition, ScrollType.RELATIVE);
                                EditorImpl.this.createSelectionTill(newLogicalPosition);
                            } else {
                                EditorImpl.this.mySelectionModel.setSelection(oldSelectionStart, EditorImpl.this.getCaretModel().getOffset());
                            }
                        }
                    }, EditorBundle.message((String)"move.cursor.command.name", (Object[])new Object[0]), (Object)DocCommandGroupId.noneGroupId((Document)EditorImpl.this.getDocument()), UndoConfirmationPolicy.DEFAULT, (Document)EditorImpl.this.getDocument());
                }
            });
            this.myTimer.start();
        }

        private void stop() {
            if (this.myTimer != null) {
                this.myTimer.stop();
                this.myTimer = null;
            }
        }

        private int validateOffset(int offset) {
            if (offset < 0) {
                return 0;
            }
            if (offset > EditorImpl.this.myDocument.getTextLength()) {
                return EditorImpl.this.myDocument.getTextLength();
            }
            return offset;
        }
    }

    private class CaretCursor {
        private CaretRectangle[] myLocations = new CaretRectangle[]{new CaretRectangle(new Point(0, 0), 0, null)};
        private boolean myEnabled;
        private boolean myIsShown = false;
        private long myStartTime = 0L;

        private CaretCursor() {
            this.setEnabled(true);
        }

        public boolean isEnabled() {
            return this.myEnabled;
        }

        public void setEnabled(boolean enabled) {
            this.myEnabled = enabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void activate() {
            boolean blink = EditorImpl.this.mySettings.isBlinkCaret();
            int blinkPeriod = EditorImpl.this.mySettings.getCaretBlinkPeriod();
            RepaintCursorCommand repaintCursorCommand = ourCaretBlinkingCommand;
            synchronized (repaintCursorCommand) {
                ourCaretBlinkingCommand.myEditor = EditorImpl.this;
                ourCaretBlinkingCommand.setBlinkCaret(blink);
                ourCaretBlinkingCommand.setBlinkPeriod(blinkPeriod);
                this.myIsShown = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isActive() {
            RepaintCursorCommand repaintCursorCommand = ourCaretBlinkingCommand;
            synchronized (repaintCursorCommand) {
                return this.myIsShown;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void passivate() {
            RepaintCursorCommand repaintCursorCommand = ourCaretBlinkingCommand;
            synchronized (repaintCursorCommand) {
                this.myIsShown = false;
            }
        }

        private void setPositions(CaretRectangle[] locations) {
            this.myStartTime = System.currentTimeMillis();
            this.myLocations = locations;
            this.myIsShown = true;
            this.repaint();
        }

        private void repaint() {
            for (CaretRectangle location : this.myLocations) {
                EditorImpl.this.myEditorComponent.repaintEditorComponent(((CaretRectangle)location).myPoint.x, ((CaretRectangle)location).myPoint.y, location.myWidth, EditorImpl.this.getLineHeight());
            }
        }

        private void paint(@NotNull Graphics g) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl$CaretCursor", "paint"));
            }
            if (!this.isEnabled() || !this.myIsShown || EditorImpl.this.isRendererMode() || !IJSwingUtilities.hasFocus(EditorImpl.this.getContentComponent())) {
                return;
            }
            for (CaretRectangle location : this.myLocations) {
                this.paintAt(g, ((CaretRectangle)location).myPoint.x, ((CaretRectangle)location).myPoint.y, location.myWidth, location.myCaret);
            }
        }

        private void paintAt(@NotNull Graphics g, int x, int y, int width, Caret caret) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl$CaretCursor", "paintAt"));
            }
            int lineHeight = EditorImpl.this.getLineHeight();
            Rectangle viewRectangle = EditorImpl.this.getScrollingModel().getVisibleArea();
            if (x - viewRectangle.x < 0) {
                return;
            }
            g.setColor(EditorImpl.this.myScheme.getColor(EditorColors.CARET_COLOR));
            if (!EditorImpl.this.paintBlockCaret()) {
                if (UIUtil.isRetina()) {
                    g.fillRect(x, y, EditorImpl.this.mySettings.getLineCursorWidth(), lineHeight);
                } else {
                    for (int i = 0; i < EditorImpl.this.mySettings.getLineCursorWidth(); ++i) {
                        UIUtil.drawLine((Graphics)g, (int)(x + i), (int)y, (int)(x + i), (int)(y + lineHeight - 1));
                    }
                }
            } else {
                Color caretColor = EditorImpl.this.myScheme.getColor(EditorColors.CARET_COLOR);
                if (caretColor == null) {
                    caretColor = new JBColor((Color)Gray._0, (Color)Gray._255);
                }
                g.setColor(caretColor);
                g.fillRect(x, y, width, lineHeight - 1);
                LogicalPosition startPosition = caret == null ? EditorImpl.this.getCaretModel().getLogicalPosition() : caret.getLogicalPosition();
                int offset = EditorImpl.this.logicalPositionToOffset(startPosition);
                CharSequence chars = EditorImpl.this.myDocument.getImmutableCharSequence();
                if (chars.length() > offset && EditorImpl.this.myDocument.getTextLength() > offset) {
                    char ch;
                    FoldRegion folding = EditorImpl.this.myFoldingModel.getCollapsedRegionAtOffset(offset);
                    if (folding == null || folding.isExpanded()) {
                        ch = chars.charAt(offset);
                    } else {
                        VisualPosition visual = caret == null ? EditorImpl.this.getCaretModel().getVisualPosition() : caret.getVisualPosition();
                        VisualPosition foldingPosition = EditorImpl.this.offsetToVisualPosition(folding.getStartOffset());
                        ch = visual.line == foldingPosition.line ? folding.getPlaceholderText().charAt(visual.column - foldingPosition.column) : chars.charAt(offset);
                    }
                    IterationState state = new IterationState(EditorImpl.this, offset, offset + 1, true);
                    TextAttributes attributes = state.getMergedAttributes();
                    FontInfo info = EditorUtil.fontForChar(ch, attributes.getFontType(), EditorImpl.this);
                    if (info != null) {
                        g.setFont(info.getFont());
                    }
                    g.setColor(ColorUtil.isDark((Color)caretColor) ? CURSOR_FOREGROUND_LIGHT : CURSOR_FOREGROUND_DARK);
                    g.drawChars(new char[]{ch}, 0, 1, x, y + EditorImpl.this.getAscent());
                }
            }
        }
    }

    private static class CaretRectangle {
        private final Point myPoint;
        private final int myWidth;
        private final Caret myCaret;

        private CaretRectangle(Point point, int width, Caret caret) {
            this.myPoint = point;
            this.myWidth = Math.max(width, 2);
            this.myCaret = caret;
        }
    }

    private static class RepaintCursorCommand
    implements Runnable {
        private long mySleepTime = 500L;
        private boolean myIsBlinkCaret = true;
        @Nullable
        private EditorImpl myEditor = null;
        @NotNull
        private final MyRepaintRunnable myRepaintRunnable = new MyRepaintRunnable();
        private ScheduledFuture<?> mySchedulerHandle;

        private RepaintCursorCommand() {
        }

        public void start() {
            if (this.mySchedulerHandle != null) {
                this.mySchedulerHandle.cancel(false);
            }
            this.mySchedulerHandle = JobScheduler.getScheduler().scheduleWithFixedDelay(this, this.mySleepTime, this.mySleepTime, TimeUnit.MILLISECONDS);
        }

        private void setBlinkPeriod(int blinkPeriod) {
            this.mySleepTime = blinkPeriod > 10 ? (long)blinkPeriod : 10L;
            this.start();
        }

        private void setBlinkCaret(boolean value) {
            this.myIsBlinkCaret = value;
        }

        @Override
        public void run() {
            if (this.myEditor != null) {
                CaretCursor activeCursor = this.myEditor.myCaretCursor;
                long time = System.currentTimeMillis();
                if ((time -= activeCursor.myStartTime) > this.mySleepTime) {
                    boolean toRepaint = true;
                    if (this.myIsBlinkCaret) {
                        activeCursor.myIsShown = !activeCursor.myIsShown;
                    } else {
                        toRepaint = !activeCursor.myIsShown;
                        activeCursor.myIsShown = true;
                    }
                    if (toRepaint) {
                        SwingUtilities.invokeLater(this.myRepaintRunnable);
                    }
                }
            }
        }

        private class MyRepaintRunnable
        implements Runnable {
            private MyRepaintRunnable() {
            }

            @Override
            public void run() {
                if (RepaintCursorCommand.this.myEditor != null) {
                    RepaintCursorCommand.this.myEditor.myCaretCursor.repaint();
                }
            }
        }
    }

    private class CachedFontContent {
        final CharSequence[] data;
        final int[] starts;
        final int[] ends;
        final int[] x;
        final int[] y;
        final Color[] color;
        final boolean[] whitespaceShown;
        int myCount;
        @NotNull
        final FontInfo myFontType;
        final boolean myHasBreakSymbols;
        final int spaceWidth;
        @Nullable
        private CharSequence myLastData;

        private CachedFontContent(FontInfo fontInfo) {
            if (fontInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontInfo", "com/intellij/openapi/editor/impl/EditorImpl$CachedFontContent", "<init>"));
            }
            this.data = new CharSequence[300];
            this.starts = new int[300];
            this.ends = new int[300];
            this.x = new int[300];
            this.y = new int[300];
            this.color = new Color[300];
            this.whitespaceShown = new boolean[300];
            this.myCount = 0;
            this.myFontType = fontInfo;
            this.spaceWidth = fontInfo.charWidth(' ');
            this.myHasBreakSymbols = fontInfo.hasGlyphsToBreakDrawingIteration();
        }

        private void flushContent(@NotNull Graphics g) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl$CachedFontContent", "flushContent"));
            }
            if (this.myCount != 0) {
                if (EditorImpl.this.myCurrentFontType != this.myFontType) {
                    EditorImpl.this.myCurrentFontType = this.myFontType;
                    g.setFont(this.myFontType.getFont());
                }
                Color currentColor = null;
                for (int i = 0; i < this.myCount; ++i) {
                    if (!Comparing.equal((Object)this.color[i], currentColor)) {
                        currentColor = this.color[i];
                        g.setColor(currentColor != null ? currentColor : JBColor.black);
                    }
                    EditorImpl.this.drawChars(g, this.data[i], this.starts[i], this.ends[i], this.x[i], this.y[i], this.whitespaceShown[i]);
                    this.color[i] = null;
                    this.data[i] = null;
                }
                this.myCount = 0;
                this.myLastData = null;
            }
        }

        private void addContent(@NotNull Graphics g, CharSequence _data, int _start, int _end, int _x, int _y, @Nullable Color _color, boolean drawWhitespace) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl$CachedFontContent", "addContent"));
            }
            int count = this.myCount;
            if (count > 0) {
                int lastCount = count - 1;
                Color lastColor = this.color[lastCount];
                if (!(_data != this.myLastData || _start != this.ends[lastCount] || _color != null && lastColor != null && !_color.equals(lastColor) || _y != this.y[lastCount] || this.myHasBreakSymbols && this.myFontType.getSymbolsToBreakDrawingIteration().contains((int)_data.charAt(this.ends[lastCount] - 1)) || EditorImpl.this.myDisableRtl && _start >= 1 && _start < _data.length() && (EditorImpl.isRtlCharacter(_data.charAt(_start)) || EditorImpl.isRtlCharacter(_data.charAt(_start - 1))) || drawWhitespace != this.whitespaceShown[lastCount])) {
                    this.ends[lastCount] = _end;
                    if (lastColor == null) {
                        this.color[lastCount] = _color;
                    }
                    return;
                }
            }
            this.myLastData = _data;
            this.data[count] = _data;
            this.x[count] = _x;
            this.y[count] = _y;
            this.starts[count] = _start;
            this.ends[count] = _end;
            this.color[count] = _color;
            this.whitespaceShown[count] = drawWhitespace;
            ++this.myCount;
            if (count >= 299) {
                this.flushContent(g);
            }
        }
    }
}

