/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.SettingsSavingComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.model.internal.InternalExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalProjectsDataStorage
implements SettingsSavingComponent {
    private static final Logger LOG = Logger.getInstance(ExternalProjectsDataStorage.class);
    private static final String STORAGE_VERSION = ExternalProjectsDataStorage.class.getSimpleName() + ".1";
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<Pair<ProjectSystemId, String>, InternalExternalProjectInfo> myExternalRootProjects;
    private final AtomicBoolean changed;

    public static ExternalProjectsDataStorage getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage", "getInstance"));
        }
        return (ExternalProjectsDataStorage)ServiceManager.getService((Project)project, ExternalProjectsDataStorage.class);
    }

    public ExternalProjectsDataStorage(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage", "<init>"));
        }
        this.myExternalRootProjects = ContainerUtil.newConcurrentMap();
        this.changed = new AtomicBoolean();
        this.myProject = project;
    }

    public synchronized void load() {
        this.myExternalRootProjects.clear();
        try {
            Collection<InternalExternalProjectInfo> projectInfos = ExternalProjectsDataStorage.load(this.myProject);
            for (InternalExternalProjectInfo projectInfo : projectInfos) {
                if (!ExternalProjectsDataStorage.validate(projectInfo)) continue;
                this.myExternalRootProjects.put((Pair<ProjectSystemId, String>)Pair.create((Object)projectInfo.getProjectSystemId(), (Object)projectInfo.getExternalProjectPath()), projectInfo);
            }
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
        }
        this.mergeLocalSettings();
    }

    private static boolean validate(InternalExternalProjectInfo externalProjectInfo) {
        try {
            DataNode<ProjectData> projectStructure = externalProjectInfo.getExternalProjectStructure();
            if (projectStructure == null) {
                return false;
            }
            ProjectDataManager.getInstance().ensureTheDataIsReadyToUse(projectStructure);
            return externalProjectInfo.getExternalProjectPath().equals(((ProjectData)projectStructure.getData()).getLinkedExternalProjectPath());
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    public synchronized void save() {
        if (!this.changed.compareAndSet(true, false)) {
            return;
        }
        try {
            ExternalProjectsDataStorage.doSave(this.myProject, this.myExternalRootProjects.values());
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
        }
    }

    synchronized void update(@NotNull ExternalProjectInfo externalProjectInfo) {
        if (externalProjectInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectInfo", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage", "update"));
        }
        ProjectSystemId projectSystemId = externalProjectInfo.getProjectSystemId();
        String projectPath = externalProjectInfo.getExternalProjectPath();
        DataNode<ProjectData> externalProjectStructure = externalProjectInfo.getExternalProjectStructure();
        long lastSuccessfulImportTimestamp = externalProjectInfo.getLastSuccessfulImportTimestamp();
        long lastImportTimestamp = externalProjectInfo.getLastImportTimestamp();
        Pair key = Pair.create((Object)projectSystemId, (Object)projectPath);
        InternalExternalProjectInfo old = this.myExternalRootProjects.get(key);
        if (old != null) {
            lastImportTimestamp = externalProjectInfo.getLastImportTimestamp();
            if (lastSuccessfulImportTimestamp == -1L) {
                lastSuccessfulImportTimestamp = old.getLastSuccessfulImportTimestamp();
            }
            if (externalProjectInfo.getExternalProjectStructure() == null) {
                externalProjectStructure = old.getExternalProjectStructure();
            }
        }
        InternalExternalProjectInfo merged = new InternalExternalProjectInfo(projectSystemId, projectPath, externalProjectStructure);
        merged.setLastImportTimestamp(lastImportTimestamp);
        merged.setLastSuccessfulImportTimestamp(lastSuccessfulImportTimestamp);
        this.myExternalRootProjects.put((Pair<ProjectSystemId, String>)key, merged);
        this.changed.set(true);
    }

    @Nullable
    synchronized ExternalProjectInfo get(@NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        if (projectSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSystemId", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage", "get"));
        }
        if (externalProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectPath", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage", "get"));
        }
        return this.myExternalRootProjects.get(Pair.create((Object)projectSystemId, (Object)externalProjectPath));
    }

    synchronized void remove(@NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        if (projectSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSystemId", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage", "remove"));
        }
        if (externalProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectPath", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage", "remove"));
        }
        InternalExternalProjectInfo removed = this.myExternalRootProjects.remove(Pair.create((Object)projectSystemId, (Object)externalProjectPath));
        if (removed != null) {
            this.changed.set(true);
        }
    }

    @NotNull
    synchronized Collection<ExternalProjectInfo> list(final @NotNull ProjectSystemId projectSystemId) {
        if (projectSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSystemId", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage", "list"));
        }
        List list = ContainerUtil.mapNotNull(this.myExternalRootProjects.values(), (Function)new Function<InternalExternalProjectInfo, ExternalProjectInfo>(){

            public ExternalProjectInfo fun(InternalExternalProjectInfo info) {
                return projectSystemId.equals((Object)info.getProjectSystemId()) ? info : null;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage", "list"));
        }
        return list;
    }

    private void mergeLocalSettings() {
        for (ExternalSystemManager manager : ExternalSystemApiUtil.getAllManagers()) {
            ProjectSystemId systemId = manager.getSystemId();
            AbstractExternalSystemLocalSettings settings = (AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)this.myProject);
            Map availableProjects = settings.getAvailableProjects();
            Map availableTasks = settings.getAvailableTasks();
            for (Map.Entry entry : availableProjects.entrySet()) {
                ExternalProjectPojo projectPojo = (ExternalProjectPojo)entry.getKey();
                String externalProjectPath = projectPojo.getPath();
                Pair key = Pair.create((Object)systemId, (Object)externalProjectPath);
                InternalExternalProjectInfo externalProjectInfo = this.myExternalRootProjects.get(key);
                if (externalProjectInfo != null) continue;
                DataNode<ProjectData> dataNode = ExternalProjectsDataStorage.convert(systemId, projectPojo, (Collection)entry.getValue(), availableTasks);
                externalProjectInfo = new InternalExternalProjectInfo(systemId, externalProjectPath, dataNode);
                this.myExternalRootProjects.put((Pair<ProjectSystemId, String>)key, externalProjectInfo);
                this.changed.set(true);
            }
        }
    }

    private static DataNode<ProjectData> convert(@NotNull ProjectSystemId systemId, @NotNull ExternalProjectPojo rootProject, @NotNull Collection<ExternalProjectPojo> childProjects, @NotNull Map<String, Collection<ExternalTaskPojo>> availableTasks) {
        if (systemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemId", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage", "convert"));
        }
        if (rootProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootProject", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage", "convert"));
        }
        if (childProjects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childProjects", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage", "convert"));
        }
        if (availableTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "availableTasks", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage", "convert"));
        }
        ProjectData projectData = new ProjectData(systemId, rootProject.getName(), rootProject.getPath(), rootProject.getPath());
        DataNode projectDataNode = new DataNode(ProjectKeys.PROJECT, (Object)projectData, null);
        for (ExternalProjectPojo childProject : childProjects) {
            String moduleConfigPath = childProject.getPath();
            ModuleData moduleData = new ModuleData(childProject.getName(), systemId, "JAVA_MODULE", childProject.getName(), moduleConfigPath, moduleConfigPath);
            DataNode moduleDataNode = projectDataNode.createChild(ProjectKeys.MODULE, (Object)moduleData);
            Collection<ExternalTaskPojo> moduleTasks = availableTasks.get(moduleConfigPath);
            if (moduleTasks == null) continue;
            for (ExternalTaskPojo moduleTask : moduleTasks) {
                TaskData taskData = new TaskData(systemId, moduleTask.getName(), moduleConfigPath, moduleTask.getDescription());
                moduleDataNode.createChild(ProjectKeys.TASK, (Object)taskData);
            }
        }
        return projectDataNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doSave(@NotNull Project project, @NotNull Collection<InternalExternalProjectInfo> externalProjects) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage", "doSave"));
        }
        if (externalProjects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjects", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage", "doSave"));
        }
        File projectConfigurationFile = ExternalProjectsDataStorage.getProjectConfigurationFile(project);
        if (!FileUtil.createParentDirs((File)projectConfigurationFile)) {
            throw new IOException("Unable to save " + projectConfigurationFile);
        }
        Iterator<InternalExternalProjectInfo> iterator = externalProjects.iterator();
        while (iterator.hasNext()) {
            InternalExternalProjectInfo externalProject = iterator.next();
            if (!ExternalProjectsDataStorage.validate(externalProject)) {
                iterator.remove();
                continue;
            }
            ExternalSystemApiUtil.visit(externalProject.getExternalProjectStructure(), (Consumer)new Consumer<DataNode>(){

                public void consume(DataNode dataNode) {
                    try {
                        dataNode.getDataBytes();
                    }
                    catch (IOException e) {
                        dataNode.clear(true);
                    }
                }
            });
        }
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(projectConfigurationFile)));
        try {
            out.writeUTF(STORAGE_VERSION);
            out.writeInt(externalProjects.size());
            ObjectOutputStream os = new ObjectOutputStream(out);
            try {
                for (InternalExternalProjectInfo externalProject : externalProjects) {
                    os.writeObject(externalProject);
                }
            }
            finally {
                os.close();
            }
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static Collection<InternalExternalProjectInfo> load(@NotNull Project project) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage", "load"));
        }
        SmartList projects = new SmartList();
        File configurationFile = ExternalProjectsDataStorage.getProjectConfigurationFile(project);
        if (!configurationFile.isFile()) {
            SmartList smartList = projects;
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage", "load"));
            }
            return smartList;
        }
        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(configurationFile)));
        try {
            String storage_version = in.readUTF();
            if (!STORAGE_VERSION.equals(storage_version)) {
                SmartList smartList = projects;
                SmartList smartList2 = smartList;
                if (smartList2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage", "load"));
                }
                return smartList2;
            }
            int size = in.readInt();
            ObjectInputStream os = new ObjectInputStream(in);
            try {
                for (int i = 0; i < size; ++i) {
                    InternalExternalProjectInfo projectDataDataNode = (InternalExternalProjectInfo)os.readObject();
                    projects.add((Object)projectDataDataNode);
                }
            }
            catch (ClassNotFoundException e) {
                IOException ioException = new IOException();
                ioException.initCause(e);
                throw ioException;
            }
            finally {
                os.close();
            }
        }
        finally {
            in.close();
        }
        SmartList smartList = projects;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage", "load"));
        }
        return smartList;
    }

    private static File getProjectConfigurationFile(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage", "getProjectConfigurationFile"));
        }
        return new File(ExternalProjectsDataStorage.getProjectConfigurationDir(), project.getLocationHash() + "/project.dat");
    }

    private static File getProjectConfigurationDir() {
        return ExternalProjectsDataStorage.getExternalBuildSystemDir("Projects");
    }

    private static File getExternalBuildSystemDir(String folder) {
        return new File(PathManager.getSystemPath(), "external_build_system/" + folder).getAbsoluteFile();
    }
}

