/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.module.ProjectLoadingErrorsNotifier;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.module.impl.ModuleLoadingErrorDescription;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.StringInterner;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.text.FilePathHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleManagerImpl
extends ModuleManager
implements ProjectComponent,
PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.module.impl.ModuleManagerImpl");
    public static final Key<String> DISPOSED_MODULE_NAME = Key.create((String)"DisposedNeverAddedModuleName");
    private static final String IML_EXTENSION = ".iml";
    protected final Project myProject;
    protected final MessageBus myMessageBus;
    protected volatile ModuleModelImpl myModuleModel = new ModuleModelImpl();
    @NonNls
    public static final String COMPONENT_NAME = "ProjectModuleManager";
    private static final String MODULE_GROUP_SEPARATOR = "/";
    private List<ModulePath> myModulePaths;
    private final List<ModulePath> myFailedModulePaths = new ArrayList<ModulePath>();
    @NonNls
    public static final String ELEMENT_MODULES = "modules";
    @NonNls
    public static final String ELEMENT_MODULE = "module";
    @NonNls
    private static final String ATTRIBUTE_FILEURL = "fileurl";
    @NonNls
    public static final String ATTRIBUTE_FILEPATH = "filepath";
    @NonNls
    private static final String ATTRIBUTE_GROUP = "group";
    private Module[] myCachedSortedModules = null;
    private Comparator<Module> myCachedModuleComparator = null;

    public static ModuleManagerImpl getInstanceImpl(Project project) {
        return (ModuleManagerImpl)ModuleManagerImpl.getInstance((Project)project);
    }

    protected void cleanCachedStuff() {
        this.myCachedModuleComparator = null;
        this.myCachedSortedModules = null;
    }

    public ModuleManagerImpl(Project project, MessageBus messageBus) {
        this.myProject = project;
        this.myMessageBus = messageBus;
    }

    @NotNull
    public String getComponentName() {
        if (COMPONENT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getComponentName"));
        }
        return COMPONENT_NAME;
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        this.myModuleModel.disposeModel();
    }

    public Element getState() {
        Element e = new Element("state");
        this.writeExternal(e);
        return e;
    }

    public void loadState(Element state) {
        List<ModulePath> prevPaths = this.myModulePaths;
        this.readExternal(state);
        if (prevPaths != null) {
            ModifiableModuleModel model = this.getModifiableModel();
            Module[] existingModules = model.getModules();
            ModuleGroupInterner groupInterner = new ModuleGroupInterner();
            for (Module existingModule : existingModules) {
                Object[] group;
                ModulePath correspondingPath = this.findCorrespondingPath(existingModule);
                if (correspondingPath == null) {
                    model.disposeModule(existingModule);
                    continue;
                }
                this.myModulePaths.remove(correspondingPath);
                String groupStr = correspondingPath.getModuleGroup();
                Object[] objectArray = group = groupStr == null ? null : groupStr.split(MODULE_GROUP_SEPARATOR);
                if (Arrays.equals(group, model.getModuleGroupPath(existingModule))) continue;
                groupInterner.setModuleGroupPath(model, existingModule, (String[])group);
            }
            this.loadModules((ModuleModelImpl)model);
            model.commit();
        }
    }

    private ModulePath findCorrespondingPath(Module existingModule) {
        for (ModulePath modulePath : this.myModulePaths) {
            if (!modulePath.getPath().equals(existingModule.getModuleFilePath())) continue;
            return modulePath;
        }
        return null;
    }

    @NotNull
    public static ModulePath[] getPathsToModuleFiles(Element element) {
        ArrayList<ModulePath> paths = new ArrayList<ModulePath>();
        Element modules = element.getChild(ELEMENT_MODULES);
        if (modules != null) {
            for (Element value : modules.getChildren(ELEMENT_MODULE)) {
                Element moduleElement = value;
                String fileUrlValue = moduleElement.getAttributeValue(ATTRIBUTE_FILEURL);
                String filepath = fileUrlValue != null ? VirtualFileManager.extractPath((String)fileUrlValue).replace('/', File.separatorChar) : moduleElement.getAttributeValue(ATTRIBUTE_FILEPATH).replace('/', File.separatorChar);
                String group = moduleElement.getAttributeValue(ATTRIBUTE_GROUP);
                paths.add(new ModulePath(filepath, group));
            }
        }
        ModulePath[] modulePathArray = paths.toArray(new ModulePath[paths.size()]);
        if (modulePathArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getPathsToModuleFiles"));
        }
        return modulePathArray;
    }

    public void readExternal(Element element) {
        this.myModulePaths = new ArrayList<ModulePath>(Arrays.asList(ModuleManagerImpl.getPathsToModuleFiles(element)));
    }

    protected void loadModules(ModuleModelImpl moduleModel) {
        ProgressIndicator progressIndicator;
        if (this.myModulePaths == null || this.myModulePaths.isEmpty()) {
            return;
        }
        ModuleGroupInterner groupInterner = new ModuleGroupInterner();
        ProgressIndicator progressIndicator2 = progressIndicator = this.myProject.isDefault() ? null : ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.setText("Loading modules...");
            progressIndicator.setText2("");
        }
        this.myFailedModulePaths.clear();
        this.myFailedModulePaths.addAll(this.myModulePaths);
        ArrayList<Module> modulesWithUnknownTypes = new ArrayList<Module>();
        ArrayList<ModuleLoadingErrorDescription> errors = new ArrayList<ModuleLoadingErrorDescription>();
        for (int i = 0; i < this.myModulePaths.size(); ++i) {
            ModulePath modulePath = this.myModulePaths.get(i);
            if (progressIndicator != null) {
                progressIndicator.setFraction((double)i / (double)this.myModulePaths.size());
            }
            try {
                String groupPathString;
                Module module = moduleModel.loadModuleInternal(modulePath.getPath());
                if (this.isUnknownModuleType(module)) {
                    modulesWithUnknownTypes.add(module);
                }
                if ((groupPathString = modulePath.getModuleGroup()) != null) {
                    String[] groupPath = groupPathString.split(MODULE_GROUP_SEPARATOR);
                    groupInterner.setModuleGroupPath(moduleModel, module, groupPath);
                }
                this.myFailedModulePaths.remove(modulePath);
                continue;
            }
            catch (IOException e) {
                errors.add(ModuleLoadingErrorDescription.create(ProjectBundle.message((String)"module.cannot.load.error", (Object[])new Object[]{modulePath.getPath(), e.getMessage()}), modulePath, this));
                continue;
            }
            catch (ModuleWithNameAlreadyExists moduleWithNameAlreadyExists) {
                errors.add(ModuleLoadingErrorDescription.create(moduleWithNameAlreadyExists.getMessage(), modulePath, this));
                continue;
            }
            catch (StateStorageException e) {
                errors.add(ModuleLoadingErrorDescription.create(ProjectBundle.message((String)"module.cannot.load.error", (Object[])new Object[]{modulePath.getPath(), e.getMessage()}), modulePath, this));
            }
        }
        this.onModuleLoadErrors(errors);
        this.showUnknownModuleTypeNotification(modulesWithUnknownTypes);
        if (progressIndicator != null) {
            progressIndicator.setIndeterminate(true);
        }
    }

    protected boolean isUnknownModuleType(Module module) {
        return false;
    }

    protected void showUnknownModuleTypeNotification(List<Module> types) {
    }

    protected void fireModuleAdded(Module module) {
        ((ModuleListener)this.myMessageBus.syncPublisher(ProjectTopics.MODULES)).moduleAdded(this.myProject, module);
    }

    protected void fireModuleRemoved(Module module) {
        ((ModuleListener)this.myMessageBus.syncPublisher(ProjectTopics.MODULES)).moduleRemoved(this.myProject, module);
    }

    protected void fireBeforeModuleRemoved(Module module) {
        ((ModuleListener)this.myMessageBus.syncPublisher(ProjectTopics.MODULES)).beforeModuleRemoved(this.myProject, module);
    }

    protected void fireModulesRenamed(List<Module> modules, final Map<Module, String> oldNames) {
        if (!modules.isEmpty()) {
            ((ModuleListener)this.myMessageBus.syncPublisher(ProjectTopics.MODULES)).modulesRenamed(this.myProject, modules, (Function)new Function<Module, String>(){

                public String fun(Module module) {
                    return (String)oldNames.get(module);
                }
            });
        }
    }

    protected void onModuleLoadErrors(List<ModuleLoadingErrorDescription> errors) {
        if (errors.isEmpty()) {
            return;
        }
        ModuleModelImpl.access$402(this.myModuleModel, null);
        for (ModuleLoadingErrorDescription error : errors) {
            final Module module = this.myModuleModel.myPathToModule.remove(FileUtil.toSystemIndependentName((String)error.getModulePath().getPath()));
            if (module == null) continue;
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Disposer.dispose((Disposable)module);
                }
            });
        }
        this.fireModuleLoadErrors(errors);
    }

    protected void fireModuleLoadErrors(List<ModuleLoadingErrorDescription> errors) {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            throw new RuntimeException(errors.get(0).getDescription());
        }
        ProjectLoadingErrorsNotifier.getInstance(this.myProject).registerErrors(errors);
    }

    public void removeFailedModulePath(@NotNull ModulePath modulePath) {
        if (modulePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulePath", "com/intellij/openapi/module/impl/ModuleManagerImpl", "removeFailedModulePath"));
        }
        this.myFailedModulePaths.remove(modulePath);
    }

    @NotNull
    public ModifiableModuleModel getModifiableModel() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ModuleModelImpl moduleModelImpl = new ModuleModelImpl(this.myModuleModel);
        if (moduleModelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getModifiableModel"));
        }
        return moduleModelImpl;
    }

    public void writeExternal(Element element) {
        Element modules = new Element(ELEMENT_MODULES);
        Module[] collection = this.getModules();
        ArrayList<SaveItem> sorted = new ArrayList<SaveItem>(collection.length + this.myFailedModulePaths.size());
        for (Module module : collection) {
            sorted.add(new ModuleSaveItem(module));
        }
        for (ModulePath modulePath : this.myFailedModulePaths) {
            sorted.add(new ModulePathSaveItem(modulePath));
        }
        Collections.sort(sorted, new Comparator<SaveItem>(){

            @Override
            public int compare(SaveItem item1, SaveItem item2) {
                return item1.getModuleName().compareTo(item2.getModuleName());
            }
        });
        for (SaveItem saveItem : sorted) {
            saveItem.writeExternal(modules);
        }
        element.addContent(modules);
    }

    @NotNull
    public Module newModule(@NotNull String filePath, String moduleTypeId) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl", "newModule"));
        }
        this.incModificationCount();
        ModifiableModuleModel modifiableModel = this.getModifiableModel();
        Module module = modifiableModel.newModule(filePath, moduleTypeId);
        modifiableModel.commit();
        Module module2 = module;
        if (module2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "newModule"));
        }
        return module2;
    }

    @NotNull
    public Module loadModule(@NotNull String filePath) throws InvalidDataException, IOException, JDOMException, ModuleWithNameAlreadyExists {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl", "loadModule"));
        }
        this.incModificationCount();
        ModifiableModuleModel modifiableModel = this.getModifiableModel();
        Module module = modifiableModel.loadModule(filePath);
        modifiableModel.commit();
        Module module2 = module;
        if (module2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "loadModule"));
        }
        return module2;
    }

    public void disposeModule(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "disposeModule"));
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ModifiableModuleModel modifiableModel = ModuleManagerImpl.this.getModifiableModel();
                modifiableModel.disposeModule(module);
                modifiableModel.commit();
            }
        });
    }

    @NotNull
    public Module[] getModules() {
        if (this.myModuleModel.myIsWritable) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        Module[] moduleArray = this.myModuleModel.getModules();
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getModules"));
        }
        return moduleArray;
    }

    @NotNull
    public Module[] getSortedModules() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.deliverPendingEvents();
        if (this.myCachedSortedModules == null) {
            this.myCachedSortedModules = this.myModuleModel.getSortedModules();
        }
        if (this.myCachedSortedModules == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getSortedModules"));
        }
        return this.myCachedSortedModules;
    }

    public Module findModuleByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/module/impl/ModuleManagerImpl", "findModuleByName"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.myModuleModel.findModuleByName(name);
    }

    @NotNull
    public Comparator<Module> moduleDependencyComparator() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.deliverPendingEvents();
        if (this.myCachedModuleComparator == null) {
            this.myCachedModuleComparator = this.myModuleModel.moduleDependencyComparator();
        }
        Comparator<Module> comparator = this.myCachedModuleComparator;
        if (comparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "moduleDependencyComparator"));
        }
        return comparator;
    }

    protected void deliverPendingEvents() {
    }

    @NotNull
    public Graph<Module> moduleGraph() {
        Graph<Module> graph = this.moduleGraph(true);
        if (graph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "moduleGraph"));
        }
        return graph;
    }

    @NotNull
    public Graph<Module> moduleGraph(boolean includeTests) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Graph graph = this.myModuleModel.moduleGraph(includeTests);
        if (graph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "moduleGraph"));
        }
        return graph;
    }

    @NotNull
    public List<Module> getModuleDependentModules(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "getModuleDependentModules"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        List list = this.myModuleModel.getModuleDependentModules(module);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getModuleDependentModules"));
        }
        return list;
    }

    public boolean isModuleDependent(@NotNull Module module, @NotNull Module onModule) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "isModuleDependent"));
        }
        if (onModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onModule", "com/intellij/openapi/module/impl/ModuleManagerImpl", "isModuleDependent"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.myModuleModel.isModuleDependent(module, onModule);
    }

    public void projectOpened() {
        this.fireModulesAdded();
        this.myModuleModel.projectOpened();
    }

    protected void fireModulesAdded() {
        for (Module module : this.myModuleModel.myPathToModule.values()) {
            this.fireModuleAddedInWriteAction(module);
        }
    }

    protected void fireModuleAddedInWriteAction(final Module module) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ((ModuleEx)module).moduleAdded();
                ModuleManagerImpl.this.fireModuleAdded(module);
            }
        });
    }

    public void projectClosed() {
        this.myModuleModel.projectClosed();
    }

    public static void commitModelWithRunnable(ModifiableModuleModel model, Runnable runnable) {
        ((ModuleModelImpl)model).commitWithRunnable(runnable);
    }

    protected abstract ModuleEx createModule(String var1);

    protected abstract ModuleEx createAndLoadModule(String var1) throws IOException;

    private void commitModel(final ModuleModelImpl moduleModel, final Runnable runnable) {
        ModuleModelImpl.access$402(this.myModuleModel, null);
        this.incModificationCount();
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Collection<Module> oldModules = this.myModuleModel.myPathToModule.values();
        Collection<Module> newModules = moduleModel.myPathToModule.values();
        final ArrayList<Module> removedModules = new ArrayList<Module>(oldModules);
        removedModules.removeAll(newModules);
        final ArrayList<Module> addedModules = new ArrayList<Module>(newModules);
        addedModules.removeAll(oldModules);
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).makeRootsChange(new Runnable(){

            @Override
            public void run() {
                for (Module removedModule : removedModules) {
                    ModuleManagerImpl.this.fireBeforeModuleRemoved(removedModule);
                    ModuleManagerImpl.this.cleanCachedStuff();
                }
                ArrayList neverAddedModules = new ArrayList(moduleModel.myModulesToDispose);
                neverAddedModules.removeAll(ModuleManagerImpl.this.myModuleModel.myPathToModule.values());
                for (Module neverAddedModule : neverAddedModules) {
                    neverAddedModule.putUserData(DISPOSED_MODULE_NAME, (Object)neverAddedModule.getName());
                    Disposer.dispose((Disposable)neverAddedModule);
                }
                if (runnable != null) {
                    runnable.run();
                }
                Map modulesToNewNamesMap = moduleModel.myModuleToNewName;
                Set modulesToBeRenamed = modulesToNewNamesMap.keySet();
                modulesToBeRenamed.removeAll(moduleModel.myModulesToDispose);
                ArrayList<Module> modules = new ArrayList<Module>();
                HashMap oldNames = ContainerUtil.newHashMap();
                for (Module module : modulesToBeRenamed) {
                    oldNames.put(module, module.getName());
                    moduleModel.myPathToModule.remove(module.getModuleFilePath());
                    modules.add(module);
                    ((ModuleEx)module).rename((String)modulesToNewNamesMap.get(module));
                    moduleModel.myPathToModule.put(module.getModuleFilePath(), module);
                }
                moduleModel.myIsWritable = false;
                ModuleManagerImpl.this.myModuleModel = moduleModel;
                for (Module module : removedModules) {
                    ModuleManagerImpl.this.fireModuleRemoved(module);
                    ModuleManagerImpl.this.cleanCachedStuff();
                    Disposer.dispose((Disposable)module);
                    ModuleManagerImpl.this.cleanCachedStuff();
                }
                for (Module addedModule : addedModules) {
                    ((ModuleEx)addedModule).moduleAdded();
                    ModuleManagerImpl.this.cleanCachedStuff();
                    ModuleManagerImpl.this.fireModuleAdded(addedModule);
                    ModuleManagerImpl.this.cleanCachedStuff();
                }
                ModuleManagerImpl.this.cleanCachedStuff();
                ModuleManagerImpl.this.fireModulesRenamed(modules, oldNames);
                ModuleManagerImpl.this.cleanCachedStuff();
            }
        }, false, true);
    }

    void fireModuleRenamedByVfsEvent(final @NotNull Module module, final @NotNull String oldName) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModuleRenamedByVfsEvent"));
        }
        if (oldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldName", "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModuleRenamedByVfsEvent"));
        }
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).makeRootsChange(new Runnable(){

            @Override
            public void run() {
                ModuleManagerImpl.this.fireModulesRenamed(Collections.singletonList(module), Collections.singletonMap(module, oldName));
            }
        }, false, true);
    }

    public String[] getModuleGroupPath(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "getModuleGroupPath"));
        }
        return this.myModuleModel.getModuleGroupPath(module);
    }

    public void setModuleGroupPath(Module module, String[] groupPath) {
        this.myModuleModel.setModuleGroupPath(module, groupPath);
    }

    class ModuleModelImpl
    implements ModifiableModuleModel {
        final Map<String, Module> myPathToModule = new LinkedHashMap((EqualityPolicy)new EqualityPolicy.ByHashingStrategy(FilePathHashingStrategy.create()));
        private Module[] myModulesCache;
        private final List<Module> myModulesToDispose = new ArrayList<Module>();
        private final Map<Module, String> myModuleToNewName = new com.intellij.util.containers.HashMap();
        private final Map<String, Module> myNewNameToModule = new com.intellij.util.containers.HashMap();
        private boolean myIsWritable;
        private Map<Module, String[]> myModuleGroupPath;

        ModuleModelImpl() {
            this.myIsWritable = false;
        }

        ModuleModelImpl(ModuleModelImpl that) {
            this.myPathToModule.putAll(that.myPathToModule);
            Map<Module, String[]> groupPath = that.myModuleGroupPath;
            if (groupPath != null) {
                this.myModuleGroupPath = new THashMap();
                this.myModuleGroupPath.putAll(that.myModuleGroupPath);
            }
            this.myIsWritable = true;
        }

        private void assertWritable() {
            LOG.assertTrue(this.myIsWritable, (Object)"Attempt to modify committed ModifiableModuleModel");
        }

        @NotNull
        public Module[] getModules() {
            if (this.myModulesCache == null) {
                Collection<Module> modules = this.myPathToModule.values();
                this.myModulesCache = modules.toArray(new Module[modules.size()]);
            }
            if (this.myModulesCache == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "getModules"));
            }
            return this.myModulesCache;
        }

        private Module[] getSortedModules() {
            Module[] allModules = (Module[])this.getModules().clone();
            Arrays.sort(allModules, this.moduleDependencyComparator());
            return allModules;
        }

        public void renameModule(@NotNull Module module, @NotNull String newName) throws ModuleWithNameAlreadyExists {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "renameModule"));
            }
            if (newName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "renameModule"));
            }
            Module oldModule = this.getModuleByNewName(newName);
            this.myNewNameToModule.remove(this.myModuleToNewName.get(module));
            if (module.getName().equals(newName)) {
                this.myModuleToNewName.remove(module);
                this.myNewNameToModule.remove(newName);
            } else {
                this.myModuleToNewName.put(module, newName);
                this.myNewNameToModule.put(newName, module);
            }
            if (oldModule != null) {
                throw new ModuleWithNameAlreadyExists(ProjectBundle.message((String)"module.already.exists.error", (Object[])new Object[]{newName}), newName);
            }
        }

        public Module getModuleToBeRenamed(@NotNull String newName) {
            if (newName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "getModuleToBeRenamed"));
            }
            return this.myNewNameToModule.get(newName);
        }

        public Module getModuleByNewName(String newName) {
            Module moduleToBeRenamed = this.getModuleToBeRenamed(newName);
            if (moduleToBeRenamed != null) {
                return moduleToBeRenamed;
            }
            Module moduleWithOldName = this.findModuleByName(newName);
            if (this.myModuleToNewName.get(moduleWithOldName) == null) {
                return moduleWithOldName;
            }
            return null;
        }

        public String getNewName(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "getNewName"));
            }
            return this.myModuleToNewName.get(module);
        }

        @NotNull
        public Module newModule(@NotNull String filePath, String moduleTypeId) {
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "newModule"));
            }
            Module module = this.newModule(filePath, moduleTypeId, null);
            if (module == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "newModule"));
            }
            return module;
        }

        @NotNull
        public Module newModule(@NotNull String filePath, String moduleTypeId, @Nullable Map<String, String> options) {
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "newModule"));
            }
            this.assertWritable();
            filePath = this.resolveShortWindowsName(filePath);
            ModuleEx module = this.getModuleByFilePath(filePath);
            if (module == null) {
                module = ModuleManagerImpl.this.createModule(filePath);
                module.setOption("type", moduleTypeId);
                if (options != null) {
                    for (Map.Entry<String, String> option : options.entrySet()) {
                        module.setOption(option.getKey(), option.getValue());
                    }
                }
                module.loadModuleComponents();
                this.initModule(module);
            }
            ModuleEx moduleEx = module;
            if (moduleEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "newModule"));
            }
            return moduleEx;
        }

        private String resolveShortWindowsName(String filePath) {
            try {
                return FileUtil.resolveShortWindowsName((String)filePath);
            }
            catch (IOException ignored) {
                return filePath;
            }
        }

        @Nullable
        private ModuleEx getModuleByFilePath(String filePath) {
            return (ModuleEx)this.myPathToModule.get(filePath);
        }

        @NotNull
        public Module loadModule(@NotNull String filePath) throws InvalidDataException, IOException, ModuleWithNameAlreadyExists {
            Module module;
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "loadModule"));
            }
            this.assertWritable();
            try {
                module = this.loadModuleInternal(filePath);
            }
            catch (StateStorageException e) {
                throw new IOException(ProjectBundle.message((String)"module.corrupted.file.error", (Object[])new Object[]{FileUtil.toSystemDependentName((String)filePath), e.getMessage()}));
            }
            if (module == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "loadModule"));
            }
            return module;
        }

        private Module loadModuleInternal(String filePath) throws ModuleWithNameAlreadyExists, IOException, StateStorageException {
            ModuleEx module;
            filePath = this.resolveShortWindowsName(filePath);
            final VirtualFile moduleFile = StandardFileSystems.local().findFileByPath(filePath);
            if (moduleFile == null || !moduleFile.exists()) {
                throw new IOException(ProjectBundle.message((String)"module.file.does.not.exist.error", (Object[])new Object[]{filePath}));
            }
            String name = moduleFile.getName();
            if (name.endsWith(ModuleManagerImpl.IML_EXTENSION)) {
                String moduleName = name.substring(0, name.length() - 4);
                for (Module module2 : this.myPathToModule.values()) {
                    if (!module2.getName().equals(moduleName)) continue;
                    throw new ModuleWithNameAlreadyExists(ProjectBundle.message((String)"module.already.exists.error", (Object[])new Object[]{moduleName}), moduleName);
                }
            }
            if ((module = this.getModuleByFilePath(moduleFile.getPath())) == null) {
                ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        moduleFile.refresh(false, false);
                    }
                }, ModalityState.defaultModalityState());
                module = ModuleManagerImpl.this.createAndLoadModule(moduleFile.getPath());
                module.loadModuleComponents();
                this.initModule(module);
            }
            return module;
        }

        private void initModule(ModuleEx module) {
            String path = module.getModuleFilePath();
            this.myModulesCache = null;
            this.myPathToModule.put(path, module);
            module.init();
        }

        public void disposeModule(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "disposeModule"));
            }
            this.assertWritable();
            this.myModulesCache = null;
            if (this.myPathToModule.values().contains(module)) {
                this.myPathToModule.remove(module.getModuleFilePath());
                this.myModulesToDispose.add(module);
            }
            if (this.myModuleGroupPath != null) {
                this.myModuleGroupPath.remove(module);
            }
        }

        public Module findModuleByName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "findModuleByName"));
            }
            for (Module module : this.myPathToModule.values()) {
                if (module.isDisposed() || !module.getName().equals(name)) continue;
                return module;
            }
            return null;
        }

        private Comparator<Module> moduleDependencyComparator() {
            DFSTBuilder builder = new DFSTBuilder(this.moduleGraph(true));
            return builder.comparator();
        }

        private Graph<Module> moduleGraph(final boolean includeTests) {
            return GraphGenerator.create((GraphGenerator.SemiGraph)CachingSemiGraph.create((GraphGenerator.SemiGraph)new GraphGenerator.SemiGraph<Module>(){

                public Collection<Module> getNodes() {
                    return ModuleModelImpl.this.myPathToModule.values();
                }

                public Iterator<Module> getIn(Module m) {
                    Module[] dependentModules = ModuleRootManager.getInstance((Module)m).getDependencies(includeTests);
                    return Arrays.asList(dependentModules).iterator();
                }
            }));
        }

        @NotNull
        private List<Module> getModuleDependentModules(Module module) {
            ArrayList<Module> result = new ArrayList<Module>();
            for (Module aModule : this.myPathToModule.values()) {
                if (!this.isModuleDependent(aModule, module)) continue;
                result.add(aModule);
            }
            ArrayList<Module> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "getModuleDependentModules"));
            }
            return arrayList;
        }

        private boolean isModuleDependent(Module module, Module onModule) {
            return ModuleRootManager.getInstance((Module)module).isDependsOn(onModule);
        }

        public void commit() {
            ModifiableRootModel[] rootModels = new ModifiableRootModel[]{};
            ModifiableModelCommitter.multiCommit(rootModels, (ModifiableModuleModel)this);
        }

        public void commitWithRunnable(Runnable runnable) {
            ModuleManagerImpl.this.commitModel(this, runnable);
            this.clearRenamingStuff();
        }

        private void clearRenamingStuff() {
            this.myModuleToNewName.clear();
            this.myNewNameToModule.clear();
        }

        public void dispose() {
            this.assertWritable();
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            Collection<Module> list = ModuleManagerImpl.this.myModuleModel.myPathToModule.values();
            Collection<Module> thisModules = this.myPathToModule.values();
            for (Module thisModule : thisModules) {
                if (list.contains(thisModule)) continue;
                Disposer.dispose((Disposable)thisModule);
            }
            for (Module moduleToDispose : this.myModulesToDispose) {
                if (list.contains(moduleToDispose)) continue;
                Disposer.dispose((Disposable)moduleToDispose);
            }
            this.clearRenamingStuff();
        }

        public boolean isChanged() {
            HashSet thatModules;
            if (!this.myIsWritable) {
                return false;
            }
            HashSet thisModules = new HashSet(this.myPathToModule.values());
            return !thisModules.equals(thatModules = new HashSet(ModuleManagerImpl.this.myModuleModel.myPathToModule.values())) || !Comparing.equal(ModuleManagerImpl.this.myModuleModel.myModuleGroupPath, this.myModuleGroupPath);
        }

        private void disposeModel() {
            this.myModulesCache = null;
            for (Module module : this.myPathToModule.values()) {
                Disposer.dispose((Disposable)module);
            }
            this.myPathToModule.clear();
            this.myModuleGroupPath = null;
        }

        public void projectOpened() {
            Collection<Module> collection = this.myPathToModule.values();
            for (Module aCollection : collection) {
                ModuleEx module = (ModuleEx)aCollection;
                module.projectOpened();
            }
        }

        public void projectClosed() {
            Collection<Module> collection = this.myPathToModule.values();
            for (Module aCollection : collection) {
                ModuleEx module = (ModuleEx)aCollection;
                module.projectClosed();
            }
        }

        public String[] getModuleGroupPath(Module module) {
            return this.myModuleGroupPath == null ? null : this.myModuleGroupPath.get(module);
        }

        public boolean hasModuleGroups() {
            return this.myModuleGroupPath != null && !this.myModuleGroupPath.isEmpty();
        }

        public void setModuleGroupPath(@NotNull Module module, @Nullable(value="null means remove") String[] groupPath) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "setModuleGroupPath"));
            }
            if (this.myModuleGroupPath == null) {
                this.myModuleGroupPath = new THashMap();
            }
            if (groupPath == null) {
                this.myModuleGroupPath.remove(module);
            } else {
                this.myModuleGroupPath.put(module, groupPath);
            }
        }

        public void setModuleFilePath(@NotNull Module module, String oldPath, String newFilePath) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "setModuleFilePath"));
            }
            this.myPathToModule.remove(oldPath);
            this.myPathToModule.put(newFilePath, module);
        }

        static /* synthetic */ Module[] access$402(ModuleModelImpl x0, Module[] x1) {
            x0.myModulesCache = x1;
            return x1;
        }
    }

    private static class ModulePathSaveItem
    extends SaveItem {
        private final ModulePath myModulePath;
        private final String myFilePath;
        private final String myName;

        public ModulePathSaveItem(ModulePath modulePath) {
            this.myModulePath = modulePath;
            this.myFilePath = modulePath.getPath().replace(File.separatorChar, '/');
            int slashIndex = this.myFilePath.lastIndexOf(47);
            int startIndex = slashIndex >= 0 && slashIndex + 1 < this.myFilePath.length() ? slashIndex + 1 : 0;
            int endIndex = this.myFilePath.endsWith(ModuleManagerImpl.IML_EXTENSION) ? this.myFilePath.length() - ModuleManagerImpl.IML_EXTENSION.length() : this.myFilePath.length();
            this.myName = this.myFilePath.substring(startIndex, endIndex);
        }

        @Override
        protected String getModuleName() {
            return this.myName;
        }

        @Override
        protected String getGroupPathString() {
            return this.myModulePath.getModuleGroup();
        }

        @Override
        protected String getModuleFilePath() {
            return this.myFilePath;
        }
    }

    private class ModuleSaveItem
    extends SaveItem {
        private final Module myModule;

        public ModuleSaveItem(Module module) {
            this.myModule = module;
        }

        @Override
        protected String getModuleName() {
            return this.myModule.getName();
        }

        @Override
        protected String getGroupPathString() {
            String[] groupPath = ModuleManagerImpl.this.getModuleGroupPath(this.myModule);
            return groupPath != null ? StringUtil.join((String[])groupPath, (String)ModuleManagerImpl.MODULE_GROUP_SEPARATOR) : null;
        }

        @Override
        protected String getModuleFilePath() {
            return this.myModule.getModuleFilePath().replace(File.separatorChar, '/');
        }
    }

    private static abstract class SaveItem {
        private SaveItem() {
        }

        protected abstract String getModuleName();

        protected abstract String getGroupPathString();

        protected abstract String getModuleFilePath();

        public final void writeExternal(Element parentElement) {
            Element moduleElement = new Element(ModuleManagerImpl.ELEMENT_MODULE);
            String moduleFilePath = this.getModuleFilePath();
            String url = VirtualFileManager.constructUrl((String)"file", (String)moduleFilePath);
            moduleElement.setAttribute(ModuleManagerImpl.ATTRIBUTE_FILEURL, url);
            moduleElement.setAttribute(ModuleManagerImpl.ATTRIBUTE_FILEPATH, moduleFilePath);
            String groupPath = this.getGroupPathString();
            if (groupPath != null) {
                moduleElement.setAttribute(ModuleManagerImpl.ATTRIBUTE_GROUP, groupPath);
            }
            parentElement.addContent(moduleElement);
        }
    }

    public static final class ModulePath {
        private final String myPath;
        private final String myModuleGroup;

        public ModulePath(String path, String moduleGroup) {
            this.myPath = path;
            this.myModuleGroup = moduleGroup;
        }

        public String getPath() {
            return this.myPath;
        }

        public String getModuleGroup() {
            return this.myModuleGroup;
        }
    }

    private static class ModuleGroupInterner {
        private final StringInterner groups = new StringInterner();
        private final Map<String[], String[]> paths = new THashMap((TObjectHashingStrategy)new TObjectHashingStrategy<String[]>(){

            public int computeHashCode(String[] object) {
                return Arrays.hashCode(object);
            }

            public boolean equals(String[] o1, String[] o2) {
                return Arrays.equals(o1, o2);
            }
        });

        private ModuleGroupInterner() {
        }

        private void setModuleGroupPath(@NotNull ModifiableModuleModel model, Module module, @Nullable String[] group) {
            String[] cached;
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleGroupInterner", "setModuleGroupPath"));
            }
            String[] stringArray = cached = group == null ? null : this.paths.get(group);
            if (cached == null && group != null) {
                cached = new String[group.length];
                for (int i = 0; i < group.length; ++i) {
                    String g = group[i];
                    cached[i] = (String)this.groups.intern((Object)g);
                }
                this.paths.put(cached, cached);
            }
            model.setModuleGroupPath(module, cached);
        }
    }
}

