/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SharedScheme;
import com.intellij.util.text.UniqueNameGenerator;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSchemesManager<T extends Scheme, E extends ExternalizableScheme>
implements SchemesManager<T, E> {
    private static final Logger LOG = Logger.getInstance(AbstractSchemesManager.class);
    protected final List<T> mySchemes = new ArrayList<T>();
    private volatile T myCurrentScheme;
    private String myCurrentSchemeName;

    public void addNewScheme(@NotNull T scheme, boolean replaceExisting) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/options/AbstractSchemesManager", "addNewScheme"));
        }
        int toReplace = -1;
        for (int i = 0; i < this.mySchemes.size(); ++i) {
            Scheme existingScheme = (Scheme)this.mySchemes.get(i);
            if (!existingScheme.getName().equals(scheme.getName())) continue;
            toReplace = i;
            break;
        }
        if (toReplace == -1) {
            this.mySchemes.add(scheme);
        } else if (replaceExisting || !(scheme instanceof ExternalizableScheme)) {
            this.mySchemes.set(toReplace, scheme);
        } else {
            this.renameScheme((ExternalizableScheme)scheme, UniqueNameGenerator.generateUniqueName((String)scheme.getName(), this.collectExistingNames(this.mySchemes)));
            this.mySchemes.add(scheme);
        }
        this.onSchemeAdded(scheme);
        this.checkCurrentScheme((Scheme)scheme);
    }

    protected void checkCurrentScheme(Scheme scheme) {
        if (this.myCurrentScheme == null && this.myCurrentSchemeName != null && this.myCurrentSchemeName.equals(scheme.getName())) {
            this.myCurrentScheme = scheme;
        }
    }

    private Collection<String> collectExistingNames(Collection<T> schemes) {
        THashSet result = new THashSet();
        for (Scheme scheme : schemes) {
            result.add(scheme.getName());
        }
        return result;
    }

    public void clearAllSchemes() {
        for (Scheme myScheme : this.mySchemes) {
            this.onSchemeDeleted(myScheme);
        }
        this.mySchemes.clear();
    }

    @NotNull
    public List<T> getAllSchemes() {
        List<T> list = Collections.unmodifiableList(this.mySchemes);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/AbstractSchemesManager", "getAllSchemes"));
        }
        return list;
    }

    @Nullable
    public T findSchemeByName(@NotNull String schemeName) {
        if (schemeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemeName", "com/intellij/openapi/options/AbstractSchemesManager", "findSchemeByName"));
        }
        for (Scheme scheme : this.mySchemes) {
            if (!scheme.getName().equals(schemeName)) continue;
            return (T)scheme;
        }
        return null;
    }

    public void setCurrentSchemeName(String schemeName) {
        this.myCurrentSchemeName = schemeName;
        this.myCurrentScheme = schemeName == null ? null : this.findSchemeByName(schemeName);
    }

    @Nullable
    public T getCurrentScheme() {
        T currentScheme = this.myCurrentScheme;
        return currentScheme == null ? null : (T)this.findSchemeByName(currentScheme.getName());
    }

    public void removeScheme(@NotNull T scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/options/AbstractSchemesManager", "removeScheme"));
        }
        int n = this.mySchemes.size();
        for (int i = 0; i < n; ++i) {
            Scheme s = (Scheme)this.mySchemes.get(i);
            if (!scheme.getName().equals(s.getName())) continue;
            this.onSchemeDeleted(s);
            this.mySchemes.remove(i);
            break;
        }
    }

    protected void onSchemeDeleted(@NotNull Scheme toDelete) {
        if (toDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toDelete", "com/intellij/openapi/options/AbstractSchemesManager", "onSchemeDeleted"));
        }
        if (this.myCurrentScheme == toDelete) {
            this.myCurrentScheme = null;
        }
    }

    @NotNull
    public Collection<String> getAllSchemeNames() {
        ArrayList<String> names = new ArrayList<String>(this.mySchemes.size());
        for (Scheme scheme : this.mySchemes) {
            names.add(scheme.getName());
        }
        ArrayList<String> arrayList = names;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/AbstractSchemesManager", "getAllSchemeNames"));
        }
        return arrayList;
    }

    protected abstract void onSchemeAdded(@NotNull T var1);

    protected void renameScheme(@NotNull E scheme, @NotNull String newName) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/options/AbstractSchemesManager", "renameScheme"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/options/AbstractSchemesManager", "renameScheme"));
        }
        if (!newName.equals(scheme.getName())) {
            scheme.setName(newName);
            LOG.assertTrue(newName.equals(scheme.getName()));
        }
    }

    @NotNull
    public Collection<SharedScheme<E>> loadSharedSchemes(Collection<T> currentSchemeList) {
        List<SharedScheme<E>> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/AbstractSchemesManager", "loadSharedSchemes"));
        }
        return list;
    }

    @NotNull
    public Collection<SharedScheme<E>> loadSharedSchemes() {
        List<SharedScheme<E>> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/AbstractSchemesManager", "loadSharedSchemes"));
        }
        return list;
    }

    public boolean isShared(@NotNull Scheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/options/AbstractSchemesManager", "isShared"));
        }
        return false;
    }

    public boolean isExportAvailable() {
        return false;
    }

    public void exportScheme(@NotNull E scheme, String name, String description) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/options/AbstractSchemesManager", "exportScheme"));
        }
    }
}

