/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.ide.caches.CacheUpdater;
import com.intellij.ide.caches.FileContent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CacheUpdateSession {
    private static final Logger LOG = Logger.getInstance((String)("#" + CacheUpdateSession.class.getName()));
    private final List<VirtualFile> myFilesToUpdate;
    private final int myJobsToDo;
    private final List<Pair<CacheUpdater, Collection<VirtualFile>>> myUpdatersWithFiles;

    CacheUpdateSession(@NotNull Collection<CacheUpdater> updaters, @NotNull ProgressIndicator indicator) {
        if (updaters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updaters", "com/intellij/openapi/project/CacheUpdateSession", "<init>"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/project/CacheUpdateSession", "<init>"));
        }
        ArrayList<CacheUpdater> processedUpdaters = new ArrayList<CacheUpdater>();
        LinkedHashSet set = ContainerUtil.newLinkedHashSet();
        ArrayList<Pair> list = new ArrayList<Pair>();
        try {
            int jobsCount = 0;
            for (CacheUpdater each : updaters) {
                indicator.checkCanceled();
                try {
                    jobsCount += each.getNumberOfPendingUpdateJobs();
                    List<VirtualFile> updaterFiles = Arrays.asList(each.queryNeededFiles(indicator));
                    processedUpdaters.add(each);
                    set.addAll(updaterFiles);
                    list.add(Pair.create((Object)each, (Object)new THashSet(updaterFiles)));
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
            this.myJobsToDo = jobsCount;
        }
        catch (ProcessCanceledException e) {
            for (CacheUpdater each : processedUpdaters) {
                each.canceled();
            }
            throw e;
        }
        this.myUpdatersWithFiles = ContainerUtil.createLockFreeCopyOnWriteList(list);
        this.myFilesToUpdate = ContainerUtil.newArrayList((Iterable)set);
    }

    int getNumberOfPendingUpdateJobs() {
        return this.myJobsToDo;
    }

    @NotNull
    public Collection<VirtualFile> getFilesToUpdate() {
        List<VirtualFile> list = this.myFilesToUpdate;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/CacheUpdateSession", "getFilesToUpdate"));
        }
        return list;
    }

    @Nullable
    private Pair<CacheUpdater, Collection<VirtualFile>> getPair(final @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/project/CacheUpdateSession", "getPair"));
        }
        return (Pair)ContainerUtil.find(this.myUpdatersWithFiles, (Condition)new Condition<Pair<CacheUpdater, Collection<VirtualFile>>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean value(Pair<CacheUpdater, Collection<VirtualFile>> cacheUpdaterCollectionPair) {
                Collection second;
                Collection collection = second = (Collection)cacheUpdaterCollectionPair.second;
                synchronized (collection) {
                    return second.contains(file);
                }
            }
        });
    }

    void processFile(@NotNull FileContent content) {
        Pair<CacheUpdater, Collection<VirtualFile>> pair;
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/project/CacheUpdateSession", "processFile"));
        }
        VirtualFile file = content.getVirtualFile();
        boolean isValid = file.isValid() && !file.isDirectory();
        Throwable exception = null;
        while ((pair = this.getPair(file)) != null) {
            CacheUpdater eachUpdater = (CacheUpdater)pair.getFirst();
            Collection eachFiles = (Collection)pair.getSecond();
            try {
                if (isValid && exception == null) {
                    eachUpdater.processFile(content);
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                exception = e;
            }
            this.removeFile(file, eachUpdater, eachFiles);
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        if (exception instanceof Error) {
            throw (Error)exception;
        }
        if (exception != null) {
            throw new RuntimeException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFile(@NotNull VirtualFile file, @NotNull CacheUpdater eachUpdater, @NotNull Collection<VirtualFile> eachFiles) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/project/CacheUpdateSession", "removeFile"));
        }
        if (eachUpdater == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eachUpdater", "com/intellij/openapi/project/CacheUpdateSession", "removeFile"));
        }
        if (eachFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eachFiles", "com/intellij/openapi/project/CacheUpdateSession", "removeFile"));
        }
        Collection<VirtualFile> collection = eachFiles;
        synchronized (collection) {
            eachFiles.remove(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updatingDone() {
        for (Pair<CacheUpdater, Collection<VirtualFile>> eachPair : this.myUpdatersWithFiles) {
            try {
                Collection second;
                CacheUpdater eachUpdater = (CacheUpdater)eachPair.first;
                eachUpdater.updatingDone();
                Collection collection = second = (Collection)eachPair.second;
                synchronized (collection) {
                    if (!second.isEmpty()) {
                        LOG.error(CacheUpdater.class.getSimpleName() + " " + eachUpdater + " has not finished yet:\n" + new ArrayList(second));
                    }
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    void canceled() {
        for (Pair<CacheUpdater, Collection<VirtualFile>> eachPair : this.myUpdatersWithFiles) {
            ((CacheUpdater)eachPair.first).canceled();
        }
    }
}

