/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.core.JavaCoreBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.ui.ListCellRendererWrapper;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nullable;

public class LanguageLevelCombo
extends ComboBox {
    public static final String USE_PROJECT_LANGUAGE_LEVEL = ProjectBundle.message((String)"project.language.level.combo.item", (Object[])new Object[0]);
    @Nullable
    private LanguageLevel myDefaultLevel;

    public LanguageLevelCombo() {
        for (LanguageLevel level : LanguageLevel.values()) {
            this.addItem(level);
        }
        this.setRenderer((ListCellRenderer)new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof LanguageLevel) {
                    this.setText(((LanguageLevel)value).getPresentableText());
                } else if (value instanceof String) {
                    this.setText((String)value);
                }
            }
        });
    }

    public void reset(Project project) {
        JavaSdkVersion version;
        this.removeAllItems();
        for (LanguageLevel level : LanguageLevel.values()) {
            this.addItem(level);
        }
        this.myDefaultLevel = null;
        Sdk sdk = ProjectRootManagerEx.getInstanceEx((Project)project).getProjectSdk();
        if (sdk != null && (version = JavaSdk.getInstance().getVersion(sdk)) != null) {
            this.myDefaultLevel = version.getMaxLanguageLevel();
        }
        String item = null;
        if (this.myDefaultLevel != null) {
            item = JavaCoreBundle.message((String)"default.jdk.level.description", (Object[])new Object[]{this.myDefaultLevel.getPresentableText()});
            this.addItem(item);
        } else if (project.isDefault()) {
            item = JavaCoreBundle.message((String)"default.language.level.description", (Object[])new Object[0]);
            this.addItem(item);
            this.myDefaultLevel = LanguageLevelProjectExtension.getInstance((Project)project).getLanguageLevel();
        }
        LanguageLevelProjectExtension extension = LanguageLevelProjectExtension.getInstance((Project)project);
        Boolean aDefault = extension.isDefault();
        if (item != null && aDefault != null && aDefault.booleanValue()) {
            this.setSelectedItem(item);
        } else {
            this.setSelectedItem(extension.getLanguageLevel());
        }
    }

    @Nullable
    public LanguageLevel getSelectedLevel() {
        Object item = this.getSelectedItem();
        return item instanceof LanguageLevel ? (LanguageLevel)item : this.myDefaultLevel;
    }

    public boolean isDefault() {
        return !(this.getSelectedItem() instanceof LanguageLevel);
    }

    public void setSelectedItem(Object anObject) {
        if (anObject == null) {
            anObject = USE_PROJECT_LANGUAGE_LEVEL;
        }
        super.setSelectedItem(anObject);
    }
}

