/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.util.Alarm;

public class ZipperUpdater {
    private final Alarm myAlarm;
    private boolean myRaised;
    private final Object myLock = new Object();
    private final int myDelay;
    private final Alarm.ThreadToUse myThreadToUse;
    private boolean myIsEmpty;

    public ZipperUpdater(int delay, Disposable parentDisposable) {
        this.myDelay = delay;
        this.myIsEmpty = true;
        this.myThreadToUse = Alarm.ThreadToUse.POOLED_THREAD;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, parentDisposable);
    }

    public ZipperUpdater(int delay, Alarm.ThreadToUse threadToUse, Disposable parentDisposable) {
        this.myDelay = delay;
        this.myThreadToUse = threadToUse;
        this.myIsEmpty = true;
        this.myAlarm = new Alarm(threadToUse, parentDisposable);
    }

    public void queue(Runnable runnable) {
        this.queue(runnable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(final Runnable runnable, boolean urgent) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myAlarm.isDisposed()) {
                return;
            }
            boolean wasRaised = this.myRaised;
            this.myRaised = true;
            this.myIsEmpty = false;
            if (!wasRaised) {
                Runnable request = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = ZipperUpdater.this.myLock;
                        synchronized (object) {
                            if (!ZipperUpdater.this.myRaised) {
                                return;
                            }
                            ZipperUpdater.this.myRaised = false;
                        }
                        runnable.run();
                        object = ZipperUpdater.this.myLock;
                        synchronized (object) {
                            ZipperUpdater.this.myIsEmpty = !ZipperUpdater.this.myRaised;
                        }
                    }
                };
                if (Alarm.ThreadToUse.SWING_THREAD.equals((Object)this.myThreadToUse) && !ApplicationManager.getApplication().isDispatchThread()) {
                    this.myAlarm.addRequest(request, urgent ? 0 : this.myDelay, ModalityState.NON_MODAL);
                } else {
                    this.myAlarm.addRequest(request, urgent ? 0 : this.myDelay);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myIsEmpty;
        }
    }

    public void stop() {
        this.myAlarm.cancelAllRequests();
    }
}

