/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.actions.AnnotateRevisionActionBase;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineNumberListener;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AnnotateRevisionAction
extends AnnotateRevisionActionBase
implements DumbAware,
LineNumberListener {
    @NotNull
    private final FileAnnotation myAnnotation;
    @NotNull
    private final AbstractVcs myVcs;
    private int currentLine;

    public AnnotateRevisionAction(@Nullable String text, @Nullable String description, @Nullable Icon icon, @NotNull FileAnnotation annotation, @NotNull AbstractVcs vcs) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/openapi/vcs/actions/AnnotateRevisionAction", "<init>"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/actions/AnnotateRevisionAction", "<init>"));
        }
        super(text, description, icon);
        this.myAnnotation = annotation;
        this.myVcs = vcs;
    }

    @NotNull
    protected abstract List<VcsFileRevision> getRevisions();

    @Override
    @Nullable
    protected AbstractVcs getVcs(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/AnnotateRevisionAction", "getVcs"));
        }
        return this.myVcs;
    }

    @Override
    @Nullable
    protected VirtualFile getFile(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/AnnotateRevisionAction", "getFile"));
        }
        VcsFileRevision revision = this.getFileRevision(e);
        if (revision == null) {
            return null;
        }
        FilePathImpl filePath = revision instanceof VcsFileRevisionEx ? ((VcsFileRevisionEx)revision).getPath() : new FilePathImpl(this.myAnnotation.getFile());
        return new VcsVirtualFile(filePath.getPath(), revision, (VirtualFileSystem)VcsFileSystem.getInstance());
    }

    @Override
    @Nullable
    protected VcsFileRevision getFileRevision(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/AnnotateRevisionAction", "getFileRevision"));
        }
        List<VcsFileRevision> revisions = this.getRevisions();
        if (this.currentLine < 0 || this.currentLine >= revisions.size()) {
            return null;
        }
        return revisions.get(this.currentLine);
    }

    public void consume(Integer integer) {
        this.currentLine = integer;
    }
}

