/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff;

import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContentImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileAwareDocumentContent
extends DocumentContentImpl {
    @NotNull
    private final Project myProject;
    @Nullable
    private final VirtualFile myLocalFile;

    public FileAwareDocumentContent(@NotNull Project project, @NotNull Document document, @Nullable FileType fileType, @Nullable VirtualFile localFile, @Nullable LineSeparator separator, @Nullable Charset charset) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/actions/diff/FileAwareDocumentContent", "<init>"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vcs/changes/actions/diff/FileAwareDocumentContent", "<init>"));
        }
        super(document, fileType, localFile, separator, charset);
        this.myProject = project;
        this.myLocalFile = localFile;
    }

    @Override
    public OpenFileDescriptor getOpenFileDescriptor(int offset) {
        return this.myLocalFile == null ? null : new OpenFileDescriptor(this.myProject, this.myLocalFile, offset);
    }

    @NotNull
    public static DiffContent create(@NotNull Project project, @NotNull String content, @NotNull FilePath path) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/actions/diff/FileAwareDocumentContent", "create"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/vcs/changes/actions/diff/FileAwareDocumentContent", "create"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/changes/actions/diff/FileAwareDocumentContent", "create"));
        }
        VirtualFile localFile = LocalFileSystem.getInstance().findFileByPath(path.getPath());
        FileType fileType = localFile != null ? localFile.getFileType() : path.getFileType();
        Charset charset = localFile != null ? localFile.getCharset() : path.getCharset(project);
        DiffContent diffContent = FileAwareDocumentContent.create(project, content, fileType, localFile, charset);
        if (diffContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/diff/FileAwareDocumentContent", "create"));
        }
        return diffContent;
    }

    @NotNull
    public static DiffContent create(@NotNull Project project, @NotNull String content, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/actions/diff/FileAwareDocumentContent", "create"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/vcs/changes/actions/diff/FileAwareDocumentContent", "create"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/actions/diff/FileAwareDocumentContent", "create"));
        }
        FileType fileType = file.getFileType();
        Charset charset = file.getCharset();
        DiffContent diffContent = FileAwareDocumentContent.create(project, content, fileType, file, charset);
        if (diffContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/diff/FileAwareDocumentContent", "create"));
        }
        return diffContent;
    }

    @NotNull
    private static DiffContent create(@NotNull Project project, @NotNull String content, @Nullable FileType fileType, @Nullable VirtualFile file, @Nullable Charset charset) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/actions/diff/FileAwareDocumentContent", "create"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/vcs/changes/actions/diff/FileAwareDocumentContent", "create"));
        }
        LineSeparator separator = StringUtil.detectSeparators((CharSequence)content);
        Document document = EditorFactory.getInstance().createDocument((CharSequence)StringUtil.convertLineSeparators((String)content));
        document.setReadOnly(true);
        if (FileTypes.UNKNOWN.equals(fileType)) {
            fileType = PlainTextFileType.INSTANCE;
        }
        FileAwareDocumentContent fileAwareDocumentContent = new FileAwareDocumentContent(project, document, (FileType)fileType, file, separator, charset);
        if (fileAwareDocumentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/diff/FileAwareDocumentContent", "create"));
        }
        return fileAwareDocumentContent;
    }
}

