/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.migrate;

import com.intellij.diff.actions.impl.GoToChangePopupBuilder;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.contents.BinaryFileContentImpl;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContentImpl;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffNavigationContext;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeRequestChain;
import com.intellij.openapi.vcs.changes.actions.ChangeDiffRequestPresentable;
import com.intellij.openapi.vcs.changes.actions.DiffRequestPresentable;
import com.intellij.openapi.vcs.changes.actions.DiffRequestPresentableProxy;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeGoToChangePopupAction;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MigrateToNewDiffUtil {
    private static final Logger LOG = Logger.getInstance(MigrateToNewDiffUtil.class);
    @NonNls
    public static final Object DO_NOT_TRY_MIGRATE = "doNotTryMigrate";

    @NotNull
    public static DiffRequestChain convertRequestChain(@NotNull com.intellij.openapi.diff.DiffRequest oldRequest) {
        if (oldRequest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRequest", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil", "convertRequestChain"));
        }
        ChangeRequestChain oldChain = (ChangeRequestChain)oldRequest.getGenericData().get(VcsDataKeys.DIFF_REQUEST_CHAIN.getName());
        if (oldChain == null || oldChain.getAllRequests().size() < 2) {
            DiffRequest request = MigrateToNewDiffUtil.convertRequest(oldRequest);
            SimpleDiffRequestChain simpleDiffRequestChain = new SimpleDiffRequestChain(request);
            if (simpleDiffRequestChain == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil", "convertRequestChain"));
            }
            return simpleDiffRequestChain;
        }
        ChangeRequestChainWrapper changeRequestChainWrapper = new ChangeRequestChainWrapper(oldChain);
        if (changeRequestChainWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil", "convertRequestChain"));
        }
        return changeRequestChainWrapper;
    }

    @NotNull
    public static DiffRequest convertRequest(@NotNull com.intellij.openapi.diff.DiffRequest oldRequest) {
        if (oldRequest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRequest", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil", "convertRequest"));
        }
        DiffRequest request = MigrateToNewDiffUtil.convertRequestFair(oldRequest);
        if (request != null) {
            DiffRequest diffRequest = request;
            if (diffRequest == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil", "convertRequest"));
            }
            return diffRequest;
        }
        ErrorDiffRequest erorRequest = new ErrorDiffRequest((DiffRequestProducer)new MyDiffRequestProducer(oldRequest), "Can't convert from old-style request");
        erorRequest.putUserData(DiffUserDataKeys.CONTEXT_ACTIONS, Collections.singletonList(new MyShowDiffAction(oldRequest)));
        ErrorDiffRequest errorDiffRequest = erorRequest;
        if (errorDiffRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil", "convertRequest"));
        }
        return errorDiffRequest;
    }

    @Nullable
    private static DiffRequest convertRequestFair(@NotNull com.intellij.openapi.diff.DiffRequest oldRequest) {
        if (oldRequest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRequest", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil", "convertRequestFair"));
        }
        if (oldRequest.getOnOkRunnable() != null) {
            return null;
        }
        com.intellij.openapi.diff.DiffContent[] contents = oldRequest.getContents();
        String[] titles = oldRequest.getContentTitles();
        DiffContent[] newContents = new DiffContent[contents.length];
        for (int i = 0; i < contents.length; ++i) {
            newContents[i] = MigrateToNewDiffUtil.convertContent(oldRequest.getProject(), contents[i]);
            if (newContents[i] != null) continue;
            return null;
        }
        SimpleDiffRequest newRequest = new SimpleDiffRequest(oldRequest.getWindowTitle(), newContents, titles);
        newRequest.putUserData(DiffUserDataKeys.CONTEXT_ACTIONS, Collections.singletonList(new MyShowDiffAction(oldRequest)));
        DiffNavigationContext navigationContext = (DiffNavigationContext)oldRequest.getGenericData().get(DiffTool.SCROLL_TO_LINE.getName());
        if (navigationContext != null) {
            newRequest.putUserData(DiffUserDataKeysEx.NAVIGATION_CONTEXT, (Object)navigationContext);
        }
        return newRequest;
    }

    @Nullable
    private static DiffContent convertContent(@Nullable Project project, final @NotNull com.intellij.openapi.diff.DiffContent oldContent) {
        if (oldContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldContent", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil", "convertContent"));
        }
        if (oldContent.isEmpty()) {
            return new EmptyContent();
        }
        if (oldContent.isBinary()) {
            VirtualFile file = oldContent.getFile();
            if (file == null) {
                return null;
            }
            return new BinaryFileContentImpl(project, file);
        }
        Document document = oldContent.getDocument();
        if (document == null) {
            return null;
        }
        return new DocumentContentImpl(document, oldContent.getContentType(), oldContent.getFile(), oldContent.getLineSeparator(), null){

            @Override
            @Nullable
            public OpenFileDescriptor getOpenFileDescriptor(int offset) {
                return oldContent.getOpenFileDescriptor(offset);
            }

            @Override
            public void onAssigned(boolean isAssigned) {
                oldContent.onAssigned(isAssigned);
            }
        };
    }

    private static class MyDiffRequestProducer
    implements DiffRequestProducer {
        @NotNull
        private final com.intellij.openapi.diff.DiffRequest myRequest;

        public MyDiffRequestProducer(@NotNull com.intellij.openapi.diff.DiffRequest request) {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil$MyDiffRequestProducer", "<init>"));
            }
            this.myRequest = request;
        }

        @NotNull
        public String getName() {
            String string = StringUtil.notNullize((String)this.myRequest.getWindowTitle());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil$MyDiffRequestProducer", "getName"));
            }
            return string;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil$MyDiffRequestProducer", "process"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil$MyDiffRequestProducer", "process"));
            }
            ErrorDiffRequest errorRequest = new ErrorDiffRequest((DiffRequestProducer)this, "Can't convert from old-style request");
            errorRequest.putUserData(DiffUserDataKeys.CONTEXT_ACTIONS, Collections.singletonList(new MyShowDiffAction(this.myRequest)));
            ErrorDiffRequest errorDiffRequest = errorRequest;
            if (errorDiffRequest == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil$MyDiffRequestProducer", "process"));
            }
            return errorDiffRequest;
        }
    }

    private static class MyShowDiffAction
    extends DumbAwareAction {
        @NotNull
        private final com.intellij.openapi.diff.DiffRequest myRequest;

        public MyShowDiffAction(@NotNull com.intellij.openapi.diff.DiffRequest request) {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil$MyShowDiffAction", "<init>"));
            }
            super("Show in old diff tool", null, AllIcons.Diff.Diff);
            this.setEnabledInModalContext(true);
            this.myRequest = request;
            request.addHint(DO_NOT_TRY_MIGRATE);
        }

        public void update(AnActionEvent e) {
            if (!ApplicationManager.getApplication().isInternal()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setVisible(true);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil$MyShowDiffAction", "actionPerformed"));
            }
            DiffManager.getInstance().getDiffTool().show(this.myRequest);
        }
    }

    private static class MyProducerWrapper
    implements DiffRequestProducer {
        @NotNull
        private final DiffRequestPresentable myPresentable;
        @NotNull
        private final ChangeRequestChain myChain;

        public MyProducerWrapper(@NotNull ChangeRequestChain chain, @NotNull DiffRequestPresentable presentable) {
            if (chain == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chain", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil$MyProducerWrapper", "<init>"));
            }
            if (presentable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentable", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil$MyProducerWrapper", "<init>"));
            }
            this.myPresentable = presentable;
            this.myChain = chain;
        }

        @NotNull
        public String getName() {
            String string = this.myPresentable.getPathPresentation();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil$MyProducerWrapper", "getName"));
            }
            return string;
        }

        @NotNull
        public DiffRequestPresentable getPresentable() {
            DiffRequestPresentable diffRequestPresentable = this.myPresentable;
            if (diffRequestPresentable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil$MyProducerWrapper", "getPresentable"));
            }
            return diffRequestPresentable;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil$MyProducerWrapper", "process"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil$MyProducerWrapper", "process"));
            }
            com.intellij.openapi.diff.DiffRequest oldRequest = (com.intellij.openapi.diff.DiffRequest)UIUtil.invokeAndWaitIfNeeded((Computable)new Computable<com.intellij.openapi.diff.DiffRequest>(){

                public com.intellij.openapi.diff.DiffRequest compute() {
                    return MyProducerWrapper.this.myChain.moveTo(MyProducerWrapper.this.myPresentable);
                }
            });
            if (oldRequest == null) {
                ErrorDiffRequest errorDiffRequest = new ErrorDiffRequest((DiffRequestProducer)this, "Can't build old-style request");
                if (errorDiffRequest == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil$MyProducerWrapper", "process"));
                }
                return errorDiffRequest;
            }
            DiffRequest diffRequest = MigrateToNewDiffUtil.convertRequest(oldRequest);
            if (diffRequest == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil$MyProducerWrapper", "process"));
            }
            return diffRequest;
        }
    }

    private static class ChangeRequestChainWrapper
    extends UserDataHolderBase
    implements DiffRequestChain,
    GoToChangePopupBuilder.Chain {
        @NotNull
        private final ChangeRequestChain myChain;
        @NotNull
        private final List<MyProducerWrapper> myRequests;
        private int myIndex;

        public ChangeRequestChainWrapper(@NotNull ChangeRequestChain chain) {
            if (chain == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chain", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil$ChangeRequestChainWrapper", "<init>"));
            }
            this.myChain = chain;
            this.myRequests = ContainerUtil.map((Collection)this.myChain.getAllRequests(), (Function)new Function<DiffRequestPresentable, MyProducerWrapper>(){

                public MyProducerWrapper fun(DiffRequestPresentable presentable) {
                    return new MyProducerWrapper(ChangeRequestChainWrapper.this.myChain, presentable);
                }
            });
            this.myIndex = chain.getAllRequests().indexOf(chain.getCurrentRequest());
        }

        @NotNull
        public List<? extends MyProducerWrapper> getRequests() {
            List<MyProducerWrapper> list = this.myRequests;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil$ChangeRequestChainWrapper", "getRequests"));
            }
            return list;
        }

        public int getIndex() {
            return this.myIndex;
        }

        public void setIndex(int index) {
            assert (index >= 0 && index < this.myRequests.size());
            this.myIndex = index;
        }

        @Nullable
        private static Change getChange(@NotNull DiffRequestPresentable presentable) {
            if (presentable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentable", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil$ChangeRequestChainWrapper", "getChange"));
            }
            if (presentable instanceof DiffRequestPresentableProxy) {
                try {
                    presentable = ((DiffRequestPresentableProxy)presentable).init();
                }
                catch (VcsException e) {
                    LOG.info((Throwable)e);
                    return null;
                }
            }
            if (presentable instanceof ChangeDiffRequestPresentable) {
                return ((ChangeDiffRequestPresentable)presentable).getChange();
            }
            return null;
        }

        @Override
        @NotNull
        public AnAction createGoToChangeAction(@NotNull Consumer<Integer> onSelected) {
            if (onSelected == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onSelected", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil$ChangeRequestChainWrapper", "createGoToChangeAction"));
            }
            ChangeGoToChangePopupAction<ChangeRequestChainWrapper> changeGoToChangePopupAction = new ChangeGoToChangePopupAction<ChangeRequestChainWrapper>(this, onSelected){

                @Override
                @NotNull
                protected List<Change> getChanges() {
                    List list = ContainerUtil.mapNotNull(((ChangeRequestChainWrapper)this.myChain).getRequests(), (Function)new Function<MyProducerWrapper, Change>(){

                        @Nullable
                        public Change fun(MyProducerWrapper wrapper) {
                            return ChangeRequestChainWrapper.getChange(wrapper.getPresentable());
                        }
                    });
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil$ChangeRequestChainWrapper$2", "getChanges"));
                    }
                    return list;
                }

                @Override
                @Nullable
                protected Change getCurrentSelection() {
                    return ChangeRequestChainWrapper.getChange(((ChangeRequestChainWrapper)this.myChain).getRequests().get(ChangeRequestChainWrapper.this.myIndex).getPresentable());
                }

                @Override
                protected int findSelectedStep(@Nullable Change change) {
                    if (change == null) {
                        return -1;
                    }
                    for (int i = 0; i < ChangeRequestChainWrapper.this.myRequests.size(); ++i) {
                        Change c = ChangeRequestChainWrapper.getChange(((MyProducerWrapper)ChangeRequestChainWrapper.this.myRequests.get(i)).getPresentable());
                        if (c == null || !change.equals((Object)c)) continue;
                        return i;
                    }
                    return -1;
                }
            };
            if (changeGoToChangePopupAction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil$ChangeRequestChainWrapper", "createGoToChangeAction"));
            }
            return changeGoToChangePopupAction;
        }
    }
}

