/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class ShelvedChangeList
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList");
    @NonNls
    private static final String ATTRIBUTE_DATE = "date";
    @NonNls
    private static final String ELEMENT_BINARY = "binary";
    public String PATH;
    public String DESCRIPTION;
    public Date DATE;
    private List<ShelvedChange> myChanges;
    private List<ShelvedBinaryFile> myBinaryFiles;
    private boolean myRecycled;
    @NonNls
    private static final String ELEMENT_CHANGELIST = "changelist";
    @NonNls
    private static final String ELEMENT_RECYCLED_CHANGELIST = "recycled_changelist";

    public ShelvedChangeList() {
    }

    public ShelvedChangeList(String path, String description, List<ShelvedBinaryFile> binaryFiles) {
        this(path, description, binaryFiles, System.currentTimeMillis());
    }

    public ShelvedChangeList(String path, String description, List<ShelvedBinaryFile> binaryFiles, long time) {
        this.PATH = path;
        this.DESCRIPTION = description;
        this.DATE = new Date(time);
        this.myBinaryFiles = binaryFiles;
    }

    public boolean isRecycled() {
        return this.myRecycled;
    }

    public void setRecycled(boolean recycled) {
        this.myRecycled = recycled;
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        this.DATE = new Date(Long.parseLong(element.getAttributeValue(ATTRIBUTE_DATE)));
        List children = element.getChildren(ELEMENT_BINARY);
        this.myBinaryFiles = new ArrayList<ShelvedBinaryFile>(children.size());
        for (Element child : children) {
            ShelvedBinaryFile binaryFile = new ShelvedBinaryFile();
            binaryFile.readExternal(child);
            this.myBinaryFiles.add(binaryFile);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        element.setAttribute(ATTRIBUTE_DATE, Long.toString(this.DATE.getTime()));
        for (ShelvedBinaryFile file : this.myBinaryFiles) {
            Element child = new Element(ELEMENT_BINARY);
            file.writeExternal(child);
            element.addContent(child);
        }
    }

    public String toString() {
        return this.DESCRIPTION;
    }

    public List<ShelvedChange> getChanges(Project project) {
        if (this.myChanges == null) {
            try {
                List<? extends FilePatch> list = ShelveChangesManager.loadPatchesWithoutContent(project, this.PATH, null);
                this.myChanges = new ArrayList<ShelvedChange>();
                for (FilePatch filePatch : list) {
                    FileStatus status = filePatch.isNewFile() ? FileStatus.ADDED : (filePatch.isDeletedFile() ? FileStatus.DELETED : FileStatus.MODIFIED);
                    this.myChanges.add(new ShelvedChange(this.PATH, filePatch.getBeforeName(), filePatch.getAfterName(), status));
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return this.myChanges;
    }

    public void clearLoadedChanges() {
        this.myChanges = null;
    }

    public List<ShelvedBinaryFile> getBinaryFiles() {
        return this.myBinaryFiles;
    }

    public static Collection<ShelvedChangeList> readChanges(Element element, boolean recycled, boolean checkForFileExistance) throws InvalidDataException {
        List children = element.getChildren(recycled ? ELEMENT_RECYCLED_CHANGELIST : ELEMENT_CHANGELIST);
        ArrayList<ShelvedChangeList> result = new ArrayList<ShelvedChangeList>();
        ShelvedChangeList.readList(children, result, checkForFileExistance);
        if (recycled) {
            for (ShelvedChangeList list : result) {
                list.setRecycled(true);
            }
        }
        return result;
    }

    private static void readList(List<Element> children, List<ShelvedChangeList> sink, boolean checkForFileExistance) throws InvalidDataException {
        for (Element child : children) {
            ShelvedChangeList data = new ShelvedChangeList();
            data.readExternal(child);
            if (checkForFileExistance && !new File(data.PATH).exists()) continue;
            sink.add(data);
        }
    }

    public static void writeChanges(Collection<ShelvedChangeList> shelvedChangeLists, Collection<ShelvedChangeList> recycledShelvedChangeLists, Element element) throws WriteExternalException {
        Element child;
        for (ShelvedChangeList data : shelvedChangeLists) {
            child = new Element(ELEMENT_CHANGELIST);
            data.writeExternal(child);
            element.addContent(child);
        }
        for (ShelvedChangeList data : recycledShelvedChangeLists) {
            child = new Element(ELEMENT_RECYCLED_CHANGELIST);
            data.writeExternal(child);
            element.addContent(child);
        }
    }
}

