/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import java.awt.Color;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class ChangesBrowserChangeNode
extends ChangesBrowserNode<Change>
implements TreeLinkMouseListener.HaveTooltip {
    private final Project myProject;
    private final ChangeNodeDecorator myDecorator;

    protected ChangesBrowserChangeNode(Project project, Change userObject, @Nullable ChangeNodeDecorator decorator) {
        super(userObject);
        this.myProject = project;
        this.myDecorator = decorator;
        if (!ChangesUtil.getFilePath((Change)userObject).isDirectory()) {
            this.myCount = 1;
        }
    }

    @Override
    protected boolean isDirectory() {
        return ChangesUtil.getFilePath((Change)((Change)this.getUserObject())).isDirectory();
    }

    @Override
    public void render(ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        Change change = (Change)this.getUserObject();
        FilePath filePath = ChangesUtil.getFilePath((Change)change);
        String fileName = filePath.getName();
        VirtualFile vFile = filePath.getVirtualFile();
        if (this.myDecorator != null) {
            this.myDecorator.preDecorate(change, renderer, renderer.isShowFlatten());
        }
        Color changeColor = change.getFileStatus().getColor();
        renderer.appendFileName(vFile, fileName, changeColor);
        String originText = change.getOriginText(this.myProject);
        if (originText != null) {
            renderer.append(" " + originText, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        if (renderer.isShowFlatten()) {
            File parentFile = filePath.getIOFile().getParentFile();
            if (parentFile != null) {
                renderer.append(" (" + FileUtil.getLocationRelativeToUserHome((String)parentFile.getPath()) + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
            this.appendSwitched(renderer);
        } else if (this.getCount() != 1 || this.getDirectoryCount() != 0) {
            this.appendSwitched(renderer);
            this.appendCount(renderer);
        } else {
            this.appendSwitched(renderer);
        }
        Icon addIcon = change.getAdditionalIcon();
        if (addIcon != null) {
            renderer.setIcon(addIcon);
        } else if (filePath.isDirectory() || !this.isLeaf()) {
            renderer.setIcon(PlatformIcons.DIRECTORY_CLOSED_ICON);
        } else {
            renderer.setIcon(filePath.getFileType().getIcon());
        }
        if (this.myDecorator != null) {
            this.myDecorator.decorate(change, (SimpleColoredComponent)renderer, renderer.isShowFlatten());
        }
    }

    private void appendSwitched(ChangesBrowserNodeRenderer renderer) {
        String branch;
        VirtualFile virtualFile = ChangesUtil.getFilePath((Change)((Change)this.getUserObject())).getVirtualFile();
        if (virtualFile != null && !this.myProject.isDefault() && (branch = ChangeListManager.getInstance((Project)this.myProject).getSwitchedBranch(virtualFile)) != null) {
            renderer.append(" [switched to " + branch + "]", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    @Override
    public String getTooltip() {
        Change change = (Change)this.getUserObject();
        return change.getDescription();
    }

    @Override
    public String getTextPresentation() {
        return ChangesUtil.getFilePath((Change)((Change)this.getUserObject())).getName();
    }

    @Override
    public String toString() {
        return FileUtil.toSystemDependentName((String)ChangesUtil.getFilePath((Change)((Change)this.getUserObject())).getPath());
    }

    @Override
    public int getSortWeight() {
        return 6;
    }

    @Override
    public int compareUserObjects(Object o2) {
        if (o2 instanceof Change) {
            return ChangesUtil.getFilePath((Change)((Change)this.getUserObject())).getName().compareToIgnoreCase(ChangesUtil.getFilePath((Change)((Change)o2)).getName());
        }
        return 0;
    }
}

