/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.codeInsight.CodeSmellInfo;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CodeSmellDetector;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl;
import com.intellij.openapi.vcs.impl.VcsErrorViewPanel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.vcsUtil.Rethrow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CodeSmellDetectorImpl
extends CodeSmellDetector {
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.CodeSmellDetectorImpl");
    private Exception myException;

    public CodeSmellDetectorImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public void showCodeSmellErrors(final List<CodeSmellInfo> smellList) {
        Collections.sort(smellList, new Comparator<CodeSmellInfo>(){

            @Override
            public int compare(CodeSmellInfo o1, CodeSmellInfo o2) {
                return o1.getTextRange().getStartOffset() - o2.getTextRange().getStartOffset();
            }
        });
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CodeSmellDetectorImpl.this.myProject.isDisposed()) {
                    return;
                }
                if (smellList.isEmpty()) {
                    return;
                }
                VcsErrorViewPanel errorTreeView = new VcsErrorViewPanel(CodeSmellDetectorImpl.this.myProject);
                AbstractVcsHelperImpl helper = (AbstractVcsHelperImpl)AbstractVcsHelper.getInstance((Project)CodeSmellDetectorImpl.this.myProject);
                helper.openMessagesView(errorTreeView, VcsBundle.message((String)"code.smells.error.messages.tab.name", (Object[])new Object[0]));
                FileDocumentManager fileManager = FileDocumentManager.getInstance();
                for (CodeSmellInfo smellInfo : smellList) {
                    VirtualFile file = fileManager.getFile(smellInfo.getDocument());
                    OpenFileDescriptor navigatable = new OpenFileDescriptor(CodeSmellDetectorImpl.this.myProject, file, smellInfo.getStartLine(), smellInfo.getStartColumn());
                    String exportPrefix = NewErrorTreeViewPanel.createExportPrefix(smellInfo.getStartLine() + 1);
                    String rendererPrefix = NewErrorTreeViewPanel.createRendererPrefix(smellInfo.getStartLine() + 1, smellInfo.getStartColumn() + 1);
                    if (smellInfo.getSeverity() == HighlightSeverity.ERROR) {
                        errorTreeView.addMessage(4, new String[]{smellInfo.getDescription()}, file.getPresentableUrl(), (Navigatable)navigatable, exportPrefix, rendererPrefix, null);
                        continue;
                    }
                    errorTreeView.addMessage(5, new String[]{smellInfo.getDescription()}, file.getPresentableUrl(), (Navigatable)navigatable, exportPrefix, rendererPrefix, null);
                }
            }
        });
    }

    @Override
    public List<CodeSmellInfo> findCodeSmells(final List<VirtualFile> filesToCheck) throws ProcessCanceledException {
        final ArrayList<CodeSmellInfo> result = new ArrayList<CodeSmellInfo>();
        final PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        final FileDocumentManager fileManager = FileDocumentManager.getInstance();
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new RuntimeException("Must not run under write action");
        }
        ProgressManager.getInstance().run((Task)new Task.Modal(this.myProject, VcsBundle.message((String)"checking.code.smells.progress.title", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator progress) {
                if (progress == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/openapi/vcs/impl/CodeSmellDetectorImpl$3", "run"));
                }
                try {
                    for (int i = 0; i < filesToCheck.size(); ++i) {
                        Document document;
                        if (progress.isCanceled()) {
                            throw new ProcessCanceledException();
                        }
                        final VirtualFile file = (VirtualFile)filesToCheck.get(i);
                        progress.setText(VcsBundle.message((String)"searching.for.code.smells.processing.file.progress.text", (Object[])new Object[]{file.getPresentableUrl()}));
                        progress.setFraction((double)i / (double)filesToCheck.size());
                        PsiFile psiFile = (PsiFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile>(){

                            public PsiFile compute() {
                                return manager.findFile(file);
                            }
                        });
                        if (psiFile == null || (document = fileManager.getDocument(file)) == null) continue;
                        List codeSmells = CodeSmellDetectorImpl.this.findCodeSmells(psiFile, progress, document);
                        result.addAll(codeSmells);
                    }
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    CodeSmellDetectorImpl.this.myException = e;
                }
            }
        });
        if (this.myException != null) {
            Rethrow.reThrowRuntime((Throwable)this.myException);
        }
        return result;
    }

    @NotNull
    private List<CodeSmellInfo> findCodeSmells(final @NotNull PsiFile psiFile, @NotNull ProgressIndicator progress, final @NotNull Document document) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/openapi/vcs/impl/CodeSmellDetectorImpl", "findCodeSmells"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/openapi/vcs/impl/CodeSmellDetectorImpl", "findCodeSmells"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vcs/impl/CodeSmellDetectorImpl", "findCodeSmells"));
        }
        final ArrayList<CodeSmellInfo> result = new ArrayList<CodeSmellInfo>();
        final DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)this.myProject);
        final DaemonProgressIndicator daemonIndicator = new DaemonProgressIndicator();
        ((ProgressIndicatorEx)progress).addStateDelegate(new AbstractProgressIndicatorExBase(){

            @Override
            public void cancel() {
                super.cancel();
                daemonIndicator.cancel();
            }
        });
        ProgressManager.getInstance().runProcess(new Runnable(){

            @Override
            public void run() {
                List infos = (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<HighlightInfo>>(){

                    public List<HighlightInfo> compute() {
                        return codeAnalyzer.runMainPasses(psiFile, document, daemonIndicator);
                    }
                });
                CodeSmellDetectorImpl.this.collectErrorsAndWarnings(infos, result, document);
            }
        }, (ProgressIndicator)daemonIndicator);
        ArrayList<CodeSmellInfo> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/CodeSmellDetectorImpl", "findCodeSmells"));
        }
        return arrayList;
    }

    private void collectErrorsAndWarnings(Collection<HighlightInfo> highlights, List<CodeSmellInfo> result, Document document) {
        if (highlights == null) {
            return;
        }
        for (HighlightInfo highlightInfo : highlights) {
            HighlightSeverity severity = highlightInfo.getSeverity();
            if (SeverityRegistrar.getSeverityRegistrar(this.myProject).compare(severity, HighlightSeverity.WARNING) < 0) continue;
            result.add(new CodeSmellInfo(document, CodeSmellDetectorImpl.getDescription(highlightInfo), new TextRange(highlightInfo.startOffset, highlightInfo.endOffset), severity));
        }
    }

    private static String getDescription(HighlightInfo highlightInfo) {
        String description = highlightInfo.getDescription();
        HighlightInfoType type = highlightInfo.type;
        if (type instanceof HighlightInfoType.HighlightInfoTypeSeverityByKey) {
            HighlightDisplayKey severityKey = ((HighlightInfoType.HighlightInfoTypeSeverityByKey)type).getSeverityKey();
            String id = severityKey.getID();
            return "[" + id + "] " + description;
        }
        return description;
    }
}

