/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.openapi.vfs.impl.FilePointerPartNode;
import com.intellij.openapi.vfs.impl.IdentityVirtualFilePointer;
import com.intellij.openapi.vfs.impl.VirtualFilePointerContainerImpl;
import com.intellij.openapi.vfs.impl.VirtualFilePointerImpl;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFilePointerManagerImpl
extends VirtualFilePointerManager
implements ApplicationComponent,
ModificationTracker,
BulkFileListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl");
    private final TempFileSystem TEMP_FILE_SYSTEM;
    private final LocalFileSystem LOCAL_FILE_SYSTEM;
    private final JarFileSystem JAR_FILE_SYSTEM;
    private final Map<VirtualFilePointerListener, FilePointerPartNode> myPointers;
    private final Set<VirtualFilePointerContainerImpl> myContainers;
    @NotNull
    private final VirtualFileManager myVirtualFileManager;
    @NotNull
    private final MessageBus myBus;
    private static final Comparator<String> URL_COMPARATOR = SystemInfo.isFileSystemCaseSensitive ? new Comparator<String>(){

        @Override
        public int compare(@NotNull String url1, @NotNull String url2) {
            if (url1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url1", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$1", "compare"));
            }
            if (url2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url2", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$1", "compare"));
            }
            return url1.compareTo(url2);
        }
    } : new Comparator<String>(){

        @Override
        public int compare(@NotNull String url1, @NotNull String url2) {
            if (url1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url1", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$2", "compare"));
            }
            if (url2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url2", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$2", "compare"));
            }
            return url1.compareToIgnoreCase(url2);
        }
    };
    private final Map<String, IdentityVirtualFilePointer> myUrlToIdentity;
    private final Set<VirtualFilePointerImpl> myStoredPointers;
    private List<EventDescriptor> myEvents;
    private List<FilePointerPartNode> myPointersToUpdateUrl;
    private List<FilePointerPartNode> myPointersToFire;

    VirtualFilePointerManagerImpl(@NotNull VirtualFileManager virtualFileManager, @NotNull MessageBus bus, @NotNull TempFileSystem tempFileSystem, @NotNull LocalFileSystem localFileSystem, @NotNull JarFileSystem jarFileSystem) {
        if (virtualFileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFileManager", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "<init>"));
        }
        if (bus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bus", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "<init>"));
        }
        if (tempFileSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tempFileSystem", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "<init>"));
        }
        if (localFileSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localFileSystem", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "<init>"));
        }
        if (jarFileSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarFileSystem", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "<init>"));
        }
        this.myPointers = new LinkedHashMap<VirtualFilePointerListener, FilePointerPartNode>();
        this.myContainers = ContainerUtil.newIdentityTroveSet();
        this.myUrlToIdentity = new THashMap();
        this.myStoredPointers = ContainerUtil.newIdentityTroveSet();
        this.myEvents = Collections.emptyList();
        this.myPointersToUpdateUrl = Collections.emptyList();
        this.myPointersToFire = Collections.emptyList();
        this.myVirtualFileManager = virtualFileManager;
        this.myBus = bus;
        bus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
        this.TEMP_FILE_SYSTEM = tempFileSystem;
        this.LOCAL_FILE_SYSTEM = localFileSystem;
        this.JAR_FILE_SYSTEM = jarFileSystem;
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        this.assertAllPointersDisposed();
    }

    @NotNull
    public String getComponentName() {
        if ("VirtualFilePointerManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "getComponentName"));
        }
        return "VirtualFilePointerManager";
    }

    @NotNull
    private static VirtualFilePointer[] toPointers(@NotNull List<FilePointerPartNode> pointers) {
        if (pointers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "toPointers"));
        }
        if (pointers.isEmpty()) {
            if (VirtualFilePointer.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "toPointers"));
            }
            return VirtualFilePointer.EMPTY_ARRAY;
        }
        List list = ContainerUtil.mapNotNull(pointers, (Function)new Function<FilePointerPartNode, VirtualFilePointer>(){

            public VirtualFilePointer fun(FilePointerPartNode pair) {
                return pair.leaf;
            }
        });
        VirtualFilePointer[] virtualFilePointerArray = list.toArray(new VirtualFilePointer[list.size()]);
        if (virtualFilePointerArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "toPointers"));
        }
        return virtualFilePointerArray;
    }

    private void addPointersUnder(VirtualFile parent, boolean separator, @NotNull CharSequence childName, @NotNull List<FilePointerPartNode> out) {
        if (childName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childName", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "addPointersUnder"));
        }
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "addPointersUnder"));
        }
        for (FilePointerPartNode root : this.myPointers.values()) {
            root.getPointersUnder(parent, separator, childName, out);
        }
    }

    @NotNull
    public synchronized VirtualFilePointer create(@NotNull String url, @NotNull Disposable parent, @Nullable VirtualFilePointerListener listener) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "create"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "create"));
        }
        VirtualFilePointer virtualFilePointer = this.create(null, url, parent, listener);
        if (virtualFilePointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "create"));
        }
        return virtualFilePointer;
    }

    @NotNull
    public synchronized VirtualFilePointer create(@NotNull VirtualFile file, @NotNull Disposable parent, @Nullable VirtualFilePointerListener listener) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "create"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "create"));
        }
        VirtualFilePointer virtualFilePointer = this.create(file, null, parent, listener);
        if (virtualFilePointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "create"));
        }
        return virtualFilePointer;
    }

    @NotNull
    private VirtualFilePointer create(@Nullable(value="null means the pointer will be created from the (not null) url") VirtualFile file, @Nullable(value="null means url has to be computed from the (not-null) file path") String url, @NotNull Disposable parentDisposable, @Nullable VirtualFilePointerListener listener) {
        String cleanPath;
        boolean isJar;
        String path;
        VirtualFileSystem fileSystem;
        String protocol;
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "create"));
        }
        if (file == null) {
            int protocolEnd = url.indexOf("://");
            if (protocolEnd == -1) {
                protocol = null;
                fileSystem = null;
            } else {
                protocol = url.substring(0, protocolEnd);
                fileSystem = this.myVirtualFileManager.getFileSystem(protocol);
            }
            path = url.substring(protocolEnd + "://".length());
        } else {
            fileSystem = file.getFileSystem();
            protocol = fileSystem.getProtocol();
            path = file.getPath();
            url = VirtualFileManager.constructUrl((String)protocol, (String)path);
        }
        if (fileSystem == this.TEMP_FILE_SYSTEM) {
            VirtualFile found = file == null ? VirtualFileManager.getInstance().findFileByUrl(url) : file;
            IdentityVirtualFilePointer identityVirtualFilePointer = new IdentityVirtualFilePointer(found, url);
            if (identityVirtualFilePointer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "create"));
            }
            return identityVirtualFilePointer;
        }
        boolean bl = isJar = fileSystem == this.JAR_FILE_SYSTEM;
        if (fileSystem != this.LOCAL_FILE_SYSTEM && !isJar) {
            VirtualFile found = fileSystem == null ? null : (file != null ? file : VirtualFileManager.getInstance().findFileByUrl(url));
            IdentityVirtualFilePointer identityVirtualFilePointer = this.getOrCreateIdentity(url, found);
            if (identityVirtualFilePointer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "create"));
            }
            return identityVirtualFilePointer;
        }
        if (file == null && (cleanPath = VirtualFilePointerManagerImpl.cleanupPath(path, isJar)) != path) {
            url = VirtualFileManager.constructUrl((String)protocol, (String)cleanPath);
            path = cleanPath;
        }
        VirtualFilePointerImpl pointer = this.getOrCreate(parentDisposable, listener, path, (Pair<VirtualFile, String>)Pair.create((Object)file, (Object)url));
        DelegatingDisposable.registerDisposable(parentDisposable, pointer);
        VirtualFilePointerImpl virtualFilePointerImpl = pointer;
        if (virtualFilePointerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "create"));
        }
        return virtualFilePointerImpl;
    }

    @NotNull
    private IdentityVirtualFilePointer getOrCreateIdentity(@NotNull String url, VirtualFile found) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "getOrCreateIdentity"));
        }
        IdentityVirtualFilePointer pointer = this.myUrlToIdentity.get(url);
        if (pointer == null) {
            pointer = new IdentityVirtualFilePointer(found, url);
            this.myUrlToIdentity.put(url, pointer);
        }
        IdentityVirtualFilePointer identityVirtualFilePointer = pointer;
        if (identityVirtualFilePointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "getOrCreateIdentity"));
        }
        return identityVirtualFilePointer;
    }

    @NotNull
    private static String cleanupPath(@NotNull String path, boolean isJar) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "cleanupPath"));
        }
        path = FileUtil.normalize((String)path);
        String string = path = VirtualFilePointerManagerImpl.trimTrailingSeparators(path, isJar);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "cleanupPath"));
        }
        return string;
    }

    private static String trimTrailingSeparators(@NotNull String path, boolean isJar) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "trimTrailingSeparators"));
        }
        while (!(!StringUtil.endsWithChar((CharSequence)path, (char)'/') || isJar && path.endsWith("!/"))) {
            path = StringUtil.trimEnd((String)path, (String)"/");
        }
        return path;
    }

    @NotNull
    private VirtualFilePointerImpl getOrCreate(@NotNull Disposable parentDisposable, @Nullable VirtualFilePointerListener listener, @NotNull String path, @NotNull Pair<VirtualFile, String> fileAndUrl) {
        VirtualFilePointerImpl pointer;
        FilePointerPartNode node;
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "getOrCreate"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "getOrCreate"));
        }
        if (fileAndUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAndUrl", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "getOrCreate"));
        }
        FilePointerPartNode root = this.myPointers.get(listener);
        if (root == null) {
            root = new FilePointerPartNode(path, null, fileAndUrl);
            this.myPointers.put(listener, root);
            node = root;
        } else {
            node = root.findPointerOrCreate(path, 0, fileAndUrl);
        }
        if (node.leaf == null) {
            pointer = new VirtualFilePointerImpl(listener, parentDisposable, fileAndUrl);
            node.associate(pointer, fileAndUrl);
        } else {
            pointer = node.leaf;
        }
        pointer.myNode.incrementUsageCount(1);
        root.checkConsistency();
        VirtualFilePointerImpl virtualFilePointerImpl = pointer;
        if (virtualFilePointerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "getOrCreate"));
        }
        return virtualFilePointerImpl;
    }

    @NotNull
    public synchronized VirtualFilePointer duplicate(@NotNull VirtualFilePointer pointer, @NotNull Disposable parent, @Nullable VirtualFilePointerListener listener) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "duplicate"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "duplicate"));
        }
        VirtualFile file = pointer.getFile();
        VirtualFilePointer virtualFilePointer = file == null ? this.create(pointer.getUrl(), parent, listener) : this.create(file, parent, listener);
        if (virtualFilePointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "duplicate"));
        }
        return virtualFilePointer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void assertAllPointersDisposed() {
        for (Map.Entry<VirtualFilePointerListener, FilePointerPartNode> entry : this.myPointers.entrySet()) {
            FilePointerPartNode root = entry.getValue();
            ArrayList<FilePointerPartNode> left = new ArrayList<FilePointerPartNode>();
            root.getPointersUnder(null, false, "", left);
            if (left.isEmpty()) continue;
            VirtualFilePointerImpl p = left.get((int)0).leaf;
            try {
                p.throwDisposalError("Not disposed pointer: " + (Object)((Object)p));
            }
            catch (Throwable throwable) {
                for (FilePointerPartNode pair : left) {
                    VirtualFilePointerImpl pointer = pair.leaf;
                    pointer.dispose();
                }
                throw throwable;
            }
            for (FilePointerPartNode pair : left) {
                VirtualFilePointerImpl pointer = pair.leaf;
                pointer.dispose();
            }
        }
        Set<VirtualFilePointerContainerImpl> set = this.myContainers;
        synchronized (set) {
            if (!this.myContainers.isEmpty()) {
                VirtualFilePointerContainerImpl container = this.myContainers.iterator().next();
                container.throwDisposalError("Not disposed container");
            }
        }
    }

    public void storePointers() {
        this.myStoredPointers.clear();
        this.addAllPointers(this.myStoredPointers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertPointersAreDisposed() {
        ArrayList<VirtualFilePointerImpl> pointers = new ArrayList<VirtualFilePointerImpl>();
        this.addAllPointers(pointers);
        try {
            for (VirtualFilePointerImpl pointer : pointers) {
                if (this.myStoredPointers.contains((Object)pointer)) continue;
                pointer.throwDisposalError("Virtual pointer hasn't been disposed: " + (Object)((Object)pointer));
            }
        }
        finally {
            this.myStoredPointers.clear();
        }
    }

    private void addAllPointers(@NotNull Collection<VirtualFilePointerImpl> pointers) {
        if (pointers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "addAllPointers"));
        }
        ArrayList<FilePointerPartNode> out = new ArrayList<FilePointerPartNode>();
        for (FilePointerPartNode root : this.myPointers.values()) {
            root.getPointersUnder(null, false, "", out);
        }
        for (FilePointerPartNode node : out) {
            pointers.add(node.leaf);
        }
    }

    public void dispose() {
    }

    @NotNull
    public VirtualFilePointerContainer createContainer(@NotNull Disposable parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "createContainer"));
        }
        VirtualFilePointerContainer virtualFilePointerContainer = this.createContainer(parent, null);
        if (virtualFilePointerContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "createContainer"));
        }
        return virtualFilePointerContainer;
    }

    @NotNull
    public synchronized VirtualFilePointerContainer createContainer(@NotNull Disposable parent, @Nullable VirtualFilePointerListener listener) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "createContainer"));
        }
        VirtualFilePointerContainer virtualFilePointerContainer = this.registerContainer(parent, new VirtualFilePointerContainerImpl(this, parent, listener));
        if (virtualFilePointerContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "createContainer"));
        }
        return virtualFilePointerContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private VirtualFilePointerContainer registerContainer(@NotNull Disposable parent, final @NotNull VirtualFilePointerContainerImpl virtualFilePointerContainer) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "registerContainer"));
        }
        if (virtualFilePointerContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFilePointerContainer", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "registerContainer"));
        }
        Set<VirtualFilePointerContainerImpl> set = this.myContainers;
        synchronized (set) {
            this.myContainers.add(virtualFilePointerContainer);
        }
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                boolean removed;
                Disposer.dispose((Disposable)virtualFilePointerContainer);
                Set set = VirtualFilePointerManagerImpl.this.myContainers;
                synchronized (set) {
                    removed = VirtualFilePointerManagerImpl.this.myContainers.remove((Object)virtualFilePointerContainer);
                }
                if (!ApplicationManager.getApplication().isUnitTestMode()) assert (removed);
            }

            @NonNls
            @NotNull
            public String toString() {
                String string = "Disposing container " + (Object)((Object)virtualFilePointerContainer);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$4", "toString"));
                }
                return string;
            }
        });
        VirtualFilePointerContainerImpl virtualFilePointerContainerImpl = virtualFilePointerContainer;
        if (virtualFilePointerContainerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "registerContainer"));
        }
        return virtualFilePointerContainerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void before(@NotNull List<? extends VFileEvent> events) {
        Object[] toFirePointers;
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "before"));
        }
        ArrayList<FilePointerPartNode> toFireEvents = new ArrayList<FilePointerPartNode>();
        ArrayList<FilePointerPartNode> toUpdateUrl = new ArrayList<FilePointerPartNode>();
        VirtualFilePointerManagerImpl virtualFilePointerManagerImpl = this;
        synchronized (virtualFilePointerManagerImpl) {
            this.incModificationCount();
            for (VFileEvent vFileEvent : events) {
                VFilePropertyChangeEvent change;
                VirtualFile eventFile;
                if (vFileEvent instanceof VFileDeleteEvent) {
                    VFileDeleteEvent deleteEvent = (VFileDeleteEvent)vFileEvent;
                    this.addPointersUnder(deleteEvent.getFile(), false, "", toFireEvents);
                    continue;
                }
                if (vFileEvent instanceof VFileCreateEvent) {
                    VFileCreateEvent createEvent = (VFileCreateEvent)vFileEvent;
                    this.addPointersUnder(createEvent.getParent(), true, createEvent.getChildName(), toFireEvents);
                    continue;
                }
                if (vFileEvent instanceof VFileCopyEvent) {
                    VFileCopyEvent copyEvent = (VFileCopyEvent)vFileEvent;
                    this.addPointersUnder(copyEvent.getNewParent(), true, copyEvent.getFile().getName(), toFireEvents);
                    continue;
                }
                if (vFileEvent instanceof VFileMoveEvent) {
                    VFileMoveEvent moveEvent = (VFileMoveEvent)vFileEvent;
                    eventFile = moveEvent.getFile();
                    this.addPointersUnder(moveEvent.getNewParent(), true, eventFile.getName(), toFireEvents);
                    ArrayList<FilePointerPartNode> nodes = new ArrayList<FilePointerPartNode>();
                    this.addPointersUnder(eventFile, false, "", nodes);
                    for (FilePointerPartNode pair : nodes) {
                        VirtualFile file = pair.leaf.getFile();
                        if (file == null) continue;
                        toUpdateUrl.add(pair);
                    }
                    continue;
                }
                if (!(vFileEvent instanceof VFilePropertyChangeEvent) || !"name".equals((change = (VFilePropertyChangeEvent)vFileEvent).getPropertyName())) continue;
                eventFile = change.getFile();
                VirtualFile parent = eventFile.getParent();
                this.addPointersUnder(parent, true, change.getNewValue().toString(), toFireEvents);
                ArrayList<FilePointerPartNode> nodes = new ArrayList<FilePointerPartNode>();
                this.addPointersUnder(eventFile, false, "", nodes);
                for (FilePointerPartNode pair : nodes) {
                    VirtualFile file = pair.leaf.getFile();
                    if (file == null) continue;
                    toUpdateUrl.add(pair);
                }
            }
            this.myEvents = new ArrayList<EventDescriptor>();
            toFirePointers = VirtualFilePointerManagerImpl.toPointers(toFireEvents);
            for (final VirtualFilePointerListener virtualFilePointerListener : this.myPointers.keySet()) {
                List filtered;
                if (virtualFilePointerListener == null || (filtered = ContainerUtil.filter((Object[])toFirePointers, (Condition)new Condition<VirtualFilePointer>(){

                    public boolean value(VirtualFilePointer pointer) {
                        return ((VirtualFilePointerImpl)pointer).getListener() == virtualFilePointerListener;
                    }
                })).isEmpty()) continue;
                EventDescriptor event = new EventDescriptor(virtualFilePointerListener, filtered.toArray(new VirtualFilePointer[filtered.size()]));
                this.myEvents.add(event);
            }
        }
        for (EventDescriptor descriptor : this.myEvents) {
            descriptor.fireBefore();
        }
        if (!toFireEvents.isEmpty()) {
            ((VirtualFilePointerListener)this.myBus.syncPublisher(VirtualFilePointerListener.TOPIC)).beforeValidityChanged((VirtualFilePointer[])toFirePointers);
        }
        this.myPointersToFire = toFireEvents;
        this.myPointersToUpdateUrl = toUpdateUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(@NotNull List<? extends VFileEvent> events) {
        VirtualFilePointer[] pointersToFireArray;
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "after"));
        }
        this.incModificationCount();
        for (FilePointerPartNode node : this.myPointersToUpdateUrl) {
            VirtualFilePointerManagerImpl virtualFilePointerManagerImpl = this;
            synchronized (virtualFilePointerManagerImpl) {
                VirtualFilePointerImpl pointer = node.leaf;
                String urlBefore = pointer.getUrlNoUpdate();
                Pair<VirtualFile, String> after = node.update();
                String urlAfter = (String)after.second;
                if (URL_COMPARATOR.compare(urlBefore, urlAfter) != 0) {
                    FilePointerPartNode root = this.myPointers.get(pointer.getListener());
                    int useCount = node.useCount;
                    node.remove();
                    FilePointerPartNode newNode = root.findPointerOrCreate(VfsUtilCore.urlToPath((String)urlAfter), 0, after);
                    VirtualFilePointerImpl existingPointer = newNode.leaf;
                    if (existingPointer != null) {
                        pointer.myNode = newNode;
                    } else {
                        newNode.associate(pointer, after);
                    }
                    newNode.incrementUsageCount(useCount);
                }
            }
        }
        for (VirtualFilePointer pointer : pointersToFireArray = VirtualFilePointerManagerImpl.toPointers(this.myPointersToFire)) {
            ((VirtualFilePointerImpl)pointer).myNode.update();
        }
        for (EventDescriptor event : this.myEvents) {
            event.fireAfter();
        }
        if (pointersToFireArray.length != 0) {
            ((VirtualFilePointerListener)this.myBus.syncPublisher(VirtualFilePointerListener.TOPIC)).validityChanged(pointersToFireArray);
        }
        this.myPointersToUpdateUrl = Collections.emptyList();
        this.myEvents = Collections.emptyList();
        this.myPointersToFire = Collections.emptyList();
        for (FilePointerPartNode root : this.myPointers.values()) {
            root.checkConsistency();
        }
    }

    void removeNode(@NotNull FilePointerPartNode node, VirtualFilePointerListener listener) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "removeNode"));
        }
        boolean rootNodeEmpty = node.remove();
        if (rootNodeEmpty) {
            this.myPointers.remove(listener);
        } else {
            this.myPointers.get(listener).checkConsistency();
        }
    }

    int numberOfPointers() {
        int number = 0;
        for (FilePointerPartNode root : this.myPointers.values()) {
            number = root.getPointersUnder();
        }
        return number;
    }

    int numberOfListeners() {
        return this.myPointers.keySet().size();
    }

    private static class DelegatingDisposable
    implements Disposable {
        private static final ConcurrentMap<Disposable, DelegatingDisposable> ourInstances = ContainerUtil.newConcurrentMap((TObjectHashingStrategy)ContainerUtil.identityStrategy());
        private final TObjectIntHashMap<VirtualFilePointerImpl> myCounts;
        private final Disposable myParent;

        private DelegatingDisposable(@NotNull Disposable parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$DelegatingDisposable", "<init>"));
            }
            this.myCounts = new TObjectIntHashMap();
            this.myParent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void registerDisposable(@NotNull Disposable parentDisposable, @NotNull VirtualFilePointerImpl pointer) {
            DelegatingDisposable newDisposable;
            if (parentDisposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$DelegatingDisposable", "registerDisposable"));
            }
            if (pointer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$DelegatingDisposable", "registerDisposable"));
            }
            DelegatingDisposable result = (DelegatingDisposable)ourInstances.get(parentDisposable);
            if (result == null && (result = (DelegatingDisposable)ConcurrencyUtil.cacheOrGet(ourInstances, (Object)parentDisposable, (Object)(newDisposable = new DelegatingDisposable(parentDisposable)))) == newDisposable) {
                Disposer.register((Disposable)parentDisposable, (Disposable)result);
            }
            DelegatingDisposable delegatingDisposable = result;
            synchronized (delegatingDisposable) {
                result.myCounts.put((Object)pointer, result.myCounts.get((Object)pointer) + 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            ourInstances.remove(this.myParent);
            DelegatingDisposable delegatingDisposable = this;
            synchronized (delegatingDisposable) {
                this.myCounts.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<VirtualFilePointerImpl>(){

                    public boolean execute(VirtualFilePointerImpl pointer, int disposeCount) {
                        int after = pointer.myNode.incrementUsageCount(-disposeCount + 1);
                        LOG.assertTrue(after > 0, (Object)after);
                        pointer.dispose();
                        return true;
                    }
                });
            }
        }
    }

    private static class EventDescriptor {
        @NotNull
        private final VirtualFilePointerListener myListener;
        @NotNull
        private final VirtualFilePointer[] myPointers;

        private EventDescriptor(@NotNull VirtualFilePointerListener listener, @NotNull VirtualFilePointer[] pointers) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$EventDescriptor", "<init>"));
            }
            if (pointers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$EventDescriptor", "<init>"));
            }
            this.myListener = listener;
            this.myPointers = pointers;
        }

        private void fireBefore() {
            if (this.myPointers.length != 0) {
                this.myListener.beforeValidityChanged(this.myPointers);
            }
        }

        private void fireAfter() {
            if (this.myPointers.length != 0) {
                this.myListener.validityChanged(this.myPointers);
            }
        }
    }
}

